package software.amazon.awscdk.services.ecs;

/**
 * The details of a task definition run on an EC2 cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .memoryLimitMiB(256)
 *         .logging(LogDrivers.awsLogs(AwsLogDriverProps.builder()
 *                 .streamPrefix("EventDemo")
 *                 .mode(AwsLogDriverMode.NON_BLOCKING)
 *                 .maxBufferSize(Size.mebibytes(25))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.818Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Ec2TaskDefinition")
public class Ec2TaskDefinition extends software.amazon.awscdk.services.ecs.TaskDefinition implements software.amazon.awscdk.services.ecs.IEc2TaskDefinition {

    protected Ec2TaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2TaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Ec2TaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Ec2TaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a task definition from the specified task definition ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param ec2TaskDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEc2TaskDefinition fromEc2TaskDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String ec2TaskDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class, "fromEc2TaskDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEc2TaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(ec2TaskDefinitionArn, "ec2TaskDefinitionArn is required") });
    }

    /**
     * Imports an existing Ec2 task definition from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEc2TaskDefinition fromEc2TaskDefinitionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2TaskDefinitionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class, "fromEc2TaskDefinitionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEc2TaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Tasks running in AWSVPC networking mode requires an additional environment variable for the region to be sourced.
     * <p>
     * This override adds in the additional environment variable as required
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition addContainer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinitionOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.Ec2TaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.Ec2TaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
         * <p>
         * Fault injection only works with tasks using the {@link NetworkMode.AWS_VPC} or {@link NetworkMode.HOST} network modes.
         * <p>
         * Default: undefined - ECS default setting is false
         * <p>
         * @return {@code this}
         * @param enableFaultInjection Enables fault injection and allows for fault injection requests to be accepted from the task's containers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFaultInjection(final java.lang.Boolean enableFaultInjection) {
            this.props().enableFaultInjection(enableFaultInjection);
            return this;
        }

        /**
         * The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         * <p>
         * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * <p>
         * Default: - An execution role will be automatically created if you use ECR images in your task definition.
         * <p>
         * @return {@code this}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props().executionRole(executionRole);
            return this;
        }

        /**
         * The name of a family that this task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props().family(family);
            return this;
        }

        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Default: - No proxy configuration.
         * <p>
         * @return {@code this}
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * Default: - A task role is automatically created for you.
         * <p>
         * @return {@code this}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(final software.amazon.awscdk.services.iam.IRole taskRole) {
            this.props().taskRole(taskRole);
            return this;
        }

        /**
         * The list of volume definitions for the task.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * <p>
         * Default: - No volumes are passed to the Docker daemon on a container instance.
         * <p>
         * @return {@code this}
         * @param volumes The list of volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * The inference accelerators to use for the containers in the task.
         * <p>
         * Not supported in Fargate.
         * <p>
         * Default: - No inference accelerators.
         * <p>
         * @return {@code this}
         * @param inferenceAccelerators The inference accelerators to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(final java.util.List<? extends software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators) {
            this.props().inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        /**
         * The IPC resource namespace to use for the containers in the task.
         * <p>
         * Not supported in Fargate and Windows containers.
         * <p>
         * Default: - IpcMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param ipcMode The IPC resource namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(final software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.props().ipcMode(ipcMode);
            return this;
        }

        /**
         * The Docker networking mode to use for the containers in the task.
         * <p>
         * The valid values are NONE, BRIDGE, AWS_VPC, and HOST.
         * <p>
         * Default: - NetworkMode.BRIDGE for EC2 tasks, AWS_VPC for Fargate tasks.
         * <p>
         * @return {@code this}
         * @param networkMode The Docker networking mode to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        /**
         * The process namespace to use for the containers in the task.
         * <p>
         * Not supported in Windows containers.
         * <p>
         * Default: - PidMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param pidMode The process namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(final software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.props().pidMode(pidMode);
            return this;
        }

        /**
         * An array of placement constraint objects to use for the task.
         * <p>
         * You can
         * specify a maximum of 10 constraints per task (this limit includes
         * constraints in the task definition and those specified at run time).
         * <p>
         * Default: - No placement constraints.
         * <p>
         * @return {@code this}
         * @param placementConstraints An array of placement constraint objects to use for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.Ec2TaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.Ec2TaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.Ec2TaskDefinition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}
