package software.amazon.awscdk.services.ecs;

/**
 * The log configuration for the results of the execute command actions.
 * <p>
 * The logs can be sent to CloudWatch Logs and/ or an Amazon S3 bucket.
 * For more information, see [ExecuteCommandLogConfiguration] https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandlogconfiguration.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Key kmsKey = new Key(this, "KmsKey");
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the log group
 * LogGroup logGroup = LogGroup.Builder.create(this, "LogGroup")
 *         .encryptionKey(kmsKey)
 *         .build();
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the S3 bucket
 * Bucket execBucket = Bucket.Builder.create(this, "EcsExecBucket")
 *         .encryptionKey(kmsKey)
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .executeCommandConfiguration(ExecuteCommandConfiguration.builder()
 *                 .kmsKey(kmsKey)
 *                 .logConfiguration(ExecuteCommandLogConfiguration.builder()
 *                         .cloudWatchLogGroup(logGroup)
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .s3Bucket(execBucket)
 *                         .s3EncryptionEnabled(true)
 *                         .s3KeyPrefix("exec-command-output")
 *                         .build())
 *                 .logging(ExecuteCommandLogging.OVERRIDE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.824Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ExecuteCommandLogConfiguration")
@software.amazon.jsii.Jsii.Proxy(ExecuteCommandLogConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExecuteCommandLogConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not to enable encryption on the CloudWatch logs.
     * <p>
     * Default: - encryption will be disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCloudWatchEncryptionEnabled() {
        return null;
    }

    /**
     * The name of the CloudWatch log group to send logs to.
     * <p>
     * The CloudWatch log group must already be created.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getCloudWatchLogGroup() {
        return null;
    }

    /**
     * The name of the S3 bucket to send logs to.
     * <p>
     * The S3 bucket must already be created.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getS3Bucket() {
        return null;
    }

    /**
     * Whether or not to enable encryption on the S3 bucket.
     * <p>
     * Default: - encryption will be disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getS3EncryptionEnabled() {
        return null;
    }

    /**
     * An optional folder in the S3 bucket to place logs in.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExecuteCommandLogConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExecuteCommandLogConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExecuteCommandLogConfiguration> {
        java.lang.Boolean cloudWatchEncryptionEnabled;
        software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup;
        software.amazon.awscdk.services.s3.IBucket s3Bucket;
        java.lang.Boolean s3EncryptionEnabled;
        java.lang.String s3KeyPrefix;

        /**
         * Sets the value of {@link ExecuteCommandLogConfiguration#getCloudWatchEncryptionEnabled}
         * @param cloudWatchEncryptionEnabled Whether or not to enable encryption on the CloudWatch logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchEncryptionEnabled(java.lang.Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteCommandLogConfiguration#getCloudWatchLogGroup}
         * @param cloudWatchLogGroup The name of the CloudWatch log group to send logs to.
         *                           The CloudWatch log group must already be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroup(software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup) {
            this.cloudWatchLogGroup = cloudWatchLogGroup;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteCommandLogConfiguration#getS3Bucket}
         * @param s3Bucket The name of the S3 bucket to send logs to.
         *                 The S3 bucket must already be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Bucket(software.amazon.awscdk.services.s3.IBucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteCommandLogConfiguration#getS3EncryptionEnabled}
         * @param s3EncryptionEnabled Whether or not to enable encryption on the S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3EncryptionEnabled(java.lang.Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteCommandLogConfiguration#getS3KeyPrefix}
         * @param s3KeyPrefix An optional folder in the S3 bucket to place logs in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExecuteCommandLogConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExecuteCommandLogConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExecuteCommandLogConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteCommandLogConfiguration {
        private final java.lang.Boolean cloudWatchEncryptionEnabled;
        private final software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup;
        private final software.amazon.awscdk.services.s3.IBucket s3Bucket;
        private final java.lang.Boolean s3EncryptionEnabled;
        private final java.lang.String s3KeyPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudWatchEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cloudWatchLogGroup = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.s3EncryptionEnabled = software.amazon.jsii.Kernel.get(this, "s3EncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudWatchEncryptionEnabled = builder.cloudWatchEncryptionEnabled;
            this.cloudWatchLogGroup = builder.cloudWatchLogGroup;
            this.s3Bucket = builder.s3Bucket;
            this.s3EncryptionEnabled = builder.s3EncryptionEnabled;
            this.s3KeyPrefix = builder.s3KeyPrefix;
        }

        @Override
        public final java.lang.Boolean getCloudWatchEncryptionEnabled() {
            return this.cloudWatchEncryptionEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getCloudWatchLogGroup() {
            return this.cloudWatchLogGroup;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final java.lang.Boolean getS3EncryptionEnabled() {
            return this.s3EncryptionEnabled;
        }

        @Override
        public final java.lang.String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudWatchEncryptionEnabled() != null) {
                data.set("cloudWatchEncryptionEnabled", om.valueToTree(this.getCloudWatchEncryptionEnabled()));
            }
            if (this.getCloudWatchLogGroup() != null) {
                data.set("cloudWatchLogGroup", om.valueToTree(this.getCloudWatchLogGroup()));
            }
            if (this.getS3Bucket() != null) {
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
            }
            if (this.getS3EncryptionEnabled() != null) {
                data.set("s3EncryptionEnabled", om.valueToTree(this.getS3EncryptionEnabled()));
            }
            if (this.getS3KeyPrefix() != null) {
                data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ExecuteCommandLogConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExecuteCommandLogConfiguration.Jsii$Proxy that = (ExecuteCommandLogConfiguration.Jsii$Proxy) o;

            if (this.cloudWatchEncryptionEnabled != null ? !this.cloudWatchEncryptionEnabled.equals(that.cloudWatchEncryptionEnabled) : that.cloudWatchEncryptionEnabled != null) return false;
            if (this.cloudWatchLogGroup != null ? !this.cloudWatchLogGroup.equals(that.cloudWatchLogGroup) : that.cloudWatchLogGroup != null) return false;
            if (this.s3Bucket != null ? !this.s3Bucket.equals(that.s3Bucket) : that.s3Bucket != null) return false;
            if (this.s3EncryptionEnabled != null ? !this.s3EncryptionEnabled.equals(that.s3EncryptionEnabled) : that.s3EncryptionEnabled != null) return false;
            return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudWatchEncryptionEnabled != null ? this.cloudWatchEncryptionEnabled.hashCode() : 0;
            result = 31 * result + (this.cloudWatchLogGroup != null ? this.cloudWatchLogGroup.hashCode() : 0);
            result = 31 * result + (this.s3Bucket != null ? this.s3Bucket.hashCode() : 0);
            result = 31 * result + (this.s3EncryptionEnabled != null ? this.s3EncryptionEnabled.hashCode() : 0);
            result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
            return result;
        }
    }
}
