package software.amazon.awscdk.services.ecs;

/**
 * Environment file from S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * S3EnvironmentFile s3EnvironmentFile = new S3EnvironmentFile(bucket, "key", "objectVersion");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.896Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.S3EnvironmentFile")
public class S3EnvironmentFile extends software.amazon.awscdk.services.ecs.EnvironmentFile {

    protected S3EnvironmentFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3EnvironmentFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     * @param objectVersion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3EnvironmentFile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), objectVersion });
    }

    /**
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3EnvironmentFile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Called when the container is initialized to allow this object to bind to the stack.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EnvironmentFileConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EnvironmentFileConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }
}
