package software.amazon.awscdk.services.efs;

/**
 * Properties for defining a <code>CfnMountTarget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * CfnMountTargetProps cfnMountTargetProps = CfnMountTargetProps.builder()
 *         .fileSystemId("fileSystemId")
 *         .securityGroups(List.of("securityGroups"))
 *         .subnetId("subnetId")
 *         // the properties below are optional
 *         .ipAddress("ipAddress")
 *         .ipAddressType("ipAddressType")
 *         .ipv6Address("ipv6Address")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:37.062Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnMountTargetProps")
@software.amazon.jsii.Jsii.Proxy(CfnMountTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMountTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the file system for which to create the mount target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * VPC security group IDs, of the form <code>sg-xxxxxxxx</code> .
     * <p>
     * These must be for the same VPC as the subnet specified. The maximum number of security groups depends on account quota. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Quotas</a> in the <em>Amazon VPC User Guide</em> (see the <em>Security Groups</em> table). If you don't specify a security group, then Amazon EFS uses the default security group for the subnet's VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroups();

    /**
     * The ID of the subnet to add the mount target in.
     * <p>
     * For One Zone file systems, use the subnet that is associated with the file system's Availability Zone. The subnet type must be the same type as the <code>IpAddressType</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * If the <code>IpAddressType</code> for the mount target is IPv4 ( <code>IPV4_ONLY</code> or <code>DUAL_STACK</code> ), then specify the IPv4 address to use.
     * <p>
     * If you do not specify an <code>IpAddress</code> , then Amazon EFS selects an unused IP address from the subnet specified for <code>SubnetId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
        return null;
    }

    /**
     * The IP address type for the mount target.
     * <p>
     * The possible values are <code>IPV4_ONLY</code> (only IPv4 addresses), <code>IPV6_ONLY</code> (only IPv6 addresses), and <code>DUAL_STACK</code> (dual-stack, both IPv4 and IPv6 addresses). If you don’t specify an <code>IpAddressType</code> , then <code>IPV4_ONLY</code> is used.
     * <p>
     * <blockquote>
     * <p>
     * The <code>IPAddressType</code> must match the IP type of the subnet. Additionally, the <code>IPAddressType</code> parameter overrides the value set as the default IP address for the subnet in the VPC. For example, if the <code>IPAddressType</code> is <code>IPV4_ONLY</code> and <code>AssignIpv6AddressOnCreation</code> is <code>true</code> , then IPv4 is used for the mount target. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-public-ip.html">Modify the IP addressing attributes of your subnet</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * If the <code>IPAddressType</code> for the mount target is IPv6 ( <code>IPV6_ONLY</code> or <code>DUAL_STACK</code> ), then specify the IPv6 address to use.
     * <p>
     * If you do not specify an <code>Ipv6Address</code> , then Amazon EFS selects an unused IP address from the subnet specified for <code>SubnetId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipv6address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipv6address</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Address() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMountTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMountTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMountTargetProps> {
        java.lang.String fileSystemId;
        java.util.List<java.lang.String> securityGroups;
        java.lang.String subnetId;
        java.lang.String ipAddress;
        java.lang.String ipAddressType;
        java.lang.String ipv6Address;

        /**
         * Sets the value of {@link CfnMountTargetProps#getFileSystemId}
         * @param fileSystemId The ID of the file system for which to create the mount target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getSecurityGroups}
         * @param securityGroups VPC security group IDs, of the form <code>sg-xxxxxxxx</code> . This parameter is required.
         *                       These must be for the same VPC as the subnet specified. The maximum number of security groups depends on account quota. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Quotas</a> in the <em>Amazon VPC User Guide</em> (see the <em>Security Groups</em> table). If you don't specify a security group, then Amazon EFS uses the default security group for the subnet's VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getSubnetId}
         * @param subnetId The ID of the subnet to add the mount target in. This parameter is required.
         *                 For One Zone file systems, use the subnet that is associated with the file system's Availability Zone. The subnet type must be the same type as the <code>IpAddressType</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getIpAddress}
         * @param ipAddress If the <code>IpAddressType</code> for the mount target is IPv4 ( <code>IPV4_ONLY</code> or <code>DUAL_STACK</code> ), then specify the IPv4 address to use.
         *                  If you do not specify an <code>IpAddress</code> , then Amazon EFS selects an unused IP address from the subnet specified for <code>SubnetId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getIpAddressType}
         * @param ipAddressType The IP address type for the mount target.
         *                      The possible values are <code>IPV4_ONLY</code> (only IPv4 addresses), <code>IPV6_ONLY</code> (only IPv6 addresses), and <code>DUAL_STACK</code> (dual-stack, both IPv4 and IPv6 addresses). If you don’t specify an <code>IpAddressType</code> , then <code>IPV4_ONLY</code> is used.
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      The <code>IPAddressType</code> must match the IP type of the subnet. Additionally, the <code>IPAddressType</code> parameter overrides the value set as the default IP address for the subnet in the VPC. For example, if the <code>IPAddressType</code> is <code>IPV4_ONLY</code> and <code>AssignIpv6AddressOnCreation</code> is <code>true</code> , then IPv4 is used for the mount target. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-public-ip.html">Modify the IP addressing attributes of your subnet</a> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getIpv6Address}
         * @param ipv6Address If the <code>IPAddressType</code> for the mount target is IPv6 ( <code>IPV6_ONLY</code> or <code>DUAL_STACK</code> ), then specify the IPv6 address to use.
         *                    If you do not specify an <code>Ipv6Address</code> , then Amazon EFS selects an unused IP address from the subnet specified for <code>SubnetId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Address(java.lang.String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMountTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMountTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMountTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMountTargetProps {
        private final java.lang.String fileSystemId;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.String subnetId;
        private final java.lang.String ipAddress;
        private final java.lang.String ipAddressType;
        private final java.lang.String ipv6Address;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6Address = software.amazon.jsii.Kernel.get(this, "ipv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
            this.securityGroups = java.util.Objects.requireNonNull(builder.securityGroups, "securityGroups is required");
            this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
            this.ipAddress = builder.ipAddress;
            this.ipAddressType = builder.ipAddressType;
            this.ipv6Address = builder.ipv6Address;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.String getIpv6Address() {
            return this.ipv6Address;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getIpAddress() != null) {
                data.set("ipAddress", om.valueToTree(this.getIpAddress()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getIpv6Address() != null) {
                data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnMountTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMountTargetProps.Jsii$Proxy that = (CfnMountTargetProps.Jsii$Proxy) o;

            if (!fileSystemId.equals(that.fileSystemId)) return false;
            if (!securityGroups.equals(that.securityGroups)) return false;
            if (!subnetId.equals(that.subnetId)) return false;
            if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            return this.ipv6Address != null ? this.ipv6Address.equals(that.ipv6Address) : that.ipv6Address == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystemId.hashCode();
            result = 31 * result + (this.securityGroups.hashCode());
            result = 31 * result + (this.subnetId.hashCode());
            result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.ipv6Address != null ? this.ipv6Address.hashCode() : 0);
            return result;
        }
    }
}
