package software.amazon.awscdk.services.eks;

/**
 * Options for defining EKS Fargate Profiles.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addFargateProfile("MyProfile", FargateProfileOptions.builder()
 *         .selectors(List.of(Selector.builder().namespace("default").build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:37.205Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.FargateProfileOptions")
@software.amazon.jsii.Jsii.Proxy(FargateProfileOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FargateProfileOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The selectors to match for pods to use this Fargate profile.
     * <p>
     * Each selector
     * must have an associated namespace. Optionally, you can also specify labels
     * for a namespace.
     * <p>
     * At least one selector is required and you may specify up to five selectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.eks.Selector> getSelectors();

    /**
     * The name of the Fargate profile.
     * <p>
     * Default: - generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFargateProfileName() {
        return null;
    }

    /**
     * The pod execution role to use for pods that match the selectors in the Fargate profile.
     * <p>
     * The pod execution role allows Fargate infrastructure to
     * register with your cluster as a node, and it provides read access to Amazon
     * ECR image repositories.
     * <p>
     * Default: - a role will be automatically created
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getPodExecutionRole() {
        return null;
    }

    /**
     * Select which subnets to launch your pods into.
     * <p>
     * At this time, pods running
     * on Fargate are not assigned public IP addresses, so only private subnets
     * (with no direct route to an Internet Gateway) are allowed.
     * <p>
     * You must specify the VPC to customize the subnet selection
     * <p>
     * Default: - all private subnets of the VPC are selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * The VPC from which to select subnets to launch your pods into.
     * <p>
     * By default, all private subnets are selected. You can customize this using
     * <code>subnetSelection</code>.
     * <p>
     * Default: - all private subnets used by the EKS cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FargateProfileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateProfileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FargateProfileOptions> {
        java.util.List<software.amazon.awscdk.services.eks.Selector> selectors;
        java.lang.String fargateProfileName;
        software.amazon.awscdk.services.iam.IRole podExecutionRole;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link FargateProfileOptions#getSelectors}
         * @param selectors The selectors to match for pods to use this Fargate profile. This parameter is required.
         *                  Each selector
         *                  must have an associated namespace. Optionally, you can also specify labels
         *                  for a namespace.
         *                  <p>
         *                  At least one selector is required and you may specify up to five selectors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder selectors(java.util.List<? extends software.amazon.awscdk.services.eks.Selector> selectors) {
            this.selectors = (java.util.List<software.amazon.awscdk.services.eks.Selector>)selectors;
            return this;
        }

        /**
         * Sets the value of {@link FargateProfileOptions#getFargateProfileName}
         * @param fargateProfileName The name of the Fargate profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateProfileName(java.lang.String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        /**
         * Sets the value of {@link FargateProfileOptions#getPodExecutionRole}
         * @param podExecutionRole The pod execution role to use for pods that match the selectors in the Fargate profile.
         *                         The pod execution role allows Fargate infrastructure to
         *                         register with your cluster as a node, and it provides read access to Amazon
         *                         ECR image repositories.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podExecutionRole(software.amazon.awscdk.services.iam.IRole podExecutionRole) {
            this.podExecutionRole = podExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link FargateProfileOptions#getSubnetSelection}
         * @param subnetSelection Select which subnets to launch your pods into.
         *                        At this time, pods running
         *                        on Fargate are not assigned public IP addresses, so only private subnets
         *                        (with no direct route to an Internet Gateway) are allowed.
         *                        <p>
         *                        You must specify the VPC to customize the subnet selection
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link FargateProfileOptions#getVpc}
         * @param vpc The VPC from which to select subnets to launch your pods into.
         *            By default, all private subnets are selected. You can customize this using
         *            <code>subnetSelection</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateProfileOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FargateProfileOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateProfileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateProfileOptions {
        private final java.util.List<software.amazon.awscdk.services.eks.Selector> selectors;
        private final java.lang.String fargateProfileName;
        private final software.amazon.awscdk.services.iam.IRole podExecutionRole;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.selectors = software.amazon.jsii.Kernel.get(this, "selectors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.Selector.class)));
            this.fargateProfileName = software.amazon.jsii.Kernel.get(this, "fargateProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.podExecutionRole = software.amazon.jsii.Kernel.get(this, "podExecutionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.selectors = (java.util.List<software.amazon.awscdk.services.eks.Selector>)java.util.Objects.requireNonNull(builder.selectors, "selectors is required");
            this.fargateProfileName = builder.fargateProfileName;
            this.podExecutionRole = builder.podExecutionRole;
            this.subnetSelection = builder.subnetSelection;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eks.Selector> getSelectors() {
            return this.selectors;
        }

        @Override
        public final java.lang.String getFargateProfileName() {
            return this.fargateProfileName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getPodExecutionRole() {
            return this.podExecutionRole;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("selectors", om.valueToTree(this.getSelectors()));
            if (this.getFargateProfileName() != null) {
                data.set("fargateProfileName", om.valueToTree(this.getFargateProfileName()));
            }
            if (this.getPodExecutionRole() != null) {
                data.set("podExecutionRole", om.valueToTree(this.getPodExecutionRole()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.FargateProfileOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateProfileOptions.Jsii$Proxy that = (FargateProfileOptions.Jsii$Proxy) o;

            if (!selectors.equals(that.selectors)) return false;
            if (this.fargateProfileName != null ? !this.fargateProfileName.equals(that.fargateProfileName) : that.fargateProfileName != null) return false;
            if (this.podExecutionRole != null ? !this.podExecutionRole.equals(that.podExecutionRole) : that.podExecutionRole != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.selectors.hashCode();
            result = 31 * result + (this.fargateProfileName != null ? this.fargateProfileName.hashCode() : 0);
            result = 31 * result + (this.podExecutionRole != null ? this.podExecutionRole.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
