package software.amazon.awscdk.services.eks;

/**
 * Represents a manifest within the Kubernetes system.
 * <p>
 * Alternatively, you can use <code>cluster.addManifest(resource[, resource, ...])</code>
 * to define resources on this cluster.
 * <p>
 * Applies/deletes the manifest using <code>kubectl</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * KubernetesManifest namespace = cluster.addManifest("my-namespace", Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Namespace",
 *         "metadata", Map.of("name", "my-app")));
 * KubernetesManifest service = cluster.addManifest("my-service", Map.of(
 *         "metadata", Map.of(
 *                 "name", "myservice",
 *                 "namespace", "my-app"),
 *         "spec", Map.of()));
 * service.node.addDependency(namespace);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:37.217Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesManifest")
public class KubernetesManifest extends software.constructs.Construct {

    protected KubernetesManifest(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KubernetesManifest(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesManifest.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RESOURCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesManifest.class, "RESOURCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KubernetesManifest(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifestProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The CloudFormation resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RESOURCE_TYPE;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.KubernetesManifest}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.KubernetesManifest> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.KubernetesManifestProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.KubernetesManifestProps.Builder();
        }

        /**
         * Automatically detect <code>Ingress</code> resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ingressAlb Automatically detect <code>Ingress</code> resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAlb(final java.lang.Boolean ingressAlb) {
            this.props.ingressAlb(ingressAlb);
            return this;
        }

        /**
         * Specify the ALB scheme that should be applied to <code>Ingress</code> resources.
         * <p>
         * Only applicable if <code>ingressAlb</code> is set to <code>true</code>.
         * <p>
         * Default: AlbScheme.INTERNAL
         * <p>
         * @return {@code this}
         * @param ingressAlbScheme Specify the ALB scheme that should be applied to <code>Ingress</code> resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAlbScheme(final software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme) {
            this.props.ingressAlbScheme(ingressAlbScheme);
            return this;
        }

        /**
         * When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
         * <p>
         * To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
         * query the cluster for all resources with a specific label and will remove
         * all the labeld resources that are not part of the applied manifest. If this
         * option is disabled and a resource is removed, it will become "orphaned" and
         * will not be deleted from the cluster.
         * <p>
         * When this option is enabled (default), the construct will inject a label to
         * all Kubernetes resources included in this manifest which will be used to
         * prune resources when the manifest changes via <code>kubectl apply --prune</code>.
         * <p>
         * The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
         * 42-char unique address of this construct in the construct tree. Value is
         * empty.
         * <p>
         * Default: - based on the prune option of the cluster, which is `true` unless
         * otherwise specified.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label">https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label</a>
         * @param prune When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(final java.lang.Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        /**
         * A flag to signify if the manifest validation should be skipped.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param skipValidation A flag to signify if the manifest validation should be skipped. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipValidation(final java.lang.Boolean skipValidation) {
            this.props.skipValidation(skipValidation);
            return this;
        }

        /**
         * The EKS cluster to apply this manifest to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply this manifest to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The manifest to apply.
         * <p>
         * Consists of any number of child resources.
         * <p>
         * When the resources are created/updated, this manifest will be applied to the
         * cluster through <code>kubectl apply</code> and when the resources or the stack is
         * deleted, the resources in the manifest will be deleted through <code>kubectl delete</code>.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * List.of(Map.of(
         *         "apiVersion", "v1",
         *         "kind", "Pod",
         *         "metadata", Map.of("name", "mypod"),
         *         "spec", Map.of(
         *                 "containers", List.of(Map.of("name", "hello", "image", "paulbouwer/hello-kubernetes:1.5", "ports", List.of(Map.of("containerPort", 8080)))))));
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param manifest The manifest to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifest(final java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> manifest) {
            this.props.manifest(manifest);
            return this;
        }

        /**
         * Overwrite any existing resources.
         * <p>
         * If this is set, we will use <code>kubectl apply</code> instead of <code>kubectl create</code>
         * when the resource is created. Otherwise, if there is already a resource
         * in the cluster with the same name, the operation will fail.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param overwrite Overwrite any existing resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overwrite(final java.lang.Boolean overwrite) {
            this.props.overwrite(overwrite);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.KubernetesManifest}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.KubernetesManifest build() {
            return new software.amazon.awscdk.services.eks.KubernetesManifest(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
