package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Reference to a listener's port just created.
 * <p>
 * This implements IConnectable with a default port (the port that an ELB
 * listener was just created on) for a given security group so that it can be
 * conveniently used just like any Connectable. E.g:
 * <p>
 * const listener = elb.addListener(...);
 * <p>
 * listener.connections.allowDefaultPortFromAnyIPv4();
 * // or
 * instance.connections.allowToDefaultPort(listener);
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancing.*;
 * Port port;
 * SecurityGroup securityGroup;
 * ListenerPort listenerPort = new ListenerPort(securityGroup, port);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:37.343Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancing.ListenerPort")
public class ListenerPort extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {

    protected ListenerPort(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ListenerPort(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param securityGroup This parameter is required.
     * @param defaultPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ListenerPort(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port defaultPort) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required"), java.util.Objects.requireNonNull(defaultPort, "defaultPort is required") });
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }
}
