package software.amazon.awscdk.services.evs;

/**
 * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
 * <p>
 * Creates an Amazon EVS environment that runs VCF software, such as SDDC Manager, NSX Manager, and vCenter Server.
 * <p>
 * During environment creation, Amazon EVS performs validations on DNS settings, provisions VLAN subnets and hosts, and deploys the supplied version of VCF.
 * <p>
 * It can take several hours to create an environment. After the deployment completes, you can configure VCF in the vSphere user interface according to your needs.
 * <p>
 * <blockquote>
 * <p>
 * You cannot use the <code>dedicatedHostId</code> and <code>placementGroupId</code> parameters together in the same <code>CreateEnvironment</code> action. This results in a <code>ValidationException</code> response.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evs.*;
 * CfnEnvironment cfnEnvironment = CfnEnvironment.Builder.create(this, "MyCfnEnvironment")
 *         .connectivityInfo(ConnectivityInfoProperty.builder()
 *                 .privateRouteServerPeerings(List.of("privateRouteServerPeerings"))
 *                 .build())
 *         .licenseInfo(LicenseInfoProperty.builder()
 *                 .solutionKey("solutionKey")
 *                 .vsanKey("vsanKey")
 *                 .build())
 *         .serviceAccessSubnetId("serviceAccessSubnetId")
 *         .siteId("siteId")
 *         .termsAccepted(false)
 *         .vcfHostnames(VcfHostnamesProperty.builder()
 *                 .cloudBuilder("cloudBuilder")
 *                 .nsx("nsx")
 *                 .nsxEdge1("nsxEdge1")
 *                 .nsxEdge2("nsxEdge2")
 *                 .nsxManager1("nsxManager1")
 *                 .nsxManager2("nsxManager2")
 *                 .nsxManager3("nsxManager3")
 *                 .sddcManager("sddcManager")
 *                 .vCenter("vCenter")
 *                 .build())
 *         .vcfVersion("vcfVersion")
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .environmentName("environmentName")
 *         .hosts(List.of(HostInfoForCreateProperty.builder()
 *                 .hostName("hostName")
 *                 .instanceType("instanceType")
 *                 .keyName("keyName")
 *                 // the properties below are optional
 *                 .dedicatedHostId("dedicatedHostId")
 *                 .placementGroupId("placementGroupId")
 *                 .build()))
 *         .initialVlans(InitialVlansProperty.builder()
 *                 .edgeVTep(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .expansionVlan1(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .expansionVlan2(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .hcx(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .nsxUpLink(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vmkManagement(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vmManagement(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vMotion(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vSan(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vTep(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .serviceAccessSecurityGroups(ServiceAccessSecurityGroupsProperty.builder()
 *                 .securityGroups(List.of("securityGroups"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:37.874Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment")
public class CfnEnvironment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.evs.CfnEnvironment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evs.CfnEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A check on the environment to identify instance health and VMware VCF licensing issues. For example:.
     * <p>
     * <code>{ "checks": [ { "type": "KEY_REUSE", "result": "PASSED" }, { "type": "KEY_COVERAGE", "result": "PASSED" }, { "type": "REACHABILITY", "result": "PASSED" }, { "type": "HOST_COUNT", "result": "PASSED" } ] }</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrChecks() {
        return software.amazon.jsii.Kernel.get(this, "attrChecks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The date and time that the environment was created.
     * <p>
     * For example: <code>1749081600.000</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VCF credentials that are stored as Amazon EVS managed secrets in AWS Secrets Manager.
     * <p>
     * Amazon EVS stores credentials that are needed to install vCenter Server, NSX, and SDDC Manager. For example:
     * <p>
     * <code>{ [ { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_vCenterAdmin-MnTMEi" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_vCenterRoot-87VyCF" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_NSXRoot-SR3k43" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_NSXAdmin-L5LUiD" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_NSXAudit-Q2oW46" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_SDDCManagerRoot-bFulOq" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_SDDCManagerVCF-Ec3gES" }, { "secretArn": "arn:aws:secretsmanager:us-east-1:000000000000:secret:evs!env-1234567890_SDDCManagerAdmin-JMTAAb" } ] }</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCredentials() {
        return software.amazon.jsii.Kernel.get(this, "attrCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) that is associated with the environment.
     * <p>
     * For example: <code>arn:aws:evs:us-east-1:000000000000:environment/env-1234567890</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID for the environment.
     * <p>
     * For example: <code>env-1234567890</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of an environment.
     * <p>
     * For example: <code>CREATED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentState() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time that the environment was modified.
     * <p>
     * For example: <code>1749081600.000</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A detailed description of the <code>environmentState</code> of an environment.
     * <p>
     * For example: <code>Environment successfully created</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStateDetails() {
        return software.amazon.jsii.Kernel.get(this, "attrStateDetails", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The connectivity configuration for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectivityInfo() {
        return software.amazon.jsii.Kernel.get(this, "connectivityInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The connectivity configuration for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectivityInfo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectivityInfo", java.util.Objects.requireNonNull(value, "connectivityInfo is required"));
    }

    /**
     * The connectivity configuration for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectivityInfo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evs.CfnEnvironment.ConnectivityInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectivityInfo", java.util.Objects.requireNonNull(value, "connectivityInfo is required"));
    }

    /**
     * The license information that Amazon EVS requires to create an environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLicenseInfo() {
        return software.amazon.jsii.Kernel.get(this, "licenseInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The license information that Amazon EVS requires to create an environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseInfo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "licenseInfo", java.util.Objects.requireNonNull(value, "licenseInfo is required"));
    }

    /**
     * The license information that Amazon EVS requires to create an environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseInfo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evs.CfnEnvironment.LicenseInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "licenseInfo", java.util.Objects.requireNonNull(value, "licenseInfo is required"));
    }

    /**
     * The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceAccessSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccessSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceAccessSubnetId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceAccessSubnetId", java.util.Objects.requireNonNull(value, "serviceAccessSubnetId is required"));
    }

    /**
     * The Broadcom Site ID that is associated with your Amazon EVS environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSiteId() {
        return software.amazon.jsii.Kernel.get(this, "siteId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Broadcom Site ID that is associated with your Amazon EVS environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSiteId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "siteId", java.util.Objects.requireNonNull(value, "siteId is required"));
    }

    /**
     * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTermsAccepted() {
        return software.amazon.jsii.Kernel.get(this, "termsAccepted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTermsAccepted(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "termsAccepted", java.util.Objects.requireNonNull(value, "termsAccepted is required"));
    }

    /**
     * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTermsAccepted(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "termsAccepted", java.util.Objects.requireNonNull(value, "termsAccepted is required"));
    }

    /**
     * The DNS hostnames to be used by the VCF management appliances in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getVcfHostnames() {
        return software.amazon.jsii.Kernel.get(this, "vcfHostnames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The DNS hostnames to be used by the VCF management appliances in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVcfHostnames(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vcfHostnames", java.util.Objects.requireNonNull(value, "vcfHostnames is required"));
    }

    /**
     * The DNS hostnames to be used by the VCF management appliances in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVcfHostnames(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evs.CfnEnvironment.VcfHostnamesProperty value) {
        software.amazon.jsii.Kernel.set(this, "vcfHostnames", java.util.Objects.requireNonNull(value, "vcfHostnames is required"));
    }

    /**
     * The VCF version of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVcfVersion() {
        return software.amazon.jsii.Kernel.get(this, "vcfVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VCF version of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVcfVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vcfVersion", java.util.Objects.requireNonNull(value, "vcfVersion is required"));
    }

    /**
     * The VPC associated with the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VPC associated with the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
    }

    /**
     * The name of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentName", value);
    }

    /**
     * Required for environment resource creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHosts() {
        return software.amazon.jsii.Kernel.get(this, "hosts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Required for environment resource creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHosts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hosts", value);
    }

    /**
     * Required for environment resource creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHosts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.evs.CfnEnvironment.HostInfoForCreateProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.evs.CfnEnvironment.HostInfoForCreateProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "hosts", value);
    }

    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialVlans() {
        return software.amazon.jsii.Kernel.get(this, "initialVlans", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVlans(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialVlans", value);
    }

    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVlans(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlansProperty value) {
        software.amazon.jsii.Kernel.set(this, "initialVlans", value);
    }

    /**
     * The AWS KMS key ID that AWS Secrets Manager uses to encrypt secrets that are associated with the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key ID that AWS Secrets Manager uses to encrypt secrets that are associated with the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServiceAccessSecurityGroups() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccessSecurityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceAccessSecurityGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serviceAccessSecurityGroups", value);
    }

    /**
     * The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceAccessSecurityGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.evs.CfnEnvironment.ServiceAccessSecurityGroupsProperty value) {
        software.amazon.jsii.Kernel.set(this, "serviceAccessSecurityGroups", value);
    }

    /**
     * Metadata that assists with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that assists with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * A check on the environment to identify environment health and validate VMware VCF licensing compliance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * CheckProperty checkProperty = CheckProperty.builder()
     *         .result("result")
     *         .type("type")
     *         // the properties below are optional
     *         .impairedSince("impairedSince")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.CheckProperty")
    @software.amazon.jsii.Jsii.Proxy(CheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The check result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html#cfn-evs-environment-check-result">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html#cfn-evs-environment-check-result</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResult();

        /**
         * The check type. Amazon EVS performs the following checks.
         * <p>
         * <ul>
         * <li><code>KEY_REUSE</code> : checks that the VCF license key is not used by another Amazon EVS environment. This check fails if a used license is added to the environment.</li>
         * <li><code>KEY_COVERAGE</code> : checks that your VCF license key allocates sufficient vCPU cores for all deployed hosts. The check fails when any assigned hosts in the EVS environment are not covered by license keys, or when any unassigned hosts cannot be covered by available vCPU cores in keys.</li>
         * <li><code>REACHABILITY</code> : checks that the Amazon EVS control plane has a persistent connection to SDDC Manager. If Amazon EVS cannot reach the environment, this check fails.</li>
         * <li><code>HOST_COUNT</code> : Checks that your environment has a minimum of 4 hosts, which is a requirement for VCF 5.2.1.</li>
         * </ul>
         * <p>
         * If this check fails, you will need to add hosts so that your environment meets this minimum requirement. Amazon EVS only supports environments with 4-16 hosts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html#cfn-evs-environment-check-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html#cfn-evs-environment-check-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The time when environment health began to be impaired.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html#cfn-evs-environment-check-impairedsince">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-check.html#cfn-evs-environment-check-impairedsince</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImpairedSince() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CheckProperty> {
            java.lang.String result;
            java.lang.String type;
            java.lang.String impairedSince;

            /**
             * Sets the value of {@link CheckProperty#getResult}
             * @param result The check result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder result(java.lang.String result) {
                this.result = result;
                return this;
            }

            /**
             * Sets the value of {@link CheckProperty#getType}
             * @param type The check type. Amazon EVS performs the following checks. This parameter is required.
             *             <ul>
             *             <li><code>KEY_REUSE</code> : checks that the VCF license key is not used by another Amazon EVS environment. This check fails if a used license is added to the environment.</li>
             *             <li><code>KEY_COVERAGE</code> : checks that your VCF license key allocates sufficient vCPU cores for all deployed hosts. The check fails when any assigned hosts in the EVS environment are not covered by license keys, or when any unassigned hosts cannot be covered by available vCPU cores in keys.</li>
             *             <li><code>REACHABILITY</code> : checks that the Amazon EVS control plane has a persistent connection to SDDC Manager. If Amazon EVS cannot reach the environment, this check fails.</li>
             *             <li><code>HOST_COUNT</code> : Checks that your environment has a minimum of 4 hosts, which is a requirement for VCF 5.2.1.</li>
             *             </ul>
             *             <p>
             *             If this check fails, you will need to add hosts so that your environment meets this minimum requirement. Amazon EVS only supports environments with 4-16 hosts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link CheckProperty#getImpairedSince}
             * @param impairedSince The time when environment health began to be impaired.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder impairedSince(java.lang.String impairedSince) {
                this.impairedSince = impairedSince;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CheckProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CheckProperty {
            private final java.lang.String result;
            private final java.lang.String type;
            private final java.lang.String impairedSince;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.result = software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.impairedSince = software.amazon.jsii.Kernel.get(this, "impairedSince", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.result = java.util.Objects.requireNonNull(builder.result, "result is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.impairedSince = builder.impairedSince;
            }

            @Override
            public final java.lang.String getResult() {
                return this.result;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getImpairedSince() {
                return this.impairedSince;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("result", om.valueToTree(this.getResult()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getImpairedSince() != null) {
                    data.set("impairedSince", om.valueToTree(this.getImpairedSince()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.CheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CheckProperty.Jsii$Proxy that = (CheckProperty.Jsii$Proxy) o;

                if (!result.equals(that.result)) return false;
                if (!type.equals(that.type)) return false;
                return this.impairedSince != null ? this.impairedSince.equals(that.impairedSince) : that.impairedSince == null;
            }

            @Override
            public final int hashCode() {
                int result = this.result.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.impairedSince != null ? this.impairedSince.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * The connectivity configuration for the environment. Amazon EVS requires that you specify two route server peer IDs. During environment creation, the route server endpoints peer with the NSX uplink VLAN for connectivity to the NSX overlay network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * ConnectivityInfoProperty connectivityInfoProperty = ConnectivityInfoProperty.builder()
     *         .privateRouteServerPeerings(List.of("privateRouteServerPeerings"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-connectivityinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-connectivityinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.ConnectivityInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectivityInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectivityInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique IDs for private route server peers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-connectivityinfo.html#cfn-evs-environment-connectivityinfo-privaterouteserverpeerings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-connectivityinfo.html#cfn-evs-environment-connectivityinfo-privaterouteserverpeerings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPrivateRouteServerPeerings();

        /**
         * @return a {@link Builder} of {@link ConnectivityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectivityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectivityInfoProperty> {
            java.util.List<java.lang.String> privateRouteServerPeerings;

            /**
             * Sets the value of {@link ConnectivityInfoProperty#getPrivateRouteServerPeerings}
             * @param privateRouteServerPeerings The unique IDs for private route server peers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateRouteServerPeerings(java.util.List<java.lang.String> privateRouteServerPeerings) {
                this.privateRouteServerPeerings = privateRouteServerPeerings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectivityInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectivityInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectivityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectivityInfoProperty {
            private final java.util.List<java.lang.String> privateRouteServerPeerings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.privateRouteServerPeerings = software.amazon.jsii.Kernel.get(this, "privateRouteServerPeerings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.privateRouteServerPeerings = java.util.Objects.requireNonNull(builder.privateRouteServerPeerings, "privateRouteServerPeerings is required");
            }

            @Override
            public final java.util.List<java.lang.String> getPrivateRouteServerPeerings() {
                return this.privateRouteServerPeerings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("privateRouteServerPeerings", om.valueToTree(this.getPrivateRouteServerPeerings()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.ConnectivityInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectivityInfoProperty.Jsii$Proxy that = (ConnectivityInfoProperty.Jsii$Proxy) o;

                return this.privateRouteServerPeerings.equals(that.privateRouteServerPeerings);
            }

            @Override
            public final int hashCode() {
                int result = this.privateRouteServerPeerings.hashCode();
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * An object that represents a host.
     * <p>
     * <blockquote>
     * <p>
     * You cannot use <code>dedicatedHostId</code> and <code>placementGroupId</code> together in the same <code>HostInfoForCreate</code> object. This results in a <code>ValidationException</code> response.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * HostInfoForCreateProperty hostInfoForCreateProperty = HostInfoForCreateProperty.builder()
     *         .hostName("hostName")
     *         .instanceType("instanceType")
     *         .keyName("keyName")
     *         // the properties below are optional
     *         .dedicatedHostId("dedicatedHostId")
     *         .placementGroupId("placementGroupId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.HostInfoForCreateProperty")
    @software.amazon.jsii.Jsii.Proxy(HostInfoForCreateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostInfoForCreateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DNS hostname of the host.
         * <p>
         * DNS hostnames for hosts must be unique across Amazon EVS environments and within VCF.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostName();

        /**
         * The EC2 instance type that represents the host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The name of the SSH key that is used to access the host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-keyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-keyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyName();

        /**
         * The unique ID of the Amazon EC2 Dedicated Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-dedicatedhostid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-dedicatedhostid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDedicatedHostId() {
            return null;
        }

        /**
         * The unique ID of the placement group where the host is placed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-placementgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-hostinfoforcreate.html#cfn-evs-environment-hostinfoforcreate-placementgroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroupId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostInfoForCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostInfoForCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostInfoForCreateProperty> {
            java.lang.String hostName;
            java.lang.String instanceType;
            java.lang.String keyName;
            java.lang.String dedicatedHostId;
            java.lang.String placementGroupId;

            /**
             * Sets the value of {@link HostInfoForCreateProperty#getHostName}
             * @param hostName The DNS hostname of the host. This parameter is required.
             *                 DNS hostnames for hosts must be unique across Amazon EVS environments and within VCF.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostName(java.lang.String hostName) {
                this.hostName = hostName;
                return this;
            }

            /**
             * Sets the value of {@link HostInfoForCreateProperty#getInstanceType}
             * @param instanceType The EC2 instance type that represents the host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link HostInfoForCreateProperty#getKeyName}
             * @param keyName The name of the SSH key that is used to access the host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyName(java.lang.String keyName) {
                this.keyName = keyName;
                return this;
            }

            /**
             * Sets the value of {@link HostInfoForCreateProperty#getDedicatedHostId}
             * @param dedicatedHostId The unique ID of the Amazon EC2 Dedicated Host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedHostId(java.lang.String dedicatedHostId) {
                this.dedicatedHostId = dedicatedHostId;
                return this;
            }

            /**
             * Sets the value of {@link HostInfoForCreateProperty#getPlacementGroupId}
             * @param placementGroupId The unique ID of the placement group where the host is placed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementGroupId(java.lang.String placementGroupId) {
                this.placementGroupId = placementGroupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostInfoForCreateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostInfoForCreateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostInfoForCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostInfoForCreateProperty {
            private final java.lang.String hostName;
            private final java.lang.String instanceType;
            private final java.lang.String keyName;
            private final java.lang.String dedicatedHostId;
            private final java.lang.String placementGroupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostName = software.amazon.jsii.Kernel.get(this, "hostName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dedicatedHostId = software.amazon.jsii.Kernel.get(this, "dedicatedHostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.placementGroupId = software.amazon.jsii.Kernel.get(this, "placementGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostName = java.util.Objects.requireNonNull(builder.hostName, "hostName is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.keyName = java.util.Objects.requireNonNull(builder.keyName, "keyName is required");
                this.dedicatedHostId = builder.dedicatedHostId;
                this.placementGroupId = builder.placementGroupId;
            }

            @Override
            public final java.lang.String getHostName() {
                return this.hostName;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getKeyName() {
                return this.keyName;
            }

            @Override
            public final java.lang.String getDedicatedHostId() {
                return this.dedicatedHostId;
            }

            @Override
            public final java.lang.String getPlacementGroupId() {
                return this.placementGroupId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hostName", om.valueToTree(this.getHostName()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("keyName", om.valueToTree(this.getKeyName()));
                if (this.getDedicatedHostId() != null) {
                    data.set("dedicatedHostId", om.valueToTree(this.getDedicatedHostId()));
                }
                if (this.getPlacementGroupId() != null) {
                    data.set("placementGroupId", om.valueToTree(this.getPlacementGroupId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.HostInfoForCreateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostInfoForCreateProperty.Jsii$Proxy that = (HostInfoForCreateProperty.Jsii$Proxy) o;

                if (!hostName.equals(that.hostName)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!keyName.equals(that.keyName)) return false;
                if (this.dedicatedHostId != null ? !this.dedicatedHostId.equals(that.dedicatedHostId) : that.dedicatedHostId != null) return false;
                return this.placementGroupId != null ? this.placementGroupId.equals(that.placementGroupId) : that.placementGroupId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostName.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.keyName.hashCode());
                result = 31 * result + (this.dedicatedHostId != null ? this.dedicatedHostId.hashCode() : 0);
                result = 31 * result + (this.placementGroupId != null ? this.placementGroupId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * An object that represents an initial VLAN subnet for the Amazon EVS environment. Amazon EVS creates initial VLAN subnets when you first create the environment. Amazon EVS creates the following 10 VLAN subnets: host management VLAN, vMotion VLAN, vSAN VLAN, VTEP VLAN, Edge VTEP VLAN, Management VM VLAN, HCX uplink VLAN, NSX uplink VLAN, expansion VLAN 1, expansion VLAN 2.
     * <p>
     * <blockquote>
     * <p>
     * For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * InitialVlanInfoProperty initialVlanInfoProperty = InitialVlanInfoProperty.builder()
     *         .cidr("cidr")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlaninfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlaninfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.InitialVlanInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialVlanInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialVlanInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CIDR block that you provide to create an Amazon EVS VLAN subnet.
         * <p>
         * Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlaninfo.html#cfn-evs-environment-initialvlaninfo-cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlaninfo.html#cfn-evs-environment-initialvlaninfo-cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCidr();

        /**
         * @return a {@link Builder} of {@link InitialVlanInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialVlanInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialVlanInfoProperty> {
            java.lang.String cidr;

            /**
             * Sets the value of {@link InitialVlanInfoProperty#getCidr}
             * @param cidr The CIDR block that you provide to create an Amazon EVS VLAN subnet. This parameter is required.
             *             Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialVlanInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialVlanInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialVlanInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialVlanInfoProperty {
            private final java.lang.String cidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            }

            @Override
            public final java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cidr", om.valueToTree(this.getCidr()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.InitialVlanInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialVlanInfoProperty.Jsii$Proxy that = (InitialVlanInfoProperty.Jsii$Proxy) o;

                return this.cidr.equals(that.cidr);
            }

            @Override
            public final int hashCode() {
                int result = this.cidr.hashCode();
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * InitialVlansProperty initialVlansProperty = InitialVlansProperty.builder()
     *         .edgeVTep(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .expansionVlan1(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .expansionVlan2(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .hcx(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .nsxUpLink(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .vmkManagement(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .vmManagement(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .vMotion(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .vSan(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .vTep(InitialVlanInfoProperty.builder()
     *                 .cidr("cidr")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.InitialVlansProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialVlansProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialVlansProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The edge VTEP VLAN subnet.
         * <p>
         * This VLAN subnet manages traffic flowing between the internal network and external networks, including internet access and other site connections.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-edgevtep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-edgevtep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEdgeVTep();

        /**
         * An additional VLAN subnet that can be used to extend VCF capabilities once configured.
         * <p>
         * For example, you can configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of multiple NSX deployments across different locations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-expansionvlan1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-expansionvlan1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExpansionVlan1();

        /**
         * An additional VLAN subnet that can be used to extend VCF capabilities once configured.
         * <p>
         * For example, you can configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of multiple NSX deployments across different locations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-expansionvlan2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-expansionvlan2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExpansionVlan2();

        /**
         * The HCX VLAN subnet.
         * <p>
         * This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to reach their peers and enable HCX Service Mesh creation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-hcx">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-hcx</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHcx();

        /**
         * The NSX uplink VLAN subnet.
         * <p>
         * This VLAN subnet allows connectivity to the NSX overlay network.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-nsxuplink">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-nsxuplink</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNsxUpLink();

        /**
         * The host VMkernel management VLAN subnet.
         * <p>
         * This VLAN subnet carries traffic for managing ESXi hosts and communicating with VMware vCenter Server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vmkmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vmkmanagement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVmkManagement();

        /**
         * The VM management VLAN subnet.
         * <p>
         * This VLAN subnet carries traffic for vSphere virtual machines.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vmmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vmmanagement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVmManagement();

        /**
         * The vMotion VLAN subnet.
         * <p>
         * This VLAN subnet carries traffic for vSphere vMotion.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vmotion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vmotion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVMotion();

        /**
         * The vSAN VLAN subnet.
         * <p>
         * This VLAN subnet carries the communication between ESXi hosts to implement a vSAN shared storage pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vsan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vsan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVSan();

        /**
         * The VTEP VLAN subnet.
         * <p>
         * This VLAN subnet handles internal network traffic between virtual machines within a VCF instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vtep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-initialvlans.html#cfn-evs-environment-initialvlans-vtep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVTep();

        /**
         * @return a {@link Builder} of {@link InitialVlansProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialVlansProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialVlansProperty> {
            java.lang.Object edgeVTep;
            java.lang.Object expansionVlan1;
            java.lang.Object expansionVlan2;
            java.lang.Object hcx;
            java.lang.Object nsxUpLink;
            java.lang.Object vmkManagement;
            java.lang.Object vmManagement;
            java.lang.Object vMotion;
            java.lang.Object vSan;
            java.lang.Object vTep;

            /**
             * Sets the value of {@link InitialVlansProperty#getEdgeVTep}
             * @param edgeVTep The edge VTEP VLAN subnet. This parameter is required.
             *                 This VLAN subnet manages traffic flowing between the internal network and external networks, including internet access and other site connections.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder edgeVTep(software.amazon.awscdk.IResolvable edgeVTep) {
                this.edgeVTep = edgeVTep;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getEdgeVTep}
             * @param edgeVTep The edge VTEP VLAN subnet. This parameter is required.
             *                 This VLAN subnet manages traffic flowing between the internal network and external networks, including internet access and other site connections.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder edgeVTep(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty edgeVTep) {
                this.edgeVTep = edgeVTep;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getExpansionVlan1}
             * @param expansionVlan1 An additional VLAN subnet that can be used to extend VCF capabilities once configured. This parameter is required.
             *                       For example, you can configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of multiple NSX deployments across different locations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expansionVlan1(software.amazon.awscdk.IResolvable expansionVlan1) {
                this.expansionVlan1 = expansionVlan1;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getExpansionVlan1}
             * @param expansionVlan1 An additional VLAN subnet that can be used to extend VCF capabilities once configured. This parameter is required.
             *                       For example, you can configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of multiple NSX deployments across different locations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expansionVlan1(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty expansionVlan1) {
                this.expansionVlan1 = expansionVlan1;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getExpansionVlan2}
             * @param expansionVlan2 An additional VLAN subnet that can be used to extend VCF capabilities once configured. This parameter is required.
             *                       For example, you can configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of multiple NSX deployments across different locations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expansionVlan2(software.amazon.awscdk.IResolvable expansionVlan2) {
                this.expansionVlan2 = expansionVlan2;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getExpansionVlan2}
             * @param expansionVlan2 An additional VLAN subnet that can be used to extend VCF capabilities once configured. This parameter is required.
             *                       For example, you can configure an expansion VLAN subnet to use NSX Federation for centralized management and synchronization of multiple NSX deployments across different locations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expansionVlan2(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty expansionVlan2) {
                this.expansionVlan2 = expansionVlan2;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getHcx}
             * @param hcx The HCX VLAN subnet. This parameter is required.
             *            This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to reach their peers and enable HCX Service Mesh creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hcx(software.amazon.awscdk.IResolvable hcx) {
                this.hcx = hcx;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getHcx}
             * @param hcx The HCX VLAN subnet. This parameter is required.
             *            This VLAN subnet allows the HCX Interconnnect (IX) and HCX Network Extension (NE) to reach their peers and enable HCX Service Mesh creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hcx(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty hcx) {
                this.hcx = hcx;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getNsxUpLink}
             * @param nsxUpLink The NSX uplink VLAN subnet. This parameter is required.
             *                  This VLAN subnet allows connectivity to the NSX overlay network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxUpLink(software.amazon.awscdk.IResolvable nsxUpLink) {
                this.nsxUpLink = nsxUpLink;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getNsxUpLink}
             * @param nsxUpLink The NSX uplink VLAN subnet. This parameter is required.
             *                  This VLAN subnet allows connectivity to the NSX overlay network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxUpLink(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty nsxUpLink) {
                this.nsxUpLink = nsxUpLink;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVmkManagement}
             * @param vmkManagement The host VMkernel management VLAN subnet. This parameter is required.
             *                      This VLAN subnet carries traffic for managing ESXi hosts and communicating with VMware vCenter Server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vmkManagement(software.amazon.awscdk.IResolvable vmkManagement) {
                this.vmkManagement = vmkManagement;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVmkManagement}
             * @param vmkManagement The host VMkernel management VLAN subnet. This parameter is required.
             *                      This VLAN subnet carries traffic for managing ESXi hosts and communicating with VMware vCenter Server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vmkManagement(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty vmkManagement) {
                this.vmkManagement = vmkManagement;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVmManagement}
             * @param vmManagement The VM management VLAN subnet. This parameter is required.
             *                     This VLAN subnet carries traffic for vSphere virtual machines.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vmManagement(software.amazon.awscdk.IResolvable vmManagement) {
                this.vmManagement = vmManagement;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVmManagement}
             * @param vmManagement The VM management VLAN subnet. This parameter is required.
             *                     This VLAN subnet carries traffic for vSphere virtual machines.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vmManagement(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty vmManagement) {
                this.vmManagement = vmManagement;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVMotion}
             * @param vMotion The vMotion VLAN subnet. This parameter is required.
             *                This VLAN subnet carries traffic for vSphere vMotion.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vMotion(software.amazon.awscdk.IResolvable vMotion) {
                this.vMotion = vMotion;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVMotion}
             * @param vMotion The vMotion VLAN subnet. This parameter is required.
             *                This VLAN subnet carries traffic for vSphere vMotion.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vMotion(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty vMotion) {
                this.vMotion = vMotion;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVSan}
             * @param vSan The vSAN VLAN subnet. This parameter is required.
             *             This VLAN subnet carries the communication between ESXi hosts to implement a vSAN shared storage pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vSan(software.amazon.awscdk.IResolvable vSan) {
                this.vSan = vSan;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVSan}
             * @param vSan The vSAN VLAN subnet. This parameter is required.
             *             This VLAN subnet carries the communication between ESXi hosts to implement a vSAN shared storage pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vSan(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty vSan) {
                this.vSan = vSan;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVTep}
             * @param vTep The VTEP VLAN subnet. This parameter is required.
             *             This VLAN subnet handles internal network traffic between virtual machines within a VCF instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vTep(software.amazon.awscdk.IResolvable vTep) {
                this.vTep = vTep;
                return this;
            }

            /**
             * Sets the value of {@link InitialVlansProperty#getVTep}
             * @param vTep The VTEP VLAN subnet. This parameter is required.
             *             This VLAN subnet handles internal network traffic between virtual machines within a VCF instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vTep(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlanInfoProperty vTep) {
                this.vTep = vTep;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialVlansProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialVlansProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialVlansProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialVlansProperty {
            private final java.lang.Object edgeVTep;
            private final java.lang.Object expansionVlan1;
            private final java.lang.Object expansionVlan2;
            private final java.lang.Object hcx;
            private final java.lang.Object nsxUpLink;
            private final java.lang.Object vmkManagement;
            private final java.lang.Object vmManagement;
            private final java.lang.Object vMotion;
            private final java.lang.Object vSan;
            private final java.lang.Object vTep;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.edgeVTep = software.amazon.jsii.Kernel.get(this, "edgeVTep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expansionVlan1 = software.amazon.jsii.Kernel.get(this, "expansionVlan1", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expansionVlan2 = software.amazon.jsii.Kernel.get(this, "expansionVlan2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hcx = software.amazon.jsii.Kernel.get(this, "hcx", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nsxUpLink = software.amazon.jsii.Kernel.get(this, "nsxUpLink", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vmkManagement = software.amazon.jsii.Kernel.get(this, "vmkManagement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vmManagement = software.amazon.jsii.Kernel.get(this, "vmManagement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vMotion = software.amazon.jsii.Kernel.get(this, "vMotion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vSan = software.amazon.jsii.Kernel.get(this, "vSan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vTep = software.amazon.jsii.Kernel.get(this, "vTep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.edgeVTep = java.util.Objects.requireNonNull(builder.edgeVTep, "edgeVTep is required");
                this.expansionVlan1 = java.util.Objects.requireNonNull(builder.expansionVlan1, "expansionVlan1 is required");
                this.expansionVlan2 = java.util.Objects.requireNonNull(builder.expansionVlan2, "expansionVlan2 is required");
                this.hcx = java.util.Objects.requireNonNull(builder.hcx, "hcx is required");
                this.nsxUpLink = java.util.Objects.requireNonNull(builder.nsxUpLink, "nsxUpLink is required");
                this.vmkManagement = java.util.Objects.requireNonNull(builder.vmkManagement, "vmkManagement is required");
                this.vmManagement = java.util.Objects.requireNonNull(builder.vmManagement, "vmManagement is required");
                this.vMotion = java.util.Objects.requireNonNull(builder.vMotion, "vMotion is required");
                this.vSan = java.util.Objects.requireNonNull(builder.vSan, "vSan is required");
                this.vTep = java.util.Objects.requireNonNull(builder.vTep, "vTep is required");
            }

            @Override
            public final java.lang.Object getEdgeVTep() {
                return this.edgeVTep;
            }

            @Override
            public final java.lang.Object getExpansionVlan1() {
                return this.expansionVlan1;
            }

            @Override
            public final java.lang.Object getExpansionVlan2() {
                return this.expansionVlan2;
            }

            @Override
            public final java.lang.Object getHcx() {
                return this.hcx;
            }

            @Override
            public final java.lang.Object getNsxUpLink() {
                return this.nsxUpLink;
            }

            @Override
            public final java.lang.Object getVmkManagement() {
                return this.vmkManagement;
            }

            @Override
            public final java.lang.Object getVmManagement() {
                return this.vmManagement;
            }

            @Override
            public final java.lang.Object getVMotion() {
                return this.vMotion;
            }

            @Override
            public final java.lang.Object getVSan() {
                return this.vSan;
            }

            @Override
            public final java.lang.Object getVTep() {
                return this.vTep;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("edgeVTep", om.valueToTree(this.getEdgeVTep()));
                data.set("expansionVlan1", om.valueToTree(this.getExpansionVlan1()));
                data.set("expansionVlan2", om.valueToTree(this.getExpansionVlan2()));
                data.set("hcx", om.valueToTree(this.getHcx()));
                data.set("nsxUpLink", om.valueToTree(this.getNsxUpLink()));
                data.set("vmkManagement", om.valueToTree(this.getVmkManagement()));
                data.set("vmManagement", om.valueToTree(this.getVmManagement()));
                data.set("vMotion", om.valueToTree(this.getVMotion()));
                data.set("vSan", om.valueToTree(this.getVSan()));
                data.set("vTep", om.valueToTree(this.getVTep()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.InitialVlansProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialVlansProperty.Jsii$Proxy that = (InitialVlansProperty.Jsii$Proxy) o;

                if (!edgeVTep.equals(that.edgeVTep)) return false;
                if (!expansionVlan1.equals(that.expansionVlan1)) return false;
                if (!expansionVlan2.equals(that.expansionVlan2)) return false;
                if (!hcx.equals(that.hcx)) return false;
                if (!nsxUpLink.equals(that.nsxUpLink)) return false;
                if (!vmkManagement.equals(that.vmkManagement)) return false;
                if (!vmManagement.equals(that.vmManagement)) return false;
                if (!vMotion.equals(that.vMotion)) return false;
                if (!vSan.equals(that.vSan)) return false;
                return this.vTep.equals(that.vTep);
            }

            @Override
            public final int hashCode() {
                int result = this.edgeVTep.hashCode();
                result = 31 * result + (this.expansionVlan1.hashCode());
                result = 31 * result + (this.expansionVlan2.hashCode());
                result = 31 * result + (this.hcx.hashCode());
                result = 31 * result + (this.nsxUpLink.hashCode());
                result = 31 * result + (this.vmkManagement.hashCode());
                result = 31 * result + (this.vmManagement.hashCode());
                result = 31 * result + (this.vMotion.hashCode());
                result = 31 * result + (this.vSan.hashCode());
                result = 31 * result + (this.vTep.hashCode());
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * The license information that Amazon EVS requires to create an environment. Amazon EVS requires two license keys: a VCF solution key and a vSAN license key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * LicenseInfoProperty licenseInfoProperty = LicenseInfoProperty.builder()
     *         .solutionKey("solutionKey")
     *         .vsanKey("vsanKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-licenseinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-licenseinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.LicenseInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(LicenseInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LicenseInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VCF solution key.
         * <p>
         * This license unlocks VMware VCF product features, including vSphere, NSX, SDDC Manager, and vCenter Server. The VCF solution key must cover a minimum of 256 cores.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-licenseinfo.html#cfn-evs-environment-licenseinfo-solutionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-licenseinfo.html#cfn-evs-environment-licenseinfo-solutionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSolutionKey();

        /**
         * The VSAN license key.
         * <p>
         * This license unlocks vSAN features. The vSAN license key must provide at least 110 TiB of vSAN capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-licenseinfo.html#cfn-evs-environment-licenseinfo-vsankey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-licenseinfo.html#cfn-evs-environment-licenseinfo-vsankey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVsanKey();

        /**
         * @return a {@link Builder} of {@link LicenseInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LicenseInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LicenseInfoProperty> {
            java.lang.String solutionKey;
            java.lang.String vsanKey;

            /**
             * Sets the value of {@link LicenseInfoProperty#getSolutionKey}
             * @param solutionKey The VCF solution key. This parameter is required.
             *                    This license unlocks VMware VCF product features, including vSphere, NSX, SDDC Manager, and vCenter Server. The VCF solution key must cover a minimum of 256 cores.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder solutionKey(java.lang.String solutionKey) {
                this.solutionKey = solutionKey;
                return this;
            }

            /**
             * Sets the value of {@link LicenseInfoProperty#getVsanKey}
             * @param vsanKey The VSAN license key. This parameter is required.
             *                This license unlocks vSAN features. The vSAN license key must provide at least 110 TiB of vSAN capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vsanKey(java.lang.String vsanKey) {
                this.vsanKey = vsanKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LicenseInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LicenseInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseInfoProperty {
            private final java.lang.String solutionKey;
            private final java.lang.String vsanKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.solutionKey = software.amazon.jsii.Kernel.get(this, "solutionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vsanKey = software.amazon.jsii.Kernel.get(this, "vsanKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.solutionKey = java.util.Objects.requireNonNull(builder.solutionKey, "solutionKey is required");
                this.vsanKey = java.util.Objects.requireNonNull(builder.vsanKey, "vsanKey is required");
            }

            @Override
            public final java.lang.String getSolutionKey() {
                return this.solutionKey;
            }

            @Override
            public final java.lang.String getVsanKey() {
                return this.vsanKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("solutionKey", om.valueToTree(this.getSolutionKey()));
                data.set("vsanKey", om.valueToTree(this.getVsanKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.LicenseInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LicenseInfoProperty.Jsii$Proxy that = (LicenseInfoProperty.Jsii$Proxy) o;

                if (!solutionKey.equals(that.solutionKey)) return false;
                return this.vsanKey.equals(that.vsanKey);
            }

            @Override
            public final int hashCode() {
                int result = this.solutionKey.hashCode();
                result = 31 * result + (this.vsanKey.hashCode());
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * A managed secret that contains the credentials for installing vCenter Server, NSX, and SDDC Manager. During environment creation, the Amazon EVS control plane uses AWS Secrets Manager to create, encrypt, validate, and store secrets. If you choose to delete your environment, Amazon EVS also deletes the secrets that are associated with your environment. Amazon EVS does not provide managed rotation of secrets. We recommend that you rotate secrets regularly to ensure that secrets are not long-lived.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * SecretProperty secretProperty = SecretProperty.builder()
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-secret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-secret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.SecretProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-secret.html#cfn-evs-environment-secret-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-secret.html#cfn-evs-environment-secret-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretProperty> {
            java.lang.String secretArn;

            /**
             * Sets the value of {@link SecretProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of the secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProperty {
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.SecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretProperty.Jsii$Proxy that = (SecretProperty.Jsii$Proxy) o;

                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn != null ? this.secretArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * The security groups that allow traffic between the Amazon EVS control plane and your VPC for Amazon EVS service access. If a security group is not specified, Amazon EVS uses the default security group in your account for service access.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * ServiceAccessSecurityGroupsProperty serviceAccessSecurityGroupsProperty = ServiceAccessSecurityGroupsProperty.builder()
     *         .securityGroups(List.of("securityGroups"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-serviceaccesssecuritygroups.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-serviceaccesssecuritygroups.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.ServiceAccessSecurityGroupsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceAccessSecurityGroupsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceAccessSecurityGroupsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The security groups that allow service access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-serviceaccesssecuritygroups.html#cfn-evs-environment-serviceaccesssecuritygroups-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-serviceaccesssecuritygroups.html#cfn-evs-environment-serviceaccesssecuritygroups-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceAccessSecurityGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceAccessSecurityGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceAccessSecurityGroupsProperty> {
            java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link ServiceAccessSecurityGroupsProperty#getSecurityGroups}
             * @param securityGroups The security groups that allow service access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceAccessSecurityGroupsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceAccessSecurityGroupsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceAccessSecurityGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceAccessSecurityGroupsProperty {
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroups = builder.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.ServiceAccessSecurityGroupsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceAccessSecurityGroupsProperty.Jsii$Proxy that = (ServiceAccessSecurityGroupsProperty.Jsii$Proxy) o;

                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroups != null ? this.securityGroups.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * The DNS hostnames that Amazon EVS uses to install VMware vCenter Server, NSX, SDDC Manager, and Cloud Builder. Each hostname must be unique, and resolve to a domain name that you've registered in your DNS service of choice. Hostnames cannot be changed.
     * <p>
     * VMware VCF requires the deployment of two NSX Edge nodes, and three NSX Manager virtual machines.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evs.*;
     * VcfHostnamesProperty vcfHostnamesProperty = VcfHostnamesProperty.builder()
     *         .cloudBuilder("cloudBuilder")
     *         .nsx("nsx")
     *         .nsxEdge1("nsxEdge1")
     *         .nsxEdge2("nsxEdge2")
     *         .nsxManager1("nsxManager1")
     *         .nsxManager2("nsxManager2")
     *         .nsxManager3("nsxManager3")
     *         .sddcManager("sddcManager")
     *         .vCenter("vCenter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironment.VcfHostnamesProperty")
    @software.amazon.jsii.Jsii.Proxy(VcfHostnamesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VcfHostnamesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hostname for VMware Cloud Builder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-cloudbuilder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-cloudbuilder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCloudBuilder();

        /**
         * The VMware NSX hostname.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsx">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsx</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNsx();

        /**
         * The hostname for the first NSX Edge node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxedge1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxedge1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNsxEdge1();

        /**
         * The hostname for the second NSX Edge node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxedge2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxedge2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNsxEdge2();

        /**
         * The hostname for the first VMware NSX Manager virtual machine (VM).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxmanager1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxmanager1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNsxManager1();

        /**
         * The hostname for the second VMware NSX Manager virtual machine (VM).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxmanager2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxmanager2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNsxManager2();

        /**
         * The hostname for the third VMware NSX Manager virtual machine (VM).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxmanager3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-nsxmanager3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNsxManager3();

        /**
         * The hostname for SDDC Manager.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-sddcmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-sddcmanager</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSddcManager();

        /**
         * The VMware vCenter hostname.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-vcenter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evs-environment-vcfhostnames.html#cfn-evs-environment-vcfhostnames-vcenter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVCenter();

        /**
         * @return a {@link Builder} of {@link VcfHostnamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VcfHostnamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VcfHostnamesProperty> {
            java.lang.String cloudBuilder;
            java.lang.String nsx;
            java.lang.String nsxEdge1;
            java.lang.String nsxEdge2;
            java.lang.String nsxManager1;
            java.lang.String nsxManager2;
            java.lang.String nsxManager3;
            java.lang.String sddcManager;
            java.lang.String vCenter;

            /**
             * Sets the value of {@link VcfHostnamesProperty#getCloudBuilder}
             * @param cloudBuilder The hostname for VMware Cloud Builder. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudBuilder(java.lang.String cloudBuilder) {
                this.cloudBuilder = cloudBuilder;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getNsx}
             * @param nsx The VMware NSX hostname. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsx(java.lang.String nsx) {
                this.nsx = nsx;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getNsxEdge1}
             * @param nsxEdge1 The hostname for the first NSX Edge node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxEdge1(java.lang.String nsxEdge1) {
                this.nsxEdge1 = nsxEdge1;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getNsxEdge2}
             * @param nsxEdge2 The hostname for the second NSX Edge node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxEdge2(java.lang.String nsxEdge2) {
                this.nsxEdge2 = nsxEdge2;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getNsxManager1}
             * @param nsxManager1 The hostname for the first VMware NSX Manager virtual machine (VM). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxManager1(java.lang.String nsxManager1) {
                this.nsxManager1 = nsxManager1;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getNsxManager2}
             * @param nsxManager2 The hostname for the second VMware NSX Manager virtual machine (VM). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxManager2(java.lang.String nsxManager2) {
                this.nsxManager2 = nsxManager2;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getNsxManager3}
             * @param nsxManager3 The hostname for the third VMware NSX Manager virtual machine (VM). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nsxManager3(java.lang.String nsxManager3) {
                this.nsxManager3 = nsxManager3;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getSddcManager}
             * @param sddcManager The hostname for SDDC Manager. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sddcManager(java.lang.String sddcManager) {
                this.sddcManager = sddcManager;
                return this;
            }

            /**
             * Sets the value of {@link VcfHostnamesProperty#getVCenter}
             * @param vCenter The VMware vCenter hostname. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCenter(java.lang.String vCenter) {
                this.vCenter = vCenter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VcfHostnamesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VcfHostnamesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VcfHostnamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VcfHostnamesProperty {
            private final java.lang.String cloudBuilder;
            private final java.lang.String nsx;
            private final java.lang.String nsxEdge1;
            private final java.lang.String nsxEdge2;
            private final java.lang.String nsxManager1;
            private final java.lang.String nsxManager2;
            private final java.lang.String nsxManager3;
            private final java.lang.String sddcManager;
            private final java.lang.String vCenter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudBuilder = software.amazon.jsii.Kernel.get(this, "cloudBuilder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nsx = software.amazon.jsii.Kernel.get(this, "nsx", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nsxEdge1 = software.amazon.jsii.Kernel.get(this, "nsxEdge1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nsxEdge2 = software.amazon.jsii.Kernel.get(this, "nsxEdge2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nsxManager1 = software.amazon.jsii.Kernel.get(this, "nsxManager1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nsxManager2 = software.amazon.jsii.Kernel.get(this, "nsxManager2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nsxManager3 = software.amazon.jsii.Kernel.get(this, "nsxManager3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sddcManager = software.amazon.jsii.Kernel.get(this, "sddcManager", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vCenter = software.amazon.jsii.Kernel.get(this, "vCenter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudBuilder = java.util.Objects.requireNonNull(builder.cloudBuilder, "cloudBuilder is required");
                this.nsx = java.util.Objects.requireNonNull(builder.nsx, "nsx is required");
                this.nsxEdge1 = java.util.Objects.requireNonNull(builder.nsxEdge1, "nsxEdge1 is required");
                this.nsxEdge2 = java.util.Objects.requireNonNull(builder.nsxEdge2, "nsxEdge2 is required");
                this.nsxManager1 = java.util.Objects.requireNonNull(builder.nsxManager1, "nsxManager1 is required");
                this.nsxManager2 = java.util.Objects.requireNonNull(builder.nsxManager2, "nsxManager2 is required");
                this.nsxManager3 = java.util.Objects.requireNonNull(builder.nsxManager3, "nsxManager3 is required");
                this.sddcManager = java.util.Objects.requireNonNull(builder.sddcManager, "sddcManager is required");
                this.vCenter = java.util.Objects.requireNonNull(builder.vCenter, "vCenter is required");
            }

            @Override
            public final java.lang.String getCloudBuilder() {
                return this.cloudBuilder;
            }

            @Override
            public final java.lang.String getNsx() {
                return this.nsx;
            }

            @Override
            public final java.lang.String getNsxEdge1() {
                return this.nsxEdge1;
            }

            @Override
            public final java.lang.String getNsxEdge2() {
                return this.nsxEdge2;
            }

            @Override
            public final java.lang.String getNsxManager1() {
                return this.nsxManager1;
            }

            @Override
            public final java.lang.String getNsxManager2() {
                return this.nsxManager2;
            }

            @Override
            public final java.lang.String getNsxManager3() {
                return this.nsxManager3;
            }

            @Override
            public final java.lang.String getSddcManager() {
                return this.sddcManager;
            }

            @Override
            public final java.lang.String getVCenter() {
                return this.vCenter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudBuilder", om.valueToTree(this.getCloudBuilder()));
                data.set("nsx", om.valueToTree(this.getNsx()));
                data.set("nsxEdge1", om.valueToTree(this.getNsxEdge1()));
                data.set("nsxEdge2", om.valueToTree(this.getNsxEdge2()));
                data.set("nsxManager1", om.valueToTree(this.getNsxManager1()));
                data.set("nsxManager2", om.valueToTree(this.getNsxManager2()));
                data.set("nsxManager3", om.valueToTree(this.getNsxManager3()));
                data.set("sddcManager", om.valueToTree(this.getSddcManager()));
                data.set("vCenter", om.valueToTree(this.getVCenter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironment.VcfHostnamesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VcfHostnamesProperty.Jsii$Proxy that = (VcfHostnamesProperty.Jsii$Proxy) o;

                if (!cloudBuilder.equals(that.cloudBuilder)) return false;
                if (!nsx.equals(that.nsx)) return false;
                if (!nsxEdge1.equals(that.nsxEdge1)) return false;
                if (!nsxEdge2.equals(that.nsxEdge2)) return false;
                if (!nsxManager1.equals(that.nsxManager1)) return false;
                if (!nsxManager2.equals(that.nsxManager2)) return false;
                if (!nsxManager3.equals(that.nsxManager3)) return false;
                if (!sddcManager.equals(that.sddcManager)) return false;
                return this.vCenter.equals(that.vCenter);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudBuilder.hashCode();
                result = 31 * result + (this.nsx.hashCode());
                result = 31 * result + (this.nsxEdge1.hashCode());
                result = 31 * result + (this.nsxEdge2.hashCode());
                result = 31 * result + (this.nsxManager1.hashCode());
                result = 31 * result + (this.nsxManager2.hashCode());
                result = 31 * result + (this.nsxManager3.hashCode());
                result = 31 * result + (this.sddcManager.hashCode());
                result = 31 * result + (this.vCenter.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.evs.CfnEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.evs.CfnEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.evs.CfnEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.evs.CfnEnvironmentProps.Builder();
        }

        /**
         * The connectivity configuration for the environment.
         * <p>
         * Amazon EVS requires that you specify two route server peer IDs. During environment creation, the route server endpoints peer with the NSX uplink VLAN for connectivity to the NSX overlay network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-connectivityinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-connectivityinfo</a>
         * @param connectivityInfo The connectivity configuration for the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectivityInfo(final software.amazon.awscdk.IResolvable connectivityInfo) {
            this.props.connectivityInfo(connectivityInfo);
            return this;
        }
        /**
         * The connectivity configuration for the environment.
         * <p>
         * Amazon EVS requires that you specify two route server peer IDs. During environment creation, the route server endpoints peer with the NSX uplink VLAN for connectivity to the NSX overlay network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-connectivityinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-connectivityinfo</a>
         * @param connectivityInfo The connectivity configuration for the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectivityInfo(final software.amazon.awscdk.services.evs.CfnEnvironment.ConnectivityInfoProperty connectivityInfo) {
            this.props.connectivityInfo(connectivityInfo);
            return this;
        }

        /**
         * The license information that Amazon EVS requires to create an environment.
         * <p>
         * Amazon EVS requires two license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-licenseinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-licenseinfo</a>
         * @param licenseInfo The license information that Amazon EVS requires to create an environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseInfo(final software.amazon.awscdk.IResolvable licenseInfo) {
            this.props.licenseInfo(licenseInfo);
            return this;
        }
        /**
         * The license information that Amazon EVS requires to create an environment.
         * <p>
         * Amazon EVS requires two license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-licenseinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-licenseinfo</a>
         * @param licenseInfo The license information that Amazon EVS requires to create an environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseInfo(final software.amazon.awscdk.services.evs.CfnEnvironment.LicenseInfoProperty licenseInfo) {
            this.props.licenseInfo(licenseInfo);
            return this;
        }

        /**
         * The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC.
         * <p>
         * Amazon EVS uses this subnet to perform validations and create the environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssubnetid</a>
         * @param serviceAccessSubnetId The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessSubnetId(final java.lang.String serviceAccessSubnetId) {
            this.props.serviceAccessSubnetId(serviceAccessSubnetId);
            return this;
        }

        /**
         * The Broadcom Site ID that is associated with your Amazon EVS environment.
         * <p>
         * Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom VCF license usage reporting requirements for Amazon EVS.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-siteid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-siteid</a>
         * @param siteId The Broadcom Site ID that is associated with your Amazon EVS environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder siteId(final java.lang.String siteId) {
            this.props.siteId(siteId);
            return this;
        }

        /**
         * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
         * <p>
         * Information about your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-termsaccepted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-termsaccepted</a>
         * @param termsAccepted Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder termsAccepted(final java.lang.Boolean termsAccepted) {
            this.props.termsAccepted(termsAccepted);
            return this;
        }
        /**
         * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
         * <p>
         * Information about your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-termsaccepted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-termsaccepted</a>
         * @param termsAccepted Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder termsAccepted(final software.amazon.awscdk.IResolvable termsAccepted) {
            this.props.termsAccepted(termsAccepted);
            return this;
        }

        /**
         * The DNS hostnames to be used by the VCF management appliances in your environment.
         * <p>
         * For environment creation to be successful, each hostname entry must resolve to a domain name that you've registered in your DNS service of choice and configured in the DHCP option set of your VPC. DNS hostnames cannot be changed after environment creation has started.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfhostnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfhostnames</a>
         * @param vcfHostnames The DNS hostnames to be used by the VCF management appliances in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcfHostnames(final software.amazon.awscdk.IResolvable vcfHostnames) {
            this.props.vcfHostnames(vcfHostnames);
            return this;
        }
        /**
         * The DNS hostnames to be used by the VCF management appliances in your environment.
         * <p>
         * For environment creation to be successful, each hostname entry must resolve to a domain name that you've registered in your DNS service of choice and configured in the DHCP option set of your VPC. DNS hostnames cannot be changed after environment creation has started.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfhostnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfhostnames</a>
         * @param vcfHostnames The DNS hostnames to be used by the VCF management appliances in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcfHostnames(final software.amazon.awscdk.services.evs.CfnEnvironment.VcfHostnamesProperty vcfHostnames) {
            this.props.vcfHostnames(vcfHostnames);
            return this;
        }

        /**
         * The VCF version of the environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfversion</a>
         * @param vcfVersion The VCF version of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcfVersion(final java.lang.String vcfVersion) {
            this.props.vcfVersion(vcfVersion);
            return this;
        }

        /**
         * The VPC associated with the environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vpcid</a>
         * @param vpcId The VPC associated with the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * The name of the environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-environmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-environmentname</a>
         * @param environmentName The name of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(final java.lang.String environmentName) {
            this.props.environmentName(environmentName);
            return this;
        }

        /**
         * Required for environment resource creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-hosts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-hosts</a>
         * @param hosts Required for environment resource creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hosts(final software.amazon.awscdk.IResolvable hosts) {
            this.props.hosts(hosts);
            return this;
        }
        /**
         * Required for environment resource creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-hosts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-hosts</a>
         * @param hosts Required for environment resource creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hosts(final java.util.List<? extends java.lang.Object> hosts) {
            this.props.hosts(hosts);
            return this;
        }

        /**
         * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
         * <p>
         * The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
         * <p>
         * Required for environment resource creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-initialvlans">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-initialvlans</a>
         * @param initialVlans <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVlans(final software.amazon.awscdk.IResolvable initialVlans) {
            this.props.initialVlans(initialVlans);
            return this;
        }
        /**
         * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
         * <p>
         * The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
         * <p>
         * Required for environment resource creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-initialvlans">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-initialvlans</a>
         * @param initialVlans <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVlans(final software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlansProperty initialVlans) {
            this.props.initialVlans(initialVlans);
            return this;
        }

        /**
         * The AWS KMS key ID that AWS Secrets Manager uses to encrypt secrets that are associated with the environment.
         * <p>
         * These secrets contain the VCF credentials that are needed to install vCenter Server, NSX, and SDDC Manager.
         * <p>
         * By default, Amazon EVS use the AWS Secrets Manager managed key <code>aws/secretsmanager</code> . You can also specify a customer managed key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-kmskeyid</a>
         * @param kmsKeyId The AWS KMS key ID that AWS Secrets Manager uses to encrypt secrets that are associated with the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
         * <p>
         * If a security group is not specified, Amazon EVS uses the default security group in your account for service access.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssecuritygroups</a>
         * @param serviceAccessSecurityGroups The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessSecurityGroups(final software.amazon.awscdk.IResolvable serviceAccessSecurityGroups) {
            this.props.serviceAccessSecurityGroups(serviceAccessSecurityGroups);
            return this;
        }
        /**
         * The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
         * <p>
         * If a security group is not specified, Amazon EVS uses the default security group in your account for service access.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssecuritygroups</a>
         * @param serviceAccessSecurityGroups The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessSecurityGroups(final software.amazon.awscdk.services.evs.CfnEnvironment.ServiceAccessSecurityGroupsProperty serviceAccessSecurityGroups) {
            this.props.serviceAccessSecurityGroups(serviceAccessSecurityGroups);
            return this;
        }

        /**
         * Metadata that assists with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-tags</a>
         * @param tags Metadata that assists with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.evs.CfnEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.evs.CfnEnvironment build() {
            return new software.amazon.awscdk.services.evs.CfnEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
