package software.amazon.awscdk.services.iam;

/**
 * Basic options for a grant operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * Object conditions;
 * IGrantable grantable;
 * CommonGrantOptions commonGrantOptions = CommonGrantOptions.builder()
 *         .actions(List.of("actions"))
 *         .grantee(grantable)
 *         .resourceArns(List.of("resourceArns"))
 *         // the properties below are optional
 *         .conditions(Map.of(
 *                 "conditionsKey", Map.of(
 *                         "conditionsKey", conditions)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:38.541Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.CommonGrantOptions")
@software.amazon.jsii.Jsii.Proxy(CommonGrantOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonGrantOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The actions to grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

    /**
     * The principal to grant to.
     * <p>
     * Default: if principal is undefined, no work is done.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable getGrantee();

    /**
     * The resource ARNs to grant to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceArns();

    /**
     * Any conditions to attach to the grant.
     * <p>
     * Default: - No conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getConditions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonGrantOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonGrantOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonGrantOptions> {
        java.util.List<java.lang.String> actions;
        software.amazon.awscdk.services.iam.IGrantable grantee;
        java.util.List<java.lang.String> resourceArns;
        java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> conditions;

        /**
         * Sets the value of {@link CommonGrantOptions#getActions}
         * @param actions The actions to grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CommonGrantOptions#getGrantee}
         * @param grantee The principal to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(software.amazon.awscdk.services.iam.IGrantable grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of {@link CommonGrantOptions#getResourceArns}
         * @param resourceArns The resource ARNs to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        /**
         * Sets the value of {@link CommonGrantOptions#getConditions}
         * @param conditions Any conditions to attach to the grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.Map<java.lang.String, ? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> conditions) {
            this.conditions = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)conditions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonGrantOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonGrantOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonGrantOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonGrantOptions {
        private final java.util.List<java.lang.String> actions;
        private final software.amazon.awscdk.services.iam.IGrantable grantee;
        private final java.util.List<java.lang.String> resourceArns;
        private final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> conditions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.grantee = software.amazon.jsii.Kernel.get(this, "grantee", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class));
            this.resourceArns = software.amazon.jsii.Kernel.get(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.grantee = java.util.Objects.requireNonNull(builder.grantee, "grantee is required");
            this.resourceArns = java.util.Objects.requireNonNull(builder.resourceArns, "resourceArns is required");
            this.conditions = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)builder.conditions;
        }

        @Override
        public final java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.grantee;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getConditions() {
            return this.conditions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("grantee", om.valueToTree(this.getGrantee()));
            data.set("resourceArns", om.valueToTree(this.getResourceArns()));
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.CommonGrantOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonGrantOptions.Jsii$Proxy that = (CommonGrantOptions.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!grantee.equals(that.grantee)) return false;
            if (!resourceArns.equals(that.resourceArns)) return false;
            return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.grantee.hashCode());
            result = 31 * result + (this.resourceArns.hashCode());
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            return result;
        }
    }
}
