package software.amazon.awscdk.services.iam;

/**
 * Options for a grant operation that only applies to principals.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.constructs.*;
 * Object conditions;
 * Construct construct;
 * IGrantable grantable;
 * GrantOnPrincipalOptions grantOnPrincipalOptions = GrantOnPrincipalOptions.builder()
 *         .actions(List.of("actions"))
 *         .grantee(grantable)
 *         .resourceArns(List.of("resourceArns"))
 *         // the properties below are optional
 *         .conditions(Map.of(
 *                 "conditionsKey", Map.of(
 *                         "conditionsKey", conditions)))
 *         .scope(construct)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:38.547Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.GrantOnPrincipalOptions")
@software.amazon.jsii.Jsii.Proxy(GrantOnPrincipalOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrantOnPrincipalOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.CommonGrantOptions {

    /**
     * Construct to report warnings on in case grant could not be registered.
     * <p>
     * Default: - the construct in which this construct is defined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.constructs.IConstruct getScope() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrantOnPrincipalOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantOnPrincipalOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrantOnPrincipalOptions> {
        software.constructs.IConstruct scope;
        java.util.List<java.lang.String> actions;
        software.amazon.awscdk.services.iam.IGrantable grantee;
        java.util.List<java.lang.String> resourceArns;
        java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> conditions;

        /**
         * Sets the value of {@link GrantOnPrincipalOptions#getScope}
         * @param scope Construct to report warnings on in case grant could not be registered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.constructs.IConstruct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalOptions#getActions}
         * @param actions The actions to grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalOptions#getGrantee}
         * @param grantee The principal to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(software.amazon.awscdk.services.iam.IGrantable grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalOptions#getResourceArns}
         * @param resourceArns The resource ARNs to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalOptions#getConditions}
         * @param conditions Any conditions to attach to the grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.Map<java.lang.String, ? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> conditions) {
            this.conditions = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)conditions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantOnPrincipalOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrantOnPrincipalOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrantOnPrincipalOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantOnPrincipalOptions {
        private final software.constructs.IConstruct scope;
        private final java.util.List<java.lang.String> actions;
        private final software.amazon.awscdk.services.iam.IGrantable grantee;
        private final java.util.List<java.lang.String> resourceArns;
        private final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> conditions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.IConstruct.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.grantee = software.amazon.jsii.Kernel.get(this, "grantee", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class));
            this.resourceArns = software.amazon.jsii.Kernel.get(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scope = builder.scope;
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.grantee = java.util.Objects.requireNonNull(builder.grantee, "grantee is required");
            this.resourceArns = java.util.Objects.requireNonNull(builder.resourceArns, "resourceArns is required");
            this.conditions = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)builder.conditions;
        }

        @Override
        public final software.constructs.IConstruct getScope() {
            return this.scope;
        }

        @Override
        public final java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.grantee;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getConditions() {
            return this.conditions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            data.set("actions", om.valueToTree(this.getActions()));
            data.set("grantee", om.valueToTree(this.getGrantee()));
            data.set("resourceArns", om.valueToTree(this.getResourceArns()));
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.GrantOnPrincipalOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantOnPrincipalOptions.Jsii$Proxy that = (GrantOnPrincipalOptions.Jsii$Proxy) o;

            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (!actions.equals(that.actions)) return false;
            if (!grantee.equals(that.grantee)) return false;
            if (!resourceArns.equals(that.resourceArns)) return false;
            return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scope != null ? this.scope.hashCode() : 0;
            result = 31 * result + (this.actions.hashCode());
            result = 31 * result + (this.grantee.hashCode());
            result = 31 * result + (this.resourceArns.hashCode());
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            return result;
        }
    }
}
