package software.amazon.awscdk.services.iotsitewise;

/**
 * Creates an asset model from specified property and hierarchy definitions.
 * <p>
 * You create assets from asset models. With asset models, you can easily create assets of the same type that have standardized definitions. Each asset created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in the <em>AWS IoT SiteWise User Guide</em> .
 * <p>
 * You can create two types of asset models, <code>ASSET_MODEL</code> or <code>COMPONENT_MODEL</code> .
 * <p>
 * <ul>
 * <li><em>ASSET_MODEL</em> – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.</li>
 * <li><em>COMPONENT_MODEL</em> – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnAssetModel cfnAssetModel = CfnAssetModel.Builder.create(this, "MyCfnAssetModel")
 *         .assetModelName("assetModelName")
 *         // the properties below are optional
 *         .assetModelCompositeModels(List.of(AssetModelCompositeModelProperty.builder()
 *                 .name("name")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .composedAssetModelId("composedAssetModelId")
 *                 .compositeModelProperties(List.of(AssetModelPropertyProperty.builder()
 *                         .dataType("dataType")
 *                         .name("name")
 *                         .type(PropertyTypeProperty.builder()
 *                                 .typeName("typeName")
 *                                 // the properties below are optional
 *                                 .attribute(AttributeProperty.builder()
 *                                         .defaultValue("defaultValue")
 *                                         .build())
 *                                 .metric(MetricProperty.builder()
 *                                         .expression("expression")
 *                                         .variables(List.of(ExpressionVariableProperty.builder()
 *                                                 .name("name")
 *                                                 .value(VariableValueProperty.builder()
 *                                                         .hierarchyExternalId("hierarchyExternalId")
 *                                                         .hierarchyId("hierarchyId")
 *                                                         .hierarchyLogicalId("hierarchyLogicalId")
 *                                                         .propertyExternalId("propertyExternalId")
 *                                                         .propertyId("propertyId")
 *                                                         .propertyLogicalId("propertyLogicalId")
 *                                                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build()))
 *                                         .window(MetricWindowProperty.builder()
 *                                                 .tumbling(TumblingWindowProperty.builder()
 *                                                         .interval("interval")
 *                                                         // the properties below are optional
 *                                                         .offset("offset")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .transform(TransformProperty.builder()
 *                                         .expression("expression")
 *                                         .variables(List.of(ExpressionVariableProperty.builder()
 *                                                 .name("name")
 *                                                 .value(VariableValueProperty.builder()
 *                                                         .hierarchyExternalId("hierarchyExternalId")
 *                                                         .hierarchyId("hierarchyId")
 *                                                         .hierarchyLogicalId("hierarchyLogicalId")
 *                                                         .propertyExternalId("propertyExternalId")
 *                                                         .propertyId("propertyId")
 *                                                         .propertyLogicalId("propertyLogicalId")
 *                                                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .dataTypeSpec("dataTypeSpec")
 *                         .externalId("externalId")
 *                         .id("id")
 *                         .logicalId("logicalId")
 *                         .unit("unit")
 *                         .build()))
 *                 .description("description")
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .parentAssetModelCompositeModelExternalId("parentAssetModelCompositeModelExternalId")
 *                 .path(List.of("path"))
 *                 .build()))
 *         .assetModelDescription("assetModelDescription")
 *         .assetModelExternalId("assetModelExternalId")
 *         .assetModelHierarchies(List.of(AssetModelHierarchyProperty.builder()
 *                 .childAssetModelId("childAssetModelId")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .logicalId("logicalId")
 *                 .build()))
 *         .assetModelProperties(List.of(AssetModelPropertyProperty.builder()
 *                 .dataType("dataType")
 *                 .name("name")
 *                 .type(PropertyTypeProperty.builder()
 *                         .typeName("typeName")
 *                         // the properties below are optional
 *                         .attribute(AttributeProperty.builder()
 *                                 .defaultValue("defaultValue")
 *                                 .build())
 *                         .metric(MetricProperty.builder()
 *                                 .expression("expression")
 *                                 .variables(List.of(ExpressionVariableProperty.builder()
 *                                         .name("name")
 *                                         .value(VariableValueProperty.builder()
 *                                                 .hierarchyExternalId("hierarchyExternalId")
 *                                                 .hierarchyId("hierarchyId")
 *                                                 .hierarchyLogicalId("hierarchyLogicalId")
 *                                                 .propertyExternalId("propertyExternalId")
 *                                                 .propertyId("propertyId")
 *                                                 .propertyLogicalId("propertyLogicalId")
 *                                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                         .name("name")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build()))
 *                                 .window(MetricWindowProperty.builder()
 *                                         .tumbling(TumblingWindowProperty.builder()
 *                                                 .interval("interval")
 *                                                 // the properties below are optional
 *                                                 .offset("offset")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .transform(TransformProperty.builder()
 *                                 .expression("expression")
 *                                 .variables(List.of(ExpressionVariableProperty.builder()
 *                                         .name("name")
 *                                         .value(VariableValueProperty.builder()
 *                                                 .hierarchyExternalId("hierarchyExternalId")
 *                                                 .hierarchyId("hierarchyId")
 *                                                 .hierarchyLogicalId("hierarchyLogicalId")
 *                                                 .propertyExternalId("propertyExternalId")
 *                                                 .propertyId("propertyId")
 *                                                 .propertyLogicalId("propertyLogicalId")
 *                                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                         .name("name")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .dataTypeSpec("dataTypeSpec")
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .logicalId("logicalId")
 *                 .unit("unit")
 *                 .build()))
 *         .assetModelType("assetModelType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:39.015Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel")
public class CfnAssetModel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAssetModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAssetModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAssetModel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnAssetModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the asset model, which has the following format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssetModelArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAssetModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssetModelId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A unique name for the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetModelName() {
        return software.amazon.jsii.Kernel.get(this, "assetModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique name for the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetModelName", java.util.Objects.requireNonNull(value, "assetModelName is required"));
    }

    /**
     * The composite models that are part of this asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelCompositeModels() {
        return software.amazon.jsii.Kernel.get(this, "assetModelCompositeModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The composite models that are part of this asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelCompositeModels(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetModelCompositeModels", value);
    }

    /**
     * The composite models that are part of this asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelCompositeModels(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AssetModelCompositeModelProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AssetModelCompositeModelProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assetModelCompositeModels", value);
    }

    /**
     * A description for the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssetModelDescription() {
        return software.amazon.jsii.Kernel.get(this, "assetModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetModelDescription", value);
    }

    /**
     * The external ID of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssetModelExternalId() {
        return software.amazon.jsii.Kernel.get(this, "assetModelExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The external ID of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelExternalId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetModelExternalId", value);
    }

    /**
     * The hierarchy definitions of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelHierarchies() {
        return software.amazon.jsii.Kernel.get(this, "assetModelHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The hierarchy definitions of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelHierarchies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetModelHierarchies", value);
    }

    /**
     * The hierarchy definitions of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelHierarchies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AssetModelHierarchyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AssetModelHierarchyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assetModelHierarchies", value);
    }

    /**
     * The property definitions of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelProperties() {
        return software.amazon.jsii.Kernel.get(this, "assetModelProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The property definitions of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetModelProperties", value);
    }

    /**
     * The property definitions of the asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AssetModelPropertyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AssetModelPropertyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assetModelProperties", value);
    }

    /**
     * The type of asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssetModelType() {
        return software.amazon.jsii.Kernel.get(this, "assetModelType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetModelType", value);
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Contains information about a composite model in an asset model.
     * <p>
     * This object contains the asset property definitions that you define in the composite model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetModelCompositeModelProperty assetModelCompositeModelProperty = AssetModelCompositeModelProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .composedAssetModelId("composedAssetModelId")
     *         .compositeModelProperties(List.of(AssetModelPropertyProperty.builder()
     *                 .dataType("dataType")
     *                 .name("name")
     *                 .type(PropertyTypeProperty.builder()
     *                         .typeName("typeName")
     *                         // the properties below are optional
     *                         .attribute(AttributeProperty.builder()
     *                                 .defaultValue("defaultValue")
     *                                 .build())
     *                         .metric(MetricProperty.builder()
     *                                 .expression("expression")
     *                                 .variables(List.of(ExpressionVariableProperty.builder()
     *                                         .name("name")
     *                                         .value(VariableValueProperty.builder()
     *                                                 .hierarchyExternalId("hierarchyExternalId")
     *                                                 .hierarchyId("hierarchyId")
     *                                                 .hierarchyLogicalId("hierarchyLogicalId")
     *                                                 .propertyExternalId("propertyExternalId")
     *                                                 .propertyId("propertyId")
     *                                                 .propertyLogicalId("propertyLogicalId")
     *                                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                                         .name("name")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build()))
     *                                 .window(MetricWindowProperty.builder()
     *                                         .tumbling(TumblingWindowProperty.builder()
     *                                                 .interval("interval")
     *                                                 // the properties below are optional
     *                                                 .offset("offset")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .transform(TransformProperty.builder()
     *                                 .expression("expression")
     *                                 .variables(List.of(ExpressionVariableProperty.builder()
     *                                         .name("name")
     *                                         .value(VariableValueProperty.builder()
     *                                                 .hierarchyExternalId("hierarchyExternalId")
     *                                                 .hierarchyId("hierarchyId")
     *                                                 .hierarchyLogicalId("hierarchyLogicalId")
     *                                                 .propertyExternalId("propertyExternalId")
     *                                                 .propertyId("propertyId")
     *                                                 .propertyLogicalId("propertyLogicalId")
     *                                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                                         .name("name")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .dataTypeSpec("dataTypeSpec")
     *                 .externalId("externalId")
     *                 .id("id")
     *                 .logicalId("logicalId")
     *                 .unit("unit")
     *                 .build()))
     *         .description("description")
     *         .externalId("externalId")
     *         .id("id")
     *         .parentAssetModelCompositeModelExternalId("parentAssetModelCompositeModelExternalId")
     *         .path(List.of("path"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AssetModelCompositeModelProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetModelCompositeModelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetModelCompositeModelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the composite model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of the composite model.
         * <p>
         * For alarm composite models, this type is <code>AWS/ALARM</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The ID of a component model which is reused to create this composite model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-composedassetmodelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-composedassetmodelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComposedAssetModelId() {
            return null;
        }

        /**
         * The asset property definitions for this composite model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-compositemodelproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-compositemodelproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompositeModelProperties() {
            return null;
        }

        /**
         * The description of the composite model.
         * <p>
         * <blockquote>
         * <p>
         * If the composite model is a <code>component-model-based</code> composite model, the description is inherited from the <code>COMPONENT_MODEL</code> asset model and cannot be changed.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The external ID of a composite model on this asset model.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * One of <code>ExternalId</code> or <code>Path</code> must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ID of the asset model composite model.
         * <p>
         * <blockquote>
         * <p>
         * This is a return value and can't be set.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The external ID of the parent composite model.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-parentassetmodelcompositemodelexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-parentassetmodelcompositemodelexternalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParentAssetModelCompositeModelExternalId() {
            return null;
        }

        /**
         * The structured path to the property from the root of the asset using property names.
         * <p>
         * Path is used as the ID if the asset model is a derived composite model.
         * <p>
         * <blockquote>
         * <p>
         * One of <code>ExternalId</code> or <code>Path</code> must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelcompositemodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodel-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetModelCompositeModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetModelCompositeModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetModelCompositeModelProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.String composedAssetModelId;
            java.lang.Object compositeModelProperties;
            java.lang.String description;
            java.lang.String externalId;
            java.lang.String id;
            java.lang.String parentAssetModelCompositeModelExternalId;
            java.util.List<java.lang.String> path;

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getName}
             * @param name The name of the composite model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getType}
             * @param type The type of the composite model. This parameter is required.
             *             For alarm composite models, this type is <code>AWS/ALARM</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getComposedAssetModelId}
             * @param composedAssetModelId The ID of a component model which is reused to create this composite model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder composedAssetModelId(java.lang.String composedAssetModelId) {
                this.composedAssetModelId = composedAssetModelId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getCompositeModelProperties}
             * @param compositeModelProperties The asset property definitions for this composite model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositeModelProperties(software.amazon.awscdk.IResolvable compositeModelProperties) {
                this.compositeModelProperties = compositeModelProperties;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getCompositeModelProperties}
             * @param compositeModelProperties The asset property definitions for this composite model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositeModelProperties(java.util.List<? extends java.lang.Object> compositeModelProperties) {
                this.compositeModelProperties = compositeModelProperties;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getDescription}
             * @param description The description of the composite model.
             *                    <blockquote>
             *                    <p>
             *                    If the composite model is a <code>component-model-based</code> composite model, the description is inherited from the <code>COMPONENT_MODEL</code> asset model and cannot be changed.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getExternalId}
             * @param externalId The external ID of a composite model on this asset model.
             *                   For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   One of <code>ExternalId</code> or <code>Path</code> must be specified.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getId}
             * @param id The ID of the asset model composite model.
             *           <blockquote>
             *           <p>
             *           This is a return value and can't be set.
             *           <p>
             *           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getParentAssetModelCompositeModelExternalId}
             * @param parentAssetModelCompositeModelExternalId The external ID of the parent composite model.
             *                                                 For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentAssetModelCompositeModelExternalId(java.lang.String parentAssetModelCompositeModelExternalId) {
                this.parentAssetModelCompositeModelExternalId = parentAssetModelCompositeModelExternalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelCompositeModelProperty#getPath}
             * @param path The structured path to the property from the root of the asset using property names.
             *             Path is used as the ID if the asset model is a derived composite model.
             *             <p>
             *             <blockquote>
             *             <p>
             *             One of <code>ExternalId</code> or <code>Path</code> must be specified.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.util.List<java.lang.String> path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetModelCompositeModelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetModelCompositeModelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetModelCompositeModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetModelCompositeModelProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.String composedAssetModelId;
            private final java.lang.Object compositeModelProperties;
            private final java.lang.String description;
            private final java.lang.String externalId;
            private final java.lang.String id;
            private final java.lang.String parentAssetModelCompositeModelExternalId;
            private final java.util.List<java.lang.String> path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.composedAssetModelId = software.amazon.jsii.Kernel.get(this, "composedAssetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compositeModelProperties = software.amazon.jsii.Kernel.get(this, "compositeModelProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parentAssetModelCompositeModelExternalId = software.amazon.jsii.Kernel.get(this, "parentAssetModelCompositeModelExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.composedAssetModelId = builder.composedAssetModelId;
                this.compositeModelProperties = builder.compositeModelProperties;
                this.description = builder.description;
                this.externalId = builder.externalId;
                this.id = builder.id;
                this.parentAssetModelCompositeModelExternalId = builder.parentAssetModelCompositeModelExternalId;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getComposedAssetModelId() {
                return this.composedAssetModelId;
            }

            @Override
            public final java.lang.Object getCompositeModelProperties() {
                return this.compositeModelProperties;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getParentAssetModelCompositeModelExternalId() {
                return this.parentAssetModelCompositeModelExternalId;
            }

            @Override
            public final java.util.List<java.lang.String> getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getComposedAssetModelId() != null) {
                    data.set("composedAssetModelId", om.valueToTree(this.getComposedAssetModelId()));
                }
                if (this.getCompositeModelProperties() != null) {
                    data.set("compositeModelProperties", om.valueToTree(this.getCompositeModelProperties()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getParentAssetModelCompositeModelExternalId() != null) {
                    data.set("parentAssetModelCompositeModelExternalId", om.valueToTree(this.getParentAssetModelCompositeModelExternalId()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AssetModelCompositeModelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetModelCompositeModelProperty.Jsii$Proxy that = (AssetModelCompositeModelProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.composedAssetModelId != null ? !this.composedAssetModelId.equals(that.composedAssetModelId) : that.composedAssetModelId != null) return false;
                if (this.compositeModelProperties != null ? !this.compositeModelProperties.equals(that.compositeModelProperties) : that.compositeModelProperties != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.parentAssetModelCompositeModelExternalId != null ? !this.parentAssetModelCompositeModelExternalId.equals(that.parentAssetModelCompositeModelExternalId) : that.parentAssetModelCompositeModelExternalId != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.composedAssetModelId != null ? this.composedAssetModelId.hashCode() : 0);
                result = 31 * result + (this.compositeModelProperties != null ? this.compositeModelProperties.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.parentAssetModelCompositeModelExternalId != null ? this.parentAssetModelCompositeModelExternalId.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an asset hierarchy that contains a hierarchy's name, ID, and child asset model ID that specifies the type of asset that can be in this hierarchy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetModelHierarchyProperty assetModelHierarchyProperty = AssetModelHierarchyProperty.builder()
     *         .childAssetModelId("childAssetModelId")
     *         .name("name")
     *         // the properties below are optional
     *         .externalId("externalId")
     *         .id("id")
     *         .logicalId("logicalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AssetModelHierarchyProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetModelHierarchyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetModelHierarchyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the asset model, in UUID format.
         * <p>
         * All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model. AWS IoT SiteWise will always return the actual asset model ID for this value. However, when you are specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> , you may provide either the asset model ID or else <code>externalId:</code> followed by the asset model's external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-childassetmodelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-childassetmodelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChildAssetModelId();

        /**
         * The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The external ID (if any) provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> . However, you can't change the external ID if one is already assigned. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code> .
         * <p>
         * <blockquote>
         * <p>
         * This is a return value and can't be set.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>If you are callling <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> to create a <em>new</em> hierarchy: You can specify its ID here, if desired. AWS IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</li>
         * <li>If you are calling UpdateAssetModel to modify an <em>existing</em> hierarchy: This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The <code>LogicalID</code> of the asset model hierarchy. This ID is a <code>hierarchyLogicalId</code> .
         * <p>
         * <blockquote>
         * <p>
         * One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-logicalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-logicalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogicalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetModelHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetModelHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetModelHierarchyProperty> {
            java.lang.String childAssetModelId;
            java.lang.String name;
            java.lang.String externalId;
            java.lang.String id;
            java.lang.String logicalId;

            /**
             * Sets the value of {@link AssetModelHierarchyProperty#getChildAssetModelId}
             * @param childAssetModelId The ID of the asset model, in UUID format. This parameter is required.
             *                          All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model. AWS IoT SiteWise will always return the actual asset model ID for this value. However, when you are specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> , you may provide either the asset model ID or else <code>externalId:</code> followed by the asset model's external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childAssetModelId(java.lang.String childAssetModelId) {
                this.childAssetModelId = childAssetModelId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelHierarchyProperty#getName}
             * @param name The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelHierarchyProperty#getExternalId}
             * @param externalId The external ID (if any) provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> . However, you can't change the external ID if one is already assigned. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                   <blockquote>
             *                   <p>
             *                   One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelHierarchyProperty#getId}
             * @param id The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code> .
             *           <blockquote>
             *           <p>
             *           This is a return value and can't be set.
             *           <p>
             *           </blockquote>
             *           <p>
             *           <ul>
             *           <li>If you are callling <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> to create a <em>new</em> hierarchy: You can specify its ID here, if desired. AWS IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</li>
             *           <li>If you are calling UpdateAssetModel to modify an <em>existing</em> hierarchy: This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .</li>
             *           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelHierarchyProperty#getLogicalId}
             * @param logicalId The <code>LogicalID</code> of the asset model hierarchy. This ID is a <code>hierarchyLogicalId</code> .
             *                  <blockquote>
             *                  <p>
             *                  One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalId(java.lang.String logicalId) {
                this.logicalId = logicalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetModelHierarchyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetModelHierarchyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetModelHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetModelHierarchyProperty {
            private final java.lang.String childAssetModelId;
            private final java.lang.String name;
            private final java.lang.String externalId;
            private final java.lang.String id;
            private final java.lang.String logicalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.childAssetModelId = software.amazon.jsii.Kernel.get(this, "childAssetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logicalId = software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.childAssetModelId = java.util.Objects.requireNonNull(builder.childAssetModelId, "childAssetModelId is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.externalId = builder.externalId;
                this.id = builder.id;
                this.logicalId = builder.logicalId;
            }

            @Override
            public final java.lang.String getChildAssetModelId() {
                return this.childAssetModelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLogicalId() {
                return this.logicalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("childAssetModelId", om.valueToTree(this.getChildAssetModelId()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLogicalId() != null) {
                    data.set("logicalId", om.valueToTree(this.getLogicalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AssetModelHierarchyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetModelHierarchyProperty.Jsii$Proxy that = (AssetModelHierarchyProperty.Jsii$Proxy) o;

                if (!childAssetModelId.equals(that.childAssetModelId)) return false;
                if (!name.equals(that.name)) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.logicalId != null ? this.logicalId.equals(that.logicalId) : that.logicalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.childAssetModelId.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.logicalId != null ? this.logicalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about an asset model property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetModelPropertyProperty assetModelPropertyProperty = AssetModelPropertyProperty.builder()
     *         .dataType("dataType")
     *         .name("name")
     *         .type(PropertyTypeProperty.builder()
     *                 .typeName("typeName")
     *                 // the properties below are optional
     *                 .attribute(AttributeProperty.builder()
     *                         .defaultValue("defaultValue")
     *                         .build())
     *                 .metric(MetricProperty.builder()
     *                         .expression("expression")
     *                         .variables(List.of(ExpressionVariableProperty.builder()
     *                                 .name("name")
     *                                 .value(VariableValueProperty.builder()
     *                                         .hierarchyExternalId("hierarchyExternalId")
     *                                         .hierarchyId("hierarchyId")
     *                                         .hierarchyLogicalId("hierarchyLogicalId")
     *                                         .propertyExternalId("propertyExternalId")
     *                                         .propertyId("propertyId")
     *                                         .propertyLogicalId("propertyLogicalId")
     *                                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                                 .name("name")
     *                                                 .build()))
     *                                         .build())
     *                                 .build()))
     *                         .window(MetricWindowProperty.builder()
     *                                 .tumbling(TumblingWindowProperty.builder()
     *                                         .interval("interval")
     *                                         // the properties below are optional
     *                                         .offset("offset")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .transform(TransformProperty.builder()
     *                         .expression("expression")
     *                         .variables(List.of(ExpressionVariableProperty.builder()
     *                                 .name("name")
     *                                 .value(VariableValueProperty.builder()
     *                                         .hierarchyExternalId("hierarchyExternalId")
     *                                         .hierarchyId("hierarchyId")
     *                                         .hierarchyLogicalId("hierarchyLogicalId")
     *                                         .propertyExternalId("propertyExternalId")
     *                                         .propertyId("propertyId")
     *                                         .propertyLogicalId("propertyLogicalId")
     *                                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                                 .name("name")
     *                                                 .build()))
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .dataTypeSpec("dataTypeSpec")
     *         .externalId("externalId")
     *         .id("id")
     *         .logicalId("logicalId")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AssetModelPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetModelPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetModelPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data type of the asset model property.
         * <p>
         * If you specify <code>STRUCT</code> , you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataType();

        /**
         * The name of the asset model property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Contains a property type, which can be one of <code>attribute</code> , <code>measurement</code> , <code>metric</code> , or <code>transform</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getType();

        /**
         * The data type of the structure for this property.
         * <p>
         * This parameter exists on properties that have the <code>STRUCT</code> data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-datatypespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-datatypespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataTypeSpec() {
            return null;
        }

        /**
         * The external ID of the asset property.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ID of the property.
         * <p>
         * <blockquote>
         * <p>
         * This is a return value and can't be set.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The <code>LogicalID</code> of the asset model property.
         * <p>
         * <blockquote>
         * <p>
         * One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-logicalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-logicalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogicalId() {
            return null;
        }

        /**
         * The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetModelPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetModelPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetModelPropertyProperty> {
            java.lang.String dataType;
            java.lang.String name;
            java.lang.Object type;
            java.lang.String dataTypeSpec;
            java.lang.String externalId;
            java.lang.String id;
            java.lang.String logicalId;
            java.lang.String unit;

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getDataType}
             * @param dataType The data type of the asset model property. This parameter is required.
             *                 If you specify <code>STRUCT</code> , you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getName}
             * @param name The name of the asset model property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getType}
             * @param type Contains a property type, which can be one of <code>attribute</code> , <code>measurement</code> , <code>metric</code> , or <code>transform</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(software.amazon.awscdk.IResolvable type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getType}
             * @param type Contains a property type, which can be one of <code>attribute</code> , <code>measurement</code> , <code>metric</code> , or <code>transform</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.PropertyTypeProperty type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getDataTypeSpec}
             * @param dataTypeSpec The data type of the structure for this property.
             *                     This parameter exists on properties that have the <code>STRUCT</code> data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTypeSpec(java.lang.String dataTypeSpec) {
                this.dataTypeSpec = dataTypeSpec;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getExternalId}
             * @param externalId The external ID of the asset property.
             *                   For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getId}
             * @param id The ID of the property.
             *           <blockquote>
             *           <p>
             *           This is a return value and can't be set.
             *           <p>
             *           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getLogicalId}
             * @param logicalId The <code>LogicalID</code> of the asset model property.
             *                  <blockquote>
             *                  <p>
             *                  One of <code>ExternalId</code> or <code>LogicalId</code> must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalId(java.lang.String logicalId) {
                this.logicalId = logicalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyProperty#getUnit}
             * @param unit The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetModelPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetModelPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetModelPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetModelPropertyProperty {
            private final java.lang.String dataType;
            private final java.lang.String name;
            private final java.lang.Object type;
            private final java.lang.String dataTypeSpec;
            private final java.lang.String externalId;
            private final java.lang.String id;
            private final java.lang.String logicalId;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataTypeSpec = software.amazon.jsii.Kernel.get(this, "dataTypeSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logicalId = software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.dataTypeSpec = builder.dataTypeSpec;
                this.externalId = builder.externalId;
                this.id = builder.id;
                this.logicalId = builder.logicalId;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getDataTypeSpec() {
                return this.dataTypeSpec;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLogicalId() {
                return this.logicalId;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataType", om.valueToTree(this.getDataType()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getDataTypeSpec() != null) {
                    data.set("dataTypeSpec", om.valueToTree(this.getDataTypeSpec()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLogicalId() != null) {
                    data.set("logicalId", om.valueToTree(this.getLogicalId()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AssetModelPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetModelPropertyProperty.Jsii$Proxy that = (AssetModelPropertyProperty.Jsii$Proxy) o;

                if (!dataType.equals(that.dataType)) return false;
                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.dataTypeSpec != null ? !this.dataTypeSpec.equals(that.dataTypeSpec) : that.dataTypeSpec != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.logicalId != null ? !this.logicalId.equals(that.logicalId) : that.logicalId != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataType.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.dataTypeSpec != null ? this.dataTypeSpec.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.logicalId != null ? this.logicalId.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains an asset attribute property.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes">Attributes</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AttributeProperty attributeProperty = AttributeProperty.builder()
     *         .defaultValue("defaultValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-attribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-attribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default value of the asset model property attribute.
         * <p>
         * All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-attribute.html#cfn-iotsitewise-assetmodel-attribute-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-attribute.html#cfn-iotsitewise-assetmodel-attribute-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeProperty> {
            java.lang.String defaultValue;

            /**
             * Sets the value of {@link AttributeProperty#getDefaultValue}
             * @param defaultValue The default value of the asset model property attribute.
             *                     All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeProperty {
            private final java.lang.String defaultValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValue = builder.defaultValue;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.AttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeProperty.Jsii$Proxy that = (AttributeProperty.Jsii$Proxy) o;

                return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValue != null ? this.defaultValue.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains expression variable information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * ExpressionVariableProperty expressionVariableProperty = ExpressionVariableProperty.builder()
     *         .name("name")
     *         .value(VariableValueProperty.builder()
     *                 .hierarchyExternalId("hierarchyExternalId")
     *                 .hierarchyId("hierarchyId")
     *                 .hierarchyLogicalId("hierarchyLogicalId")
     *                 .propertyExternalId("propertyExternalId")
     *                 .propertyId("propertyId")
     *                 .propertyLogicalId("propertyLogicalId")
     *                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.ExpressionVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressionVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressionVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The friendly name of the variable to be used in the expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html#cfn-iotsitewise-assetmodel-expressionvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html#cfn-iotsitewise-assetmodel-expressionvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The variable that identifies an asset property from which to use values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html#cfn-iotsitewise-assetmodel-expressionvariable-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html#cfn-iotsitewise-assetmodel-expressionvariable-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link ExpressionVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressionVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressionVariableProperty> {
            java.lang.String name;
            java.lang.Object value;

            /**
             * Sets the value of {@link ExpressionVariableProperty#getName}
             * @param name The friendly name of the variable to be used in the expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionVariableProperty#getValue}
             * @param value The variable that identifies an asset property from which to use values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionVariableProperty#getValue}
             * @param value The variable that identifies an asset property from which to use values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.VariableValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressionVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressionVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressionVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressionVariableProperty {
            private final java.lang.String name;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.ExpressionVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressionVariableProperty.Jsii$Proxy that = (ExpressionVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains an asset metric property.
     * <p>
     * With metrics, you can calculate aggregate functions, such as an average, maximum, or minimum, as specified through an expression. A metric maps several values to a single value (such as a sum).
     * <p>
     * The maximum number of dependent/cascading variables used in any one metric calculation is 10. Therefore, a <em>root</em> metric can have up to 10 cascading metrics in its computational dependency tree. Additionally, a metric can only have a data type of <code>DOUBLE</code> and consume properties with data types of <code>INTEGER</code> or <code>DOUBLE</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics">Metrics</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * MetricProperty metricProperty = MetricProperty.builder()
     *         .expression("expression")
     *         .variables(List.of(ExpressionVariableProperty.builder()
     *                 .name("name")
     *                 .value(VariableValueProperty.builder()
     *                         .hierarchyExternalId("hierarchyExternalId")
     *                         .hierarchyId("hierarchyId")
     *                         .hierarchyLogicalId("hierarchyLogicalId")
     *                         .propertyExternalId("propertyExternalId")
     *                         .propertyId("propertyId")
     *                         .propertyLogicalId("propertyLogicalId")
     *                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .window(MetricWindowProperty.builder()
     *                 .tumbling(TumblingWindowProperty.builder()
     *                         .interval("interval")
     *                         // the properties below are optional
     *                         .offset("offset")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.MetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The mathematical expression that defines the metric aggregation function.
         * <p>
         * You can specify up to 10 variables per expression. You can specify up to 10 functions per expression.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The list of variables used in the expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-variables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVariables();

        /**
         * The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression.
         * <p>
         * AWS IoT SiteWise computes one data point per <code>window</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-window">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-window</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWindow();

        /**
         * @return a {@link Builder} of {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricProperty> {
            java.lang.String expression;
            java.lang.Object variables;
            java.lang.Object window;

            /**
             * Sets the value of {@link MetricProperty#getExpression}
             * @param expression The mathematical expression that defines the metric aggregation function. This parameter is required.
             *                   You can specify up to 10 variables per expression. You can specify up to 10 functions per expression.
             *                   <p>
             *                   For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getVariables}
             * @param variables The list of variables used in the expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getVariables}
             * @param variables The list of variables used in the expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.List<? extends java.lang.Object> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getWindow}
             * @param window The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression. This parameter is required.
             *               AWS IoT SiteWise computes one data point per <code>window</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder window(software.amazon.awscdk.IResolvable window) {
                this.window = window;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getWindow}
             * @param window The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression. This parameter is required.
             *               AWS IoT SiteWise computes one data point per <code>window</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder window(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.MetricWindowProperty window) {
                this.window = window;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricProperty {
            private final java.lang.String expression;
            private final java.lang.Object variables;
            private final java.lang.Object window;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.window = software.amazon.jsii.Kernel.get(this, "window", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.variables = java.util.Objects.requireNonNull(builder.variables, "variables is required");
                this.window = java.util.Objects.requireNonNull(builder.window, "window is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            public final java.lang.Object getWindow() {
                return this.window;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("variables", om.valueToTree(this.getVariables()));
                data.set("window", om.valueToTree(this.getWindow()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.MetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricProperty.Jsii$Proxy that = (MetricProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                if (!variables.equals(that.variables)) return false;
                return this.window.equals(that.window);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.variables.hashCode());
                result = 31 * result + (this.window.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * MetricWindowProperty metricWindowProperty = MetricWindowProperty.builder()
     *         .tumbling(TumblingWindowProperty.builder()
     *                 .interval("interval")
     *                 // the properties below are optional
     *                 .offset("offset")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metricwindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metricwindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.MetricWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tumbling time interval window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metricwindow.html#cfn-iotsitewise-assetmodel-metricwindow-tumbling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metricwindow.html#cfn-iotsitewise-assetmodel-metricwindow-tumbling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTumbling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricWindowProperty> {
            java.lang.Object tumbling;

            /**
             * Sets the value of {@link MetricWindowProperty#getTumbling}
             * @param tumbling The tumbling time interval window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tumbling(software.amazon.awscdk.IResolvable tumbling) {
                this.tumbling = tumbling;
                return this;
            }

            /**
             * Sets the value of {@link MetricWindowProperty#getTumbling}
             * @param tumbling The tumbling time interval window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tumbling(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.TumblingWindowProperty tumbling) {
                this.tumbling = tumbling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricWindowProperty {
            private final java.lang.Object tumbling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tumbling = software.amazon.jsii.Kernel.get(this, "tumbling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tumbling = builder.tumbling;
            }

            @Override
            public final java.lang.Object getTumbling() {
                return this.tumbling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTumbling() != null) {
                    data.set("tumbling", om.valueToTree(this.getTumbling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.MetricWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricWindowProperty.Jsii$Proxy that = (MetricWindowProperty.Jsii$Proxy) o;

                return this.tumbling != null ? this.tumbling.equals(that.tumbling) : that.tumbling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tumbling != null ? this.tumbling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents one level between a composite model and the root of the asset model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * PropertyPathDefinitionProperty propertyPathDefinitionProperty = PropertyPathDefinitionProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertypathdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertypathdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.PropertyPathDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyPathDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyPathDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the path segment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertypathdefinition.html#cfn-iotsitewise-assetmodel-propertypathdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertypathdefinition.html#cfn-iotsitewise-assetmodel-propertypathdefinition-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link PropertyPathDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyPathDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyPathDefinitionProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link PropertyPathDefinitionProperty#getName}
             * @param name The name of the path segment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyPathDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyPathDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyPathDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyPathDefinitionProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.PropertyPathDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyPathDefinitionProperty.Jsii$Proxy that = (PropertyPathDefinitionProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains a property type, which can be one of <code>attribute</code> , <code>measurement</code> , <code>metric</code> , or <code>transform</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * PropertyTypeProperty propertyTypeProperty = PropertyTypeProperty.builder()
     *         .typeName("typeName")
     *         // the properties below are optional
     *         .attribute(AttributeProperty.builder()
     *                 .defaultValue("defaultValue")
     *                 .build())
     *         .metric(MetricProperty.builder()
     *                 .expression("expression")
     *                 .variables(List.of(ExpressionVariableProperty.builder()
     *                         .name("name")
     *                         .value(VariableValueProperty.builder()
     *                                 .hierarchyExternalId("hierarchyExternalId")
     *                                 .hierarchyId("hierarchyId")
     *                                 .hierarchyLogicalId("hierarchyLogicalId")
     *                                 .propertyExternalId("propertyExternalId")
     *                                 .propertyId("propertyId")
     *                                 .propertyLogicalId("propertyLogicalId")
     *                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .build())
     *                         .build()))
     *                 .window(MetricWindowProperty.builder()
     *                         .tumbling(TumblingWindowProperty.builder()
     *                                 .interval("interval")
     *                                 // the properties below are optional
     *                                 .offset("offset")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .transform(TransformProperty.builder()
     *                 .expression("expression")
     *                 .variables(List.of(ExpressionVariableProperty.builder()
     *                         .name("name")
     *                         .value(VariableValueProperty.builder()
     *                                 .hierarchyExternalId("hierarchyExternalId")
     *                                 .hierarchyId("hierarchyId")
     *                                 .hierarchyLogicalId("hierarchyLogicalId")
     *                                 .propertyExternalId("propertyExternalId")
     *                                 .propertyId("propertyId")
     *                                 .propertyLogicalId("propertyLogicalId")
     *                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.PropertyTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of property type, which can be one of <code>Attribute</code> , <code>Measurement</code> , <code>Metric</code> , or <code>Transform</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-typename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

        /**
         * Specifies an asset attribute property.
         * <p>
         * An attribute generally contains static information, such as the serial number of an <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttribute() {
            return null;
        }

        /**
         * Specifies an asset metric property.
         * <p>
         * A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetric() {
            return null;
        }

        /**
         * Specifies an asset transform property.
         * <p>
         * A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-transform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-transform</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransform() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyTypeProperty> {
            java.lang.String typeName;
            java.lang.Object attribute;
            java.lang.Object metric;
            java.lang.Object transform;

            /**
             * Sets the value of {@link PropertyTypeProperty#getTypeName}
             * @param typeName The type of property type, which can be one of <code>Attribute</code> , <code>Measurement</code> , <code>Metric</code> , or <code>Transform</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link PropertyTypeProperty#getAttribute}
             * @param attribute Specifies an asset attribute property.
             *                  An attribute generally contains static information, such as the serial number of an <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(software.amazon.awscdk.IResolvable attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link PropertyTypeProperty#getAttribute}
             * @param attribute Specifies an asset attribute property.
             *                  An attribute generally contains static information, such as the serial number of an <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.AttributeProperty attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link PropertyTypeProperty#getMetric}
             * @param metric Specifies an asset metric property.
             *               A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link PropertyTypeProperty#getMetric}
             * @param metric Specifies an asset metric property.
             *               A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.MetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link PropertyTypeProperty#getTransform}
             * @param transform Specifies an asset transform property.
             *                  A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transform(software.amazon.awscdk.IResolvable transform) {
                this.transform = transform;
                return this;
            }

            /**
             * Sets the value of {@link PropertyTypeProperty#getTransform}
             * @param transform Specifies an asset transform property.
             *                  A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transform(software.amazon.awscdk.services.iotsitewise.CfnAssetModel.TransformProperty transform) {
                this.transform = transform;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyTypeProperty {
            private final java.lang.String typeName;
            private final java.lang.Object attribute;
            private final java.lang.Object metric;
            private final java.lang.Object transform;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transform = software.amazon.jsii.Kernel.get(this, "transform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
                this.attribute = builder.attribute;
                this.metric = builder.metric;
                this.transform = builder.transform;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.Object getTransform() {
                return this.transform;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("typeName", om.valueToTree(this.getTypeName()));
                if (this.getAttribute() != null) {
                    data.set("attribute", om.valueToTree(this.getAttribute()));
                }
                if (this.getMetric() != null) {
                    data.set("metric", om.valueToTree(this.getMetric()));
                }
                if (this.getTransform() != null) {
                    data.set("transform", om.valueToTree(this.getTransform()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.PropertyTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyTypeProperty.Jsii$Proxy that = (PropertyTypeProperty.Jsii$Proxy) o;

                if (!typeName.equals(that.typeName)) return false;
                if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) return false;
                if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) return false;
                return this.transform != null ? this.transform.equals(that.transform) : that.transform == null;
            }

            @Override
            public final int hashCode() {
                int result = this.typeName.hashCode();
                result = 31 * result + (this.attribute != null ? this.attribute.hashCode() : 0);
                result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
                result = 31 * result + (this.transform != null ? this.transform.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains an asset transform property.
     * <p>
     * A transform is a one-to-one mapping of a property's data points from one form to another. For example, you can use a transform to convert a Celsius data stream to Fahrenheit by applying the transformation expression to each data point of the Celsius stream. A transform can only have a data type of <code>DOUBLE</code> and consume properties with data types of <code>INTEGER</code> or <code>DOUBLE</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms">Transforms</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * TransformProperty transformProperty = TransformProperty.builder()
     *         .expression("expression")
     *         .variables(List.of(ExpressionVariableProperty.builder()
     *                 .name("name")
     *                 .value(VariableValueProperty.builder()
     *                         .hierarchyExternalId("hierarchyExternalId")
     *                         .hierarchyId("hierarchyId")
     *                         .hierarchyLogicalId("hierarchyLogicalId")
     *                         .propertyExternalId("propertyExternalId")
     *                         .propertyId("propertyId")
     *                         .propertyLogicalId("propertyLogicalId")
     *                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.TransformProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The mathematical expression that defines the transformation function.
         * <p>
         * You can specify up to 10 variables per expression. You can specify up to 10 functions per expression.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html#cfn-iotsitewise-assetmodel-transform-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html#cfn-iotsitewise-assetmodel-transform-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The list of variables used in the expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html#cfn-iotsitewise-assetmodel-transform-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html#cfn-iotsitewise-assetmodel-transform-variables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link TransformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformProperty> {
            java.lang.String expression;
            java.lang.Object variables;

            /**
             * Sets the value of {@link TransformProperty#getExpression}
             * @param expression The mathematical expression that defines the transformation function. This parameter is required.
             *                   You can specify up to 10 variables per expression. You can specify up to 10 functions per expression.
             *                   <p>
             *                   For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link TransformProperty#getVariables}
             * @param variables The list of variables used in the expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link TransformProperty#getVariables}
             * @param variables The list of variables used in the expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.List<? extends java.lang.Object> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformProperty {
            private final java.lang.String expression;
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.variables = java.util.Objects.requireNonNull(builder.variables, "variables is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("variables", om.valueToTree(this.getVariables()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.TransformProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformProperty.Jsii$Proxy that = (TransformProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                return this.variables.equals(that.variables);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.variables.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time window.
     * <p>
     * You can use this window in metrics to aggregate data from properties and other assets.
     * <p>
     * You can use <code>m</code> , <code>h</code> , <code>d</code> , and <code>w</code> when you specify an interval or offset. Note that <code>m</code> represents minutes, <code>h</code> represents hours, <code>d</code> represents days, and <code>w</code> represents weeks. You can also use <code>s</code> to represent seconds in <code>offset</code> .
     * <p>
     * The <code>interval</code> and <code>offset</code> parameters support the <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> . For example, <code>PT5S</code> represents 5 seconds, <code>PT5M</code> represents 5 minutes, and <code>PT5H</code> represents 5 hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * TumblingWindowProperty tumblingWindowProperty = TumblingWindowProperty.builder()
     *         .interval("interval")
     *         // the properties below are optional
     *         .offset("offset")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.TumblingWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(TumblingWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TumblingWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
         * <p>
         * AWS IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on.
         * <p>
         * When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at the end of the interval.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html#cfn-iotsitewise-assetmodel-tumblingwindow-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html#cfn-iotsitewise-assetmodel-tumblingwindow-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterval();

        /**
         * The offset for the tumbling window. The <code>offset</code> parameter accepts the following:.
         * <p>
         * <ul>
         * <li>The offset time.</li>
         * </ul>
         * <p>
         * For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code> , AWS IoT SiteWise aggregates data in one of the following ways:
         * <p>
         * <ul>
         * <li>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</li>
         * <li>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</li>
         * <li>The ISO 8601 format.</li>
         * </ul>
         * <p>
         * For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code> , AWS IoT SiteWise aggregates data in one of the following ways:
         * <p>
         * <ul>
         * <li>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</li>
         * <li>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</li>
         * <li>The 24-hour clock.</li>
         * </ul>
         * <p>
         * For example, if you specify <code>00:03:00</code> for <code>offset</code> , <code>5m</code> for <code>interval</code> , and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
         * <p>
         * <ul>
         * <li>The offset time zone.</li>
         * </ul>
         * <p>
         * For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code> , AWS IoT SiteWise aggregates data in one of the following ways:
         * <p>
         * <ul>
         * <li>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</li>
         * <li>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html#cfn-iotsitewise-assetmodel-tumblingwindow-offset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html#cfn-iotsitewise-assetmodel-tumblingwindow-offset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOffset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TumblingWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TumblingWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TumblingWindowProperty> {
            java.lang.String interval;
            java.lang.String offset;

            /**
             * Sets the value of {@link TumblingWindowProperty#getInterval}
             * @param interval The time interval for the tumbling window. The interval time must be between 1 minute and 1 week. This parameter is required.
             *                 AWS IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on.
             *                 <p>
             *                 When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at the end of the interval.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.String interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link TumblingWindowProperty#getOffset}
             * @param offset The offset for the tumbling window. The <code>offset</code> parameter accepts the following:.
             *               <ul>
             *               <li>The offset time.</li>
             *               </ul>
             *               <p>
             *               For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code> , AWS IoT SiteWise aggregates data in one of the following ways:
             *               <p>
             *               <ul>
             *               <li>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</li>
             *               <li>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</li>
             *               <li>The ISO 8601 format.</li>
             *               </ul>
             *               <p>
             *               For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code> , AWS IoT SiteWise aggregates data in one of the following ways:
             *               <p>
             *               <ul>
             *               <li>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</li>
             *               <li>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</li>
             *               <li>The 24-hour clock.</li>
             *               </ul>
             *               <p>
             *               For example, if you specify <code>00:03:00</code> for <code>offset</code> , <code>5m</code> for <code>interval</code> , and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
             *               <p>
             *               <ul>
             *               <li>The offset time zone.</li>
             *               </ul>
             *               <p>
             *               For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code> , AWS IoT SiteWise aggregates data in one of the following ways:
             *               <p>
             *               <ul>
             *               <li>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</li>
             *               <li>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.String offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TumblingWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TumblingWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TumblingWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TumblingWindowProperty {
            private final java.lang.String interval;
            private final java.lang.String offset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
                this.offset = builder.offset;
            }

            @Override
            public final java.lang.String getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getOffset() {
                return this.offset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interval", om.valueToTree(this.getInterval()));
                if (this.getOffset() != null) {
                    data.set("offset", om.valueToTree(this.getOffset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.TumblingWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TumblingWindowProperty.Jsii$Proxy that = (TumblingWindowProperty.Jsii$Proxy) o;

                if (!interval.equals(that.interval)) return false;
                return this.offset != null ? this.offset.equals(that.offset) : that.offset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.interval.hashCode();
                result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies a property value used in an expression.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * VariableValueProperty variableValueProperty = VariableValueProperty.builder()
     *         .hierarchyExternalId("hierarchyExternalId")
     *         .hierarchyId("hierarchyId")
     *         .hierarchyLogicalId("hierarchyLogicalId")
     *         .propertyExternalId("propertyExternalId")
     *         .propertyId("propertyId")
     *         .propertyLogicalId("propertyLogicalId")
     *         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModel.VariableValueProperty")
    @software.amazon.jsii.Jsii.Proxy(VariableValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VariableValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The external ID of the hierarchy being referenced.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchyexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchyexternalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyExternalId() {
            return null;
        }

        /**
         * The ID of the hierarchy to query for the property ID.
         * <p>
         * You can use the hierarchy's name instead of the hierarchy's ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed by the external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code> . For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyId() {
            return null;
        }

        /**
         * The <code>LogicalID</code> of the hierarchy to query for the <code>PropertyLogicalID</code> .
         * <p>
         * You use a <code>hierarchyLogicalID</code> instead of a model ID because you can have several hierarchies using the same model and therefore the same property. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Defining relationships between asset models (hierarchies)</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchylogicalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchylogicalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLogicalId() {
            return null;
        }

        /**
         * The external ID of the property being referenced.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertyexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertyexternalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyExternalId() {
            return null;
        }

        /**
         * The ID of the property to use as the variable.
         * <p>
         * You can use the property <code>name</code> if it's from the same asset model. If the property has an external ID, you can specify <code>externalId:</code> followed by the external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This is a return value and can't be set.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyId() {
            return null;
        }

        /**
         * The <code>LogicalID</code> of the property that is being referenced.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertylogicalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertylogicalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyLogicalId() {
            return null;
        }

        /**
         * The path of the property.
         * <p>
         * Each step of the path is the name of the step. See the following example:
         * <p>
         * <code>PropertyPath: Name: AssetModelName Name: Composite1 Name: NestedComposite</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertypath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VariableValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VariableValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VariableValueProperty> {
            java.lang.String hierarchyExternalId;
            java.lang.String hierarchyId;
            java.lang.String hierarchyLogicalId;
            java.lang.String propertyExternalId;
            java.lang.String propertyId;
            java.lang.String propertyLogicalId;
            java.lang.Object propertyPath;

            /**
             * Sets the value of {@link VariableValueProperty#getHierarchyExternalId}
             * @param hierarchyExternalId The external ID of the hierarchy being referenced.
             *                            For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyExternalId(java.lang.String hierarchyExternalId) {
                this.hierarchyExternalId = hierarchyExternalId;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getHierarchyId}
             * @param hierarchyId The ID of the hierarchy to query for the property ID.
             *                    You can use the hierarchy's name instead of the hierarchy's ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed by the external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                    <p>
             *                    You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code> . For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyId(java.lang.String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getHierarchyLogicalId}
             * @param hierarchyLogicalId The <code>LogicalID</code> of the hierarchy to query for the <code>PropertyLogicalID</code> .
             *                           You use a <code>hierarchyLogicalID</code> instead of a model ID because you can have several hierarchies using the same model and therefore the same property. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Defining relationships between asset models (hierarchies)</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLogicalId(java.lang.String hierarchyLogicalId) {
                this.hierarchyLogicalId = hierarchyLogicalId;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getPropertyExternalId}
             * @param propertyExternalId The external ID of the property being referenced.
             *                           For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyExternalId(java.lang.String propertyExternalId) {
                this.propertyExternalId = propertyExternalId;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getPropertyId}
             * @param propertyId The ID of the property to use as the variable.
             *                   You can use the property <code>name</code> if it's from the same asset model. If the property has an external ID, you can specify <code>externalId:</code> followed by the external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This is a return value and can't be set.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyId(java.lang.String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getPropertyLogicalId}
             * @param propertyLogicalId The <code>LogicalID</code> of the property that is being referenced.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyLogicalId(java.lang.String propertyLogicalId) {
                this.propertyLogicalId = propertyLogicalId;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getPropertyPath}
             * @param propertyPath The path of the property.
             *                     Each step of the path is the name of the step. See the following example:
             *                     <p>
             *                     <code>PropertyPath: Name: AssetModelName Name: Composite1 Name: NestedComposite</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyPath(software.amazon.awscdk.IResolvable propertyPath) {
                this.propertyPath = propertyPath;
                return this;
            }

            /**
             * Sets the value of {@link VariableValueProperty#getPropertyPath}
             * @param propertyPath The path of the property.
             *                     Each step of the path is the name of the step. See the following example:
             *                     <p>
             *                     <code>PropertyPath: Name: AssetModelName Name: Composite1 Name: NestedComposite</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyPath(java.util.List<? extends java.lang.Object> propertyPath) {
                this.propertyPath = propertyPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VariableValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VariableValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VariableValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VariableValueProperty {
            private final java.lang.String hierarchyExternalId;
            private final java.lang.String hierarchyId;
            private final java.lang.String hierarchyLogicalId;
            private final java.lang.String propertyExternalId;
            private final java.lang.String propertyId;
            private final java.lang.String propertyLogicalId;
            private final java.lang.Object propertyPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hierarchyExternalId = software.amazon.jsii.Kernel.get(this, "hierarchyExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyId = software.amazon.jsii.Kernel.get(this, "hierarchyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLogicalId = software.amazon.jsii.Kernel.get(this, "hierarchyLogicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyExternalId = software.amazon.jsii.Kernel.get(this, "propertyExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyId = software.amazon.jsii.Kernel.get(this, "propertyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyLogicalId = software.amazon.jsii.Kernel.get(this, "propertyLogicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyPath = software.amazon.jsii.Kernel.get(this, "propertyPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hierarchyExternalId = builder.hierarchyExternalId;
                this.hierarchyId = builder.hierarchyId;
                this.hierarchyLogicalId = builder.hierarchyLogicalId;
                this.propertyExternalId = builder.propertyExternalId;
                this.propertyId = builder.propertyId;
                this.propertyLogicalId = builder.propertyLogicalId;
                this.propertyPath = builder.propertyPath;
            }

            @Override
            public final java.lang.String getHierarchyExternalId() {
                return this.hierarchyExternalId;
            }

            @Override
            public final java.lang.String getHierarchyId() {
                return this.hierarchyId;
            }

            @Override
            public final java.lang.String getHierarchyLogicalId() {
                return this.hierarchyLogicalId;
            }

            @Override
            public final java.lang.String getPropertyExternalId() {
                return this.propertyExternalId;
            }

            @Override
            public final java.lang.String getPropertyId() {
                return this.propertyId;
            }

            @Override
            public final java.lang.String getPropertyLogicalId() {
                return this.propertyLogicalId;
            }

            @Override
            public final java.lang.Object getPropertyPath() {
                return this.propertyPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHierarchyExternalId() != null) {
                    data.set("hierarchyExternalId", om.valueToTree(this.getHierarchyExternalId()));
                }
                if (this.getHierarchyId() != null) {
                    data.set("hierarchyId", om.valueToTree(this.getHierarchyId()));
                }
                if (this.getHierarchyLogicalId() != null) {
                    data.set("hierarchyLogicalId", om.valueToTree(this.getHierarchyLogicalId()));
                }
                if (this.getPropertyExternalId() != null) {
                    data.set("propertyExternalId", om.valueToTree(this.getPropertyExternalId()));
                }
                if (this.getPropertyId() != null) {
                    data.set("propertyId", om.valueToTree(this.getPropertyId()));
                }
                if (this.getPropertyLogicalId() != null) {
                    data.set("propertyLogicalId", om.valueToTree(this.getPropertyLogicalId()));
                }
                if (this.getPropertyPath() != null) {
                    data.set("propertyPath", om.valueToTree(this.getPropertyPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModel.VariableValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VariableValueProperty.Jsii$Proxy that = (VariableValueProperty.Jsii$Proxy) o;

                if (this.hierarchyExternalId != null ? !this.hierarchyExternalId.equals(that.hierarchyExternalId) : that.hierarchyExternalId != null) return false;
                if (this.hierarchyId != null ? !this.hierarchyId.equals(that.hierarchyId) : that.hierarchyId != null) return false;
                if (this.hierarchyLogicalId != null ? !this.hierarchyLogicalId.equals(that.hierarchyLogicalId) : that.hierarchyLogicalId != null) return false;
                if (this.propertyExternalId != null ? !this.propertyExternalId.equals(that.propertyExternalId) : that.propertyExternalId != null) return false;
                if (this.propertyId != null ? !this.propertyId.equals(that.propertyId) : that.propertyId != null) return false;
                if (this.propertyLogicalId != null ? !this.propertyLogicalId.equals(that.propertyLogicalId) : that.propertyLogicalId != null) return false;
                return this.propertyPath != null ? this.propertyPath.equals(that.propertyPath) : that.propertyPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hierarchyExternalId != null ? this.hierarchyExternalId.hashCode() : 0;
                result = 31 * result + (this.hierarchyId != null ? this.hierarchyId.hashCode() : 0);
                result = 31 * result + (this.hierarchyLogicalId != null ? this.hierarchyLogicalId.hashCode() : 0);
                result = 31 * result + (this.propertyExternalId != null ? this.propertyExternalId.hashCode() : 0);
                result = 31 * result + (this.propertyId != null ? this.propertyId.hashCode() : 0);
                result = 31 * result + (this.propertyLogicalId != null ? this.propertyLogicalId.hashCode() : 0);
                result = 31 * result + (this.propertyPath != null ? this.propertyPath.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotsitewise.CfnAssetModel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotsitewise.CfnAssetModel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotsitewise.CfnAssetModelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotsitewise.CfnAssetModelProps.Builder();
        }

        /**
         * A unique name for the asset model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelname</a>
         * @param assetModelName A unique name for the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelName(final java.lang.String assetModelName) {
            this.props.assetModelName(assetModelName);
            return this;
        }

        /**
         * The composite models that are part of this asset model.
         * <p>
         * It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
         * <p>
         * <blockquote>
         * <p>
         * When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a> . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating custom composite models (Components)</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodels</a>
         * @param assetModelCompositeModels The composite models that are part of this asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelCompositeModels(final software.amazon.awscdk.IResolvable assetModelCompositeModels) {
            this.props.assetModelCompositeModels(assetModelCompositeModels);
            return this;
        }
        /**
         * The composite models that are part of this asset model.
         * <p>
         * It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
         * <p>
         * <blockquote>
         * <p>
         * When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a> . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating custom composite models (Components)</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodels</a>
         * @param assetModelCompositeModels The composite models that are part of this asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelCompositeModels(final java.util.List<? extends java.lang.Object> assetModelCompositeModels) {
            this.props.assetModelCompositeModels(assetModelCompositeModels);
            return this;
        }

        /**
         * A description for the asset model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeldescription</a>
         * @param assetModelDescription A description for the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelDescription(final java.lang.String assetModelDescription) {
            this.props.assetModelDescription(assetModelDescription);
            return this;
        }

        /**
         * The external ID of the asset model.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelexternalid</a>
         * @param assetModelExternalId The external ID of the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelExternalId(final java.lang.String assetModelExternalId) {
            this.props.assetModelExternalId(assetModelExternalId);
            return this;
        }

        /**
         * The hierarchy definitions of the asset model.
         * <p>
         * Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies</a>
         * @param assetModelHierarchies The hierarchy definitions of the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelHierarchies(final software.amazon.awscdk.IResolvable assetModelHierarchies) {
            this.props.assetModelHierarchies(assetModelHierarchies);
            return this;
        }
        /**
         * The hierarchy definitions of the asset model.
         * <p>
         * Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies</a>
         * @param assetModelHierarchies The hierarchy definitions of the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelHierarchies(final java.util.List<? extends java.lang.Object> assetModelHierarchies) {
            this.props.assetModelHierarchies(assetModelHierarchies);
            return this;
        }

        /**
         * The property definitions of the asset model.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties</a>
         * @param assetModelProperties The property definitions of the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelProperties(final software.amazon.awscdk.IResolvable assetModelProperties) {
            this.props.assetModelProperties(assetModelProperties);
            return this;
        }
        /**
         * The property definitions of the asset model.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties</a>
         * @param assetModelProperties The property definitions of the asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelProperties(final java.util.List<? extends java.lang.Object> assetModelProperties) {
            this.props.assetModelProperties(assetModelProperties);
            return this;
        }

        /**
         * The type of asset model.
         * <p>
         * <ul>
         * <li><em>ASSET_MODEL</em> – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.</li>
         * <li><em>COMPONENT_MODEL</em> – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeltype</a>
         * @param assetModelType The type of asset model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelType(final java.lang.String assetModelType) {
            this.props.assetModelType(assetModelType);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the asset.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-tags</a>
         * @param tags A list of key-value pairs that contain metadata for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotsitewise.CfnAssetModel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotsitewise.CfnAssetModel build() {
            return new software.amazon.awscdk.services.iotsitewise.CfnAssetModel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
