package software.amazon.awscdk.services.kms;

/**
 * Properties for defining a <code>CfnReplicaKey</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kms.*;
 * Object keyPolicy;
 * CfnReplicaKeyProps cfnReplicaKeyProps = CfnReplicaKeyProps.builder()
 *         .keyPolicy(keyPolicy)
 *         .primaryKeyArn("primaryKeyArn")
 *         // the properties below are optional
 *         .description("description")
 *         .enabled(false)
 *         .pendingWindowInDays(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:39.531Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.CfnReplicaKeyProps")
@software.amazon.jsii.Jsii.Proxy(CfnReplicaKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReplicaKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key policy that authorizes use of the replica key.
     * <p>
     * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. AWS KMS does not synchronize this property.
     * <p>
     * The key policy must conform to the following rules.
     * <p>
     * <ul>
     * <li>The key policy must give the caller <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> permission on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
     * <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
     * </ul>
     * <p>
     * A key policy document can include only the following characters:
     * <p>
     * <ul>
     * <li>Printable ASCII characters from the space character ( <code>\u0020</code> ) through the end of the ASCII character range.</li>
     * <li>Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code> ).</li>
     * <li>The tab ( <code>\u0009</code> ), line feed ( <code>\u000A</code> ), and carriage return ( <code>\u000D</code> ) special characters</li>
     * </ul>
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>32768</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-keypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-keypolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeyPolicy();

    /**
     * Specifies the multi-Region primary key to replicate.
     * <p>
     * The primary key must be in a different AWS Region of the same AWS partition. You can create only one replica of a given primary key in each AWS Region .
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>PrimaryKeyArn</code> value of a replica key, the existing replica key is scheduled for deletion and a new replica key is created based on the specified primary key. While it is scheduled for deletion, the existing replica key becomes unusable. You can cancel the scheduled deletion of the key outside of CloudFormation.
     * <p>
     * However, if you inadvertently delete a replica key, you can decrypt ciphertext encrypted by that replica key by using any related multi-Region key. If necessary, you can recreate the replica in the same Region after the previous one is completely deleted. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em>
     * <p>
     * </blockquote>
     * <p>
     * Specify the key ARN of an existing multi-Region primary key. For example, <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-primarykeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-primarykeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrimaryKeyArn();

    /**
     * A description of the KMS key.
     * <p>
     * The default value is an empty string (no description).
     * <p>
     * The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. AWS Key Management Service does not synchronize this property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
     * <p>
     * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
     * <p>
     * The actual key state of the replica might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations. Also, while the replica key is being created, its key state is <code>Creating</code> . When the process is complete, the key state of the replica key changes to <code>Enabled</code> .
     * <p>
     * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a replica key that has been removed from a CloudFormation stack.
     * <p>
     * Enter a value between 7 and 30 days. The default value is 30 days.
     * <p>
     * When you remove a replica key from a CloudFormation stack, AWS KMS schedules the replica key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of replica key is <code>Pending Deletion</code> , which prevents it from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the replica key.
     * <p>
     * If the KMS key is a multi-Region primary key with replica keys, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
     * <p>
     * You cannot use a CloudFormation template to cancel deletion of the replica after you remove it from the stack, regardless of the waiting period. However, if you specify a replica key in your template that is based on the same primary key as the original replica key, CloudFormation creates a new replica key with the same key ID, key material, and other shared properties of the original replica key. This new replica key can decrypt ciphertext that was encrypted under the original replica key, or any related multi-Region key.
     * <p>
     * For detailed information about deleting multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * For information about the <code>PendingDeletion</code> key state, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-pendingwindowindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-pendingwindowindays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPendingWindowInDays() {
        return null;
    }

    /**
     * Assigns one or more tags to the replica key.
     * <p>
     * <blockquote>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. AWS KMS does not synchronize this property.
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, AWS KMS replaces the current tag value with the specified one.
     * <p>
     * When you assign tags to an AWS resource, AWS generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html#cfn-kms-replicakey-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReplicaKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReplicaKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReplicaKeyProps> {
        java.lang.Object keyPolicy;
        java.lang.String primaryKeyArn;
        java.lang.String description;
        java.lang.Object enabled;
        java.lang.Number pendingWindowInDays;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getKeyPolicy}
         * @param keyPolicy The key policy that authorizes use of the replica key. This parameter is required.
         *                  The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. AWS KMS does not synchronize this property.
         *                  <p>
         *                  The key policy must conform to the following rules.
         *                  <p>
         *                  <ul>
         *                  <li>The key policy must give the caller <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> permission on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
         *                  <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
         *                  </ul>
         *                  <p>
         *                  A key policy document can include only the following characters:
         *                  <p>
         *                  <ul>
         *                  <li>Printable ASCII characters from the space character ( <code>\u0020</code> ) through the end of the ASCII character range.</li>
         *                  <li>Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code> ).</li>
         *                  <li>The tab ( <code>\u0009</code> ), line feed ( <code>\u000A</code> ), and carriage return ( <code>\u000D</code> ) special characters</li>
         *                  </ul>
         *                  <p>
         *                  <em>Minimum</em> : <code>1</code>
         *                  <p>
         *                  <em>Maximum</em> : <code>32768</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPolicy(java.lang.Object keyPolicy) {
            this.keyPolicy = keyPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getPrimaryKeyArn}
         * @param primaryKeyArn Specifies the multi-Region primary key to replicate. This parameter is required.
         *                      The primary key must be in a different AWS Region of the same AWS partition. You can create only one replica of a given primary key in each AWS Region .
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      If you change the <code>PrimaryKeyArn</code> value of a replica key, the existing replica key is scheduled for deletion and a new replica key is created based on the specified primary key. While it is scheduled for deletion, the existing replica key becomes unusable. You can cancel the scheduled deletion of the key outside of CloudFormation.
         *                      <p>
         *                      However, if you inadvertently delete a replica key, you can decrypt ciphertext encrypted by that replica key by using any related multi-Region key. If necessary, you can recreate the replica in the same Region after the previous one is completely deleted. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em>
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      Specify the key ARN of an existing multi-Region primary key. For example, <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryKeyArn(java.lang.String primaryKeyArn) {
            this.primaryKeyArn = primaryKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getDescription}
         * @param description A description of the KMS key.
         *                    The default value is an empty string (no description).
         *                    <p>
         *                    The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. AWS Key Management Service does not synchronize this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getEnabled}
         * @param enabled Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         *                When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         *                <p>
         *                The actual key state of the replica might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations. Also, while the replica key is being created, its key state is <code>Creating</code> . When the process is complete, the key state of the replica key changes to <code>Enabled</code> .
         *                <p>
         *                For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getEnabled}
         * @param enabled Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         *                When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         *                <p>
         *                The actual key state of the replica might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations. Also, while the replica key is being created, its key state is <code>Creating</code> . When the process is complete, the key state of the replica key changes to <code>Enabled</code> .
         *                <p>
         *                For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getPendingWindowInDays}
         * @param pendingWindowInDays Specifies the number of days in the waiting period before AWS KMS deletes a replica key that has been removed from a CloudFormation stack.
         *                            Enter a value between 7 and 30 days. The default value is 30 days.
         *                            <p>
         *                            When you remove a replica key from a CloudFormation stack, AWS KMS schedules the replica key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of replica key is <code>Pending Deletion</code> , which prevents it from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the replica key.
         *                            <p>
         *                            If the KMS key is a multi-Region primary key with replica keys, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
         *                            <p>
         *                            You cannot use a CloudFormation template to cancel deletion of the replica after you remove it from the stack, regardless of the waiting period. However, if you specify a replica key in your template that is based on the same primary key as the original replica key, CloudFormation creates a new replica key with the same key ID, key material, and other shared properties of the original replica key. This new replica key can decrypt ciphertext that was encrypted under the original replica key, or any related multi-Region key.
         *                            <p>
         *                            For detailed information about deleting multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                            <p>
         *                            For information about the <code>PendingDeletion</code> key state, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingWindowInDays(java.lang.Number pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicaKeyProps#getTags}
         * @param tags Assigns one or more tags to the replica key.
         *             <blockquote>
         *             <p>
         *             Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *             <p>
         *             </blockquote>
         *             <p>
         *             Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. AWS KMS does not synchronize this property.
         *             <p>
         *             Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, AWS KMS replaces the current tag value with the specified one.
         *             <p>
         *             When you assign tags to an AWS resource, AWS generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReplicaKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReplicaKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReplicaKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReplicaKeyProps {
        private final java.lang.Object keyPolicy;
        private final java.lang.String primaryKeyArn;
        private final java.lang.String description;
        private final java.lang.Object enabled;
        private final java.lang.Number pendingWindowInDays;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyPolicy = software.amazon.jsii.Kernel.get(this, "keyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.primaryKeyArn = software.amazon.jsii.Kernel.get(this, "primaryKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pendingWindowInDays = software.amazon.jsii.Kernel.get(this, "pendingWindowInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyPolicy = java.util.Objects.requireNonNull(builder.keyPolicy, "keyPolicy is required");
            this.primaryKeyArn = java.util.Objects.requireNonNull(builder.primaryKeyArn, "primaryKeyArn is required");
            this.description = builder.description;
            this.enabled = builder.enabled;
            this.pendingWindowInDays = builder.pendingWindowInDays;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getKeyPolicy() {
            return this.keyPolicy;
        }

        @Override
        public final java.lang.String getPrimaryKeyArn() {
            return this.primaryKeyArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Number getPendingWindowInDays() {
            return this.pendingWindowInDays;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyPolicy", om.valueToTree(this.getKeyPolicy()));
            data.set("primaryKeyArn", om.valueToTree(this.getPrimaryKeyArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getPendingWindowInDays() != null) {
                data.set("pendingWindowInDays", om.valueToTree(this.getPendingWindowInDays()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kms.CfnReplicaKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReplicaKeyProps.Jsii$Proxy that = (CfnReplicaKeyProps.Jsii$Proxy) o;

            if (!keyPolicy.equals(that.keyPolicy)) return false;
            if (!primaryKeyArn.equals(that.primaryKeyArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.pendingWindowInDays != null ? !this.pendingWindowInDays.equals(that.pendingWindowInDays) : that.pendingWindowInDays != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyPolicy.hashCode();
            result = 31 * result + (this.primaryKeyArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.pendingWindowInDays != null ? this.pendingWindowInDays.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
