package software.amazon.awscdk.services.lambda;

/**
 * Specific access configuration settings that tell Lambda how to authenticate with your schema registry.
 * <p>
 * If you're working with an AWS Glue schema registry, don't provide authentication details in this object. Instead, ensure that your execution role has the required permissions for Lambda to access your cluster.
 * <p>
 * If you're working with a Confluent schema registry, choose the authentication method in the Type field, and provide the AWS Secrets Manager secret ARN in the URI field.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * KafkaSchemaRegistryAccessConfigType kafkaSchemaRegistryAccessConfigType;
 * KafkaSchemaRegistryAccessConfig kafkaSchemaRegistryAccessConfig = KafkaSchemaRegistryAccessConfig.builder()
 *         .type(kafkaSchemaRegistryAccessConfigType)
 *         .uri("uri")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:39.769Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.KafkaSchemaRegistryAccessConfig")
@software.amazon.jsii.Jsii.Proxy(KafkaSchemaRegistryAccessConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KafkaSchemaRegistryAccessConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of authentication Lambda uses to access your schema registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType getType();

    /**
     * The URI of the secret (Secrets Manager secret ARN) to authenticate with your schema registry.
     * <p>
     * @see <a href="KafkaSchemaRegistryAccessConfigType">KafkaSchemaRegistryAccessConfigType</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUri();

    /**
     * @return a {@link Builder} of {@link KafkaSchemaRegistryAccessConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KafkaSchemaRegistryAccessConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KafkaSchemaRegistryAccessConfig> {
        software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType type;
        java.lang.String uri;

        /**
         * Sets the value of {@link KafkaSchemaRegistryAccessConfig#getType}
         * @param type The type of authentication Lambda uses to access your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link KafkaSchemaRegistryAccessConfig#getUri}
         * @param uri The URI of the secret (Secrets Manager secret ARN) to authenticate with your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KafkaSchemaRegistryAccessConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KafkaSchemaRegistryAccessConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KafkaSchemaRegistryAccessConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaSchemaRegistryAccessConfig {
        private final software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType type;
        private final java.lang.String uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.uri = java.util.Objects.requireNonNull(builder.uri, "uri is required");
        }

        @Override
        public final software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getUri() {
            return this.uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            data.set("uri", om.valueToTree(this.getUri()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.KafkaSchemaRegistryAccessConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KafkaSchemaRegistryAccessConfig.Jsii$Proxy that = (KafkaSchemaRegistryAccessConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            return this.uri.equals(that.uri);
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.uri.hashCode());
            return result;
        }
    }
}
