package software.amazon.awscdk.services.lambda;

/**
 * A Lambda that will only ever be added to a stack once.
 * <p>
 * This construct is a way to guarantee that the lambda function will be guaranteed to be part of the stack,
 * once and only once, irrespective of how many times the construct is declared to be part of the stack.
 * This is guaranteed as long as the <code>uuid</code> property and the optional <code>lambdaPurpose</code> property stay the same
 * whenever they're declared into the stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SingletonFunction fn = new SingletonFunction(this, "MyProvider", functionProps);
 * CustomResource.Builder.create(this, "MyResource")
 *         .serviceToken(fn.getFunctionArn())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:39.784Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.SingletonFunction")
public class SingletonFunction extends software.amazon.awscdk.services.lambda.FunctionBase {

    protected SingletonFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SingletonFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SingletonFunction.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SingletonFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.SingletonFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Using node.addDependency() does not work on this method as the underlying lambda function is modeled as a singleton across the stack. Use this method instead to declare dependencies.
     * <p>
     * @param up This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final @org.jetbrains.annotations.NotNull software.constructs.IDependable... up) {
        software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(up).toArray(Object[]::new));
    }

    /**
     * Adds an environment variable to this Lambda function.
     * <p>
     * If this is a ref to a Lambda function, this operation results in a no-op.
     * <p>
     * @param key The environment variable key. This parameter is required.
     * @param value The environment variable's value. This parameter is required.
     * @param options Environment variable options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Function addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.EnvironmentOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required"), options });
    }

    /**
     * Adds an environment variable to this Lambda function.
     * <p>
     * If this is a ref to a Lambda function, this operation results in a no-op.
     * <p>
     * @param key The environment variable key. This parameter is required.
     * @param value The environment variable's value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Function addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Adds one or more Lambda Layers to this Lambda function.
     * <p>
     * @param layers the layers to be added. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLayers(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ILayerVersion... layers) {
        software.amazon.jsii.Kernel.call(this, "addLayers", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(layers).toArray(Object[]::new));
    }

    /**
     * Use this method to write to the construct tree.
     * <p>
     * The metadata entries are written to the Cloud Assembly Manifest if the <code>treeMetadata</code> property is specified in the props of the App that contains this Construct.
     * <p>
     * @param type This parameter is required.
     * @param data This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetadata(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.NotNull java.lang.Object data, final @org.jetbrains.annotations.Nullable software.constructs.MetadataOptions options) {
        software.amazon.jsii.Kernel.call(this, "addMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), data, options });
    }

    /**
     * Use this method to write to the construct tree.
     * <p>
     * The metadata entries are written to the Cloud Assembly Manifest if the <code>treeMetadata</code> property is specified in the props of the App that contains this Construct.
     * <p>
     * @param type This parameter is required.
     * @param data This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetadata(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.NotNull java.lang.Object data) {
        software.amazon.jsii.Kernel.call(this, "addMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), data });
    }

    /**
     * Adds a permission to the Lambda resource policy.
     * <p>
     * @param name This parameter is required.
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Permission permission) {
        software.amazon.jsii.Kernel.call(this, "addPermission", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * The SingletonFunction construct cannot be added as a dependency of another construct using node.addDependency(). Use this method instead to declare this as a dependency of another construct.
     * <p>
     * @param down This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void dependOn(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct down) {
        software.amazon.jsii.Kernel.call(this, "dependOn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(down, "down is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The architecture of this Lambda Function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture getArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
    }

    /**
     * Whether the addPermission() call adds any permissions.
     * <p>
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getCanCreatePermissions() {
        return software.amazon.jsii.Kernel.get(this, "canCreatePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Access the Connections object.
     * <p>
     * Will fail if not a VPC-enabled Lambda Function
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The name of the singleton function.
     * <p>
     * It acts as a unique ID within its CDK stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConstructName() {
        return software.amazon.jsii.Kernel.get(this, "constructName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a <code>lambda.Version</code> which represents the current version of this singleton Lambda function. A new version will be created every time the function's configuration changes.
     * <p>
     * You can specify options for this version using the <code>currentVersionOptions</code>
     * prop when initializing the <code>lambda.SingletonFunction</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Version getCurrentVersion() {
        return software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Version.class));
    }

    /**
     * The ARN fo the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * Whether or not this Lambda function was bound to a VPC.
     * <p>
     * If this is is <code>false</code>, trying to access the <code>connections</code> object will fail.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsBoundToVpc() {
        return software.amazon.jsii.Kernel.get(this, "isBoundToVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The LogGroup where the Lambda function's logs are made available.
     * <p>
     * If either <code>logRetention</code> is set or this property is called, a CloudFormation custom resource is added to the stack that
     * pre-creates the log group as part of the stack deployment, if it already doesn't exist, and sets the correct log retention
     * period (never expire, by default).
     * <p>
     * Further, if the log group already exists and the <code>logRetention</code> is not set, the custom resource will reset the log retention
     * to never expire even if it was configured with a different value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * The construct node where permissions are attached.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.constructs.Node getPermissionsNode() {
        return software.amazon.jsii.Kernel.get(this, "permissionsNode", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
    }

    /**
     * The ARN(s) to put into the resource field of the generated IAM policy for grantInvoke().
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceArnsForGrantInvoke() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "resourceArnsForGrantInvoke", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The runtime environment for the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Runtime getRuntime() {
        return software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
    }

    /**
     * The IAM role associated with this function.
     * <p>
     * Undefined if the function was imported without a role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.SingletonFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.SingletonFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.SingletonFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.SingletonFunctionProps.Builder();
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum: 60 seconds
         * Maximum: 6 hours
         * <p>
         * Default: Duration.hours(6)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The destination for failed invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onFailure The destination for failed invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The destination for successful invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onSuccess The destination for successful invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(final software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum: 0
         * Maximum: 2
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Specify the configuration of AWS Distro for OpenTelemetry (ADOT) instrumentation.
         * <p>
         * Default: - No ADOT instrumentation
         * <p>
         * @return {@code this}
         * @see <a href="https://aws-otel.github.io/docs/getting-started/lambda">https://aws-otel.github.io/docs/getting-started/lambda</a>
         * @param adotInstrumentation Specify the configuration of AWS Distro for OpenTelemetry (ADOT) instrumentation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adotInstrumentation(final software.amazon.awscdk.services.lambda.AdotInstrumentationConfig adotInstrumentation) {
            this.props.adotInstrumentation(adotInstrumentation);
            return this;
        }

        /**
         * Whether to allow the Lambda to send all ipv6 network traffic.
         * <p>
         * If set to true, there will only be a single egress rule which allows all
         * outbound ipv6 traffic. If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets using ipv6.
         * <p>
         * Do not specify this property if the <code>securityGroups</code> or <code>securityGroup</code> property is set.
         * Instead, configure <code>allowAllIpv6Outbound</code> directly on the security group.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param allowAllIpv6Outbound Whether to allow the Lambda to send all ipv6 network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllIpv6Outbound(final java.lang.Boolean allowAllIpv6Outbound) {
            this.props.allowAllIpv6Outbound(allowAllIpv6Outbound);
            return this;
        }

        /**
         * Whether to allow the Lambda to send all network traffic (except ipv6).
         * <p>
         * If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets.
         * <p>
         * Do not specify this property if the <code>securityGroups</code> or <code>securityGroup</code> property is set.
         * Instead, configure <code>allowAllOutbound</code> directly on the security group.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic (except ipv6). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Lambda Functions in a public subnet can NOT access the internet.
         * <p>
         * Use this property to acknowledge this limitation and still place the function in a public subnet.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841">https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841</a>
         * @param allowPublicSubnet Lambda Functions in a public subnet can NOT access the internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowPublicSubnet(final java.lang.Boolean allowPublicSubnet) {
            this.props.allowPublicSubnet(allowPublicSubnet);
            return this;
        }

        /**
         * (deprecated) Sets the application log level for the function.
         * <p>
         * Default: "INFO"
         * <p>
         * @return {@code this}
         * @deprecated Use <code>applicationLogLevelV2</code> as a property instead.
         * @param applicationLogLevel Sets the application log level for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder applicationLogLevel(final java.lang.String applicationLogLevel) {
            this.props.applicationLogLevel(applicationLogLevel);
            return this;
        }

        /**
         * Sets the application log level for the function.
         * <p>
         * Default: ApplicationLogLevel.INFO
         * <p>
         * @return {@code this}
         * @param applicationLogLevelV2 Sets the application log level for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationLogLevelV2(final software.amazon.awscdk.services.lambda.ApplicationLogLevel applicationLogLevelV2) {
            this.props.applicationLogLevelV2(applicationLogLevelV2);
            return this;
        }

        /**
         * The system architectures compatible with this lambda function.
         * <p>
         * Default: Architecture.X86_64
         * <p>
         * @return {@code this}
         * @param architecture The system architectures compatible with this lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(final software.amazon.awscdk.services.lambda.Architecture architecture) {
            this.props.architecture(architecture);
            return this;
        }

        /**
         * Code signing config associated with this function.
         * <p>
         * Default: - Not Sign the Code
         * <p>
         * @return {@code this}
         * @param codeSigningConfig Code signing config associated with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfig(final software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig) {
            this.props.codeSigningConfig(codeSigningConfig);
            return this;
        }

        /**
         * Options for the <code>lambda.Version</code> resource automatically created by the <code>fn.currentVersion</code> method.
         * <p>
         * Default: - default options as described in `VersionOptions`
         * <p>
         * @return {@code this}
         * @param currentVersionOptions Options for the <code>lambda.Version</code> resource automatically created by the <code>fn.currentVersion</code> method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionOptions(final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.props.currentVersionOptions(currentVersionOptions);
            return this;
        }

        /**
         * The SQS queue to use if DLQ is enabled.
         * <p>
         * If SNS topic is desired, specify <code>deadLetterTopic</code> property instead.
         * <p>
         * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Enabled DLQ.
         * <p>
         * If <code>deadLetterQueue</code> is undefined,
         * an SQS queue with default options will be defined for your Function.
         * <p>
         * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueueEnabled Enabled DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(final java.lang.Boolean deadLetterQueueEnabled) {
            this.props.deadLetterQueueEnabled(deadLetterQueueEnabled);
            return this;
        }

        /**
         * The SNS topic to use as a DLQ.
         * <p>
         * Note that if <code>deadLetterQueueEnabled</code> is set to <code>true</code>, an SQS queue will be created
         * rather than an SNS topic. Using an SNS topic as a DLQ requires this property to be set explicitly.
         * <p>
         * Default: - no SNS topic
         * <p>
         * @return {@code this}
         * @param deadLetterTopic The SNS topic to use as a DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterTopic(final software.amazon.awscdk.services.sns.ITopic deadLetterTopic) {
            this.props.deadLetterTopic(deadLetterTopic);
            return this;
        }

        /**
         * A description of the function.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * <p>
         * Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The AWS KMS key that's used to encrypt your function's environment variables.
         * <p>
         * Default: - AWS Lambda creates and uses an AWS managed customer master key (CMK).
         * <p>
         * @return {@code this}
         * @param environmentEncryption The AWS KMS key that's used to encrypt your function's environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentEncryption(final software.amazon.awscdk.services.kms.IKey environmentEncryption) {
            this.props.environmentEncryption(environmentEncryption);
            return this;
        }

        /**
         * The size of the function’s /tmp directory in MiB.
         * <p>
         * Default: 512 MiB
         * <p>
         * @return {@code this}
         * @param ephemeralStorageSize The size of the function’s /tmp directory in MiB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(final software.amazon.awscdk.Size ephemeralStorageSize) {
            this.props.ephemeralStorageSize(ephemeralStorageSize);
            return this;
        }

        /**
         * Event sources for this function.
         * <p>
         * You can also add event sources using <code>addEventSource</code>.
         * <p>
         * Default: - No event sources.
         * <p>
         * @return {@code this}
         * @param events Event sources for this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<? extends software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.props.events(events);
            return this;
        }

        /**
         * The filesystem configuration for the lambda function.
         * <p>
         * Default: - will not mount any filesystem
         * <p>
         * @return {@code this}
         * @param filesystem The filesystem configuration for the lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filesystem(final software.amazon.awscdk.services.lambda.FileSystem filesystem) {
            this.props.filesystem(filesystem);
            return this;
        }

        /**
         * A name for the function.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the function's name. For more information, see Name Type.
         * <p>
         * @return {@code this}
         * @param functionName A name for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * Initial policy statements to add to the created Lambda Role.
         * <p>
         * You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * <p>
         * Default: - No policy statements are added to the created Lambda role.
         * <p>
         * @return {@code this}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.props.initialPolicy(initialPolicy);
            return this;
        }

        /**
         * Specify the version of CloudWatch Lambda insights to use for monitoring.
         * <p>
         * Default: - No Lambda Insights
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-docker.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-docker.html</a>
         * @param insightsVersion Specify the version of CloudWatch Lambda insights to use for monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsVersion(final software.amazon.awscdk.services.lambda.LambdaInsightsVersion insightsVersion) {
            this.props.insightsVersion(insightsVersion);
            return this;
        }

        /**
         * Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ipv6AllowedForDualStack Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6AllowedForDualStack(final java.lang.Boolean ipv6AllowedForDualStack) {
            this.props.ipv6AllowedForDualStack(ipv6AllowedForDualStack);
            return this;
        }

        /**
         * A list of layers to add to the function's execution environment.
         * <p>
         * You can configure your Lambda function to pull in
         * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         * that can be used by multiple functions.
         * <p>
         * Default: - No layers.
         * <p>
         * @return {@code this}
         * @param layers A list of layers to add to the function's execution environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(final java.util.List<? extends software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.props.layers(layers);
            return this;
        }

        /**
         * (deprecated) Sets the logFormat for the function.
         * <p>
         * Default: "Text"
         * <p>
         * @return {@code this}
         * @deprecated Use <code>loggingFormat</code> as a property instead.
         * @param logFormat Sets the logFormat for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder logFormat(final java.lang.String logFormat) {
            this.props.logFormat(logFormat);
            return this;
        }

        /**
         * Sets the loggingFormat for the function.
         * <p>
         * Default: LoggingFormat.TEXT
         * <p>
         * @return {@code this}
         * @param loggingFormat Sets the loggingFormat for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingFormat(final software.amazon.awscdk.services.lambda.LoggingFormat loggingFormat) {
            this.props.loggingFormat(loggingFormat);
            return this;
        }

        /**
         * The log group the function sends logs to.
         * <p>
         * By default, Lambda functions send logs to an automatically created default log group named /aws/lambda/<function name>.
         * However you cannot change the properties of this auto-created log group using the AWS CDK, e.g. you cannot set a different log retention.
         * <p>
         * Use the <code>logGroup</code> property to create a fully customizable LogGroup ahead of time, and instruct the Lambda function to send logs to it.
         * <p>
         * Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
         * If you are deploying to another type of region, please check regional availability first.
         * <p>
         * Default: `/aws/lambda/${this.functionName}` - default log group created by Lambda
         * <p>
         * @return {@code this}
         * @param logGroup The log group the function sends logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * (deprecated) Determine the removal policy of the log group that is auto-created by this construct.
         * <p>
         * Normally you want to retain the log group so you can diagnose issues
         * from logs even after a deployment that no longer includes the log group.
         * In that case, use the normal date-based retention policy to age out your
         * logs.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @deprecated use <code>logGroup</code> instead
         * @param logRemovalPolicy Determine the removal policy of the log group that is auto-created by this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder logRemovalPolicy(final software.amazon.awscdk.RemovalPolicy logRemovalPolicy) {
            this.props.logRemovalPolicy(logRemovalPolicy);
            return this;
        }

        /**
         * (deprecated) The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>INFINITE</code>.
         * <p>
         * This is a legacy API and we strongly recommend you move away from it if you can.
         * Instead create a fully customizable log group with <code>logs.LogGroup</code> and use the <code>logGroup</code> property
         * to instruct the Lambda function to send logs to it.
         * Migrating from <code>logRetention</code> to <code>logGroup</code> will cause the name of the log group to change.
         * Users and code and referencing the name verbatim will have to adjust.
         * <p>
         * In AWS CDK code, you can access the log group name directly from the LogGroup construct:
         * <p>
         * <blockquote><pre>
         * import software.amazon.awscdk.services.logs.*;
         * LogGroup myLogGroup;
         * myLogGroup.getLogGroupName();
         * </pre></blockquote>
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @deprecated use <code>logGroup</code> instead
         * @param logRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         * <p>
         * These options control the retry policy when interacting with CloudWatch APIs.
         * <p>
         * This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
         * <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
         * <p>
         * Default: - Default AWS SDK retry options.
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
         * <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
         * <p>
         * Default: - A new role is created.
         * <p>
         * @return {@code this}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(final software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        /**
         * The amount of memory, in MB, that is allocated to your Lambda function.
         * <p>
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        /**
         * Specify the configuration of Parameters and Secrets Extension.
         * <p>
         * Default: - No Parameters and Secrets Extension
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-integration-lambda-extensions.html">https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-integration-lambda-extensions.html</a>
         * @param paramsAndSecrets Specify the configuration of Parameters and Secrets Extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paramsAndSecrets(final software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion paramsAndSecrets) {
            this.props.paramsAndSecrets(paramsAndSecrets);
            return this;
        }

        /**
         * Enable profiling.
         * <p>
         * Default: - No profiling.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html">https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html</a>
         * @param profiling Enable profiling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profiling(final java.lang.Boolean profiling) {
            this.props.profiling(profiling);
            return this;
        }

        /**
         * Profiling Group.
         * <p>
         * Default: - A new profiling group will be created if `profiling` is set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html">https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html</a>
         * @param profilingGroup Profiling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilingGroup(final software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup) {
            this.props.profilingGroup(profilingGroup);
            return this;
        }

        /**
         * Sets the Recursive Loop Protection for Lambda Function.
         * <p>
         * It lets Lambda detect and terminate unintended recursive loops.
         * <p>
         * Default: RecursiveLoop.Terminate
         * <p>
         * @return {@code this}
         * @param recursiveLoop Sets the Recursive Loop Protection for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveLoop(final software.amazon.awscdk.services.lambda.RecursiveLoop recursiveLoop) {
            this.props.recursiveLoop(recursiveLoop);
            return this;
        }

        /**
         * The maximum of concurrent executions you want to reserve for the function.
         * <p>
         * Default: - No specific limit - account limit.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html</a>
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * Lambda execution role.
         * <p>
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * <p>
         * The default Role automatically has permissions granted for Lambda execution. If you
         * provide a Role, you must add the relevant AWS managed policies yourself.
         * <p>
         * The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
         * "service-role/AWSLambdaVPCAccessExecutionRole".
         * <p>
         * Default: - A unique role will be generated for this lambda function.
         * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         * <p>
         * @return {@code this}
         * @param role Lambda execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Sets the runtime management configuration for a function's version.
         * <p>
         * Default: Auto
         * <p>
         * @return {@code this}
         * @param runtimeManagementMode Sets the runtime management configuration for a function's version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeManagementMode(final software.amazon.awscdk.services.lambda.RuntimeManagementMode runtimeManagementMode) {
            this.props.runtimeManagementMode(runtimeManagementMode);
            return this;
        }

        /**
         * The list of security groups to associate with the Lambda's network interfaces.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, either by this or securityGroup prop, a dedicated security
         * group will be created for this function.
         * <p>
         * @return {@code this}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Enable SnapStart for Lambda Function.
         * <p>
         * SnapStart is currently supported for Java 11, Java 17, Python 3.12, Python 3.13, and .NET 8 runtime
         * <p>
         * Default: - No snapstart
         * <p>
         * @return {@code this}
         * @param snapStart Enable SnapStart for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapStart(final software.amazon.awscdk.services.lambda.SnapStartConf snapStart) {
            this.props.snapStart(snapStart);
            return this;
        }

        /**
         * (deprecated) Sets the system log level for the function.
         * <p>
         * Default: "INFO"
         * <p>
         * @return {@code this}
         * @deprecated Use <code>systemLogLevelV2</code> as a property instead.
         * @param systemLogLevel Sets the system log level for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder systemLogLevel(final java.lang.String systemLogLevel) {
            this.props.systemLogLevel(systemLogLevel);
            return this;
        }

        /**
         * Sets the system log level for the function.
         * <p>
         * Default: SystemLogLevel.INFO
         * <p>
         * @return {@code this}
         * @param systemLogLevelV2 Sets the system log level for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder systemLogLevelV2(final software.amazon.awscdk.services.lambda.SystemLogLevel systemLogLevelV2) {
            this.props.systemLogLevelV2(systemLogLevelV2);
            return this;
        }

        /**
         * The function execution time (in seconds) after which Lambda terminates the function.
         * <p>
         * Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * <p>
         * Default: Duration.seconds(3)
         * <p>
         * @return {@code this}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Enable AWS X-Ray Tracing for Lambda Function.
         * <p>
         * Default: Tracing.Disabled
         * <p>
         * @return {@code this}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.props.tracing(tracing);
            return this;
        }

        /**
         * VPC network to place Lambda network interfaces.
         * <p>
         * Specify this if the Lambda function needs to access resources in a VPC.
         * This is required when <code>vpcSubnets</code> is specified.
         * <p>
         * Default: - Function is not placed within a VPC.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place Lambda network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * This requires <code>vpc</code> to be specified in order for interfaces to actually be
         * placed in the subnets. If <code>vpc</code> is not specify, this will raise an error.
         * <p>
         * Note: Internet access for Lambda Functions requires a NAT Gateway, so picking
         * public subnets is not allowed (unless <code>allowPublicSubnet</code> is set to <code>true</code>).
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The source code of your Lambda function.
         * <p>
         * You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         * <p>
         * @return {@code this}
         * @param code The source code of your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.lambda.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * The name of the method within your code that Lambda calls to execute your function.
         * <p>
         * The format includes the file name. It can also include
         * namespaces and other qualifiers, depending on the runtime.
         * For more information, see https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html.
         * <p>
         * Use <code>Handler.FROM_IMAGE</code> when defining a function from a Docker image.
         * <p>
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         * <p>
         * @return {@code this}
         * @param handler The name of the method within your code that Lambda calls to execute your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final java.lang.String handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * The runtime environment for the Lambda function that you are uploading.
         * <p>
         * For valid values, see the Runtime property in the AWS Lambda Developer
         * Guide.
         * <p>
         * Use <code>Runtime.FROM_IMAGE</code> when defining a function from a Docker image.
         * <p>
         * @return {@code this}
         * @param runtime The runtime environment for the Lambda function that you are uploading. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * A unique identifier to identify this lambda.
         * <p>
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         * <p>
         * @return {@code this}
         * @param uuid A unique identifier to identify this lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uuid(final java.lang.String uuid) {
            this.props.uuid(uuid);
            return this;
        }

        /**
         * A descriptive name for the purpose of this Lambda.
         * <p>
         * If the Lambda does not have a physical name, this string will be
         * reflected its generated name. The combination of lambdaPurpose
         * and uuid must be unique.
         * <p>
         * Default: SingletonLambda
         * <p>
         * @return {@code this}
         * @param lambdaPurpose A descriptive name for the purpose of this Lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaPurpose(final java.lang.String lambdaPurpose) {
            this.props.lambdaPurpose(lambdaPurpose);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.SingletonFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.SingletonFunction build() {
            return new software.amazon.awscdk.services.lambda.SingletonFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
