package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Properties for glue schema registry configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.glue.CfnRegistry;
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * // Your Glue Schema Registry
 * CfnRegistry glueRegistry = CfnRegistry.Builder.create(this, "Registry")
 *         .name("schema-registry")
 *         .description("Schema registry for event source")
 *         .build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(GlueSchemaRegistry.Builder.create()
 *                 .schemaRegistry(glueRegistry)
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:39.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.GlueSchemaRegistryProps")
@software.amazon.jsii.Jsii.Proxy(GlueSchemaRegistryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GlueSchemaRegistryProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.SchemaRegistryProps {

    /**
     * The CfnRegistry reference of your glue schema registry.
     * <p>
     * If used, schemaRegistryArn will be ignored.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnRegistry getSchemaRegistry() {
        return null;
    }

    /**
     * The Arn of your glue schema registry.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchemaRegistryArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GlueSchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GlueSchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GlueSchemaRegistryProps> {
        software.amazon.awscdk.services.glue.CfnRegistry schemaRegistry;
        java.lang.String schemaRegistryArn;
        software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;

        /**
         * Sets the value of {@link GlueSchemaRegistryProps#getSchemaRegistry}
         * @param schemaRegistry The CfnRegistry reference of your glue schema registry.
         *                       If used, schemaRegistryArn will be ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistry(software.amazon.awscdk.services.glue.CfnRegistry schemaRegistry) {
            this.schemaRegistry = schemaRegistry;
            return this;
        }

        /**
         * Sets the value of {@link GlueSchemaRegistryProps#getSchemaRegistryArn}
         * @param schemaRegistryArn The Arn of your glue schema registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryArn(java.lang.String schemaRegistryArn) {
            this.schemaRegistryArn = schemaRegistryArn;
            return this;
        }

        /**
         * Sets the value of {@link GlueSchemaRegistryProps#getEventRecordFormat}
         * @param eventRecordFormat The record format that Lambda delivers to your function after schema validation. This parameter is required.
         *                          <ul>
         *                          <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
         *                          <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRecordFormat(software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat) {
            this.eventRecordFormat = eventRecordFormat;
            return this;
        }

        /**
         * Sets the value of {@link GlueSchemaRegistryProps#getSchemaValidationConfigs}
         * @param schemaValidationConfigs An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder schemaValidationConfigs(java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)schemaValidationConfigs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlueSchemaRegistryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GlueSchemaRegistryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GlueSchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueSchemaRegistryProps {
        private final software.amazon.awscdk.services.glue.CfnRegistry schemaRegistry;
        private final java.lang.String schemaRegistryArn;
        private final software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        private final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schemaRegistry = software.amazon.jsii.Kernel.get(this, "schemaRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.CfnRegistry.class));
            this.schemaRegistryArn = software.amazon.jsii.Kernel.get(this, "schemaRegistryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventRecordFormat = software.amazon.jsii.Kernel.get(this, "eventRecordFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class));
            this.schemaValidationConfigs = software.amazon.jsii.Kernel.get(this, "schemaValidationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schemaRegistry = builder.schemaRegistry;
            this.schemaRegistryArn = builder.schemaRegistryArn;
            this.eventRecordFormat = java.util.Objects.requireNonNull(builder.eventRecordFormat, "eventRecordFormat is required");
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)java.util.Objects.requireNonNull(builder.schemaValidationConfigs, "schemaValidationConfigs is required");
        }

        @Override
        public final software.amazon.awscdk.services.glue.CfnRegistry getSchemaRegistry() {
            return this.schemaRegistry;
        }

        @Override
        public final java.lang.String getSchemaRegistryArn() {
            return this.schemaRegistryArn;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.EventRecordFormat getEventRecordFormat() {
            return this.eventRecordFormat;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> getSchemaValidationConfigs() {
            return this.schemaValidationConfigs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getSchemaRegistry() != null) {
                data.set("schemaRegistry", om.valueToTree(this.getSchemaRegistry()));
            }
            if (this.getSchemaRegistryArn() != null) {
                data.set("schemaRegistryArn", om.valueToTree(this.getSchemaRegistryArn()));
            }
            data.set("eventRecordFormat", om.valueToTree(this.getEventRecordFormat()));
            data.set("schemaValidationConfigs", om.valueToTree(this.getSchemaValidationConfigs()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_event_sources.GlueSchemaRegistryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GlueSchemaRegistryProps.Jsii$Proxy that = (GlueSchemaRegistryProps.Jsii$Proxy) o;

            if (this.schemaRegistry != null ? !this.schemaRegistry.equals(that.schemaRegistry) : that.schemaRegistry != null) return false;
            if (this.schemaRegistryArn != null ? !this.schemaRegistryArn.equals(that.schemaRegistryArn) : that.schemaRegistryArn != null) return false;
            if (!eventRecordFormat.equals(that.eventRecordFormat)) return false;
            return this.schemaValidationConfigs.equals(that.schemaValidationConfigs);
        }

        @Override
        public final int hashCode() {
            int result = this.schemaRegistry != null ? this.schemaRegistry.hashCode() : 0;
            result = 31 * result + (this.schemaRegistryArn != null ? this.schemaRegistryArn.hashCode() : 0);
            result = 31 * result + (this.eventRecordFormat.hashCode());
            result = 31 * result + (this.schemaValidationConfigs.hashCode());
            return result;
        }
    }
}
