package software.amazon.awscdk.services.logs;

/**
 * This processor adds new key-value pairs to the log event.
 * <p>
 * For more information about this processor including examples, see addKeys in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.088Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.AddKeysProperty")
@software.amazon.jsii.Jsii.Proxy(AddKeysProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddKeysProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of objects, where each object contains information about one key to add to the log event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.AddKeyEntryProperty> getEntries();

    /**
     * @return a {@link Builder} of {@link AddKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddKeysProperty> {
        java.util.List<software.amazon.awscdk.services.logs.AddKeyEntryProperty> entries;

        /**
         * Sets the value of {@link AddKeysProperty#getEntries}
         * @param entries An array of objects, where each object contains information about one key to add to the log event. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder entries(java.util.List<? extends software.amazon.awscdk.services.logs.AddKeyEntryProperty> entries) {
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.AddKeyEntryProperty>)entries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddKeysProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddKeysProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddKeysProperty {
        private final java.util.List<software.amazon.awscdk.services.logs.AddKeyEntryProperty> entries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.AddKeyEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.AddKeyEntryProperty>)java.util.Objects.requireNonNull(builder.entries, "entries is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.AddKeyEntryProperty> getEntries() {
            return this.entries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entries", om.valueToTree(this.getEntries()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.AddKeysProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddKeysProperty.Jsii$Proxy that = (AddKeysProperty.Jsii$Proxy) o;

            return this.entries.equals(that.entries);
        }

        @Override
        public final int hashCode() {
            int result = this.entries.hashCode();
            return result;
        }
    }
}
