package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnTransformer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnTransformerProps cfnTransformerProps = CfnTransformerProps.builder()
 *         .logGroupIdentifier("logGroupIdentifier")
 *         .transformerConfig(List.of(ProcessorProperty.builder()
 *                 .addKeys(AddKeysProperty.builder()
 *                         .entries(List.of(AddKeyEntryProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .copyValue(CopyValueProperty.builder()
 *                         .entries(List.of(CopyValueEntryProperty.builder()
 *                                 .source("source")
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .csv(CsvProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .delimiter("delimiter")
 *                         .quoteCharacter("quoteCharacter")
 *                         .source("source")
 *                         .build())
 *                 .dateTimeConverter(DateTimeConverterProperty.builder()
 *                         .matchPatterns(List.of("matchPatterns"))
 *                         .source("source")
 *                         .target("target")
 *                         // the properties below are optional
 *                         .locale("locale")
 *                         .sourceTimezone("sourceTimezone")
 *                         .targetFormat("targetFormat")
 *                         .targetTimezone("targetTimezone")
 *                         .build())
 *                 .deleteKeys(DeleteKeysProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .grok(GrokProperty.builder()
 *                         .match("match")
 *                         // the properties below are optional
 *                         .source("source")
 *                         .build())
 *                 .listToMap(ListToMapProperty.builder()
 *                         .key("key")
 *                         .source("source")
 *                         // the properties below are optional
 *                         .flatten(false)
 *                         .flattenedElement("flattenedElement")
 *                         .target("target")
 *                         .valueKey("valueKey")
 *                         .build())
 *                 .lowerCaseString(LowerCaseStringProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .moveKeys(MoveKeysProperty.builder()
 *                         .entries(List.of(MoveKeyEntryProperty.builder()
 *                                 .source("source")
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .parseCloudfront(ParseCloudfrontProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseJson(ParseJSONProperty.builder()
 *                         .destination("destination")
 *                         .source("source")
 *                         .build())
 *                 .parseKeyValue(ParseKeyValueProperty.builder()
 *                         .destination("destination")
 *                         .fieldDelimiter("fieldDelimiter")
 *                         .keyPrefix("keyPrefix")
 *                         .keyValueDelimiter("keyValueDelimiter")
 *                         .nonMatchValue("nonMatchValue")
 *                         .overwriteIfExists(false)
 *                         .source("source")
 *                         .build())
 *                 .parsePostgres(ParsePostgresProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseRoute53(ParseRoute53Property.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseToOcsf(ParseToOCSFProperty.builder()
 *                         .eventSource("eventSource")
 *                         .ocsfVersion("ocsfVersion")
 *                         // the properties below are optional
 *                         .source("source")
 *                         .build())
 *                 .parseVpc(ParseVPCProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseWaf(ParseWAFProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .renameKeys(RenameKeysProperty.builder()
 *                         .entries(List.of(RenameKeyEntryProperty.builder()
 *                                 .key("key")
 *                                 .renameTo("renameTo")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .splitString(SplitStringProperty.builder()
 *                         .entries(List.of(SplitStringEntryProperty.builder()
 *                                 .delimiter("delimiter")
 *                                 .source("source")
 *                                 .build()))
 *                         .build())
 *                 .substituteString(SubstituteStringProperty.builder()
 *                         .entries(List.of(SubstituteStringEntryProperty.builder()
 *                                 .from("from")
 *                                 .source("source")
 *                                 .to("to")
 *                                 .build()))
 *                         .build())
 *                 .trimString(TrimStringProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .typeConverter(TypeConverterProperty.builder()
 *                         .entries(List.of(TypeConverterEntryProperty.builder()
 *                                 .key("key")
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .upperCaseString(UpperCaseStringProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.150Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransformerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransformerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specify either the name or ARN of the log group to create the transformer for.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-loggroupidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-loggroupidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogGroupIdentifier();

    /**
     * This structure is an array that contains the configuration of this log transformer.
     * <p>
     * A log transformer is an array of processors, where each processor applies one type of transformation to the log events that are ingested.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-transformerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-transformerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTransformerConfig();

    /**
     * @return a {@link Builder} of {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransformerProps> {
        java.lang.String logGroupIdentifier;
        java.lang.Object transformerConfig;

        /**
         * Sets the value of {@link CfnTransformerProps#getLogGroupIdentifier}
         * @param logGroupIdentifier Specify either the name or ARN of the log group to create the transformer for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupIdentifier(java.lang.String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getTransformerConfig}
         * @param transformerConfig This structure is an array that contains the configuration of this log transformer. This parameter is required.
         *                          A log transformer is an array of processors, where each processor applies one type of transformation to the log events that are ingested.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerConfig(software.amazon.awscdk.IResolvable transformerConfig) {
            this.transformerConfig = transformerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getTransformerConfig}
         * @param transformerConfig This structure is an array that contains the configuration of this log transformer. This parameter is required.
         *                          A log transformer is an array of processors, where each processor applies one type of transformation to the log events that are ingested.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerConfig(java.util.List<? extends java.lang.Object> transformerConfig) {
            this.transformerConfig = transformerConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransformerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransformerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransformerProps {
        private final java.lang.String logGroupIdentifier;
        private final java.lang.Object transformerConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroupIdentifier = software.amazon.jsii.Kernel.get(this, "logGroupIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transformerConfig = software.amazon.jsii.Kernel.get(this, "transformerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroupIdentifier = java.util.Objects.requireNonNull(builder.logGroupIdentifier, "logGroupIdentifier is required");
            this.transformerConfig = java.util.Objects.requireNonNull(builder.transformerConfig, "transformerConfig is required");
        }

        @Override
        public final java.lang.String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        @Override
        public final java.lang.Object getTransformerConfig() {
            return this.transformerConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroupIdentifier", om.valueToTree(this.getLogGroupIdentifier()));
            data.set("transformerConfig", om.valueToTree(this.getTransformerConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransformerProps.Jsii$Proxy that = (CfnTransformerProps.Jsii$Proxy) o;

            if (!logGroupIdentifier.equals(that.logGroupIdentifier)) return false;
            return this.transformerConfig.equals(that.transformerConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.logGroupIdentifier.hashCode();
            result = 31 * result + (this.transformerConfig.hashCode());
            return result;
        }
    }
}
