package software.amazon.awscdk.services.logs;

/**
 * Processor for data conversion operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * DataConverterProcessor dataConverterProcessor = DataConverterProcessor.Builder.create()
 *         .type(DataConverterType.TYPE_CONVERTER)
 *         // the properties below are optional
 *         .dateTimeConverterOptions(DateTimeConverterProperty.builder()
 *                 .locale("locale")
 *                 .matchPatterns(List.of("matchPatterns"))
 *                 .source("source")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .sourceTimezone("sourceTimezone")
 *                 .targetFormat("targetFormat")
 *                 .targetTimezone("targetTimezone")
 *                 .build())
 *         .typeConverterOptions(TypeConverterProperty.builder()
 *                 .entries(List.of(TypeConverterEntryProperty.builder()
 *                         .key("key")
 *                         .type(TypeConverterType.BOOLEAN)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.154Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DataConverterProcessor")
public class DataConverterProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.IProcessor {

    protected DataConverterProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DataConverterProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new data converter processor.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DataConverterProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.DataConverterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The type of data conversion operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.DataConverterType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataConverterType.class));
    }

    /**
     * The type of data conversion operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.DataConverterType value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.DataConverterProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.DataConverterProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.DataConverterProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.DataConverterProps.Builder();
        }

        /**
         * The type of data conversion operation.
         * <p>
         * @return {@code this}
         * @param type The type of data conversion operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.logs.DataConverterType type) {
            this.props.type(type);
            return this;
        }

        /**
         * Options for datetime conversion.
         * <p>
         * Required when type is DATETIME_CONVERTER.
         * <p>
         * Default: - No date time converter processor is created if not set
         * <p>
         * @return {@code this}
         * @param dateTimeConverterOptions Options for datetime conversion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dateTimeConverterOptions(final software.amazon.awscdk.services.logs.DateTimeConverterProperty dateTimeConverterOptions) {
            this.props.dateTimeConverterOptions(dateTimeConverterOptions);
            return this;
        }

        /**
         * Options for type conversion.
         * <p>
         * Required when type is TYPE_CONVERTER.
         * <p>
         * Default: - No type convertor processor is created if not set
         * <p>
         * @return {@code this}
         * @param typeConverterOptions Options for type conversion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeConverterOptions(final software.amazon.awscdk.services.logs.TypeConverterProperty typeConverterOptions) {
            this.props.typeConverterOptions(typeConverterOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.DataConverterProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.DataConverterProcessor build() {
            return new software.amazon.awscdk.services.logs.DataConverterProcessor(
                this.props.build()
            );
        }
    }
}
