package software.amazon.awscdk.services.logs;

/**
 * This processor converts a datetime string into a format that you specify.
 * <p>
 * For more information about this processor including examples, see datetimeConverter in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * DateTimeConverterProperty dateTimeConverterProperty = DateTimeConverterProperty.builder()
 *         .locale("locale")
 *         .matchPatterns(List.of("matchPatterns"))
 *         .source("source")
 *         .target("target")
 *         // the properties below are optional
 *         .sourceTimezone("sourceTimezone")
 *         .targetFormat("targetFormat")
 *         .targetTimezone("targetTimezone")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.157Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DateTimeConverterProperty")
@software.amazon.jsii.Jsii.Proxy(DateTimeConverterProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DateTimeConverterProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The locale of the source field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocale();

    /**
     * A list of patterns to match against the source field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchPatterns();

    /**
     * The key to apply the date conversion to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * The JSON field to store the result in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * The time zone of the source field.
     * <p>
     * Default: UTC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceTimezone() {
        return null;
    }

    /**
     * The datetime format to use for the converted data in the target field.
     * <p>
     * Default: "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetFormat() {
        return null;
    }

    /**
     * The time zone of the target field.
     * <p>
     * Default: UTC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetTimezone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DateTimeConverterProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DateTimeConverterProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DateTimeConverterProperty> {
        java.lang.String locale;
        java.util.List<java.lang.String> matchPatterns;
        java.lang.String source;
        java.lang.String target;
        java.lang.String sourceTimezone;
        java.lang.String targetFormat;
        java.lang.String targetTimezone;

        /**
         * Sets the value of {@link DateTimeConverterProperty#getLocale}
         * @param locale The locale of the source field. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(java.lang.String locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Sets the value of {@link DateTimeConverterProperty#getMatchPatterns}
         * @param matchPatterns A list of patterns to match against the source field. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPatterns(java.util.List<java.lang.String> matchPatterns) {
            this.matchPatterns = matchPatterns;
            return this;
        }

        /**
         * Sets the value of {@link DateTimeConverterProperty#getSource}
         * @param source The key to apply the date conversion to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link DateTimeConverterProperty#getTarget}
         * @param target The JSON field to store the result in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link DateTimeConverterProperty#getSourceTimezone}
         * @param sourceTimezone The time zone of the source field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceTimezone(java.lang.String sourceTimezone) {
            this.sourceTimezone = sourceTimezone;
            return this;
        }

        /**
         * Sets the value of {@link DateTimeConverterProperty#getTargetFormat}
         * @param targetFormat The datetime format to use for the converted data in the target field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFormat(java.lang.String targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        /**
         * Sets the value of {@link DateTimeConverterProperty#getTargetTimezone}
         * @param targetTimezone The time zone of the target field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTimezone(java.lang.String targetTimezone) {
            this.targetTimezone = targetTimezone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DateTimeConverterProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DateTimeConverterProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DateTimeConverterProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeConverterProperty {
        private final java.lang.String locale;
        private final java.util.List<java.lang.String> matchPatterns;
        private final java.lang.String source;
        private final java.lang.String target;
        private final java.lang.String sourceTimezone;
        private final java.lang.String targetFormat;
        private final java.lang.String targetTimezone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.matchPatterns = software.amazon.jsii.Kernel.get(this, "matchPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceTimezone = software.amazon.jsii.Kernel.get(this, "sourceTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetFormat = software.amazon.jsii.Kernel.get(this, "targetFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetTimezone = software.amazon.jsii.Kernel.get(this, "targetTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.locale = java.util.Objects.requireNonNull(builder.locale, "locale is required");
            this.matchPatterns = java.util.Objects.requireNonNull(builder.matchPatterns, "matchPatterns is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.sourceTimezone = builder.sourceTimezone;
            this.targetFormat = builder.targetFormat;
            this.targetTimezone = builder.targetTimezone;
        }

        @Override
        public final java.lang.String getLocale() {
            return this.locale;
        }

        @Override
        public final java.util.List<java.lang.String> getMatchPatterns() {
            return this.matchPatterns;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getSourceTimezone() {
            return this.sourceTimezone;
        }

        @Override
        public final java.lang.String getTargetFormat() {
            return this.targetFormat;
        }

        @Override
        public final java.lang.String getTargetTimezone() {
            return this.targetTimezone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("locale", om.valueToTree(this.getLocale()));
            data.set("matchPatterns", om.valueToTree(this.getMatchPatterns()));
            data.set("source", om.valueToTree(this.getSource()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getSourceTimezone() != null) {
                data.set("sourceTimezone", om.valueToTree(this.getSourceTimezone()));
            }
            if (this.getTargetFormat() != null) {
                data.set("targetFormat", om.valueToTree(this.getTargetFormat()));
            }
            if (this.getTargetTimezone() != null) {
                data.set("targetTimezone", om.valueToTree(this.getTargetTimezone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.DateTimeConverterProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DateTimeConverterProperty.Jsii$Proxy that = (DateTimeConverterProperty.Jsii$Proxy) o;

            if (!locale.equals(that.locale)) return false;
            if (!matchPatterns.equals(that.matchPatterns)) return false;
            if (!source.equals(that.source)) return false;
            if (!target.equals(that.target)) return false;
            if (this.sourceTimezone != null ? !this.sourceTimezone.equals(that.sourceTimezone) : that.sourceTimezone != null) return false;
            if (this.targetFormat != null ? !this.targetFormat.equals(that.targetFormat) : that.targetFormat != null) return false;
            return this.targetTimezone != null ? this.targetTimezone.equals(that.targetTimezone) : that.targetTimezone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.locale.hashCode();
            result = 31 * result + (this.matchPatterns.hashCode());
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.sourceTimezone != null ? this.sourceTimezone.hashCode() : 0);
            result = 31 * result + (this.targetFormat != null ? this.targetFormat.hashCode() : 0);
            result = 31 * result + (this.targetTimezone != null ? this.targetTimezone.hashCode() : 0);
            return result;
        }
    }
}
