package software.amazon.awscdk.services.logs;

/**
 * Properties for creating JSON mutator processors.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.163Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.JsonMutatorProps")
@software.amazon.jsii.Jsii.Proxy(JsonMutatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JsonMutatorProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.logs.BaseProcessorProps {

    /**
     * The type of JSON mutation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonMutatorType getType();

    /**
     * Options for adding keys.
     * <p>
     * Required when type is ADD_KEYS.
     * <p>
     * Default: - No adding keys processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.AddKeysProperty getAddKeysOptions() {
        return null;
    }

    /**
     * Options for copying values.
     * <p>
     * Required when type is COPY_VALUE.
     * <p>
     * Default: - No copy value processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.CopyValueProperty getCopyValueOptions() {
        return null;
    }

    /**
     * Keys to delete.
     * <p>
     * Required when type is DELETE_KEYS.
     * <p>
     * Default: - No delete key processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty getDeleteKeysOptions() {
        return null;
    }

    /**
     * Options for converting lists to maps.
     * <p>
     * Required when type is LIST_TO_MAP.
     * <p>
     * Default: - No list-to-map processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ListToMapProperty getListToMapOptions() {
        return null;
    }

    /**
     * Options for moving keys.
     * <p>
     * Required when type is MOVE_KEYS.
     * <p>
     * Default: - No move key processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.MoveKeysProperty getMoveKeysOptions() {
        return null;
    }

    /**
     * Options for renaming keys.
     * <p>
     * Required when type is RENAME_KEYS.
     * <p>
     * Default: - No rename key processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RenameKeysProperty getRenameKeysOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JsonMutatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JsonMutatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JsonMutatorProps> {
        software.amazon.awscdk.services.logs.JsonMutatorType type;
        software.amazon.awscdk.services.logs.AddKeysProperty addKeysOptions;
        software.amazon.awscdk.services.logs.CopyValueProperty copyValueOptions;
        software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty deleteKeysOptions;
        software.amazon.awscdk.services.logs.ListToMapProperty listToMapOptions;
        software.amazon.awscdk.services.logs.MoveKeysProperty moveKeysOptions;
        software.amazon.awscdk.services.logs.RenameKeysProperty renameKeysOptions;

        /**
         * Sets the value of {@link JsonMutatorProps#getType}
         * @param type The type of JSON mutation operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.logs.JsonMutatorType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link JsonMutatorProps#getAddKeysOptions}
         * @param addKeysOptions Options for adding keys.
         *                       Required when type is ADD_KEYS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addKeysOptions(software.amazon.awscdk.services.logs.AddKeysProperty addKeysOptions) {
            this.addKeysOptions = addKeysOptions;
            return this;
        }

        /**
         * Sets the value of {@link JsonMutatorProps#getCopyValueOptions}
         * @param copyValueOptions Options for copying values.
         *                         Required when type is COPY_VALUE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyValueOptions(software.amazon.awscdk.services.logs.CopyValueProperty copyValueOptions) {
            this.copyValueOptions = copyValueOptions;
            return this;
        }

        /**
         * Sets the value of {@link JsonMutatorProps#getDeleteKeysOptions}
         * @param deleteKeysOptions Keys to delete.
         *                          Required when type is DELETE_KEYS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteKeysOptions(software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty deleteKeysOptions) {
            this.deleteKeysOptions = deleteKeysOptions;
            return this;
        }

        /**
         * Sets the value of {@link JsonMutatorProps#getListToMapOptions}
         * @param listToMapOptions Options for converting lists to maps.
         *                         Required when type is LIST_TO_MAP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listToMapOptions(software.amazon.awscdk.services.logs.ListToMapProperty listToMapOptions) {
            this.listToMapOptions = listToMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link JsonMutatorProps#getMoveKeysOptions}
         * @param moveKeysOptions Options for moving keys.
         *                        Required when type is MOVE_KEYS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moveKeysOptions(software.amazon.awscdk.services.logs.MoveKeysProperty moveKeysOptions) {
            this.moveKeysOptions = moveKeysOptions;
            return this;
        }

        /**
         * Sets the value of {@link JsonMutatorProps#getRenameKeysOptions}
         * @param renameKeysOptions Options for renaming keys.
         *                          Required when type is RENAME_KEYS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renameKeysOptions(software.amazon.awscdk.services.logs.RenameKeysProperty renameKeysOptions) {
            this.renameKeysOptions = renameKeysOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JsonMutatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JsonMutatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JsonMutatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonMutatorProps {
        private final software.amazon.awscdk.services.logs.JsonMutatorType type;
        private final software.amazon.awscdk.services.logs.AddKeysProperty addKeysOptions;
        private final software.amazon.awscdk.services.logs.CopyValueProperty copyValueOptions;
        private final software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty deleteKeysOptions;
        private final software.amazon.awscdk.services.logs.ListToMapProperty listToMapOptions;
        private final software.amazon.awscdk.services.logs.MoveKeysProperty moveKeysOptions;
        private final software.amazon.awscdk.services.logs.RenameKeysProperty renameKeysOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonMutatorType.class));
            this.addKeysOptions = software.amazon.jsii.Kernel.get(this, "addKeysOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.AddKeysProperty.class));
            this.copyValueOptions = software.amazon.jsii.Kernel.get(this, "copyValueOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.CopyValueProperty.class));
            this.deleteKeysOptions = software.amazon.jsii.Kernel.get(this, "deleteKeysOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty.class));
            this.listToMapOptions = software.amazon.jsii.Kernel.get(this, "listToMapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ListToMapProperty.class));
            this.moveKeysOptions = software.amazon.jsii.Kernel.get(this, "moveKeysOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.MoveKeysProperty.class));
            this.renameKeysOptions = software.amazon.jsii.Kernel.get(this, "renameKeysOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RenameKeysProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.addKeysOptions = builder.addKeysOptions;
            this.copyValueOptions = builder.copyValueOptions;
            this.deleteKeysOptions = builder.deleteKeysOptions;
            this.listToMapOptions = builder.listToMapOptions;
            this.moveKeysOptions = builder.moveKeysOptions;
            this.renameKeysOptions = builder.renameKeysOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.JsonMutatorType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.logs.AddKeysProperty getAddKeysOptions() {
            return this.addKeysOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.CopyValueProperty getCopyValueOptions() {
            return this.copyValueOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty getDeleteKeysOptions() {
            return this.deleteKeysOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ListToMapProperty getListToMapOptions() {
            return this.listToMapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.MoveKeysProperty getMoveKeysOptions() {
            return this.moveKeysOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RenameKeysProperty getRenameKeysOptions() {
            return this.renameKeysOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getAddKeysOptions() != null) {
                data.set("addKeysOptions", om.valueToTree(this.getAddKeysOptions()));
            }
            if (this.getCopyValueOptions() != null) {
                data.set("copyValueOptions", om.valueToTree(this.getCopyValueOptions()));
            }
            if (this.getDeleteKeysOptions() != null) {
                data.set("deleteKeysOptions", om.valueToTree(this.getDeleteKeysOptions()));
            }
            if (this.getListToMapOptions() != null) {
                data.set("listToMapOptions", om.valueToTree(this.getListToMapOptions()));
            }
            if (this.getMoveKeysOptions() != null) {
                data.set("moveKeysOptions", om.valueToTree(this.getMoveKeysOptions()));
            }
            if (this.getRenameKeysOptions() != null) {
                data.set("renameKeysOptions", om.valueToTree(this.getRenameKeysOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.JsonMutatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JsonMutatorProps.Jsii$Proxy that = (JsonMutatorProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.addKeysOptions != null ? !this.addKeysOptions.equals(that.addKeysOptions) : that.addKeysOptions != null) return false;
            if (this.copyValueOptions != null ? !this.copyValueOptions.equals(that.copyValueOptions) : that.copyValueOptions != null) return false;
            if (this.deleteKeysOptions != null ? !this.deleteKeysOptions.equals(that.deleteKeysOptions) : that.deleteKeysOptions != null) return false;
            if (this.listToMapOptions != null ? !this.listToMapOptions.equals(that.listToMapOptions) : that.listToMapOptions != null) return false;
            if (this.moveKeysOptions != null ? !this.moveKeysOptions.equals(that.moveKeysOptions) : that.moveKeysOptions != null) return false;
            return this.renameKeysOptions != null ? this.renameKeysOptions.equals(that.renameKeysOptions) : that.renameKeysOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.addKeysOptions != null ? this.addKeysOptions.hashCode() : 0);
            result = 31 * result + (this.copyValueOptions != null ? this.copyValueOptions.hashCode() : 0);
            result = 31 * result + (this.deleteKeysOptions != null ? this.deleteKeysOptions.hashCode() : 0);
            result = 31 * result + (this.listToMapOptions != null ? this.listToMapOptions.hashCode() : 0);
            result = 31 * result + (this.moveKeysOptions != null ? this.moveKeysOptions.hashCode() : 0);
            result = 31 * result + (this.renameKeysOptions != null ? this.renameKeysOptions.hashCode() : 0);
            return result;
        }
    }
}
