package software.amazon.awscdk.services.logs;

/**
 * Processor to parse events from CloudTrail, Route53Resolver, VPCFlow, EKSAudit and AWSWAF into OCSF V1.1 format.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * ParseToOCSFProperty parseToOCSFProperty = ParseToOCSFProperty.builder()
 *         .eventSource(OCSFSourceType.CLOUD_TRAIL)
 *         .ocsfVersion(OCSFVersion.V1_1)
 *         // the properties below are optional
 *         .source("source")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.211Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ParseToOCSFProperty")
@software.amazon.jsii.Jsii.Proxy(ParseToOCSFProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ParseToOCSFProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of input log event source to convert to OCSF format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.OCSFSourceType getEventSource();

    /**
     * Version of OCSF schema to convert to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.OCSFVersion getOcsfVersion();

    /**
     * Path to the field in the log event that will be parsed.
     * <p>
     * Use dot notation to access child fields.
     * <p>
     * Default: '@message'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ParseToOCSFProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ParseToOCSFProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ParseToOCSFProperty> {
        software.amazon.awscdk.services.logs.OCSFSourceType eventSource;
        software.amazon.awscdk.services.logs.OCSFVersion ocsfVersion;
        java.lang.String source;

        /**
         * Sets the value of {@link ParseToOCSFProperty#getEventSource}
         * @param eventSource Type of input log event source to convert to OCSF format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSource(software.amazon.awscdk.services.logs.OCSFSourceType eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        /**
         * Sets the value of {@link ParseToOCSFProperty#getOcsfVersion}
         * @param ocsfVersion Version of OCSF schema to convert to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ocsfVersion(software.amazon.awscdk.services.logs.OCSFVersion ocsfVersion) {
            this.ocsfVersion = ocsfVersion;
            return this;
        }

        /**
         * Sets the value of {@link ParseToOCSFProperty#getSource}
         * @param source Path to the field in the log event that will be parsed.
         *               Use dot notation to access child fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ParseToOCSFProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ParseToOCSFProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ParseToOCSFProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseToOCSFProperty {
        private final software.amazon.awscdk.services.logs.OCSFSourceType eventSource;
        private final software.amazon.awscdk.services.logs.OCSFVersion ocsfVersion;
        private final java.lang.String source;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventSource = software.amazon.jsii.Kernel.get(this, "eventSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.OCSFSourceType.class));
            this.ocsfVersion = software.amazon.jsii.Kernel.get(this, "ocsfVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.OCSFVersion.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventSource = java.util.Objects.requireNonNull(builder.eventSource, "eventSource is required");
            this.ocsfVersion = java.util.Objects.requireNonNull(builder.ocsfVersion, "ocsfVersion is required");
            this.source = builder.source;
        }

        @Override
        public final software.amazon.awscdk.services.logs.OCSFSourceType getEventSource() {
            return this.eventSource;
        }

        @Override
        public final software.amazon.awscdk.services.logs.OCSFVersion getOcsfVersion() {
            return this.ocsfVersion;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventSource", om.valueToTree(this.getEventSource()));
            data.set("ocsfVersion", om.valueToTree(this.getOcsfVersion()));
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ParseToOCSFProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ParseToOCSFProperty.Jsii$Proxy that = (ParseToOCSFProperty.Jsii$Proxy) o;

            if (!eventSource.equals(that.eventSource)) return false;
            if (!ocsfVersion.equals(that.ocsfVersion)) return false;
            return this.source != null ? this.source.equals(that.source) : that.source == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventSource.hashCode();
            result = 31 * result + (this.ocsfVersion.hashCode());
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }
    }
}
