package software.amazon.awscdk.services.logs;

/**
 * Parser processor for common data formats.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.212Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ParserProcessor")
public class ParserProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.IProcessor {

    protected ParserProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ParserProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new parser processor.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ParserProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ParserProcessorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The type of parser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ParserProcessorType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ParserProcessorType.class));
    }

    /**
     * The type of parser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ParserProcessorType value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.ParserProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.ParserProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.ParserProcessorProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.ParserProcessorProps.Builder();
        }

        /**
         * The type of parser processor.
         * <p>
         * @return {@code this}
         * @param type The type of parser processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.logs.ParserProcessorType type) {
            this.props.type(type);
            return this;
        }

        /**
         * Options for CSV parser.
         * <p>
         * Required when type is CSV.
         * <p>
         * Default: - No CSV parser is created if props not set
         * <p>
         * @return {@code this}
         * @param csvOptions Options for CSV parser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csvOptions(final software.amazon.awscdk.services.logs.CsvProperty csvOptions) {
            this.props.csvOptions(csvOptions);
            return this;
        }

        /**
         * Options for Grok parser.
         * <p>
         * Required when type is GROK.
         * <p>
         * Default: - No Grok parser is created if props not set
         * <p>
         * @return {@code this}
         * @param grokOptions Options for Grok parser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grokOptions(final software.amazon.awscdk.services.logs.GrokProperty grokOptions) {
            this.props.grokOptions(grokOptions);
            return this;
        }

        /**
         * Options for JSON parser.
         * <p>
         * Required when type is JSON.
         * <p>
         * Default: - No JSON parser is created if props not set
         * <p>
         * @return {@code this}
         * @param jsonOptions Options for JSON parser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonOptions(final software.amazon.awscdk.services.logs.ParseJSONProperty jsonOptions) {
            this.props.jsonOptions(jsonOptions);
            return this;
        }

        /**
         * Options for key-value parser.
         * <p>
         * Required when type is KEY_VALUE.
         * <p>
         * Default: - No key-value parser is created if props not set
         * <p>
         * @return {@code this}
         * @param keyValueOptions Options for key-value parser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueOptions(final software.amazon.awscdk.services.logs.ParseKeyValueProperty keyValueOptions) {
            this.props.keyValueOptions(keyValueOptions);
            return this;
        }

        /**
         * Options for ParseToOCSF parser.
         * <p>
         * Required when type is set to OCSF
         * <p>
         * Default: - no OCSF parser is created.
         * <p>
         * @return {@code this}
         * @param parseToOcsfOptions Options for ParseToOCSF parser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parseToOcsfOptions(final software.amazon.awscdk.services.logs.ParseToOCSFProperty parseToOcsfOptions) {
            this.props.parseToOcsfOptions(parseToOcsfOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.ParserProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.ParserProcessor build() {
            return new software.amazon.awscdk.services.logs.ParserProcessor(
                this.props.build()
            );
        }
    }
}
