package software.amazon.awscdk.services.logs;

/**
 * Properties for creating configurable parser processors.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.213Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ParserProcessorProps")
@software.amazon.jsii.Jsii.Proxy(ParserProcessorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ParserProcessorProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.logs.BaseProcessorProps {

    /**
     * The type of parser processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ParserProcessorType getType();

    /**
     * Options for CSV parser.
     * <p>
     * Required when type is CSV.
     * <p>
     * Default: - No CSV parser is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.CsvProperty getCsvOptions() {
        return null;
    }

    /**
     * Options for Grok parser.
     * <p>
     * Required when type is GROK.
     * <p>
     * Default: - No Grok parser is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.GrokProperty getGrokOptions() {
        return null;
    }

    /**
     * Options for JSON parser.
     * <p>
     * Required when type is JSON.
     * <p>
     * Default: - No JSON parser is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ParseJSONProperty getJsonOptions() {
        return null;
    }

    /**
     * Options for key-value parser.
     * <p>
     * Required when type is KEY_VALUE.
     * <p>
     * Default: - No key-value parser is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ParseKeyValueProperty getKeyValueOptions() {
        return null;
    }

    /**
     * Options for ParseToOCSF parser.
     * <p>
     * Required when type is set to OCSF
     * <p>
     * Default: - no OCSF parser is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ParseToOCSFProperty getParseToOCSFOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ParserProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ParserProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ParserProcessorProps> {
        software.amazon.awscdk.services.logs.ParserProcessorType type;
        software.amazon.awscdk.services.logs.CsvProperty csvOptions;
        software.amazon.awscdk.services.logs.GrokProperty grokOptions;
        software.amazon.awscdk.services.logs.ParseJSONProperty jsonOptions;
        software.amazon.awscdk.services.logs.ParseKeyValueProperty keyValueOptions;
        software.amazon.awscdk.services.logs.ParseToOCSFProperty parseToOcsfOptions;

        /**
         * Sets the value of {@link ParserProcessorProps#getType}
         * @param type The type of parser processor. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.logs.ParserProcessorType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ParserProcessorProps#getCsvOptions}
         * @param csvOptions Options for CSV parser.
         *                   Required when type is CSV.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csvOptions(software.amazon.awscdk.services.logs.CsvProperty csvOptions) {
            this.csvOptions = csvOptions;
            return this;
        }

        /**
         * Sets the value of {@link ParserProcessorProps#getGrokOptions}
         * @param grokOptions Options for Grok parser.
         *                    Required when type is GROK.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grokOptions(software.amazon.awscdk.services.logs.GrokProperty grokOptions) {
            this.grokOptions = grokOptions;
            return this;
        }

        /**
         * Sets the value of {@link ParserProcessorProps#getJsonOptions}
         * @param jsonOptions Options for JSON parser.
         *                    Required when type is JSON.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonOptions(software.amazon.awscdk.services.logs.ParseJSONProperty jsonOptions) {
            this.jsonOptions = jsonOptions;
            return this;
        }

        /**
         * Sets the value of {@link ParserProcessorProps#getKeyValueOptions}
         * @param keyValueOptions Options for key-value parser.
         *                        Required when type is KEY_VALUE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueOptions(software.amazon.awscdk.services.logs.ParseKeyValueProperty keyValueOptions) {
            this.keyValueOptions = keyValueOptions;
            return this;
        }

        /**
         * Sets the value of {@link ParserProcessorProps#getParseToOcsfOptions}
         * @param parseToOcsfOptions Options for ParseToOCSF parser.
         *                           Required when type is set to OCSF
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parseToOcsfOptions(software.amazon.awscdk.services.logs.ParseToOCSFProperty parseToOcsfOptions) {
            this.parseToOcsfOptions = parseToOcsfOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ParserProcessorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ParserProcessorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ParserProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParserProcessorProps {
        private final software.amazon.awscdk.services.logs.ParserProcessorType type;
        private final software.amazon.awscdk.services.logs.CsvProperty csvOptions;
        private final software.amazon.awscdk.services.logs.GrokProperty grokOptions;
        private final software.amazon.awscdk.services.logs.ParseJSONProperty jsonOptions;
        private final software.amazon.awscdk.services.logs.ParseKeyValueProperty keyValueOptions;
        private final software.amazon.awscdk.services.logs.ParseToOCSFProperty parseToOcsfOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ParserProcessorType.class));
            this.csvOptions = software.amazon.jsii.Kernel.get(this, "csvOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.CsvProperty.class));
            this.grokOptions = software.amazon.jsii.Kernel.get(this, "grokOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.GrokProperty.class));
            this.jsonOptions = software.amazon.jsii.Kernel.get(this, "jsonOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ParseJSONProperty.class));
            this.keyValueOptions = software.amazon.jsii.Kernel.get(this, "keyValueOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ParseKeyValueProperty.class));
            this.parseToOcsfOptions = software.amazon.jsii.Kernel.get(this, "parseToOCSFOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ParseToOCSFProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.csvOptions = builder.csvOptions;
            this.grokOptions = builder.grokOptions;
            this.jsonOptions = builder.jsonOptions;
            this.keyValueOptions = builder.keyValueOptions;
            this.parseToOcsfOptions = builder.parseToOcsfOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ParserProcessorType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.logs.CsvProperty getCsvOptions() {
            return this.csvOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.GrokProperty getGrokOptions() {
            return this.grokOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ParseJSONProperty getJsonOptions() {
            return this.jsonOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ParseKeyValueProperty getKeyValueOptions() {
            return this.keyValueOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ParseToOCSFProperty getParseToOCSFOptions() {
            return this.parseToOcsfOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getCsvOptions() != null) {
                data.set("csvOptions", om.valueToTree(this.getCsvOptions()));
            }
            if (this.getGrokOptions() != null) {
                data.set("grokOptions", om.valueToTree(this.getGrokOptions()));
            }
            if (this.getJsonOptions() != null) {
                data.set("jsonOptions", om.valueToTree(this.getJsonOptions()));
            }
            if (this.getKeyValueOptions() != null) {
                data.set("keyValueOptions", om.valueToTree(this.getKeyValueOptions()));
            }
            if (this.getParseToOCSFOptions() != null) {
                data.set("parseToOCSFOptions", om.valueToTree(this.getParseToOCSFOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ParserProcessorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ParserProcessorProps.Jsii$Proxy that = (ParserProcessorProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.csvOptions != null ? !this.csvOptions.equals(that.csvOptions) : that.csvOptions != null) return false;
            if (this.grokOptions != null ? !this.grokOptions.equals(that.grokOptions) : that.grokOptions != null) return false;
            if (this.jsonOptions != null ? !this.jsonOptions.equals(that.jsonOptions) : that.jsonOptions != null) return false;
            if (this.keyValueOptions != null ? !this.keyValueOptions.equals(that.keyValueOptions) : that.keyValueOptions != null) return false;
            return this.parseToOcsfOptions != null ? this.parseToOcsfOptions.equals(that.parseToOcsfOptions) : that.parseToOcsfOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.csvOptions != null ? this.csvOptions.hashCode() : 0);
            result = 31 * result + (this.grokOptions != null ? this.grokOptions.hashCode() : 0);
            result = 31 * result + (this.jsonOptions != null ? this.jsonOptions.hashCode() : 0);
            result = 31 * result + (this.keyValueOptions != null ? this.keyValueOptions.hashCode() : 0);
            result = 31 * result + (this.parseToOcsfOptions != null ? this.parseToOcsfOptions.hashCode() : 0);
            return result;
        }
    }
}
