package software.amazon.awscdk.services.logs;

/**
 * Space delimited text pattern.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Search for all events where the component is "HttpServer" and the
 * // result code is not equal to 200.
 * SpaceDelimitedTextPattern pattern = FilterPattern.spaceDelimited("time", "component", "...", "result_code", "latency").whereString("component", "=", "HttpServer").whereNumber("result_code", "!=", 200);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.227Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.SpaceDelimitedTextPattern")
public class SpaceDelimitedTextPattern extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.IFilterPattern {

    protected SpaceDelimitedTextPattern(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SpaceDelimitedTextPattern(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param columns This parameter is required.
     * @param restrictions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected SpaceDelimitedTextPattern(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> columns, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.services.logs.ColumnRestriction>> restrictions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(columns, "columns is required"), java.util.Objects.requireNonNull(restrictions, "restrictions is required") });
    }

    /**
     * Construct a new instance of a space delimited text pattern.
     * <p>
     * Since this class must be public, we can't rely on the user only creating it through
     * the <code>LogPattern.spaceDelimited()</code> factory function. We must therefore validate the
     * argument in the constructor. Since we're returning a copy on every mutation, and we
     * don't want to re-validate the same things on every construction, we provide a limited
     * set of mutator functions and only validate the new data every time.
     * <p>
     * @param columns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern construct(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> columns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern.class, "construct", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern.class), new Object[] { java.util.Objects.requireNonNull(columns, "columns is required") });
    }

    /**
     * Restrict where the pattern applies.
     * <p>
     * @param columnName This parameter is required.
     * @param comparison This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern whereNumber(final @org.jetbrains.annotations.NotNull java.lang.String columnName, final @org.jetbrains.annotations.NotNull java.lang.String comparison, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.Kernel.call(this, "whereNumber", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern.class), new Object[] { java.util.Objects.requireNonNull(columnName, "columnName is required"), java.util.Objects.requireNonNull(comparison, "comparison is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Restrict where the pattern applies.
     * <p>
     * @param columnName This parameter is required.
     * @param comparison This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern whereString(final @org.jetbrains.annotations.NotNull java.lang.String columnName, final @org.jetbrains.annotations.NotNull java.lang.String comparison, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "whereString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern.class), new Object[] { java.util.Objects.requireNonNull(columnName, "columnName is required"), java.util.Objects.requireNonNull(comparison, "comparison is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogPatternString() {
        return software.amazon.jsii.Kernel.get(this, "logPatternString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
