package software.amazon.awscdk.services.logs;

/**
 * Properties for creating string mutator processors.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * StringMutatorProps stringMutatorProps = StringMutatorProps.builder()
 *         .type(StringMutatorType.LOWER_CASE)
 *         // the properties below are optional
 *         .lowerCaseKeys(List.of("lowerCaseKeys"))
 *         .splitOptions(SplitStringProperty.builder()
 *                 .entries(List.of(SplitStringEntryProperty.builder()
 *                         .delimiter(DelimiterCharacter.COMMA)
 *                         .source("source")
 *                         .build()))
 *                 .build())
 *         .substituteOptions(SubstituteStringProperty.builder()
 *                 .entries(List.of(SubstituteStringEntryProperty.builder()
 *                         .from("from")
 *                         .source("source")
 *                         .to("to")
 *                         .build()))
 *                 .build())
 *         .trimKeys(List.of("trimKeys"))
 *         .upperCaseKeys(List.of("upperCaseKeys"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.231Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.StringMutatorProps")
@software.amazon.jsii.Jsii.Proxy(StringMutatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StringMutatorProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.logs.BaseProcessorProps {

    /**
     * The type of string mutation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.StringMutatorType getType();

    /**
     * Keys for strings to convert to lowercase.
     * <p>
     * Required when type is LOWER_CASE.
     * <p>
     * Default: - No lowercase processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLowerCaseKeys() {
        return null;
    }

    /**
     * Options for string splitting.
     * <p>
     * Required when type is SPLIT.
     * <p>
     * Default: - No string splitting processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.SplitStringProperty getSplitOptions() {
        return null;
    }

    /**
     * Options for string substitution.
     * <p>
     * Required when type is SUBSTITUTE.
     * <p>
     * Default: - No string substitution processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.SubstituteStringProperty getSubstituteOptions() {
        return null;
    }

    /**
     * Keys for strings to trim.
     * <p>
     * Required when type is TRIM.
     * <p>
     * Default: - No trim processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrimKeys() {
        return null;
    }

    /**
     * Keys for strings to convert to uppercase.
     * <p>
     * Required when type is UPPER_CASE.
     * <p>
     * Default: - No uppercase processor is created if props not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUpperCaseKeys() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StringMutatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StringMutatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StringMutatorProps> {
        software.amazon.awscdk.services.logs.StringMutatorType type;
        java.util.List<java.lang.String> lowerCaseKeys;
        software.amazon.awscdk.services.logs.SplitStringProperty splitOptions;
        software.amazon.awscdk.services.logs.SubstituteStringProperty substituteOptions;
        java.util.List<java.lang.String> trimKeys;
        java.util.List<java.lang.String> upperCaseKeys;

        /**
         * Sets the value of {@link StringMutatorProps#getType}
         * @param type The type of string mutation operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.logs.StringMutatorType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link StringMutatorProps#getLowerCaseKeys}
         * @param lowerCaseKeys Keys for strings to convert to lowercase.
         *                      Required when type is LOWER_CASE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowerCaseKeys(java.util.List<java.lang.String> lowerCaseKeys) {
            this.lowerCaseKeys = lowerCaseKeys;
            return this;
        }

        /**
         * Sets the value of {@link StringMutatorProps#getSplitOptions}
         * @param splitOptions Options for string splitting.
         *                     Required when type is SPLIT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitOptions(software.amazon.awscdk.services.logs.SplitStringProperty splitOptions) {
            this.splitOptions = splitOptions;
            return this;
        }

        /**
         * Sets the value of {@link StringMutatorProps#getSubstituteOptions}
         * @param substituteOptions Options for string substitution.
         *                          Required when type is SUBSTITUTE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder substituteOptions(software.amazon.awscdk.services.logs.SubstituteStringProperty substituteOptions) {
            this.substituteOptions = substituteOptions;
            return this;
        }

        /**
         * Sets the value of {@link StringMutatorProps#getTrimKeys}
         * @param trimKeys Keys for strings to trim.
         *                 Required when type is TRIM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trimKeys(java.util.List<java.lang.String> trimKeys) {
            this.trimKeys = trimKeys;
            return this;
        }

        /**
         * Sets the value of {@link StringMutatorProps#getUpperCaseKeys}
         * @param upperCaseKeys Keys for strings to convert to uppercase.
         *                      Required when type is UPPER_CASE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upperCaseKeys(java.util.List<java.lang.String> upperCaseKeys) {
            this.upperCaseKeys = upperCaseKeys;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StringMutatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StringMutatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StringMutatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringMutatorProps {
        private final software.amazon.awscdk.services.logs.StringMutatorType type;
        private final java.util.List<java.lang.String> lowerCaseKeys;
        private final software.amazon.awscdk.services.logs.SplitStringProperty splitOptions;
        private final software.amazon.awscdk.services.logs.SubstituteStringProperty substituteOptions;
        private final java.util.List<java.lang.String> trimKeys;
        private final java.util.List<java.lang.String> upperCaseKeys;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.StringMutatorType.class));
            this.lowerCaseKeys = software.amazon.jsii.Kernel.get(this, "lowerCaseKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.splitOptions = software.amazon.jsii.Kernel.get(this, "splitOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SplitStringProperty.class));
            this.substituteOptions = software.amazon.jsii.Kernel.get(this, "substituteOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SubstituteStringProperty.class));
            this.trimKeys = software.amazon.jsii.Kernel.get(this, "trimKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.upperCaseKeys = software.amazon.jsii.Kernel.get(this, "upperCaseKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.lowerCaseKeys = builder.lowerCaseKeys;
            this.splitOptions = builder.splitOptions;
            this.substituteOptions = builder.substituteOptions;
            this.trimKeys = builder.trimKeys;
            this.upperCaseKeys = builder.upperCaseKeys;
        }

        @Override
        public final software.amazon.awscdk.services.logs.StringMutatorType getType() {
            return this.type;
        }

        @Override
        public final java.util.List<java.lang.String> getLowerCaseKeys() {
            return this.lowerCaseKeys;
        }

        @Override
        public final software.amazon.awscdk.services.logs.SplitStringProperty getSplitOptions() {
            return this.splitOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.SubstituteStringProperty getSubstituteOptions() {
            return this.substituteOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getTrimKeys() {
            return this.trimKeys;
        }

        @Override
        public final java.util.List<java.lang.String> getUpperCaseKeys() {
            return this.upperCaseKeys;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getLowerCaseKeys() != null) {
                data.set("lowerCaseKeys", om.valueToTree(this.getLowerCaseKeys()));
            }
            if (this.getSplitOptions() != null) {
                data.set("splitOptions", om.valueToTree(this.getSplitOptions()));
            }
            if (this.getSubstituteOptions() != null) {
                data.set("substituteOptions", om.valueToTree(this.getSubstituteOptions()));
            }
            if (this.getTrimKeys() != null) {
                data.set("trimKeys", om.valueToTree(this.getTrimKeys()));
            }
            if (this.getUpperCaseKeys() != null) {
                data.set("upperCaseKeys", om.valueToTree(this.getUpperCaseKeys()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.StringMutatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StringMutatorProps.Jsii$Proxy that = (StringMutatorProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.lowerCaseKeys != null ? !this.lowerCaseKeys.equals(that.lowerCaseKeys) : that.lowerCaseKeys != null) return false;
            if (this.splitOptions != null ? !this.splitOptions.equals(that.splitOptions) : that.splitOptions != null) return false;
            if (this.substituteOptions != null ? !this.substituteOptions.equals(that.substituteOptions) : that.substituteOptions != null) return false;
            if (this.trimKeys != null ? !this.trimKeys.equals(that.trimKeys) : that.trimKeys != null) return false;
            return this.upperCaseKeys != null ? this.upperCaseKeys.equals(that.upperCaseKeys) : that.upperCaseKeys == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.lowerCaseKeys != null ? this.lowerCaseKeys.hashCode() : 0);
            result = 31 * result + (this.splitOptions != null ? this.splitOptions.hashCode() : 0);
            result = 31 * result + (this.substituteOptions != null ? this.substituteOptions.hashCode() : 0);
            result = 31 * result + (this.trimKeys != null ? this.trimKeys.hashCode() : 0);
            result = 31 * result + (this.upperCaseKeys != null ? this.upperCaseKeys.hashCode() : 0);
            return result;
        }
    }
}
