package software.amazon.awscdk.services.logs;

/**
 * Use this processor to convert a value type associated with the specified key to the specified type.
 * <p>
 * It's a casting processor that changes the types of the specified fields.
 * For more information about this processor including examples, see typeConverter in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * TypeConverterProperty typeConverterProperty = TypeConverterProperty.builder()
 *         .entries(List.of(TypeConverterEntryProperty.builder()
 *                 .key("key")
 *                 .type(TypeConverterType.BOOLEAN)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:40.241Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.TypeConverterProperty")
@software.amazon.jsii.Jsii.Proxy(TypeConverterProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TypeConverterProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of TypeConverterEntry objects, where each object contains information about one field to change the type of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.TypeConverterEntryProperty> getEntries();

    /**
     * @return a {@link Builder} of {@link TypeConverterProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TypeConverterProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TypeConverterProperty> {
        java.util.List<software.amazon.awscdk.services.logs.TypeConverterEntryProperty> entries;

        /**
         * Sets the value of {@link TypeConverterProperty#getEntries}
         * @param entries An array of TypeConverterEntry objects, where each object contains information about one field to change the type of. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder entries(java.util.List<? extends software.amazon.awscdk.services.logs.TypeConverterEntryProperty> entries) {
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.TypeConverterEntryProperty>)entries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TypeConverterProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TypeConverterProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TypeConverterProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TypeConverterProperty {
        private final java.util.List<software.amazon.awscdk.services.logs.TypeConverterEntryProperty> entries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.TypeConverterEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.TypeConverterEntryProperty>)java.util.Objects.requireNonNull(builder.entries, "entries is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.TypeConverterEntryProperty> getEntries() {
            return this.entries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entries", om.valueToTree(this.getEntries()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.TypeConverterProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TypeConverterProperty.Jsii$Proxy that = (TypeConverterProperty.Jsii$Proxy) o;

            return this.entries.equals(that.entries);
        }

        @Override
        public final int hashCode() {
            int result = this.entries.hashCode();
            return result;
        }
    }
}
