package software.amazon.awscdk.services.mpa;

/**
 * Creates a new approval team.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Approval team</a> in the <em>Multi-party approval User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mpa.*;
 * CfnApprovalTeam cfnApprovalTeam = CfnApprovalTeam.Builder.create(this, "MyCfnApprovalTeam")
 *         .approvalStrategy(ApprovalStrategyProperty.builder()
 *                 .mofN(MofNApprovalStrategyProperty.builder()
 *                         .minApprovalsRequired(123)
 *                         .build())
 *                 .build())
 *         .approvers(List.of(ApproverProperty.builder()
 *                 .primaryIdentityId("primaryIdentityId")
 *                 .primaryIdentitySourceArn("primaryIdentitySourceArn")
 *                 // the properties below are optional
 *                 .approverId("approverId")
 *                 .primaryIdentityStatus("primaryIdentityStatus")
 *                 .responseTime("responseTime")
 *                 .build()))
 *         .description("description")
 *         .name("name")
 *         .policies(List.of(PolicyProperty.builder()
 *                 .policyArn("policyArn")
 *                 .build()))
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:41.390Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnApprovalTeam")
public class CfnApprovalTeam extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnApprovalTeam(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApprovalTeam(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mpa.CfnApprovalTeam.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApprovalTeam(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mpa.CfnApprovalTeamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Amazon Resource Name (ARN) for the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Timestamp when the team was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Timestamp when the team was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Total number of approvers in the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrNumberOfApprovers() {
        return software.amazon.jsii.Kernel.get(this, "attrNumberOfApprovers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Status for the team.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <em>Multi-party approval User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Status code for the team.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <em>Multi-party approval User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusCode() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Message describing the status for the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Timestamp when the team was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateSessionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateSessionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Version ID for the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionId() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains details for how an approval team grants approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getApprovalStrategy() {
        return software.amazon.jsii.Kernel.get(this, "approvalStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details for how an approval team grants approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovalStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "approvalStrategy", java.util.Objects.requireNonNull(value, "approvalStrategy is required"));
    }

    /**
     * Contains details for how an approval team grants approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovalStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mpa.CfnApprovalTeam.ApprovalStrategyProperty value) {
        software.amazon.jsii.Kernel.set(this, "approvalStrategy", java.util.Objects.requireNonNull(value, "approvalStrategy is required"));
    }

    /**
     * Contains details for an approver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getApprovers() {
        return software.amazon.jsii.Kernel.get(this, "approvers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details for an approver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovers(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "approvers", java.util.Objects.requireNonNull(value, "approvers is required"));
    }

    /**
     * Contains details for an approver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovers(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mpa.CfnApprovalTeam.ApproverProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mpa.CfnApprovalTeam.ApproverProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "approvers", java.util.Objects.requireNonNull(value, "approvers is required"));
    }

    /**
     * Description for the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Description for the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * Name of the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the team.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Contains details for a policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicies() {
        return software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details for a policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policies", java.util.Objects.requireNonNull(value, "policies is required"));
    }

    /**
     * Contains details for a policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mpa.CfnApprovalTeam.PolicyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mpa.CfnApprovalTeam.PolicyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "policies", java.util.Objects.requireNonNull(value, "policies is required"));
    }

    /**
     * Tags that you have added to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags that you have added to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Strategy for how an approval team grants approval.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mpa.*;
     * ApprovalStrategyProperty approvalStrategyProperty = ApprovalStrategyProperty.builder()
     *         .mofN(MofNApprovalStrategyProperty.builder()
     *                 .minApprovalsRequired(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approvalstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approvalstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnApprovalTeam.ApprovalStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(ApprovalStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApprovalStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Minimum number of approvals (M) required for a total number of approvers (N).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approvalstrategy.html#cfn-mpa-approvalteam-approvalstrategy-mofn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approvalstrategy.html#cfn-mpa-approvalteam-approvalstrategy-mofn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMofN();

        /**
         * @return a {@link Builder} of {@link ApprovalStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApprovalStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApprovalStrategyProperty> {
            java.lang.Object mofN;

            /**
             * Sets the value of {@link ApprovalStrategyProperty#getMofN}
             * @param mofN Minimum number of approvals (M) required for a total number of approvers (N). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mofN(software.amazon.awscdk.IResolvable mofN) {
                this.mofN = mofN;
                return this;
            }

            /**
             * Sets the value of {@link ApprovalStrategyProperty#getMofN}
             * @param mofN Minimum number of approvals (M) required for a total number of approvers (N). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mofN(software.amazon.awscdk.services.mpa.CfnApprovalTeam.MofNApprovalStrategyProperty mofN) {
                this.mofN = mofN;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApprovalStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApprovalStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApprovalStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApprovalStrategyProperty {
            private final java.lang.Object mofN;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mofN = software.amazon.jsii.Kernel.get(this, "mofN", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mofN = java.util.Objects.requireNonNull(builder.mofN, "mofN is required");
            }

            @Override
            public final java.lang.Object getMofN() {
                return this.mofN;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mofN", om.valueToTree(this.getMofN()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mpa.CfnApprovalTeam.ApprovalStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApprovalStrategyProperty.Jsii$Proxy that = (ApprovalStrategyProperty.Jsii$Proxy) o;

                return this.mofN.equals(that.mofN);
            }

            @Override
            public final int hashCode() {
                int result = this.mofN.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details for an approver.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mpa.*;
     * ApproverProperty approverProperty = ApproverProperty.builder()
     *         .primaryIdentityId("primaryIdentityId")
     *         .primaryIdentitySourceArn("primaryIdentitySourceArn")
     *         // the properties below are optional
     *         .approverId("approverId")
     *         .primaryIdentityStatus("primaryIdentityStatus")
     *         .responseTime("responseTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnApprovalTeam.ApproverProperty")
    @software.amazon.jsii.Jsii.Proxy(ApproverProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApproverProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ID for the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-primaryidentityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-primaryidentityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrimaryIdentityId();

        /**
         * Amazon Resource Name (ARN) for the identity source.
         * <p>
         * The identity source manages the user authentication for approvers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-primaryidentitysourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-primaryidentitysourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrimaryIdentitySourceArn();

        /**
         * ID for the approver.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-approverid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-approverid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApproverId() {
            return null;
        }

        /**
         * Status for the identity source.
         * <p>
         * For example, if an approver has accepted a team invitation with a user authentication method managed by the identity source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-primaryidentitystatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-primaryidentitystatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryIdentityStatus() {
            return null;
        }

        /**
         * Timestamp when the approver responded to an approval team invitation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-responsetime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-approver.html#cfn-mpa-approvalteam-approver-responsetime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponseTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApproverProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApproverProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApproverProperty> {
            java.lang.String primaryIdentityId;
            java.lang.String primaryIdentitySourceArn;
            java.lang.String approverId;
            java.lang.String primaryIdentityStatus;
            java.lang.String responseTime;

            /**
             * Sets the value of {@link ApproverProperty#getPrimaryIdentityId}
             * @param primaryIdentityId ID for the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryIdentityId(java.lang.String primaryIdentityId) {
                this.primaryIdentityId = primaryIdentityId;
                return this;
            }

            /**
             * Sets the value of {@link ApproverProperty#getPrimaryIdentitySourceArn}
             * @param primaryIdentitySourceArn Amazon Resource Name (ARN) for the identity source. This parameter is required.
             *                                 The identity source manages the user authentication for approvers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryIdentitySourceArn(java.lang.String primaryIdentitySourceArn) {
                this.primaryIdentitySourceArn = primaryIdentitySourceArn;
                return this;
            }

            /**
             * Sets the value of {@link ApproverProperty#getApproverId}
             * @param approverId ID for the approver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approverId(java.lang.String approverId) {
                this.approverId = approverId;
                return this;
            }

            /**
             * Sets the value of {@link ApproverProperty#getPrimaryIdentityStatus}
             * @param primaryIdentityStatus Status for the identity source.
             *                              For example, if an approver has accepted a team invitation with a user authentication method managed by the identity source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryIdentityStatus(java.lang.String primaryIdentityStatus) {
                this.primaryIdentityStatus = primaryIdentityStatus;
                return this;
            }

            /**
             * Sets the value of {@link ApproverProperty#getResponseTime}
             * @param responseTime Timestamp when the approver responded to an approval team invitation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseTime(java.lang.String responseTime) {
                this.responseTime = responseTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApproverProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApproverProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApproverProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApproverProperty {
            private final java.lang.String primaryIdentityId;
            private final java.lang.String primaryIdentitySourceArn;
            private final java.lang.String approverId;
            private final java.lang.String primaryIdentityStatus;
            private final java.lang.String responseTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primaryIdentityId = software.amazon.jsii.Kernel.get(this, "primaryIdentityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryIdentitySourceArn = software.amazon.jsii.Kernel.get(this, "primaryIdentitySourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.approverId = software.amazon.jsii.Kernel.get(this, "approverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryIdentityStatus = software.amazon.jsii.Kernel.get(this, "primaryIdentityStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseTime = software.amazon.jsii.Kernel.get(this, "responseTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primaryIdentityId = java.util.Objects.requireNonNull(builder.primaryIdentityId, "primaryIdentityId is required");
                this.primaryIdentitySourceArn = java.util.Objects.requireNonNull(builder.primaryIdentitySourceArn, "primaryIdentitySourceArn is required");
                this.approverId = builder.approverId;
                this.primaryIdentityStatus = builder.primaryIdentityStatus;
                this.responseTime = builder.responseTime;
            }

            @Override
            public final java.lang.String getPrimaryIdentityId() {
                return this.primaryIdentityId;
            }

            @Override
            public final java.lang.String getPrimaryIdentitySourceArn() {
                return this.primaryIdentitySourceArn;
            }

            @Override
            public final java.lang.String getApproverId() {
                return this.approverId;
            }

            @Override
            public final java.lang.String getPrimaryIdentityStatus() {
                return this.primaryIdentityStatus;
            }

            @Override
            public final java.lang.String getResponseTime() {
                return this.responseTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("primaryIdentityId", om.valueToTree(this.getPrimaryIdentityId()));
                data.set("primaryIdentitySourceArn", om.valueToTree(this.getPrimaryIdentitySourceArn()));
                if (this.getApproverId() != null) {
                    data.set("approverId", om.valueToTree(this.getApproverId()));
                }
                if (this.getPrimaryIdentityStatus() != null) {
                    data.set("primaryIdentityStatus", om.valueToTree(this.getPrimaryIdentityStatus()));
                }
                if (this.getResponseTime() != null) {
                    data.set("responseTime", om.valueToTree(this.getResponseTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mpa.CfnApprovalTeam.ApproverProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApproverProperty.Jsii$Proxy that = (ApproverProperty.Jsii$Proxy) o;

                if (!primaryIdentityId.equals(that.primaryIdentityId)) return false;
                if (!primaryIdentitySourceArn.equals(that.primaryIdentitySourceArn)) return false;
                if (this.approverId != null ? !this.approverId.equals(that.approverId) : that.approverId != null) return false;
                if (this.primaryIdentityStatus != null ? !this.primaryIdentityStatus.equals(that.primaryIdentityStatus) : that.primaryIdentityStatus != null) return false;
                return this.responseTime != null ? this.responseTime.equals(that.responseTime) : that.responseTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.primaryIdentityId.hashCode();
                result = 31 * result + (this.primaryIdentitySourceArn.hashCode());
                result = 31 * result + (this.approverId != null ? this.approverId.hashCode() : 0);
                result = 31 * result + (this.primaryIdentityStatus != null ? this.primaryIdentityStatus.hashCode() : 0);
                result = 31 * result + (this.responseTime != null ? this.responseTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Strategy for how an approval team grants approval.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mpa.*;
     * MofNApprovalStrategyProperty mofNApprovalStrategyProperty = MofNApprovalStrategyProperty.builder()
     *         .minApprovalsRequired(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-mofnapprovalstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-mofnapprovalstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnApprovalTeam.MofNApprovalStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(MofNApprovalStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MofNApprovalStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Minimum number of approvals (M) required for a total number of approvers (N).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-mofnapprovalstrategy.html#cfn-mpa-approvalteam-mofnapprovalstrategy-minapprovalsrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-mofnapprovalstrategy.html#cfn-mpa-approvalteam-mofnapprovalstrategy-minapprovalsrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinApprovalsRequired();

        /**
         * @return a {@link Builder} of {@link MofNApprovalStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MofNApprovalStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MofNApprovalStrategyProperty> {
            java.lang.Number minApprovalsRequired;

            /**
             * Sets the value of {@link MofNApprovalStrategyProperty#getMinApprovalsRequired}
             * @param minApprovalsRequired Minimum number of approvals (M) required for a total number of approvers (N). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minApprovalsRequired(java.lang.Number minApprovalsRequired) {
                this.minApprovalsRequired = minApprovalsRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MofNApprovalStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MofNApprovalStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MofNApprovalStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MofNApprovalStrategyProperty {
            private final java.lang.Number minApprovalsRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minApprovalsRequired = software.amazon.jsii.Kernel.get(this, "minApprovalsRequired", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minApprovalsRequired = java.util.Objects.requireNonNull(builder.minApprovalsRequired, "minApprovalsRequired is required");
            }

            @Override
            public final java.lang.Number getMinApprovalsRequired() {
                return this.minApprovalsRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minApprovalsRequired", om.valueToTree(this.getMinApprovalsRequired()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mpa.CfnApprovalTeam.MofNApprovalStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MofNApprovalStrategyProperty.Jsii$Proxy that = (MofNApprovalStrategyProperty.Jsii$Proxy) o;

                return this.minApprovalsRequired.equals(that.minApprovalsRequired);
            }

            @Override
            public final int hashCode() {
                int result = this.minApprovalsRequired.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details for a policy.
     * <p>
     * Policies define what operations a team that define the permissions for team resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mpa.*;
     * PolicyProperty policyProperty = PolicyProperty.builder()
     *         .policyArn("policyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-policy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-policy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnApprovalTeam.PolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-policy.html#cfn-mpa-approvalteam-policy-policyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-approvalteam-policy.html#cfn-mpa-approvalteam-policy-policyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyArn();

        /**
         * @return a {@link Builder} of {@link PolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyProperty> {
            java.lang.String policyArn;

            /**
             * Sets the value of {@link PolicyProperty#getPolicyArn}
             * @param policyArn the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyArn(java.lang.String policyArn) {
                this.policyArn = policyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyProperty {
            private final java.lang.String policyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyArn = software.amazon.jsii.Kernel.get(this, "policyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyArn = java.util.Objects.requireNonNull(builder.policyArn, "policyArn is required");
            }

            @Override
            public final java.lang.String getPolicyArn() {
                return this.policyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyArn", om.valueToTree(this.getPolicyArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mpa.CfnApprovalTeam.PolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyProperty.Jsii$Proxy that = (PolicyProperty.Jsii$Proxy) o;

                return this.policyArn.equals(that.policyArn);
            }

            @Override
            public final int hashCode() {
                int result = this.policyArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mpa.CfnApprovalTeam}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mpa.CfnApprovalTeam> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mpa.CfnApprovalTeamProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mpa.CfnApprovalTeamProps.Builder();
        }

        /**
         * Contains details for how an approval team grants approval.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvalstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvalstrategy</a>
         * @param approvalStrategy Contains details for how an approval team grants approval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalStrategy(final software.amazon.awscdk.IResolvable approvalStrategy) {
            this.props.approvalStrategy(approvalStrategy);
            return this;
        }
        /**
         * Contains details for how an approval team grants approval.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvalstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvalstrategy</a>
         * @param approvalStrategy Contains details for how an approval team grants approval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalStrategy(final software.amazon.awscdk.services.mpa.CfnApprovalTeam.ApprovalStrategyProperty approvalStrategy) {
            this.props.approvalStrategy(approvalStrategy);
            return this;
        }

        /**
         * Contains details for an approver.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvers</a>
         * @param approvers Contains details for an approver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvers(final software.amazon.awscdk.IResolvable approvers) {
            this.props.approvers(approvers);
            return this;
        }
        /**
         * Contains details for an approver.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-approvers</a>
         * @param approvers Contains details for an approver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvers(final java.util.List<? extends java.lang.Object> approvers) {
            this.props.approvers(approvers);
            return this;
        }

        /**
         * Description for the team.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-description</a>
         * @param description Description for the team. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Name of the team.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-name</a>
         * @param name Name of the team. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Contains details for a policy.
         * <p>
         * Policies define what operations a team that define the permissions for team resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-policies</a>
         * @param policies Contains details for a policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.IResolvable policies) {
            this.props.policies(policies);
            return this;
        }
        /**
         * Contains details for a policy.
         * <p>
         * Policies define what operations a team that define the permissions for team resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-policies</a>
         * @param policies Contains details for a policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.util.List<? extends java.lang.Object> policies) {
            this.props.policies(policies);
            return this;
        }

        /**
         * Tags that you have added to the specified resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-approvalteam.html#cfn-mpa-approvalteam-tags</a>
         * @param tags Tags that you have added to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mpa.CfnApprovalTeam}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mpa.CfnApprovalTeam build() {
            return new software.amazon.awscdk.services.mpa.CfnApprovalTeam(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
