package software.amazon.awscdk.services.msk;

/**
 * Properties for defining a <code>CfnReplicator</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnReplicatorProps cfnReplicatorProps = CfnReplicatorProps.builder()
 *         .kafkaClusters(List.of(KafkaClusterProperty.builder()
 *                 .amazonMskCluster(AmazonMskClusterProperty.builder()
 *                         .mskClusterArn("mskClusterArn")
 *                         .build())
 *                 .vpcConfig(KafkaClusterClientVpcConfigProperty.builder()
 *                         .subnetIds(List.of("subnetIds"))
 *                         // the properties below are optional
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .build())
 *                 .build()))
 *         .replicationInfoList(List.of(ReplicationInfoProperty.builder()
 *                 .consumerGroupReplication(ConsumerGroupReplicationProperty.builder()
 *                         .consumerGroupsToReplicate(List.of("consumerGroupsToReplicate"))
 *                         // the properties below are optional
 *                         .consumerGroupsToExclude(List.of("consumerGroupsToExclude"))
 *                         .detectAndCopyNewConsumerGroups(false)
 *                         .synchroniseConsumerGroupOffsets(false)
 *                         .build())
 *                 .sourceKafkaClusterArn("sourceKafkaClusterArn")
 *                 .targetCompressionType("targetCompressionType")
 *                 .targetKafkaClusterArn("targetKafkaClusterArn")
 *                 .topicReplication(TopicReplicationProperty.builder()
 *                         .topicsToReplicate(List.of("topicsToReplicate"))
 *                         // the properties below are optional
 *                         .copyAccessControlListsForTopics(false)
 *                         .copyTopicConfigurations(false)
 *                         .detectAndCopyNewTopics(false)
 *                         .startingPosition(ReplicationStartingPositionProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .topicNameConfiguration(ReplicationTopicNameConfigurationProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .topicsToExclude(List.of("topicsToExclude"))
 *                         .build())
 *                 .build()))
 *         .replicatorName("replicatorName")
 *         .serviceExecutionRoleArn("serviceExecutionRoleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:41.478Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicatorProps")
@software.amazon.jsii.Jsii.Proxy(CfnReplicatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReplicatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Kafka Clusters to use in setting up sources / targets for replication.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-kafkaclusters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-kafkaclusters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKafkaClusters();

    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicationinfolist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicationinfolist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getReplicationInfoList();

    /**
     * The name of the replicator.
     * <p>
     * Alpha-numeric characters with '-' are allowed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicatorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicatorname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicatorName();

    /**
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-serviceexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-serviceexecutionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceExecutionRoleArn();

    /**
     * A summary description of the replicator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * List of tags to attach to created Replicator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReplicatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReplicatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReplicatorProps> {
        java.lang.Object kafkaClusters;
        java.lang.Object replicationInfoList;
        java.lang.String replicatorName;
        java.lang.String serviceExecutionRoleArn;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnReplicatorProps#getKafkaClusters}
         * @param kafkaClusters Kafka Clusters to use in setting up sources / targets for replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusters(software.amazon.awscdk.IResolvable kafkaClusters) {
            this.kafkaClusters = kafkaClusters;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getKafkaClusters}
         * @param kafkaClusters Kafka Clusters to use in setting up sources / targets for replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusters(java.util.List<? extends java.lang.Object> kafkaClusters) {
            this.kafkaClusters = kafkaClusters;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getReplicationInfoList}
         * @param replicationInfoList A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationInfoList(software.amazon.awscdk.IResolvable replicationInfoList) {
            this.replicationInfoList = replicationInfoList;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getReplicationInfoList}
         * @param replicationInfoList A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationInfoList(java.util.List<? extends java.lang.Object> replicationInfoList) {
            this.replicationInfoList = replicationInfoList;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getReplicatorName}
         * @param replicatorName The name of the replicator. This parameter is required.
         *                       Alpha-numeric characters with '-' are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicatorName(java.lang.String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getServiceExecutionRoleArn}
         * @param serviceExecutionRoleArn The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceExecutionRoleArn(java.lang.String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getDescription}
         * @param description A summary description of the replicator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicatorProps#getTags}
         * @param tags List of tags to attach to created Replicator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReplicatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReplicatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReplicatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReplicatorProps {
        private final java.lang.Object kafkaClusters;
        private final java.lang.Object replicationInfoList;
        private final java.lang.String replicatorName;
        private final java.lang.String serviceExecutionRoleArn;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.kafkaClusters = software.amazon.jsii.Kernel.get(this, "kafkaClusters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicationInfoList = software.amazon.jsii.Kernel.get(this, "replicationInfoList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicatorName = software.amazon.jsii.Kernel.get(this, "replicatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "serviceExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.kafkaClusters = java.util.Objects.requireNonNull(builder.kafkaClusters, "kafkaClusters is required");
            this.replicationInfoList = java.util.Objects.requireNonNull(builder.replicationInfoList, "replicationInfoList is required");
            this.replicatorName = java.util.Objects.requireNonNull(builder.replicatorName, "replicatorName is required");
            this.serviceExecutionRoleArn = java.util.Objects.requireNonNull(builder.serviceExecutionRoleArn, "serviceExecutionRoleArn is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getKafkaClusters() {
            return this.kafkaClusters;
        }

        @Override
        public final java.lang.Object getReplicationInfoList() {
            return this.replicationInfoList;
        }

        @Override
        public final java.lang.String getReplicatorName() {
            return this.replicatorName;
        }

        @Override
        public final java.lang.String getServiceExecutionRoleArn() {
            return this.serviceExecutionRoleArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("kafkaClusters", om.valueToTree(this.getKafkaClusters()));
            data.set("replicationInfoList", om.valueToTree(this.getReplicationInfoList()));
            data.set("replicatorName", om.valueToTree(this.getReplicatorName()));
            data.set("serviceExecutionRoleArn", om.valueToTree(this.getServiceExecutionRoleArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReplicatorProps.Jsii$Proxy that = (CfnReplicatorProps.Jsii$Proxy) o;

            if (!kafkaClusters.equals(that.kafkaClusters)) return false;
            if (!replicationInfoList.equals(that.replicationInfoList)) return false;
            if (!replicatorName.equals(that.replicatorName)) return false;
            if (!serviceExecutionRoleArn.equals(that.serviceExecutionRoleArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.kafkaClusters.hashCode();
            result = 31 * result + (this.replicationInfoList.hashCode());
            result = 31 * result + (this.replicatorName.hashCode());
            result = 31 * result + (this.serviceExecutionRoleArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
