package software.amazon.awscdk.services.oam;

/**
 * Creates a link between a source account and a sink that you have created in a monitoring account.
 * <p>
 * Before you create a link, you must create a sink in the monitoring account. The sink must have a sink policy that permits the source account to link to it. You can grant permission to source accounts by granting permission to an entire organization, an organizational unit, or to individual accounts.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html">CreateSink</a> and <a href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html">PutSinkPolicy</a> .
 * <p>
 * Each monitoring account can be linked to as many as 100,000 source accounts.
 * <p>
 * Each source account can be linked to as many as five monitoring accounts.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.oam.*;
 * CfnLink cfnLink = CfnLink.Builder.create(this, "MyCfnLink")
 *         .resourceTypes(List.of("resourceTypes"))
 *         .sinkIdentifier("sinkIdentifier")
 *         // the properties below are optional
 *         .labelTemplate("labelTemplate")
 *         .linkConfiguration(LinkConfigurationProperty.builder()
 *                 .logGroupConfiguration(LinkFilterProperty.builder()
 *                         .filter("filter")
 *                         .build())
 *                 .metricConfiguration(LinkFilterProperty.builder()
 *                         .filter("filter")
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:41.959Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_oam.CfnLink")
public class CfnLink extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnLink(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLink(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.oam.CfnLink.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLink(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.oam.CfnLinkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the link.
     * <p>
     * For example, <code>arn:aws:oam:us-west-1:111111111111:link:abcd1234-a123-456a-a12b-a123b456c789</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The friendly human-readable name used to identify this source account when it is viewed from the monitoring account.
     * <p>
     * For example, <code>my-account1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLabel() {
        return software.amazon.jsii.Kernel.get(this, "attrLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An array of strings that define which types of data that the source account shares with the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * An array of strings that define which types of data that the source account shares with the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTypes(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourceTypes", java.util.Objects.requireNonNull(value, "resourceTypes is required"));
    }

    /**
     * The ARN of the sink in the monitoring account that you want to link to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSinkIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sinkIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the sink in the monitoring account that you want to link to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSinkIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sinkIdentifier", java.util.Objects.requireNonNull(value, "sinkIdentifier is required"));
    }

    /**
     * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLabelTemplate() {
        return software.amazon.jsii.Kernel.get(this, "labelTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLabelTemplate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "labelTemplate", value);
    }

    /**
     * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLinkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "linkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLinkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "linkConfiguration", value);
    }

    /**
     * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLinkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.oam.CfnLink.LinkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "linkConfiguration", value);
    }

    /**
     * An array of key-value pairs to apply to the link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to the link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.oam.*;
     * LinkConfigurationProperty linkConfigurationProperty = LinkConfigurationProperty.builder()
     *         .logGroupConfiguration(LinkFilterProperty.builder()
     *                 .filter("filter")
     *                 .build())
     *         .metricConfiguration(LinkFilterProperty.builder()
     *                 .filter("filter")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_oam.CfnLink.LinkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LinkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LinkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use this structure to filter which log groups are to share log events from this source account to the monitoring account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkconfiguration.html#cfn-oam-link-linkconfiguration-loggroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkconfiguration.html#cfn-oam-link-linkconfiguration-loggroupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogGroupConfiguration() {
            return null;
        }

        /**
         * Use this structure to filter which metric namespaces are to be shared from the source account to the monitoring account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkconfiguration.html#cfn-oam-link-linkconfiguration-metricconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkconfiguration.html#cfn-oam-link-linkconfiguration-metricconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LinkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LinkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LinkConfigurationProperty> {
            java.lang.Object logGroupConfiguration;
            java.lang.Object metricConfiguration;

            /**
             * Sets the value of {@link LinkConfigurationProperty#getLogGroupConfiguration}
             * @param logGroupConfiguration Use this structure to filter which log groups are to share log events from this source account to the monitoring account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupConfiguration(software.amazon.awscdk.IResolvable logGroupConfiguration) {
                this.logGroupConfiguration = logGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LinkConfigurationProperty#getLogGroupConfiguration}
             * @param logGroupConfiguration Use this structure to filter which log groups are to share log events from this source account to the monitoring account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupConfiguration(software.amazon.awscdk.services.oam.CfnLink.LinkFilterProperty logGroupConfiguration) {
                this.logGroupConfiguration = logGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LinkConfigurationProperty#getMetricConfiguration}
             * @param metricConfiguration Use this structure to filter which metric namespaces are to be shared from the source account to the monitoring account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricConfiguration(software.amazon.awscdk.IResolvable metricConfiguration) {
                this.metricConfiguration = metricConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LinkConfigurationProperty#getMetricConfiguration}
             * @param metricConfiguration Use this structure to filter which metric namespaces are to be shared from the source account to the monitoring account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricConfiguration(software.amazon.awscdk.services.oam.CfnLink.LinkFilterProperty metricConfiguration) {
                this.metricConfiguration = metricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LinkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LinkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LinkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinkConfigurationProperty {
            private final java.lang.Object logGroupConfiguration;
            private final java.lang.Object metricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupConfiguration = software.amazon.jsii.Kernel.get(this, "logGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricConfiguration = software.amazon.jsii.Kernel.get(this, "metricConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupConfiguration = builder.logGroupConfiguration;
                this.metricConfiguration = builder.metricConfiguration;
            }

            @Override
            public final java.lang.Object getLogGroupConfiguration() {
                return this.logGroupConfiguration;
            }

            @Override
            public final java.lang.Object getMetricConfiguration() {
                return this.metricConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogGroupConfiguration() != null) {
                    data.set("logGroupConfiguration", om.valueToTree(this.getLogGroupConfiguration()));
                }
                if (this.getMetricConfiguration() != null) {
                    data.set("metricConfiguration", om.valueToTree(this.getMetricConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_oam.CfnLink.LinkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LinkConfigurationProperty.Jsii$Proxy that = (LinkConfigurationProperty.Jsii$Proxy) o;

                if (this.logGroupConfiguration != null ? !this.logGroupConfiguration.equals(that.logGroupConfiguration) : that.logGroupConfiguration != null) return false;
                return this.metricConfiguration != null ? this.metricConfiguration.equals(that.metricConfiguration) : that.metricConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupConfiguration != null ? this.logGroupConfiguration.hashCode() : 0;
                result = 31 * result + (this.metricConfiguration != null ? this.metricConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When used in <code>MetricConfiguration</code> this field specifies which metric namespaces are to be shared with the monitoring account.
     * <p>
     * When used in <code>LogGroupConfiguration</code> this field specifies which log groups are to share their log events with the monitoring account. Use the term <code>LogGroupName</code> and one or more of the following operands.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.oam.*;
     * LinkFilterProperty linkFilterProperty = LinkFilterProperty.builder()
     *         .filter("filter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_oam.CfnLink.LinkFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(LinkFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LinkFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When used in <code>MetricConfiguration</code> this field specifies which metric namespaces are to be shared with the monitoring account.
         * <p>
         * When used in <code>LogGroupConfiguration</code> this field specifies which log groups are to share their log events with the monitoring account. Use the term <code>LogGroupName</code> and one or more of the following operands.
         * <p>
         * Use single quotation marks (') around log group names and metric namespaces.
         * <p>
         * The matching of log group names and metric namespaces is case sensitive. Each filter has a limit of five conditional operands. Conditional operands are <code>AND</code> and <code>OR</code> .
         * <p>
         * <ul>
         * <li><code>=</code> and <code>!=</code></li>
         * <li><code>AND</code></li>
         * <li><code>OR</code></li>
         * <li><code>LIKE</code> and <code>NOT LIKE</code> . These can be used only as prefix searches. Include a <code>%</code> at the end of the string that you want to search for and include.</li>
         * <li><code>IN</code> and <code>NOT IN</code> , using parentheses <code>( )</code></li>
         * </ul>
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li><code>Namespace NOT LIKE 'AWS/%'</code> includes only namespaces that don't start with <code>AWS/</code> , such as custom namespaces.</li>
         * <li><code>Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')</code> includes only the metrics in the EC2, Elastic Load Balancing , and Amazon S3 namespaces.</li>
         * <li><code>Namespace = 'AWS/EC2' OR Namespace NOT LIKE 'AWS/%'</code> includes only the EC2 namespace and your custom namespaces.</li>
         * <li><code>LogGroupName IN ('This-Log-Group', 'Other-Log-Group')</code> includes only the log groups with names <code>This-Log-Group</code> and <code>Other-Log-Group</code> .</li>
         * <li><code>LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')</code> includes all log groups except the log groups with names <code>Private-Log-Group</code> and <code>Private-Log-Group-2</code> .</li>
         * <li><code>LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'</code> includes all log groups that have names that start with <code>aws/lambda/</code> or <code>AWSLogs</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you are updating a link that uses filters, you can specify <code>*</code> as the only value for the <code>filter</code> parameter to delete the filter and share all log groups with the monitoring account.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkfilter.html#cfn-oam-link-linkfilter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-oam-link-linkfilter.html#cfn-oam-link-linkfilter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilter();

        /**
         * @return a {@link Builder} of {@link LinkFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LinkFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LinkFilterProperty> {
            java.lang.String filter;

            /**
             * Sets the value of {@link LinkFilterProperty#getFilter}
             * @param filter When used in <code>MetricConfiguration</code> this field specifies which metric namespaces are to be shared with the monitoring account. This parameter is required.
             *               When used in <code>LogGroupConfiguration</code> this field specifies which log groups are to share their log events with the monitoring account. Use the term <code>LogGroupName</code> and one or more of the following operands.
             *               <p>
             *               Use single quotation marks (') around log group names and metric namespaces.
             *               <p>
             *               The matching of log group names and metric namespaces is case sensitive. Each filter has a limit of five conditional operands. Conditional operands are <code>AND</code> and <code>OR</code> .
             *               <p>
             *               <ul>
             *               <li><code>=</code> and <code>!=</code></li>
             *               <li><code>AND</code></li>
             *               <li><code>OR</code></li>
             *               <li><code>LIKE</code> and <code>NOT LIKE</code> . These can be used only as prefix searches. Include a <code>%</code> at the end of the string that you want to search for and include.</li>
             *               <li><code>IN</code> and <code>NOT IN</code> , using parentheses <code>( )</code></li>
             *               </ul>
             *               <p>
             *               Examples:
             *               <p>
             *               <ul>
             *               <li><code>Namespace NOT LIKE 'AWS/%'</code> includes only namespaces that don't start with <code>AWS/</code> , such as custom namespaces.</li>
             *               <li><code>Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')</code> includes only the metrics in the EC2, Elastic Load Balancing , and Amazon S3 namespaces.</li>
             *               <li><code>Namespace = 'AWS/EC2' OR Namespace NOT LIKE 'AWS/%'</code> includes only the EC2 namespace and your custom namespaces.</li>
             *               <li><code>LogGroupName IN ('This-Log-Group', 'Other-Log-Group')</code> includes only the log groups with names <code>This-Log-Group</code> and <code>Other-Log-Group</code> .</li>
             *               <li><code>LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')</code> includes all log groups except the log groups with names <code>Private-Log-Group</code> and <code>Private-Log-Group-2</code> .</li>
             *               <li><code>LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'</code> includes all log groups that have names that start with <code>aws/lambda/</code> or <code>AWSLogs</code> .</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               If you are updating a link that uses filters, you can specify <code>*</code> as the only value for the <code>filter</code> parameter to delete the filter and share all log groups with the monitoring account.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(java.lang.String filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LinkFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LinkFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LinkFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinkFilterProperty {
            private final java.lang.String filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            }

            @Override
            public final java.lang.String getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filter", om.valueToTree(this.getFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_oam.CfnLink.LinkFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LinkFilterProperty.Jsii$Proxy that = (LinkFilterProperty.Jsii$Proxy) o;

                return this.filter.equals(that.filter);
            }

            @Override
            public final int hashCode() {
                int result = this.filter.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.oam.CfnLink}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.oam.CfnLink> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.oam.CfnLinkProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.oam.CfnLinkProps.Builder();
        }

        /**
         * An array of strings that define which types of data that the source account shares with the monitoring account.
         * <p>
         * Valid values are <code>AWS::CloudWatch::Metric | AWS::Logs::LogGroup | AWS::XRay::Trace | AWS::ApplicationInsights::Application | AWS::InternetMonitor::Monitor</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-resourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-resourcetypes</a>
         * @param resourceTypes An array of strings that define which types of data that the source account shares with the monitoring account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTypes(final java.util.List<java.lang.String> resourceTypes) {
            this.props.resourceTypes(resourceTypes);
            return this;
        }

        /**
         * The ARN of the sink in the monitoring account that you want to link to.
         * <p>
         * You can use <a href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find the ARNs of sinks.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-sinkidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-sinkidentifier</a>
         * @param sinkIdentifier The ARN of the sink in the monitoring account that you want to link to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sinkIdentifier(final java.lang.String sinkIdentifier) {
            this.props.sinkIdentifier(sinkIdentifier);
            return this;
        }

        /**
         * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
         * <p>
         * You can include the following variables in your template:
         * <p>
         * <ul>
         * <li><code>$AccountName</code> is the name of the account</li>
         * <li><code>$AccountEmail</code> is a globally-unique email address, which includes the email domain, such as <code>mariagarcia&#64;example.com</code></li>
         * <li><code>$AccountEmailNoDomain</code> is an email address without the domain name, such as <code>mariagarcia</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * In the  and  Regions, the only supported option is to use custom labels, and the <code>$AccountName</code> , <code>$AccountEmail</code> , and <code>$AccountEmailNoDomain</code> variables all resolve as <em>account-id</em> instead of the specified variable.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-labeltemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-labeltemplate</a>
         * @param labelTemplate Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labelTemplate(final java.lang.String labelTemplate) {
            this.props.labelTemplate(labelTemplate);
            return this;
        }

        /**
         * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-linkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-linkconfiguration</a>
         * @param linkConfiguration Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkConfiguration(final software.amazon.awscdk.IResolvable linkConfiguration) {
            this.props.linkConfiguration(linkConfiguration);
            return this;
        }
        /**
         * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-linkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-linkconfiguration</a>
         * @param linkConfiguration Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkConfiguration(final software.amazon.awscdk.services.oam.CfnLink.LinkConfigurationProperty linkConfiguration) {
            this.props.linkConfiguration(linkConfiguration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to the link.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-tags</a>
         * @param tags An array of key-value pairs to apply to the link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.oam.CfnLink}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.oam.CfnLink build() {
            return new software.amazon.awscdk.services.oam.CfnLink(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
