package software.amazon.awscdk.services.pcaconnectorad;

/**
 * Properties for defining a <code>CfnTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcaconnectorad.*;
 * CfnTemplateProps cfnTemplateProps = CfnTemplateProps.builder()
 *         .connectorArn("connectorArn")
 *         .definition(TemplateDefinitionProperty.builder()
 *                 .templateV2(TemplateV2Property.builder()
 *                         .certificateValidity(CertificateValidityProperty.builder()
 *                                 .renewalPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .validityPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .build())
 *                         .enrollmentFlags(EnrollmentFlagsV2Property.builder()
 *                                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
 *                                 .includeSymmetricAlgorithms(false)
 *                                 .noSecurityExtension(false)
 *                                 .removeInvalidCertificateFromPersonalStore(false)
 *                                 .userInteractionRequired(false)
 *                                 .build())
 *                         .extensions(ExtensionsV2Property.builder()
 *                                 .keyUsage(KeyUsageProperty.builder()
 *                                         .usageFlags(KeyUsageFlagsProperty.builder()
 *                                                 .dataEncipherment(false)
 *                                                 .digitalSignature(false)
 *                                                 .keyAgreement(false)
 *                                                 .keyEncipherment(false)
 *                                                 .nonRepudiation(false)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .applicationPolicies(ApplicationPoliciesProperty.builder()
 *                                         .policies(List.of(ApplicationPolicyProperty.builder()
 *                                                 .policyObjectIdentifier("policyObjectIdentifier")
 *                                                 .policyType("policyType")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 .build())
 *                         .generalFlags(GeneralFlagsV2Property.builder()
 *                                 .autoEnrollment(false)
 *                                 .machineType(false)
 *                                 .build())
 *                         .privateKeyAttributes(PrivateKeyAttributesV2Property.builder()
 *                                 .keySpec("keySpec")
 *                                 .minimalKeyLength(123)
 *                                 // the properties below are optional
 *                                 .cryptoProviders(List.of("cryptoProviders"))
 *                                 .build())
 *                         .privateKeyFlags(PrivateKeyFlagsV2Property.builder()
 *                                 .clientVersion("clientVersion")
 *                                 // the properties below are optional
 *                                 .exportableKey(false)
 *                                 .strongKeyProtectionRequired(false)
 *                                 .build())
 *                         .subjectNameFlags(SubjectNameFlagsV2Property.builder()
 *                                 .requireCommonName(false)
 *                                 .requireDirectoryPath(false)
 *                                 .requireDnsAsCn(false)
 *                                 .requireEmail(false)
 *                                 .sanRequireDirectoryGuid(false)
 *                                 .sanRequireDns(false)
 *                                 .sanRequireDomainDns(false)
 *                                 .sanRequireEmail(false)
 *                                 .sanRequireSpn(false)
 *                                 .sanRequireUpn(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .supersededTemplates(List.of("supersededTemplates"))
 *                         .build())
 *                 .templateV3(TemplateV3Property.builder()
 *                         .certificateValidity(CertificateValidityProperty.builder()
 *                                 .renewalPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .validityPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .build())
 *                         .enrollmentFlags(EnrollmentFlagsV3Property.builder()
 *                                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
 *                                 .includeSymmetricAlgorithms(false)
 *                                 .noSecurityExtension(false)
 *                                 .removeInvalidCertificateFromPersonalStore(false)
 *                                 .userInteractionRequired(false)
 *                                 .build())
 *                         .extensions(ExtensionsV3Property.builder()
 *                                 .keyUsage(KeyUsageProperty.builder()
 *                                         .usageFlags(KeyUsageFlagsProperty.builder()
 *                                                 .dataEncipherment(false)
 *                                                 .digitalSignature(false)
 *                                                 .keyAgreement(false)
 *                                                 .keyEncipherment(false)
 *                                                 .nonRepudiation(false)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .applicationPolicies(ApplicationPoliciesProperty.builder()
 *                                         .policies(List.of(ApplicationPolicyProperty.builder()
 *                                                 .policyObjectIdentifier("policyObjectIdentifier")
 *                                                 .policyType("policyType")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 .build())
 *                         .generalFlags(GeneralFlagsV3Property.builder()
 *                                 .autoEnrollment(false)
 *                                 .machineType(false)
 *                                 .build())
 *                         .hashAlgorithm("hashAlgorithm")
 *                         .privateKeyAttributes(PrivateKeyAttributesV3Property.builder()
 *                                 .algorithm("algorithm")
 *                                 .keySpec("keySpec")
 *                                 .keyUsageProperty(KeyUsagePropertyProperty.builder()
 *                                         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
 *                                                 .decrypt(false)
 *                                                 .keyAgreement(false)
 *                                                 .sign(false)
 *                                                 .build())
 *                                         .propertyType("propertyType")
 *                                         .build())
 *                                 .minimalKeyLength(123)
 *                                 // the properties below are optional
 *                                 .cryptoProviders(List.of("cryptoProviders"))
 *                                 .build())
 *                         .privateKeyFlags(PrivateKeyFlagsV3Property.builder()
 *                                 .clientVersion("clientVersion")
 *                                 // the properties below are optional
 *                                 .exportableKey(false)
 *                                 .requireAlternateSignatureAlgorithm(false)
 *                                 .strongKeyProtectionRequired(false)
 *                                 .build())
 *                         .subjectNameFlags(SubjectNameFlagsV3Property.builder()
 *                                 .requireCommonName(false)
 *                                 .requireDirectoryPath(false)
 *                                 .requireDnsAsCn(false)
 *                                 .requireEmail(false)
 *                                 .sanRequireDirectoryGuid(false)
 *                                 .sanRequireDns(false)
 *                                 .sanRequireDomainDns(false)
 *                                 .sanRequireEmail(false)
 *                                 .sanRequireSpn(false)
 *                                 .sanRequireUpn(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .supersededTemplates(List.of("supersededTemplates"))
 *                         .build())
 *                 .templateV4(TemplateV4Property.builder()
 *                         .certificateValidity(CertificateValidityProperty.builder()
 *                                 .renewalPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .validityPeriod(ValidityPeriodProperty.builder()
 *                                         .period(123)
 *                                         .periodType("periodType")
 *                                         .build())
 *                                 .build())
 *                         .enrollmentFlags(EnrollmentFlagsV4Property.builder()
 *                                 .enableKeyReuseOnNtTokenKeysetStorageFull(false)
 *                                 .includeSymmetricAlgorithms(false)
 *                                 .noSecurityExtension(false)
 *                                 .removeInvalidCertificateFromPersonalStore(false)
 *                                 .userInteractionRequired(false)
 *                                 .build())
 *                         .extensions(ExtensionsV4Property.builder()
 *                                 .keyUsage(KeyUsageProperty.builder()
 *                                         .usageFlags(KeyUsageFlagsProperty.builder()
 *                                                 .dataEncipherment(false)
 *                                                 .digitalSignature(false)
 *                                                 .keyAgreement(false)
 *                                                 .keyEncipherment(false)
 *                                                 .nonRepudiation(false)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .applicationPolicies(ApplicationPoliciesProperty.builder()
 *                                         .policies(List.of(ApplicationPolicyProperty.builder()
 *                                                 .policyObjectIdentifier("policyObjectIdentifier")
 *                                                 .policyType("policyType")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .critical(false)
 *                                         .build())
 *                                 .build())
 *                         .generalFlags(GeneralFlagsV4Property.builder()
 *                                 .autoEnrollment(false)
 *                                 .machineType(false)
 *                                 .build())
 *                         .privateKeyAttributes(PrivateKeyAttributesV4Property.builder()
 *                                 .keySpec("keySpec")
 *                                 .minimalKeyLength(123)
 *                                 // the properties below are optional
 *                                 .algorithm("algorithm")
 *                                 .cryptoProviders(List.of("cryptoProviders"))
 *                                 .keyUsageProperty(KeyUsagePropertyProperty.builder()
 *                                         .propertyFlags(KeyUsagePropertyFlagsProperty.builder()
 *                                                 .decrypt(false)
 *                                                 .keyAgreement(false)
 *                                                 .sign(false)
 *                                                 .build())
 *                                         .propertyType("propertyType")
 *                                         .build())
 *                                 .build())
 *                         .privateKeyFlags(PrivateKeyFlagsV4Property.builder()
 *                                 .clientVersion("clientVersion")
 *                                 // the properties below are optional
 *                                 .exportableKey(false)
 *                                 .requireAlternateSignatureAlgorithm(false)
 *                                 .requireSameKeyRenewal(false)
 *                                 .strongKeyProtectionRequired(false)
 *                                 .useLegacyProvider(false)
 *                                 .build())
 *                         .subjectNameFlags(SubjectNameFlagsV4Property.builder()
 *                                 .requireCommonName(false)
 *                                 .requireDirectoryPath(false)
 *                                 .requireDnsAsCn(false)
 *                                 .requireEmail(false)
 *                                 .sanRequireDirectoryGuid(false)
 *                                 .sanRequireDns(false)
 *                                 .sanRequireDomainDns(false)
 *                                 .sanRequireEmail(false)
 *                                 .sanRequireSpn(false)
 *                                 .sanRequireUpn(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .hashAlgorithm("hashAlgorithm")
 *                         .supersededTemplates(List.of("supersededTemplates"))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .reenrollAllCertificateHolders(false)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:42.241Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-connectorarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-connectorarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorArn();

    /**
     * Template configuration to define the information included in certificates.
     * <p>
     * Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-definition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefinition();

    /**
     * Name of the templates.
     * <p>
     * Template names must be unique.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * This setting allows the major version of a template to be increased automatically.
     * <p>
     * All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-reenrollallcertificateholders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-reenrollallcertificateholders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReenrollAllCertificateHolders() {
        return null;
    }

    /**
     * Metadata assigned to a template consisting of a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-template.html#cfn-pcaconnectorad-template-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTemplateProps> {
        java.lang.String connectorArn;
        java.lang.Object definition;
        java.lang.String name;
        java.lang.Object reenrollAllCertificateHolders;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnTemplateProps#getConnectorArn}
         * @param connectorArn The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorArn(java.lang.String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateProps#getDefinition}
         * @param definition Template configuration to define the information included in certificates. This parameter is required.
         *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.IResolvable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateProps#getDefinition}
         * @param definition Template configuration to define the information included in certificates. This parameter is required.
         *                   Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.pcaconnectorad.CfnTemplate.TemplateDefinitionProperty definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateProps#getName}
         * @param name Name of the templates. This parameter is required.
         *             Template names must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateProps#getReenrollAllCertificateHolders}
         * @param reenrollAllCertificateHolders This setting allows the major version of a template to be increased automatically.
         *                                      All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reenrollAllCertificateHolders(java.lang.Boolean reenrollAllCertificateHolders) {
            this.reenrollAllCertificateHolders = reenrollAllCertificateHolders;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateProps#getReenrollAllCertificateHolders}
         * @param reenrollAllCertificateHolders This setting allows the major version of a template to be increased automatically.
         *                                      All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reenrollAllCertificateHolders(software.amazon.awscdk.IResolvable reenrollAllCertificateHolders) {
            this.reenrollAllCertificateHolders = reenrollAllCertificateHolders;
            return this;
        }

        /**
         * Sets the value of {@link CfnTemplateProps#getTags}
         * @param tags Metadata assigned to a template consisting of a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTemplateProps {
        private final java.lang.String connectorArn;
        private final java.lang.Object definition;
        private final java.lang.String name;
        private final java.lang.Object reenrollAllCertificateHolders;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectorArn = software.amazon.jsii.Kernel.get(this, "connectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reenrollAllCertificateHolders = software.amazon.jsii.Kernel.get(this, "reenrollAllCertificateHolders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectorArn = java.util.Objects.requireNonNull(builder.connectorArn, "connectorArn is required");
            this.definition = java.util.Objects.requireNonNull(builder.definition, "definition is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.reenrollAllCertificateHolders = builder.reenrollAllCertificateHolders;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getConnectorArn() {
            return this.connectorArn;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getReenrollAllCertificateHolders() {
            return this.reenrollAllCertificateHolders;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectorArn", om.valueToTree(this.getConnectorArn()));
            data.set("definition", om.valueToTree(this.getDefinition()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getReenrollAllCertificateHolders() != null) {
                data.set("reenrollAllCertificateHolders", om.valueToTree(this.getReenrollAllCertificateHolders()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTemplateProps.Jsii$Proxy that = (CfnTemplateProps.Jsii$Proxy) o;

            if (!connectorArn.equals(that.connectorArn)) return false;
            if (!definition.equals(that.definition)) return false;
            if (!name.equals(that.name)) return false;
            if (this.reenrollAllCertificateHolders != null ? !this.reenrollAllCertificateHolders.equals(that.reenrollAllCertificateHolders) : that.reenrollAllCertificateHolders != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectorArn.hashCode();
            result = 31 * result + (this.definition.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.reenrollAllCertificateHolders != null ? this.reenrollAllCertificateHolders.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
