package software.amazon.awscdk.services.qbusiness;

/**
 * Creates a data source connector for an Amazon Q Business application.
 * <p>
 * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * Object configuration;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .applicationId("applicationId")
 *         .configuration(configuration)
 *         .displayName("displayName")
 *         .indexId("indexId")
 *         // the properties below are optional
 *         .description("description")
 *         .documentEnrichmentConfiguration(DocumentEnrichmentConfigurationProperty.builder()
 *                 .inlineConfigurations(List.of(InlineDocumentEnrichmentConfigurationProperty.builder()
 *                         .condition(DocumentAttributeConditionProperty.builder()
 *                                 .key("key")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .documentContentOperator("documentContentOperator")
 *                         .target(DocumentAttributeTargetProperty.builder()
 *                                 .key("key")
 *                                 // the properties below are optional
 *                                 .attributeValueOperator("attributeValueOperator")
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .postExtractionHookConfiguration(HookConfigurationProperty.builder()
 *                         .invocationCondition(DocumentAttributeConditionProperty.builder()
 *                                 .key("key")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .lambdaArn("lambdaArn")
 *                         .roleArn("roleArn")
 *                         .s3BucketName("s3BucketName")
 *                         .build())
 *                 .preExtractionHookConfiguration(HookConfigurationProperty.builder()
 *                         .invocationCondition(DocumentAttributeConditionProperty.builder()
 *                                 .key("key")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .lambdaArn("lambdaArn")
 *                         .roleArn("roleArn")
 *                         .s3BucketName("s3BucketName")
 *                         .build())
 *                 .build())
 *         .mediaExtractionConfiguration(MediaExtractionConfigurationProperty.builder()
 *                 .audioExtractionConfiguration(AudioExtractionConfigurationProperty.builder()
 *                         .audioExtractionStatus("audioExtractionStatus")
 *                         .build())
 *                 .imageExtractionConfiguration(ImageExtractionConfigurationProperty.builder()
 *                         .imageExtractionStatus("imageExtractionStatus")
 *                         .build())
 *                 .videoExtractionConfiguration(VideoExtractionConfigurationProperty.builder()
 *                         .videoExtractionStatus("videoExtractionStatus")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         .syncSchedule("syncSchedule")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:42.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.qbusiness.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.qbusiness.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Unix timestamp when the Amazon Q Business data source was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a data source in an Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Q Business data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the Amazon Q Business data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the Amazon Q Business data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrType() {
        return software.amazon.jsii.Kernel.get(this, "attrType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Unix timestamp when the Amazon Q Business data source was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identifier of the Amazon Q Business application the data source will be attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Q Business application the data source will be attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     * Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The name of the Amazon Q Business data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Amazon Q Business data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * The identifier of the index the data source is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIndexId() {
        return software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the index the data source is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIndexId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "indexId", java.util.Objects.requireNonNull(value, "indexId is required"));
    }

    /**
     * A description for the data source connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the data source connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDocumentEnrichmentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "documentEnrichmentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentEnrichmentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "documentEnrichmentConfiguration", value);
    }

    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentEnrichmentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentEnrichmentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "documentEnrichmentConfiguration", value);
    }

    /**
     * The configuration for extracting information from media in documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMediaExtractionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "mediaExtractionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for extracting information from media in documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaExtractionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mediaExtractionConfiguration", value);
    }

    /**
     * The configuration for extracting information from media in documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaExtractionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnDataSource.MediaExtractionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "mediaExtractionConfiguration", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSyncSchedule() {
        return software.amazon.jsii.Kernel.get(this, "syncSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "syncSchedule", value);
    }

    /**
     * A list of key-value pairs that identify or categorize the data source connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that identify or categorize the data source connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfiguration", value);
    }

    /**
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnDataSource.DataSourceVpcConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfiguration", value);
    }
    /**
     * Configuration settings for audio content extraction and processing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * AudioExtractionConfigurationProperty audioExtractionConfigurationProperty = AudioExtractionConfigurationProperty.builder()
     *         .audioExtractionStatus("audioExtractionStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-audioextractionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-audioextractionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.AudioExtractionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioExtractionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioExtractionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-audioextractionconfiguration.html#cfn-qbusiness-datasource-audioextractionconfiguration-audioextractionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-audioextractionconfiguration.html#cfn-qbusiness-datasource-audioextractionconfiguration-audioextractionstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAudioExtractionStatus();

        /**
         * @return a {@link Builder} of {@link AudioExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioExtractionConfigurationProperty> {
            java.lang.String audioExtractionStatus;

            /**
             * Sets the value of {@link AudioExtractionConfigurationProperty#getAudioExtractionStatus}
             * @param audioExtractionStatus The status of audio extraction (ENABLED or DISABLED) for processing audio content from files. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioExtractionStatus(java.lang.String audioExtractionStatus) {
                this.audioExtractionStatus = audioExtractionStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioExtractionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioExtractionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioExtractionConfigurationProperty {
            private final java.lang.String audioExtractionStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioExtractionStatus = software.amazon.jsii.Kernel.get(this, "audioExtractionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioExtractionStatus = java.util.Objects.requireNonNull(builder.audioExtractionStatus, "audioExtractionStatus is required");
            }

            @Override
            public final java.lang.String getAudioExtractionStatus() {
                return this.audioExtractionStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("audioExtractionStatus", om.valueToTree(this.getAudioExtractionStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.AudioExtractionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioExtractionConfigurationProperty.Jsii$Proxy that = (AudioExtractionConfigurationProperty.Jsii$Proxy) o;

                return this.audioExtractionStatus.equals(that.audioExtractionStatus);
            }

            @Override
            public final int hashCode() {
                int result = this.audioExtractionStatus.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides configuration information needed to connect to an Amazon VPC (Virtual Private Cloud).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DataSourceVpcConfigurationProperty dataSourceVpcConfigurationProperty = DataSourceVpcConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-datasourcevpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-datasourcevpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.DataSourceVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of identifiers of security groups within your Amazon VPC.
         * <p>
         * The security groups should enable Amazon Q Business to connect to the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-datasourcevpcconfiguration.html#cfn-qbusiness-datasource-datasourcevpcconfiguration-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-datasourcevpcconfiguration.html#cfn-qbusiness-datasource-datasourcevpcconfiguration-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * A list of identifiers for subnets within your Amazon VPC.
         * <p>
         * The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-datasourcevpcconfiguration.html#cfn-qbusiness-datasource-datasourcevpcconfiguration-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-datasourcevpcconfiguration.html#cfn-qbusiness-datasource-datasourcevpcconfiguration-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link DataSourceVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceVpcConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link DataSourceVpcConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of identifiers of security groups within your Amazon VPC. This parameter is required.
             *                         The security groups should enable Amazon Q Business to connect to the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceVpcConfigurationProperty#getSubnetIds}
             * @param subnetIds A list of identifiers for subnets within your Amazon VPC. This parameter is required.
             *                  The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceVpcConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.DataSourceVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceVpcConfigurationProperty.Jsii$Proxy that = (DataSourceVpcConfigurationProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }
    /**
     * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business.
     * <p>
     * You use this with <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html"><code>DocumentAttributeTarget</code></a> to apply the condition.
     * <p>
     * For example, you can create the 'Department' target field and have it prefill department names associated with the documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the document.
     * <p>
     * Amazon Q Business can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code> . Amazon Q Business then will map your newly created metadata field to your index field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DocumentAttributeConditionProperty documentAttributeConditionProperty = DocumentAttributeConditionProperty.builder()
     *         .key("key")
     *         .operator("operator")
     *         // the properties below are optional
     *         .value(DocumentAttributeValueProperty.builder()
     *                 .dateValue("dateValue")
     *                 .longValue(123)
     *                 .stringListValue(List.of("stringListValue"))
     *                 .stringValue("stringValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentAttributeConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the document attribute used for the condition.
         * <p>
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
         * <p>
         * Amazon Q Business currently doesn't support <code>_document_body</code> as an attribute key used for the condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html#cfn-qbusiness-datasource-documentattributecondition-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html#cfn-qbusiness-datasource-documentattributecondition-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The identifier of the document attribute used for the condition.
         * <p>
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
         * <p>
         * Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html#cfn-qbusiness-datasource-documentattributecondition-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html#cfn-qbusiness-datasource-documentattributecondition-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The value of a document attribute.
         * <p>
         * You can only provide one value for a document attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html#cfn-qbusiness-datasource-documentattributecondition-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributecondition.html#cfn-qbusiness-datasource-documentattributecondition-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeConditionProperty> {
            java.lang.String key;
            java.lang.String operator;
            java.lang.Object value;

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getKey}
             * @param key The identifier of the document attribute used for the condition. This parameter is required.
             *            For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
             *            <p>
             *            Amazon Q Business currently doesn't support <code>_document_body</code> as an attribute key used for the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getOperator}
             * @param operator The identifier of the document attribute used for the condition. This parameter is required.
             *                 For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
             *                 <p>
             *                 Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getValue}
             * @param value The value of a document attribute.
             *              You can only provide one value for a document attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getValue}
             * @param value The value of a document attribute.
             *              You can only provide one value for a document attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentAttributeValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeConditionProperty {
            private final java.lang.String key;
            private final java.lang.String operator;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("operator", om.valueToTree(this.getOperator()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentAttributeConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeConditionProperty.Jsii$Proxy that = (DocumentAttributeConditionProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Q Business.
     * <p>
     * For example, you can delete all customer identification numbers associated with the documents, stored in the document metadata field called 'Customer_ID' by setting the target key as 'Customer_ID' and the deletion flag to <code>TRUE</code> . This removes all customer ID values in the field 'Customer_ID'. This would scrub personally identifiable information from each document's metadata.
     * <p>
     * Amazon Q Business can't create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html"><code>DocumentAttributeTarget</code></a> . Amazon Q Business will then map your newly created document attribute to your index field.
     * <p>
     * You can also use this with <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html"><code>DocumentAttributeCondition</code></a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DocumentAttributeTargetProperty documentAttributeTargetProperty = DocumentAttributeTargetProperty.builder()
     *         .key("key")
     *         // the properties below are optional
     *         .attributeValueOperator("attributeValueOperator")
     *         .value(DocumentAttributeValueProperty.builder()
     *                 .dateValue("dateValue")
     *                 .longValue(123)
     *                 .stringListValue(List.of("stringListValue"))
     *                 .stringValue("stringValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentAttributeTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the target document attribute or metadata field.
         * <p>
         * For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html#cfn-qbusiness-datasource-documentattributetarget-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html#cfn-qbusiness-datasource-documentattributetarget-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * <code>TRUE</code> to delete the existing target value for your specified target attribute key.
         * <p>
         * You cannot create a target value and set this to <code>TRUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html#cfn-qbusiness-datasource-documentattributetarget-attributevalueoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html#cfn-qbusiness-datasource-documentattributetarget-attributevalueoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeValueOperator() {
            return null;
        }

        /**
         * The value of a document attribute.
         * <p>
         * You can only provide one value for a document attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html#cfn-qbusiness-datasource-documentattributetarget-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributetarget.html#cfn-qbusiness-datasource-documentattributetarget-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeTargetProperty> {
            java.lang.String key;
            java.lang.String attributeValueOperator;
            java.lang.Object value;

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getKey}
             * @param key The identifier of the target document attribute or metadata field. This parameter is required.
             *            For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getAttributeValueOperator}
             * @param attributeValueOperator <code>TRUE</code> to delete the existing target value for your specified target attribute key.
             *                               You cannot create a target value and set this to <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeValueOperator(java.lang.String attributeValueOperator) {
                this.attributeValueOperator = attributeValueOperator;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getValue}
             * @param value The value of a document attribute.
             *              You can only provide one value for a document attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getValue}
             * @param value The value of a document attribute.
             *              You can only provide one value for a document attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentAttributeValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeTargetProperty {
            private final java.lang.String key;
            private final java.lang.String attributeValueOperator;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeValueOperator = software.amazon.jsii.Kernel.get(this, "attributeValueOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.attributeValueOperator = builder.attributeValueOperator;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getAttributeValueOperator() {
                return this.attributeValueOperator;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getAttributeValueOperator() != null) {
                    data.set("attributeValueOperator", om.valueToTree(this.getAttributeValueOperator()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentAttributeTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeTargetProperty.Jsii$Proxy that = (DocumentAttributeTargetProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (this.attributeValueOperator != null ? !this.attributeValueOperator.equals(that.attributeValueOperator) : that.attributeValueOperator != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.attributeValueOperator != null ? this.attributeValueOperator.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The value of a document attribute.
     * <p>
     * You can only provide one value for a document attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DocumentAttributeValueProperty documentAttributeValueProperty = DocumentAttributeValueProperty.builder()
     *         .dateValue("dateValue")
     *         .longValue(123)
     *         .stringListValue(List.of("stringListValue"))
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentAttributeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date expressed as an ISO 8601 string.
         * <p>
         * It's important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-datevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-datevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateValue() {
            return null;
        }

        /**
         * A long integer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-longvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-longvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLongValue() {
            return null;
        }

        /**
         * A list of strings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-stringlistvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-stringlistvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringListValue() {
            return null;
        }

        /**
         * A string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentattributevalue.html#cfn-qbusiness-datasource-documentattributevalue-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeValueProperty> {
            java.lang.String dateValue;
            java.lang.Number longValue;
            java.util.List<java.lang.String> stringListValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getDateValue}
             * @param dateValue A date expressed as an ISO 8601 string.
             *                  It's important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateValue(java.lang.String dateValue) {
                this.dateValue = dateValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getLongValue}
             * @param longValue A long integer value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longValue(java.lang.Number longValue) {
                this.longValue = longValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getStringListValue}
             * @param stringListValue A list of strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringListValue(java.util.List<java.lang.String> stringListValue) {
                this.stringListValue = stringListValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getStringValue}
             * @param stringValue A string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeValueProperty {
            private final java.lang.String dateValue;
            private final java.lang.Number longValue;
            private final java.util.List<java.lang.String> stringListValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateValue = software.amazon.jsii.Kernel.get(this, "dateValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.longValue = software.amazon.jsii.Kernel.get(this, "longValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stringListValue = software.amazon.jsii.Kernel.get(this, "stringListValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateValue = builder.dateValue;
                this.longValue = builder.longValue;
                this.stringListValue = builder.stringListValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getDateValue() {
                return this.dateValue;
            }

            @Override
            public final java.lang.Number getLongValue() {
                return this.longValue;
            }

            @Override
            public final java.util.List<java.lang.String> getStringListValue() {
                return this.stringListValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateValue() != null) {
                    data.set("dateValue", om.valueToTree(this.getDateValue()));
                }
                if (this.getLongValue() != null) {
                    data.set("longValue", om.valueToTree(this.getLongValue()));
                }
                if (this.getStringListValue() != null) {
                    data.set("stringListValue", om.valueToTree(this.getStringListValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentAttributeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeValueProperty.Jsii$Proxy that = (DocumentAttributeValueProperty.Jsii$Proxy) o;

                if (this.dateValue != null ? !this.dateValue.equals(that.dateValue) : that.dateValue != null) return false;
                if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) return false;
                if (this.stringListValue != null ? !this.stringListValue.equals(that.stringListValue) : that.stringListValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateValue != null ? this.dateValue.hashCode() : 0;
                result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
                result = 31 * result + (this.stringListValue != null ? this.stringListValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DocumentEnrichmentConfigurationProperty documentEnrichmentConfigurationProperty = DocumentEnrichmentConfigurationProperty.builder()
     *         .inlineConfigurations(List.of(InlineDocumentEnrichmentConfigurationProperty.builder()
     *                 .condition(DocumentAttributeConditionProperty.builder()
     *                         .key("key")
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .documentContentOperator("documentContentOperator")
     *                 .target(DocumentAttributeTargetProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .attributeValueOperator("attributeValueOperator")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .postExtractionHookConfiguration(HookConfigurationProperty.builder()
     *                 .invocationCondition(DocumentAttributeConditionProperty.builder()
     *                         .key("key")
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .lambdaArn("lambdaArn")
     *                 .roleArn("roleArn")
     *                 .s3BucketName("s3BucketName")
     *                 .build())
     *         .preExtractionHookConfiguration(HookConfigurationProperty.builder()
     *                 .invocationCondition(DocumentAttributeConditionProperty.builder()
     *                         .key("key")
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .lambdaArn("lambdaArn")
     *                 .roleArn("roleArn")
     *                 .s3BucketName("s3BucketName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentEnrichmentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentEnrichmentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q Business.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html#cfn-qbusiness-datasource-documentenrichmentconfiguration-inlineconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html#cfn-qbusiness-datasource-documentenrichmentconfiguration-inlineconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInlineConfigurations() {
            return null;
        }

        /**
         * Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted.
         * <p>
         * You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html">Using Lambda functions</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html#cfn-qbusiness-datasource-documentenrichmentconfiguration-postextractionhookconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html#cfn-qbusiness-datasource-documentenrichmentconfiguration-postextractionhookconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostExtractionHookConfiguration() {
            return null;
        }

        /**
         * Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text.
         * <p>
         * You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html">Using Lambda functions</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html#cfn-qbusiness-datasource-documentenrichmentconfiguration-preextractionhookconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-documentenrichmentconfiguration.html#cfn-qbusiness-datasource-documentenrichmentconfiguration-preextractionhookconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreExtractionHookConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentEnrichmentConfigurationProperty> {
            java.lang.Object inlineConfigurations;
            java.lang.Object postExtractionHookConfiguration;
            java.lang.Object preExtractionHookConfiguration;

            /**
             * Sets the value of {@link DocumentEnrichmentConfigurationProperty#getInlineConfigurations}
             * @param inlineConfigurations Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q Business.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineConfigurations(software.amazon.awscdk.IResolvable inlineConfigurations) {
                this.inlineConfigurations = inlineConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DocumentEnrichmentConfigurationProperty#getInlineConfigurations}
             * @param inlineConfigurations Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q Business.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineConfigurations(java.util.List<? extends java.lang.Object> inlineConfigurations) {
                this.inlineConfigurations = inlineConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DocumentEnrichmentConfigurationProperty#getPostExtractionHookConfiguration}
             * @param postExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted.
             *                                        You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html">Using Lambda functions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postExtractionHookConfiguration(software.amazon.awscdk.IResolvable postExtractionHookConfiguration) {
                this.postExtractionHookConfiguration = postExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DocumentEnrichmentConfigurationProperty#getPostExtractionHookConfiguration}
             * @param postExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted.
             *                                        You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html">Using Lambda functions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postExtractionHookConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.HookConfigurationProperty postExtractionHookConfiguration) {
                this.postExtractionHookConfiguration = postExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DocumentEnrichmentConfigurationProperty#getPreExtractionHookConfiguration}
             * @param preExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text.
             *                                       You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html">Using Lambda functions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preExtractionHookConfiguration(software.amazon.awscdk.IResolvable preExtractionHookConfiguration) {
                this.preExtractionHookConfiguration = preExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DocumentEnrichmentConfigurationProperty#getPreExtractionHookConfiguration}
             * @param preExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text.
             *                                       You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html">Using Lambda functions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preExtractionHookConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.HookConfigurationProperty preExtractionHookConfiguration) {
                this.preExtractionHookConfiguration = preExtractionHookConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentEnrichmentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentEnrichmentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentEnrichmentConfigurationProperty {
            private final java.lang.Object inlineConfigurations;
            private final java.lang.Object postExtractionHookConfiguration;
            private final java.lang.Object preExtractionHookConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inlineConfigurations = software.amazon.jsii.Kernel.get(this, "inlineConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postExtractionHookConfiguration = software.amazon.jsii.Kernel.get(this, "postExtractionHookConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preExtractionHookConfiguration = software.amazon.jsii.Kernel.get(this, "preExtractionHookConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inlineConfigurations = builder.inlineConfigurations;
                this.postExtractionHookConfiguration = builder.postExtractionHookConfiguration;
                this.preExtractionHookConfiguration = builder.preExtractionHookConfiguration;
            }

            @Override
            public final java.lang.Object getInlineConfigurations() {
                return this.inlineConfigurations;
            }

            @Override
            public final java.lang.Object getPostExtractionHookConfiguration() {
                return this.postExtractionHookConfiguration;
            }

            @Override
            public final java.lang.Object getPreExtractionHookConfiguration() {
                return this.preExtractionHookConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInlineConfigurations() != null) {
                    data.set("inlineConfigurations", om.valueToTree(this.getInlineConfigurations()));
                }
                if (this.getPostExtractionHookConfiguration() != null) {
                    data.set("postExtractionHookConfiguration", om.valueToTree(this.getPostExtractionHookConfiguration()));
                }
                if (this.getPreExtractionHookConfiguration() != null) {
                    data.set("preExtractionHookConfiguration", om.valueToTree(this.getPreExtractionHookConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.DocumentEnrichmentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentEnrichmentConfigurationProperty.Jsii$Proxy that = (DocumentEnrichmentConfigurationProperty.Jsii$Proxy) o;

                if (this.inlineConfigurations != null ? !this.inlineConfigurations.equals(that.inlineConfigurations) : that.inlineConfigurations != null) return false;
                if (this.postExtractionHookConfiguration != null ? !this.postExtractionHookConfiguration.equals(that.postExtractionHookConfiguration) : that.postExtractionHookConfiguration != null) return false;
                return this.preExtractionHookConfiguration != null ? this.preExtractionHookConfiguration.equals(that.preExtractionHookConfiguration) : that.preExtractionHookConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inlineConfigurations != null ? this.inlineConfigurations.hashCode() : 0;
                result = 31 * result + (this.postExtractionHookConfiguration != null ? this.postExtractionHookConfiguration.hashCode() : 0);
                result = 31 * result + (this.preExtractionHookConfiguration != null ? this.preExtractionHookConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for invoking a Lambda function in AWS Lambda to alter document metadata and content when ingesting documents into Amazon Q Business.
     * <p>
     * You can configure your Lambda function using the <code>PreExtractionHookConfiguration</code> parameter if you want to apply advanced alterations on the original or raw documents.
     * <p>
     * If you want to apply advanced alterations on the Amazon Q Business structured documents, you must configure your Lambda function using <code>PostExtractionHookConfiguration</code> .
     * <p>
     * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * HookConfigurationProperty hookConfigurationProperty = HookConfigurationProperty.builder()
     *         .invocationCondition(DocumentAttributeConditionProperty.builder()
     *                 .key("key")
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .lambdaArn("lambdaArn")
     *         .roleArn("roleArn")
     *         .s3BucketName("s3BucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.HookConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HookConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HookConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition used for when a Lambda function should be invoked.
         * <p>
         * For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business should invoke a function that inserts the current date-time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-invocationcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-invocationcondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvocationCondition() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lambda function during ingestion.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cde-lambda-operations.html">Using Lambda functions for Amazon Q Business document enrichment</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the document ingestion process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Stores the original, raw documents or the structured, parsed documents before and after altering them.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts">Data contracts for Lambda functions</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-hookconfiguration.html#cfn-qbusiness-datasource-hookconfiguration-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HookConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HookConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HookConfigurationProperty> {
            java.lang.Object invocationCondition;
            java.lang.String lambdaArn;
            java.lang.String roleArn;
            java.lang.String s3BucketName;

            /**
             * Sets the value of {@link HookConfigurationProperty#getInvocationCondition}
             * @param invocationCondition The condition used for when a Lambda function should be invoked.
             *                            For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business should invoke a function that inserts the current date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationCondition(software.amazon.awscdk.IResolvable invocationCondition) {
                this.invocationCondition = invocationCondition;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getInvocationCondition}
             * @param invocationCondition The condition used for when a Lambda function should be invoked.
             *                            For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business should invoke a function that inserts the current date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationCondition(software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentAttributeConditionProperty invocationCondition) {
                this.invocationCondition = invocationCondition;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the Lambda function during ingestion.
             *                  For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cde-lambda-operations.html">Using Lambda functions for Amazon Q Business document enrichment</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the document ingestion process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getS3BucketName}
             * @param s3BucketName Stores the original, raw documents or the structured, parsed documents before and after altering them.
             *                     For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts">Data contracts for Lambda functions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HookConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HookConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HookConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HookConfigurationProperty {
            private final java.lang.Object invocationCondition;
            private final java.lang.String lambdaArn;
            private final java.lang.String roleArn;
            private final java.lang.String s3BucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.invocationCondition = software.amazon.jsii.Kernel.get(this, "invocationCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.invocationCondition = builder.invocationCondition;
                this.lambdaArn = builder.lambdaArn;
                this.roleArn = builder.roleArn;
                this.s3BucketName = builder.s3BucketName;
            }

            @Override
            public final java.lang.Object getInvocationCondition() {
                return this.invocationCondition;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInvocationCondition() != null) {
                    data.set("invocationCondition", om.valueToTree(this.getInvocationCondition()));
                }
                if (this.getLambdaArn() != null) {
                    data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.HookConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HookConfigurationProperty.Jsii$Proxy that = (HookConfigurationProperty.Jsii$Proxy) o;

                if (this.invocationCondition != null ? !this.invocationCondition.equals(that.invocationCondition) : that.invocationCondition != null) return false;
                if (this.lambdaArn != null ? !this.lambdaArn.equals(that.lambdaArn) : that.lambdaArn != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.s3BucketName != null ? this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.invocationCondition != null ? this.invocationCondition.hashCode() : 0;
                result = 31 * result + (this.lambdaArn != null ? this.lambdaArn.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for extracting semantic meaning from images in documents.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting semantic meaning from images and visuals</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * ImageExtractionConfigurationProperty imageExtractionConfigurationProperty = ImageExtractionConfigurationProperty.builder()
     *         .imageExtractionStatus("imageExtractionStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-imageextractionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-imageextractionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.ImageExtractionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageExtractionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageExtractionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify whether to extract semantic meaning from images and visuals from documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-imageextractionconfiguration.html#cfn-qbusiness-datasource-imageextractionconfiguration-imageextractionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-imageextractionconfiguration.html#cfn-qbusiness-datasource-imageextractionconfiguration-imageextractionstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageExtractionStatus();

        /**
         * @return a {@link Builder} of {@link ImageExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageExtractionConfigurationProperty> {
            java.lang.String imageExtractionStatus;

            /**
             * Sets the value of {@link ImageExtractionConfigurationProperty#getImageExtractionStatus}
             * @param imageExtractionStatus Specify whether to extract semantic meaning from images and visuals from documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageExtractionStatus(java.lang.String imageExtractionStatus) {
                this.imageExtractionStatus = imageExtractionStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageExtractionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageExtractionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageExtractionConfigurationProperty {
            private final java.lang.String imageExtractionStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageExtractionStatus = software.amazon.jsii.Kernel.get(this, "imageExtractionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageExtractionStatus = java.util.Objects.requireNonNull(builder.imageExtractionStatus, "imageExtractionStatus is required");
            }

            @Override
            public final java.lang.String getImageExtractionStatus() {
                return this.imageExtractionStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageExtractionStatus", om.valueToTree(this.getImageExtractionStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.ImageExtractionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageExtractionConfigurationProperty.Jsii$Proxy that = (ImageExtractionConfigurationProperty.Jsii$Proxy) o;

                return this.imageExtractionStatus.equals(that.imageExtractionStatus);
            }

            @Override
            public final int hashCode() {
                int result = this.imageExtractionStatus.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for applying basic logic to alter document metadata and content when ingesting documents into Amazon Q Business.
     * <p>
     * To apply advanced logic, to go beyond what you can do with basic logic, see <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_HookConfiguration.html"><code>HookConfiguration</code></a> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * InlineDocumentEnrichmentConfigurationProperty inlineDocumentEnrichmentConfigurationProperty = InlineDocumentEnrichmentConfigurationProperty.builder()
     *         .condition(DocumentAttributeConditionProperty.builder()
     *                 .key("key")
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .documentContentOperator("documentContentOperator")
     *         .target(DocumentAttributeTargetProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .attributeValueOperator("attributeValueOperator")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.InlineDocumentEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InlineDocumentEnrichmentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InlineDocumentEnrichmentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html#cfn-qbusiness-datasource-inlinedocumentenrichmentconfiguration-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html#cfn-qbusiness-datasource-inlinedocumentenrichmentconfiguration-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
            return null;
        }

        /**
         * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html#cfn-qbusiness-datasource-inlinedocumentenrichmentconfiguration-documentcontentoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html#cfn-qbusiness-datasource-inlinedocumentenrichmentconfiguration-documentcontentoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentContentOperator() {
            return null;
        }

        /**
         * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Q Business .
         * <p>
         * You can also include a value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html#cfn-qbusiness-datasource-inlinedocumentenrichmentconfiguration-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-inlinedocumentenrichmentconfiguration.html#cfn-qbusiness-datasource-inlinedocumentenrichmentconfiguration-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTarget() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InlineDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InlineDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InlineDocumentEnrichmentConfigurationProperty> {
            java.lang.Object condition;
            java.lang.String documentContentOperator;
            java.lang.Object target;

            /**
             * Sets the value of {@link InlineDocumentEnrichmentConfigurationProperty#getCondition}
             * @param condition Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link InlineDocumentEnrichmentConfigurationProperty#getCondition}
             * @param condition Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentAttributeConditionProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link InlineDocumentEnrichmentConfigurationProperty#getDocumentContentOperator}
             * @param documentContentOperator <code>TRUE</code> to delete content if the condition used for the target attribute is met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentContentOperator(java.lang.String documentContentOperator) {
                this.documentContentOperator = documentContentOperator;
                return this;
            }

            /**
             * Sets the value of {@link InlineDocumentEnrichmentConfigurationProperty#getTarget}
             * @param target Configuration of the target document attribute or metadata field when ingesting documents into Amazon Q Business .
             *               You can also include a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.IResolvable target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link InlineDocumentEnrichmentConfigurationProperty#getTarget}
             * @param target Configuration of the target document attribute or metadata field when ingesting documents into Amazon Q Business .
             *               You can also include a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentAttributeTargetProperty target) {
                this.target = target;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InlineDocumentEnrichmentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InlineDocumentEnrichmentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InlineDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InlineDocumentEnrichmentConfigurationProperty {
            private final java.lang.Object condition;
            private final java.lang.String documentContentOperator;
            private final java.lang.Object target;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentContentOperator = software.amazon.jsii.Kernel.get(this, "documentContentOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = builder.condition;
                this.documentContentOperator = builder.documentContentOperator;
                this.target = builder.target;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getDocumentContentOperator() {
                return this.documentContentOperator;
            }

            @Override
            public final java.lang.Object getTarget() {
                return this.target;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getDocumentContentOperator() != null) {
                    data.set("documentContentOperator", om.valueToTree(this.getDocumentContentOperator()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.InlineDocumentEnrichmentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InlineDocumentEnrichmentConfigurationProperty.Jsii$Proxy that = (InlineDocumentEnrichmentConfigurationProperty.Jsii$Proxy) o;

                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                if (this.documentContentOperator != null ? !this.documentContentOperator.equals(that.documentContentOperator) : that.documentContentOperator != null) return false;
                return this.target != null ? this.target.equals(that.target) : that.target == null;
            }

            @Override
            public final int hashCode() {
                int result = this.condition != null ? this.condition.hashCode() : 0;
                result = 31 * result + (this.documentContentOperator != null ? this.documentContentOperator.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for extracting information from media in documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * MediaExtractionConfigurationProperty mediaExtractionConfigurationProperty = MediaExtractionConfigurationProperty.builder()
     *         .audioExtractionConfiguration(AudioExtractionConfigurationProperty.builder()
     *                 .audioExtractionStatus("audioExtractionStatus")
     *                 .build())
     *         .imageExtractionConfiguration(ImageExtractionConfigurationProperty.builder()
     *                 .imageExtractionStatus("imageExtractionStatus")
     *                 .build())
     *         .videoExtractionConfiguration(VideoExtractionConfigurationProperty.builder()
     *                 .videoExtractionStatus("videoExtractionStatus")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.MediaExtractionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaExtractionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaExtractionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for extracting and processing audio content from media files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html#cfn-qbusiness-datasource-mediaextractionconfiguration-audioextractionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html#cfn-qbusiness-datasource-mediaextractionconfiguration-audioextractionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioExtractionConfiguration() {
            return null;
        }

        /**
         * The configuration for extracting semantic meaning from images in documents.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting semantic meaning from images and visuals</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html#cfn-qbusiness-datasource-mediaextractionconfiguration-imageextractionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html#cfn-qbusiness-datasource-mediaextractionconfiguration-imageextractionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageExtractionConfiguration() {
            return null;
        }

        /**
         * Configuration settings for extracting and processing video content from media files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html#cfn-qbusiness-datasource-mediaextractionconfiguration-videoextractionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-mediaextractionconfiguration.html#cfn-qbusiness-datasource-mediaextractionconfiguration-videoextractionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVideoExtractionConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaExtractionConfigurationProperty> {
            java.lang.Object audioExtractionConfiguration;
            java.lang.Object imageExtractionConfiguration;
            java.lang.Object videoExtractionConfiguration;

            /**
             * Sets the value of {@link MediaExtractionConfigurationProperty#getAudioExtractionConfiguration}
             * @param audioExtractionConfiguration Configuration settings for extracting and processing audio content from media files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioExtractionConfiguration(software.amazon.awscdk.IResolvable audioExtractionConfiguration) {
                this.audioExtractionConfiguration = audioExtractionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaExtractionConfigurationProperty#getAudioExtractionConfiguration}
             * @param audioExtractionConfiguration Configuration settings for extracting and processing audio content from media files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioExtractionConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.AudioExtractionConfigurationProperty audioExtractionConfiguration) {
                this.audioExtractionConfiguration = audioExtractionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaExtractionConfigurationProperty#getImageExtractionConfiguration}
             * @param imageExtractionConfiguration The configuration for extracting semantic meaning from images in documents.
             *                                     For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting semantic meaning from images and visuals</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageExtractionConfiguration(software.amazon.awscdk.IResolvable imageExtractionConfiguration) {
                this.imageExtractionConfiguration = imageExtractionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaExtractionConfigurationProperty#getImageExtractionConfiguration}
             * @param imageExtractionConfiguration The configuration for extracting semantic meaning from images in documents.
             *                                     For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting semantic meaning from images and visuals</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageExtractionConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.ImageExtractionConfigurationProperty imageExtractionConfiguration) {
                this.imageExtractionConfiguration = imageExtractionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaExtractionConfigurationProperty#getVideoExtractionConfiguration}
             * @param videoExtractionConfiguration Configuration settings for extracting and processing video content from media files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoExtractionConfiguration(software.amazon.awscdk.IResolvable videoExtractionConfiguration) {
                this.videoExtractionConfiguration = videoExtractionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaExtractionConfigurationProperty#getVideoExtractionConfiguration}
             * @param videoExtractionConfiguration Configuration settings for extracting and processing video content from media files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoExtractionConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.VideoExtractionConfigurationProperty videoExtractionConfiguration) {
                this.videoExtractionConfiguration = videoExtractionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaExtractionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaExtractionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaExtractionConfigurationProperty {
            private final java.lang.Object audioExtractionConfiguration;
            private final java.lang.Object imageExtractionConfiguration;
            private final java.lang.Object videoExtractionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioExtractionConfiguration = software.amazon.jsii.Kernel.get(this, "audioExtractionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageExtractionConfiguration = software.amazon.jsii.Kernel.get(this, "imageExtractionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.videoExtractionConfiguration = software.amazon.jsii.Kernel.get(this, "videoExtractionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioExtractionConfiguration = builder.audioExtractionConfiguration;
                this.imageExtractionConfiguration = builder.imageExtractionConfiguration;
                this.videoExtractionConfiguration = builder.videoExtractionConfiguration;
            }

            @Override
            public final java.lang.Object getAudioExtractionConfiguration() {
                return this.audioExtractionConfiguration;
            }

            @Override
            public final java.lang.Object getImageExtractionConfiguration() {
                return this.imageExtractionConfiguration;
            }

            @Override
            public final java.lang.Object getVideoExtractionConfiguration() {
                return this.videoExtractionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioExtractionConfiguration() != null) {
                    data.set("audioExtractionConfiguration", om.valueToTree(this.getAudioExtractionConfiguration()));
                }
                if (this.getImageExtractionConfiguration() != null) {
                    data.set("imageExtractionConfiguration", om.valueToTree(this.getImageExtractionConfiguration()));
                }
                if (this.getVideoExtractionConfiguration() != null) {
                    data.set("videoExtractionConfiguration", om.valueToTree(this.getVideoExtractionConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.MediaExtractionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaExtractionConfigurationProperty.Jsii$Proxy that = (MediaExtractionConfigurationProperty.Jsii$Proxy) o;

                if (this.audioExtractionConfiguration != null ? !this.audioExtractionConfiguration.equals(that.audioExtractionConfiguration) : that.audioExtractionConfiguration != null) return false;
                if (this.imageExtractionConfiguration != null ? !this.imageExtractionConfiguration.equals(that.imageExtractionConfiguration) : that.imageExtractionConfiguration != null) return false;
                return this.videoExtractionConfiguration != null ? this.videoExtractionConfiguration.equals(that.videoExtractionConfiguration) : that.videoExtractionConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioExtractionConfiguration != null ? this.audioExtractionConfiguration.hashCode() : 0;
                result = 31 * result + (this.imageExtractionConfiguration != null ? this.imageExtractionConfiguration.hashCode() : 0);
                result = 31 * result + (this.videoExtractionConfiguration != null ? this.videoExtractionConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for video content extraction and processing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * VideoExtractionConfigurationProperty videoExtractionConfigurationProperty = VideoExtractionConfigurationProperty.builder()
     *         .videoExtractionStatus("videoExtractionStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-videoextractionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-videoextractionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSource.VideoExtractionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoExtractionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoExtractionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of video extraction (ENABLED or DISABLED) for processing video content from files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-videoextractionconfiguration.html#cfn-qbusiness-datasource-videoextractionconfiguration-videoextractionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-datasource-videoextractionconfiguration.html#cfn-qbusiness-datasource-videoextractionconfiguration-videoextractionstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVideoExtractionStatus();

        /**
         * @return a {@link Builder} of {@link VideoExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoExtractionConfigurationProperty> {
            java.lang.String videoExtractionStatus;

            /**
             * Sets the value of {@link VideoExtractionConfigurationProperty#getVideoExtractionStatus}
             * @param videoExtractionStatus The status of video extraction (ENABLED or DISABLED) for processing video content from files. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoExtractionStatus(java.lang.String videoExtractionStatus) {
                this.videoExtractionStatus = videoExtractionStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoExtractionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoExtractionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoExtractionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoExtractionConfigurationProperty {
            private final java.lang.String videoExtractionStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.videoExtractionStatus = software.amazon.jsii.Kernel.get(this, "videoExtractionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.videoExtractionStatus = java.util.Objects.requireNonNull(builder.videoExtractionStatus, "videoExtractionStatus is required");
            }

            @Override
            public final java.lang.String getVideoExtractionStatus() {
                return this.videoExtractionStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("videoExtractionStatus", om.valueToTree(this.getVideoExtractionStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSource.VideoExtractionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoExtractionConfigurationProperty.Jsii$Proxy that = (VideoExtractionConfigurationProperty.Jsii$Proxy) o;

                return this.videoExtractionStatus.equals(that.videoExtractionStatus);
            }

            @Override
            public final int hashCode() {
                int result = this.videoExtractionStatus.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.qbusiness.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.qbusiness.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.qbusiness.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.qbusiness.CfnDataSourceProps.Builder();
        }

        /**
         * The identifier of the Amazon Q Business application the data source will be attached to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-applicationid</a>
         * @param applicationId The identifier of the Amazon Q Business application the data source will be attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business .
         * <p>
         * You must use the JSON or YAML schema provided by Amazon Q .
         * <p>
         * The following links have the configuration properties and schemas for AWS CloudFormation for the following connectors:
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-cfn.html">Amazon Simple Storage Service</a></li>
         * <li><a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-cfn.html">Amazon Q Web Crawler</a></li>
         * </ul>
         * <p>
         * Similarly, you can find configuration templates and properties for your specific data source using the following steps:
         * <p>
         * <ul>
         * <li>Navigate to the <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported connectors</a> page in the Amazon Q Business User Guide, and select the data source connector of your choice.</li>
         * <li>Then, from that specific data source connector's page, choose the topic containing <em>Using AWS CloudFormation</em> to find the schemas for your data source connector, including configuration parameter descriptions and examples.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-configuration</a>
         * @param configuration Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final java.lang.Object configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The name of the Amazon Q Business data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-displayname</a>
         * @param displayName The name of the Amazon Q Business data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The identifier of the index the data source is attached to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-indexid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-indexid</a>
         * @param indexId The identifier of the index the data source is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexId(final java.lang.String indexId) {
            this.props.indexId(indexId);
            return this;
        }

        /**
         * A description for the data source connector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-description</a>
         * @param description A description for the data source connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Provides the configuration information for altering document metadata and content during the document ingestion process.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-documentenrichmentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-documentenrichmentconfiguration</a>
         * @param documentEnrichmentConfiguration Provides the configuration information for altering document metadata and content during the document ingestion process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentEnrichmentConfiguration(final software.amazon.awscdk.IResolvable documentEnrichmentConfiguration) {
            this.props.documentEnrichmentConfiguration(documentEnrichmentConfiguration);
            return this;
        }
        /**
         * Provides the configuration information for altering document metadata and content during the document ingestion process.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-documentenrichmentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-documentenrichmentconfiguration</a>
         * @param documentEnrichmentConfiguration Provides the configuration information for altering document metadata and content during the document ingestion process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentEnrichmentConfiguration(final software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentEnrichmentConfigurationProperty documentEnrichmentConfiguration) {
            this.props.documentEnrichmentConfiguration(documentEnrichmentConfiguration);
            return this;
        }

        /**
         * The configuration for extracting information from media in documents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-mediaextractionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-mediaextractionconfiguration</a>
         * @param mediaExtractionConfiguration The configuration for extracting information from media in documents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaExtractionConfiguration(final software.amazon.awscdk.IResolvable mediaExtractionConfiguration) {
            this.props.mediaExtractionConfiguration(mediaExtractionConfiguration);
            return this;
        }
        /**
         * The configuration for extracting information from media in documents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-mediaextractionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-mediaextractionconfiguration</a>
         * @param mediaExtractionConfiguration The configuration for extracting information from media in documents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaExtractionConfiguration(final software.amazon.awscdk.services.qbusiness.CfnDataSource.MediaExtractionConfigurationProperty mediaExtractionConfiguration) {
            this.props.mediaExtractionConfiguration(mediaExtractionConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index.
         * <p>
         * If you don't set a schedule, Amazon Q Business won't periodically update the index.
         * <p>
         * Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> . If you do, you receive a <code>ValidationException</code> exception.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-syncschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-syncschedule</a>
         * @param syncSchedule Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSchedule(final java.lang.String syncSchedule) {
            this.props.syncSchedule(syncSchedule);
            return this;
        }

        /**
         * A list of key-value pairs that identify or categorize the data source connector.
         * <p>
         * You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-tags</a>
         * @param tags A list of key-value pairs that identify or categorize the data source connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with Amazon Q Business connectors</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-vpcconfiguration</a>
         * @param vpcConfiguration Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(final software.amazon.awscdk.IResolvable vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }
        /**
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with Amazon Q Business connectors</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-vpcconfiguration</a>
         * @param vpcConfiguration Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(final software.amazon.awscdk.services.qbusiness.CfnDataSource.DataSourceVpcConfigurationProperty vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.qbusiness.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.qbusiness.CfnDataSource build() {
            return new software.amazon.awscdk.services.qbusiness.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
