package software.amazon.awscdk.services.rds;

/**
 * The storage type to be associated with the DB cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraPostgres(AuroraPostgresClusterEngineProps.builder().version(AuroraPostgresEngineVersion.VER_15_2).build()))
 *         .credentials(Credentials.fromUsername("adminuser", CredentialsFromUsernameOptions.builder().password(SecretValue.unsafePlainText("7959866cacc02c2d243ecfe177464fe6")).build()))
 *         .writer(ClusterInstance.provisioned("writer", ProvisionedClusterInstanceProps.builder()
 *                 .publiclyAccessible(false)
 *                 .build()))
 *         .readers(List.of(ClusterInstance.provisioned("reader")))
 *         .storageType(DBClusterStorageType.AURORA_IOPT1)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_EGRESS)
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:44.382Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DBClusterStorageType")
public enum DBClusterStorageType {
    /**
     * Storage type for Aurora DB standard clusters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AURORA,
    /**
     * Storage type for Aurora DB I/O-Optimized clusters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AURORA_IOPT1,
}
