package software.amazon.awscdk.services.rds;

/**
 * Properties for looking up an existing DatabaseInstance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role myUserRole;
 * IDatabaseInstance dbFromLookup = DatabaseInstance.fromLookup(this, "dbFromLookup", DatabaseInstanceLookupOptions.builder()
 *         .instanceIdentifier("instanceId")
 *         .build());
 * // Grant a connection
 * dbFromLookup.grantConnect(myUserRole, "my-user-id");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:44.420Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstanceLookupOptions")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseInstanceLookupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The instance identifier of the DatabaseInstance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceIdentifier();

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceLookupOptions> {
        java.lang.String instanceIdentifier;

        /**
         * Sets the value of {@link DatabaseInstanceLookupOptions#getInstanceIdentifier}
         * @param instanceIdentifier The instance identifier of the DatabaseInstance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifier(java.lang.String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseInstanceLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceLookupOptions {
        private final java.lang.String instanceIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceIdentifier = software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceIdentifier = java.util.Objects.requireNonNull(builder.instanceIdentifier, "instanceIdentifier is required");
        }

        @Override
        public final java.lang.String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceIdentifier", om.valueToTree(this.getInstanceIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseInstanceLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceLookupOptions.Jsii$Proxy that = (DatabaseInstanceLookupOptions.Jsii$Proxy) o;

            return this.instanceIdentifier.equals(that.instanceIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.instanceIdentifier.hashCode();
            return result;
        }
    }
}
