package software.amazon.awscdk.services.rds;

/**
 * Construction properties for an OptionGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Set open cursors with parameter group
 * ParameterGroup parameterGroup = ParameterGroup.Builder.create(this, "ParameterGroup")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         .parameters(Map.of(
 *                 "open_cursors", "2500"))
 *         .build();
 * OptionGroup optionGroup = OptionGroup.Builder.create(this, "OptionGroup")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         .configurations(List.of(OptionConfiguration.builder()
 *                 .name("LOCATOR")
 *                 .build(), OptionConfiguration.builder()
 *                 .name("OEM")
 *                 .port(1158)
 *                 .vpc(vpc)
 *                 .build()))
 *         .build();
 * // Allow connections to OEM
 * optionGroup.optionConnections.OEM.connections.allowDefaultPortFromAnyIpv4();
 * // Database instance with production values
 * DatabaseInstance instance = DatabaseInstance.Builder.create(this, "Instance")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         .licenseModel(LicenseModel.BRING_YOUR_OWN_LICENSE)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.MEDIUM))
 *         .multiAz(true)
 *         .storageType(StorageType.IO1)
 *         .credentials(Credentials.fromUsername("syscdk"))
 *         .vpc(vpc)
 *         .databaseName("ORCL")
 *         .storageEncrypted(true)
 *         .backupRetention(Duration.days(7))
 *         .monitoringInterval(Duration.seconds(60))
 *         .enablePerformanceInsights(true)
 *         .cloudwatchLogsExports(List.of("trace", "audit", "alert", "listener"))
 *         .cloudwatchLogsRetention(RetentionDays.ONE_MONTH)
 *         .autoMinorVersionUpgrade(true) // required to be true if LOCATOR is used in the option group
 *         .optionGroup(optionGroup)
 *         .parameterGroup(parameterGroup)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * // Allow connections on default port from any IPV4
 * instance.connections.allowDefaultPortFromAnyIpv4();
 * // Rotate the master user password every 30 days
 * instance.addRotationSingleUser();
 * // Add alarm for high CPU
 * // Add alarm for high CPU
 * Alarm.Builder.create(this, "HighCPU")
 *         .metric(instance.metricCPUUtilization())
 *         .threshold(90)
 *         .evaluationPeriods(1)
 *         .build();
 * // Trigger Lambda function on instance availability events
 * Function fn = Function.Builder.create(this, "Function")
 *         .code(Code.fromInline("exports.handler = (event) =&gt; console.log(event);"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .build();
 * Rule availabilityRule = instance.onEvent("Availability", OnEventOptions.builder().target(new LambdaFunction(fn)).build());
 * availabilityRule.addEventPattern(EventPattern.builder()
 *         .detail(Map.of(
 *                 "EventCategories", List.of("availability")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:44.483Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.OptionGroupProps")
@software.amazon.jsii.Jsii.Proxy(OptionGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OptionGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configurations for this option group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.rds.OptionConfiguration> getConfigurations();

    /**
     * The database engine that this option group is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine getEngine();

    /**
     * A description of the option group.
     * <p>
     * Default: a CDK generated description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OptionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OptionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OptionGroupProps> {
        java.util.List<software.amazon.awscdk.services.rds.OptionConfiguration> configurations;
        software.amazon.awscdk.services.rds.IInstanceEngine engine;
        java.lang.String description;

        /**
         * Sets the value of {@link OptionGroupProps#getConfigurations}
         * @param configurations The configurations for this option group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.rds.OptionConfiguration> configurations) {
            this.configurations = (java.util.List<software.amazon.awscdk.services.rds.OptionConfiguration>)configurations;
            return this;
        }

        /**
         * Sets the value of {@link OptionGroupProps#getEngine}
         * @param engine The database engine that this option group is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(software.amazon.awscdk.services.rds.IInstanceEngine engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link OptionGroupProps#getDescription}
         * @param description A description of the option group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OptionGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OptionGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OptionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionGroupProps {
        private final java.util.List<software.amazon.awscdk.services.rds.OptionConfiguration> configurations;
        private final software.amazon.awscdk.services.rds.IInstanceEngine engine;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OptionConfiguration.class)));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurations = (java.util.List<software.amazon.awscdk.services.rds.OptionConfiguration>)java.util.Objects.requireNonNull(builder.configurations, "configurations is required");
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.description = builder.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.rds.OptionConfiguration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IInstanceEngine getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurations", om.valueToTree(this.getConfigurations()));
            data.set("engine", om.valueToTree(this.getEngine()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.OptionGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OptionGroupProps.Jsii$Proxy that = (OptionGroupProps.Jsii$Proxy) o;

            if (!configurations.equals(that.configurations)) return false;
            if (!engine.equals(that.engine)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurations.hashCode();
            result = 31 * result + (this.engine.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
