package software.amazon.awscdk.services.route53;

/**
 * Properties for defining a <code>CfnHostedZone</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnHostedZoneProps cfnHostedZoneProps = CfnHostedZoneProps.builder()
 *         .hostedZoneConfig(HostedZoneConfigProperty.builder()
 *                 .comment("comment")
 *                 .build())
 *         .hostedZoneTags(List.of(HostedZoneTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .name("name")
 *         .queryLoggingConfig(QueryLoggingConfigProperty.builder()
 *                 .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *                 .build())
 *         .vpcs(List.of(VPCProperty.builder()
 *                 .vpcId("vpcId")
 *                 .vpcRegion("vpcRegion")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:44.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnHostedZoneProps")
@software.amazon.jsii.Jsii.Proxy(CfnHostedZoneProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHostedZoneProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A complex type that contains an optional comment.
     * <p>
     * If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHostedZoneConfig() {
        return null;
    }

    /**
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * <p>
     * For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>Billing and Cost Management User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> getHostedZoneTags() {
        return null;
    }

    /**
     * The name of the domain.
     * <p>
     * Specify a fully qualified domain name, for example, <em>www.example.com</em> . The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <em>www.example.com</em> (without a trailing dot) and <em>www.example.com.</em> (with a trailing dot) as identical.
     * <p>
     * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that are returned by the <code>Fn::GetAtt</code> intrinsic function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Creates a configuration for DNS query logging.
     * <p>
     * After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
     * <p>
     * <ul>
     * <li>Route 53 edge location that responded to the DNS query</li>
     * <li>Domain or subdomain that was requested</li>
     * <li>DNS record type, such as A or AAAA</li>
     * <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
     * <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
     * <li>You must create the log group in the us-east-1 region.</li>
     * <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
     * <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
     * </ul>
     * <p>
     * <code>/aws/route53/ *hosted zone name*</code>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. You must create the CloudWatch Logs resource policy in the us-east-1 region. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
     * </ul>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
     * <p>
     * <ul>
     * <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
     * <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
     * <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
     * <li>Begins to send query logs to the applicable log stream.</li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * <p>
     * <code>*hosted zone ID* / *edge location code*</code>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
     * <p>
     * <ul>
     * <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
     * <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQueryLoggingConfig() {
        return null;
    }

    /**
     * <em>Private hosted zones:</em> A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * <p>
     * <blockquote>
     * <p>
     * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHostedZoneProps> {
        java.lang.Object hostedZoneConfig;
        java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags;
        java.lang.String name;
        java.lang.Object queryLoggingConfig;
        java.lang.Object vpcs;

        /**
         * Sets the value of {@link CfnHostedZoneProps#getHostedZoneConfig}
         * @param hostedZoneConfig A complex type that contains an optional comment.
         *                         If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneConfig(software.amazon.awscdk.IResolvable hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getHostedZoneConfig}
         * @param hostedZoneConfig A complex type that contains an optional comment.
         *                         If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneConfig(software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneConfigProperty hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getHostedZoneTags}
         * @param hostedZoneTags Adds, edits, or deletes tags for a health check or a hosted zone.
         *                       For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>Billing and Cost Management User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder hostedZoneTags(java.util.List<? extends software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags) {
            this.hostedZoneTags = (java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty>)hostedZoneTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getName}
         * @param name The name of the domain.
         *             Specify a fully qualified domain name, for example, <em>www.example.com</em> . The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <em>www.example.com</em> (without a trailing dot) and <em>www.example.com.</em> (with a trailing dot) as identical.
         *             <p>
         *             If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that are returned by the <code>Fn::GetAtt</code> intrinsic function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getQueryLoggingConfig}
         * @param queryLoggingConfig Creates a configuration for DNS query logging.
         *                           After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
         *                           <p>
         *                           DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
         *                           <p>
         *                           <ul>
         *                           <li>Route 53 edge location that responded to the DNS query</li>
         *                           <li>Domain or subdomain that was requested</li>
         *                           <li>DNS record type, such as A or AAAA</li>
         *                           <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
         *                           <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
         *                           </ul>
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
         *                           <p>
         *                           </blockquote>
         *                           <p>
         *                           <ul>
         *                           <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
         *                           <li>You must create the log group in the us-east-1 region.</li>
         *                           <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
         *                           <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
         *                           </ul>
         *                           <p>
         *                           <code>/aws/route53/ *hosted zone name*</code>
         *                           <p>
         *                           In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
         *                           <p>
         *                           <ul>
         *                           <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. You must create the CloudWatch Logs resource policy in the us-east-1 region. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
         *                           </ul>
         *                           <p>
         *                           <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
         *                           <p>
         *                           To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
         *                           <p>
         *                           <ul>
         *                           <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
         *                           <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
         *                           </ul>
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
         *                           <p>
         *                           </blockquote>
         *                           <p>
         *                           <ul>
         *                           <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
         *                           <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
         *                           <li>Begins to send query logs to the applicable log stream.</li>
         *                           </ul>
         *                           <p>
         *                           The name of each log stream is in the following format:
         *                           <p>
         *                           <code>*hosted zone ID* / *edge location code*</code>
         *                           <p>
         *                           The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
         *                           <p>
         *                           <ul>
         *                           <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         *                           <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         *                           <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
         *                           <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfig(software.amazon.awscdk.IResolvable queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getQueryLoggingConfig}
         * @param queryLoggingConfig Creates a configuration for DNS query logging.
         *                           After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
         *                           <p>
         *                           DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
         *                           <p>
         *                           <ul>
         *                           <li>Route 53 edge location that responded to the DNS query</li>
         *                           <li>Domain or subdomain that was requested</li>
         *                           <li>DNS record type, such as A or AAAA</li>
         *                           <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
         *                           <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
         *                           </ul>
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
         *                           <p>
         *                           </blockquote>
         *                           <p>
         *                           <ul>
         *                           <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
         *                           <li>You must create the log group in the us-east-1 region.</li>
         *                           <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
         *                           <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
         *                           </ul>
         *                           <p>
         *                           <code>/aws/route53/ *hosted zone name*</code>
         *                           <p>
         *                           In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
         *                           <p>
         *                           <ul>
         *                           <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. You must create the CloudWatch Logs resource policy in the us-east-1 region. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
         *                           </ul>
         *                           <p>
         *                           <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
         *                           <p>
         *                           To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
         *                           <p>
         *                           <ul>
         *                           <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
         *                           <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
         *                           </ul>
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
         *                           <p>
         *                           </blockquote>
         *                           <p>
         *                           <ul>
         *                           <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
         *                           <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
         *                           <li>Begins to send query logs to the applicable log stream.</li>
         *                           </ul>
         *                           <p>
         *                           The name of each log stream is in the following format:
         *                           <p>
         *                           <code>*hosted zone ID* / *edge location code*</code>
         *                           <p>
         *                           The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
         *                           <p>
         *                           <ul>
         *                           <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         *                           <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         *                           <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
         *                           <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfig(software.amazon.awscdk.services.route53.CfnHostedZone.QueryLoggingConfigProperty queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getVpcs}
         * @param vpcs <em>Private hosted zones:</em> A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         *             <blockquote>
         *             <p>
         *             For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(software.amazon.awscdk.IResolvable vpcs) {
            this.vpcs = vpcs;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getVpcs}
         * @param vpcs <em>Private hosted zones:</em> A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         *             <blockquote>
         *             <p>
         *             For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(java.util.List<? extends java.lang.Object> vpcs) {
            this.vpcs = vpcs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHostedZoneProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHostedZoneProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHostedZoneProps {
        private final java.lang.Object hostedZoneConfig;
        private final java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags;
        private final java.lang.String name;
        private final java.lang.Object queryLoggingConfig;
        private final java.lang.Object vpcs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZoneConfig = software.amazon.jsii.Kernel.get(this, "hostedZoneConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hostedZoneTags = software.amazon.jsii.Kernel.get(this, "hostedZoneTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLoggingConfig = software.amazon.jsii.Kernel.get(this, "queryLoggingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcs = software.amazon.jsii.Kernel.get(this, "vpcs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZoneConfig = builder.hostedZoneConfig;
            this.hostedZoneTags = (java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty>)builder.hostedZoneTags;
            this.name = builder.name;
            this.queryLoggingConfig = builder.queryLoggingConfig;
            this.vpcs = builder.vpcs;
        }

        @Override
        public final java.lang.Object getHostedZoneConfig() {
            return this.hostedZoneConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> getHostedZoneTags() {
            return this.hostedZoneTags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getQueryLoggingConfig() {
            return this.queryLoggingConfig;
        }

        @Override
        public final java.lang.Object getVpcs() {
            return this.vpcs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHostedZoneConfig() != null) {
                data.set("hostedZoneConfig", om.valueToTree(this.getHostedZoneConfig()));
            }
            if (this.getHostedZoneTags() != null) {
                data.set("hostedZoneTags", om.valueToTree(this.getHostedZoneTags()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getQueryLoggingConfig() != null) {
                data.set("queryLoggingConfig", om.valueToTree(this.getQueryLoggingConfig()));
            }
            if (this.getVpcs() != null) {
                data.set("vpcs", om.valueToTree(this.getVpcs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnHostedZoneProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHostedZoneProps.Jsii$Proxy that = (CfnHostedZoneProps.Jsii$Proxy) o;

            if (this.hostedZoneConfig != null ? !this.hostedZoneConfig.equals(that.hostedZoneConfig) : that.hostedZoneConfig != null) return false;
            if (this.hostedZoneTags != null ? !this.hostedZoneTags.equals(that.hostedZoneTags) : that.hostedZoneTags != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.queryLoggingConfig != null ? !this.queryLoggingConfig.equals(that.queryLoggingConfig) : that.queryLoggingConfig != null) return false;
            return this.vpcs != null ? this.vpcs.equals(that.vpcs) : that.vpcs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostedZoneConfig != null ? this.hostedZoneConfig.hashCode() : 0;
            result = 31 * result + (this.hostedZoneTags != null ? this.hostedZoneTags.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.queryLoggingConfig != null ? this.queryLoggingConfig.hashCode() : 0);
            result = 31 * result + (this.vpcs != null ? this.vpcs.hashCode() : 0);
            return result;
        }
    }
}
