package software.amazon.awscdk.services.route53;

/**
 * Options for enabling key signing from a hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key kmsKey = Key.Builder.create(this, "KmsCMK")
 *         .keySpec(KeySpec.ECC_NIST_P256)
 *         .keyUsage(KeyUsage.SIGN_VERIFY)
 *         .build();
 * HostedZone hostedZone = HostedZone.Builder.create(this, "HostedZone")
 *         .zoneName("example.com")
 *         .build();
 * // Enable DNSSEC signing for the zone
 * hostedZone.enableDnssec(ZoneSigningOptions.builder().kmsKey(kmsKey).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:44.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.ZoneSigningOptions")
@software.amazon.jsii.Jsii.Proxy(ZoneSigningOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ZoneSigningOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The customer-managed KMS key that that will be used to sign the records.
     * <p>
     * The KMS Key must be unique for each KSK within a hosted zone. Additionally, the
     * KMS key must be an asymetric customer-managed key using the ECC_NIST_P256 algorithm.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html">https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey getKmsKey();

    /**
     * The name for the key signing key.
     * <p>
     * This name must be unique within a hosted zone.
     * <p>
     * Default: an autogenerated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeySigningKeyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ZoneSigningOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ZoneSigningOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ZoneSigningOptions> {
        software.amazon.awscdk.services.kms.IKey kmsKey;
        java.lang.String keySigningKeyName;

        /**
         * Sets the value of {@link ZoneSigningOptions#getKmsKey}
         * @param kmsKey The customer-managed KMS key that that will be used to sign the records. This parameter is required.
         *               The KMS Key must be unique for each KSK within a hosted zone. Additionally, the
         *               KMS key must be an asymetric customer-managed key using the ECC_NIST_P256 algorithm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link ZoneSigningOptions#getKeySigningKeyName}
         * @param keySigningKeyName The name for the key signing key.
         *                          This name must be unique within a hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySigningKeyName(java.lang.String keySigningKeyName) {
            this.keySigningKeyName = keySigningKeyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ZoneSigningOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ZoneSigningOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ZoneSigningOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZoneSigningOptions {
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final java.lang.String keySigningKeyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.keySigningKeyName = software.amazon.jsii.Kernel.get(this, "keySigningKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.kmsKey = java.util.Objects.requireNonNull(builder.kmsKey, "kmsKey is required");
            this.keySigningKeyName = builder.keySigningKeyName;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getKeySigningKeyName() {
            return this.keySigningKeyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            if (this.getKeySigningKeyName() != null) {
                data.set("keySigningKeyName", om.valueToTree(this.getKeySigningKeyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.ZoneSigningOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ZoneSigningOptions.Jsii$Proxy that = (ZoneSigningOptions.Jsii$Proxy) o;

            if (!kmsKey.equals(that.kmsKey)) return false;
            return this.keySigningKeyName != null ? this.keySigningKeyName.equals(that.keySigningKeyName) : that.keySigningKeyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.kmsKey.hashCode();
            result = 31 * result + (this.keySigningKeyName != null ? this.keySigningKeyName.hashCode() : 0);
            return result;
        }
    }
}
