package software.amazon.awscdk.services.scheduler;

/**
 * A time window during which EventBridge Scheduler invokes the schedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaInvoke target;
 * Schedule schedule = Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.hours(12)))
 *         .target(target)
 *         .timeWindow(TimeWindow.flexible(Duration.hours(10)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:45.614Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.TimeWindow")
public class TimeWindow extends software.amazon.jsii.JsiiObject {

    protected TimeWindow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TimeWindow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * TimeWindow is enabled.
     * <p>
     * @param maxWindow This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.TimeWindow flexible(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration maxWindow) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.TimeWindow.class, "flexible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.TimeWindow.class), new Object[] { java.util.Objects.requireNonNull(maxWindow, "maxWindow is required") });
    }

    /**
     * TimeWindow is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.TimeWindow off() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.TimeWindow.class, "off", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.TimeWindow.class));
    }

    /**
     * Determines whether the schedule is invoked within a flexible time window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum time window during which the schedule can be invoked.
     * <p>
     * Must be between 1 to 1440 minutes.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxWindow() {
        return software.amazon.jsii.Kernel.get(this, "maxWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }
}
