package software.amazon.awscdk.services.scheduler.targets;

/**
 * Use an Amazon Kinesis Data Streams as a target for AWS EventBridge Scheduler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesis.*;
 * Stream stream = new Stream(this, "MyStream");
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(60)))
 *         .target(KinesisStreamPutRecord.Builder.create(stream)
 *                 .partitionKey("key")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:45.641Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.KinesisStreamPutRecord")
public class KinesisStreamPutRecord extends software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase implements software.amazon.awscdk.services.scheduler.IScheduleTarget {

    protected KinesisStreamPutRecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisStreamPutRecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisStreamPutRecord(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void addTargetActionToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "addTargetActionToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * @param _schedule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleTargetConfig bindBaseTargetConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule _schedule) {
        return software.amazon.jsii.Kernel.call(this, "bindBaseTargetConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_schedule, "_schedule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.kinesis.IStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecordProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            this.props = new software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecordProps.Builder();
        }

        /**
         * The SQS queue to be used as deadLetterQueue.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Input passed to the target.
         * <p>
         * Default: - no input.
         * <p>
         * @return {@code this}
         * @param input Input passed to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.props.input(input);
            return this;
        }

        /**
         * The maximum age of a request that Scheduler sends to a target for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Scheduler sends to a target for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the target returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the target returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf.
         * <p>
         * If none provided templates target will automatically create an IAM role with all the minimum necessary
         * permissions to interact with the templated target. If you wish you may specify your own IAM role, then the templated targets
         * will grant minimal required permissions.
         * <p>
         * Default: - created by target
         * <p>
         * @return {@code this}
         * @param role An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The shard to which EventBridge Scheduler sends the event.
         * <p>
         * The length must be between 1 and 256.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-kinesisparameters.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-kinesisparameters.html</a>
         * @param partitionKey The shard to which EventBridge Scheduler sends the event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(final java.lang.String partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecord build() {
            return new software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecord(
                this.stream,
                this.props.build()
            );
        }
    }
}
