package software.amazon.awscdk.services.securitylake;

/**
 * Properties for defining a <code>CfnDataLake</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securitylake.*;
 * CfnDataLakeProps cfnDataLakeProps = CfnDataLakeProps.builder()
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .lifecycleConfiguration(LifecycleConfigurationProperty.builder()
 *                 .expiration(ExpirationProperty.builder()
 *                         .days(123)
 *                         .build())
 *                 .transitions(List.of(TransitionsProperty.builder()
 *                         .days(123)
 *                         .storageClass("storageClass")
 *                         .build()))
 *                 .build())
 *         .metaStoreManagerRoleArn("metaStoreManagerRoleArn")
 *         .replicationConfiguration(ReplicationConfigurationProperty.builder()
 *                 .regions(List.of("regions"))
 *                 .roleArn("roleArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:45.816Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnDataLakeProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataLakeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataLakeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Provides encryption details of the Amazon Security Lake object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time.
     * <p>
     * Lifecycle management can help you comply with different compliance requirements. For more details, see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html">Lifecycle management</a> in the Amazon Security Lake User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-lifecycleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-lifecycleconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) used to create and update the AWS Glue table.
     * <p>
     * This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-metastoremanagerrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-metastoremanagerrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetaStoreManagerRoleArn() {
        return null;
    }

    /**
     * Provides replication details of Amazon Security Lake object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-replicationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-replicationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationConfiguration() {
        return null;
    }

    /**
     * An array of objects, one for each tag to associate with the data lake configuration.
     * <p>
     * For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-datalake.html#cfn-securitylake-datalake-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataLakeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataLakeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataLakeProps> {
        java.lang.Object encryptionConfiguration;
        java.lang.Object lifecycleConfiguration;
        java.lang.String metaStoreManagerRoleArn;
        java.lang.Object replicationConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataLakeProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Provides encryption details of the Amazon Security Lake object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Provides encryption details of the Amazon Security Lake object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.securitylake.CfnDataLake.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time.
         *                               Lifecycle management can help you comply with different compliance requirements. For more details, see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html">Lifecycle management</a> in the Amazon Security Lake User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.IResolvable lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time.
         *                               Lifecycle management can help you comply with different compliance requirements. For more details, see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html">Lifecycle management</a> in the Amazon Security Lake User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.services.securitylake.CfnDataLake.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getMetaStoreManagerRoleArn}
         * @param metaStoreManagerRoleArn The Amazon Resource Name (ARN) used to create and update the AWS Glue table.
         *                                This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metaStoreManagerRoleArn(java.lang.String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getReplicationConfiguration}
         * @param replicationConfiguration Provides replication details of Amazon Security Lake object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(software.amazon.awscdk.IResolvable replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getReplicationConfiguration}
         * @param replicationConfiguration Provides replication details of Amazon Security Lake object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(software.amazon.awscdk.services.securitylake.CfnDataLake.ReplicationConfigurationProperty replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeProps#getTags}
         * @param tags An array of objects, one for each tag to associate with the data lake configuration.
         *             For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataLakeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataLakeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataLakeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataLakeProps {
        private final java.lang.Object encryptionConfiguration;
        private final java.lang.Object lifecycleConfiguration;
        private final java.lang.String metaStoreManagerRoleArn;
        private final java.lang.Object replicationConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lifecycleConfiguration = software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metaStoreManagerRoleArn = software.amazon.jsii.Kernel.get(this, "metaStoreManagerRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationConfiguration = software.amazon.jsii.Kernel.get(this, "replicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.lifecycleConfiguration = builder.lifecycleConfiguration;
            this.metaStoreManagerRoleArn = builder.metaStoreManagerRoleArn;
            this.replicationConfiguration = builder.replicationConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.lang.Object getLifecycleConfiguration() {
            return this.lifecycleConfiguration;
        }

        @Override
        public final java.lang.String getMetaStoreManagerRoleArn() {
            return this.metaStoreManagerRoleArn;
        }

        @Override
        public final java.lang.Object getReplicationConfiguration() {
            return this.replicationConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getLifecycleConfiguration() != null) {
                data.set("lifecycleConfiguration", om.valueToTree(this.getLifecycleConfiguration()));
            }
            if (this.getMetaStoreManagerRoleArn() != null) {
                data.set("metaStoreManagerRoleArn", om.valueToTree(this.getMetaStoreManagerRoleArn()));
            }
            if (this.getReplicationConfiguration() != null) {
                data.set("replicationConfiguration", om.valueToTree(this.getReplicationConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.CfnDataLakeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataLakeProps.Jsii$Proxy that = (CfnDataLakeProps.Jsii$Proxy) o;

            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            if (this.lifecycleConfiguration != null ? !this.lifecycleConfiguration.equals(that.lifecycleConfiguration) : that.lifecycleConfiguration != null) return false;
            if (this.metaStoreManagerRoleArn != null ? !this.metaStoreManagerRoleArn.equals(that.metaStoreManagerRoleArn) : that.metaStoreManagerRoleArn != null) return false;
            if (this.replicationConfiguration != null ? !this.replicationConfiguration.equals(that.replicationConfiguration) : that.replicationConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0;
            result = 31 * result + (this.lifecycleConfiguration != null ? this.lifecycleConfiguration.hashCode() : 0);
            result = 31 * result + (this.metaStoreManagerRoleArn != null ? this.metaStoreManagerRoleArn.hashCode() : 0);
            result = 31 * result + (this.replicationConfiguration != null ? this.replicationConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
