package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for provisoning rule constraint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Portfolio portfolio;
 * CloudFormationProduct product;
 * portfolio.constrainCloudFormationParameters(product, CloudFormationRuleConstraintOptions.builder()
 *         .rule(TemplateRule.builder()
 *                 .ruleName("testInstanceType")
 *                 .condition(Fn.conditionEquals(Fn.ref("Environment"), "test"))
 *                 .assertions(List.of(TemplateRuleAssertion.builder()
 *                         .assert(Fn.conditionContains(List.of("t2.micro", "t2.small"), Fn.ref("InstanceType")))
 *                         .description("For test environment, the instance type should be small")
 *                         .build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:45.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.CloudFormationRuleConstraintOptions")
@software.amazon.jsii.Jsii.Proxy(CloudFormationRuleConstraintOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationRuleConstraintOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions {

    /**
     * The rule with condition and assertions to apply to template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.TemplateRule getRule();

    /**
     * @return a {@link Builder} of {@link CloudFormationRuleConstraintOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationRuleConstraintOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationRuleConstraintOptions> {
        software.amazon.awscdk.services.servicecatalog.TemplateRule rule;
        java.lang.String description;
        software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;

        /**
         * Sets the value of {@link CloudFormationRuleConstraintOptions#getRule}
         * @param rule The rule with condition and assertions to apply to template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(software.amazon.awscdk.services.servicecatalog.TemplateRule rule) {
            this.rule = rule;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationRuleConstraintOptions#getDescription}
         * @param description The description of the constraint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationRuleConstraintOptions#getMessageLanguage}
         * @param messageLanguage The language code.
         *                        Configures the language for error messages from service catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.messageLanguage = messageLanguage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationRuleConstraintOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationRuleConstraintOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationRuleConstraintOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationRuleConstraintOptions {
        private final software.amazon.awscdk.services.servicecatalog.TemplateRule rule;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rule = software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.TemplateRule.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.messageLanguage = software.amazon.jsii.Kernel.get(this, "messageLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.MessageLanguage.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rule = java.util.Objects.requireNonNull(builder.rule, "rule is required");
            this.description = builder.description;
            this.messageLanguage = builder.messageLanguage;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.TemplateRule getRule() {
            return this.rule;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
            return this.messageLanguage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rule", om.valueToTree(this.getRule()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMessageLanguage() != null) {
                data.set("messageLanguage", om.valueToTree(this.getMessageLanguage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.CloudFormationRuleConstraintOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationRuleConstraintOptions.Jsii$Proxy that = (CloudFormationRuleConstraintOptions.Jsii$Proxy) o;

            if (!rule.equals(that.rule)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.messageLanguage != null ? this.messageLanguage.equals(that.messageLanguage) : that.messageLanguage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.rule.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.messageLanguage != null ? this.messageLanguage.hashCode() : 0);
            return result;
        }
    }
}
