package software.amazon.awscdk.services.servicediscovery;

/**
 * Basic props needed to create a service in a given namespace.
 * <p>
 * Used by HttpNamespace.createService
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * HttpNamespace namespace = HttpNamespace.Builder.create(stack, "MyNamespace")
 *         .name("MyHTTPNamespace")
 *         .build();
 * Service service1 = namespace.createService("NonIpService", BaseServiceProps.builder()
 *         .description("service registering non-ip instances")
 *         .build());
 * service1.registerNonIpInstance("NonIpInstance", NonIpInstanceBaseProps.builder()
 *         .customAttributes(Map.of("arn", "arn:aws:s3:::amzn-s3-demo-bucket"))
 *         .build());
 * Service service2 = namespace.createService("IpService", BaseServiceProps.builder()
 *         .description("service registering ip instances")
 *         .healthCheck(HealthCheckConfig.builder()
 *                 .type(HealthCheckType.HTTP)
 *                 .resourcePath("/check")
 *                 .build())
 *         .build());
 * service2.registerIpInstance("IpInstance", IpInstanceBaseProps.builder()
 *         .ipv4("54.239.25.192")
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:45.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.BaseServiceProps")
@software.amazon.jsii.Jsii.Proxy(BaseServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Structure containing failure threshold for a custom health checker.
     * <p>
     * Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
     * See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig getCustomHealthCheck() {
        return null;
    }

    /**
     * A description of the service.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Settings for an optional health check.
     * <p>
     * If you specify health check settings, AWS Cloud Map associates the health
     * check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
     * be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
     * this service.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.HealthCheckConfig getHealthCheck() {
        return null;
    }

    /**
     * A name for the Service.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseServiceProps> {
        software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        java.lang.String description;
        software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        java.lang.String name;

        /**
         * Sets the value of {@link BaseServiceProps#getCustomHealthCheck}
         * @param customHealthCheck Structure containing failure threshold for a custom health checker.
         *                          Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
         *                          See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHealthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck) {
            this.customHealthCheck = customHealthCheck;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceProps#getDescription}
         * @param description A description of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceProps#getHealthCheck}
         * @param healthCheck Settings for an optional health check.
         *                    If you specify health check settings, AWS Cloud Map associates the health
         *                    check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
         *                    be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
         *                    this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceProps#getName}
         * @param name A name for the Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseServiceProps {
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customHealthCheck = software.amazon.jsii.Kernel.get(this, "customHealthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.HealthCheckConfig.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customHealthCheck = builder.customHealthCheck;
            this.description = builder.description;
            this.healthCheck = builder.healthCheck;
            this.name = builder.name;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig getCustomHealthCheck() {
            return this.customHealthCheck;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCustomHealthCheck() != null) {
                data.set("customHealthCheck", om.valueToTree(this.getCustomHealthCheck()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.BaseServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseServiceProps.Jsii$Proxy that = (BaseServiceProps.Jsii$Proxy) o;

            if (this.customHealthCheck != null ? !this.customHealthCheck.equals(that.customHealthCheck) : that.customHealthCheck != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customHealthCheck != null ? this.customHealthCheck.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
