package software.amazon.awscdk.services.sns;

/**
 * The type of subscription, controlling the type of the endpoint parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * DeliveryStream stream;
 * Topic topic = new Topic(this, "Topic");
 * Subscription.Builder.create(this, "Subscription")
 *         .topic(topic)
 *         .endpoint(stream.getDeliveryStreamArn())
 *         .protocol(SubscriptionProtocol.FIREHOSE)
 *         .subscriptionRoleArn("SAMPLE_ARN")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.160Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.SubscriptionProtocol")
public enum SubscriptionProtocol {
    /**
     * JSON-encoded message is POSTED to an HTTP url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * JSON-encoded message is POSTed to an HTTPS url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
    /**
     * Notifications are sent via email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EMAIL,
    /**
     * Notifications are JSON-encoded and sent via mail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EMAIL_JSON,
    /**
     * Notification is delivered by SMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMS,
    /**
     * Notifications are enqueued into an SQS queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS,
    /**
     * JSON-encoded notifications are sent to a mobile app endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPLICATION,
    /**
     * Notifications trigger a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
    /**
     * Notifications put records into a firehose delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIREHOSE,
}
