package software.amazon.awscdk.services.sns.subscriptions;

/**
 * Use an Amazon Data Firehose delivery stream as a subscription target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * DeliveryStream stream;
 * Topic myTopic = new Topic(this, "Topic");
 * myTopic.addSubscription(new FirehoseSubscription(stream));
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.169Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns_subscriptions.FirehoseSubscription")
public class FirehoseSubscription extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sns.ITopicSubscription {

    protected FirehoseSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehoseSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param deliveryStream This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(deliveryStream, "deliveryStream is required"), props });
    }

    /**
     * @param deliveryStream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(deliveryStream, "deliveryStream is required") });
    }

    /**
     * Returns a configuration for a Lambda function to subscribe to an SNS topic.
     * <p>
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.TopicSubscriptionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.TopicSubscriptionConfig.class), new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param deliveryStream This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
            return new Builder(deliveryStream);
        }

        private final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream;
        private software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscriptionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        /**
         * Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        /**
         * The filter policy that is applied on the message body.
         * <p>
         * To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicyWithMessageBody(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.props().filterPolicyWithMessageBody(filterPolicyWithMessageBody);
            return this;
        }

        /**
         * Whether to remove any Amazon SNS metadata from published messages.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-large-payload-raw-message-delivery.html">https://docs.aws.amazon.com/sns/latest/dg/sns-large-payload-raw-message-delivery.html</a>
         * @param rawMessageDelivery Whether to remove any Amazon SNS metadata from published messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(final java.lang.Boolean rawMessageDelivery) {
            this.props().rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        /**
         * The role to assume to write messages to the Amazon Data Firehose delivery stream.
         * <p>
         * Default: - A new Role is created
         * <p>
         * @return {@code this}
         * @param role The role to assume to write messages to the Amazon Data Firehose delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscription build() {
            return new software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscription(
                this.deliveryStream,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}
