package software.amazon.awscdk.services.sqs;

/**
 * The permission type that defines which source queues can specify the current queue as the dead-letter queue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IQueue sourceQueue;
 * // Only the sourceQueue can specify this queue as the dead-letter queue.
 * Queue queue1 = Queue.Builder.create(this, "Queue2")
 *         .redriveAllowPolicy(RedriveAllowPolicy.builder()
 *                 .sourceQueues(List.of(sourceQueue))
 *                 .build())
 *         .build();
 * // No source queues can specify this queue as the dead-letter queue.
 * Queue queue2 = Queue.Builder.create(this, "Queue")
 *         .redriveAllowPolicy(RedriveAllowPolicy.builder()
 *                 .redrivePermission(RedrivePermission.DENY_ALL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.205Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.RedrivePermission")
public enum RedrivePermission {
    /**
     * Any source queues in this AWS account in the same Region can specify this queue as the dead-letter queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOW_ALL,
    /**
     * No source queues can specify this queue as the dead-letter queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DENY_ALL,
    /**
     * Only queues specified by the <code>sourceQueueArns</code> parameter can specify this queue as the dead-letter queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BY_QUEUE,
}
