package software.amazon.awscdk.services.ssmcontacts;

/**
 * Properties for defining a <code>CfnPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmcontacts.*;
 * CfnPlanProps cfnPlanProps = CfnPlanProps.builder()
 *         .contactId("contactId")
 *         // the properties below are optional
 *         .rotationIds(List.of("rotationIds"))
 *         .stages(List.of(StageProperty.builder()
 *                 .durationInMinutes(123)
 *                 // the properties below are optional
 *                 .targets(List.of(TargetsProperty.builder()
 *                         .channelTargetInfo(ChannelTargetInfoProperty.builder()
 *                                 .channelId("channelId")
 *                                 .retryIntervalInMinutes(123)
 *                                 .build())
 *                         .contactTargetInfo(ContactTargetInfoProperty.builder()
 *                                 .contactId("contactId")
 *                                 .isEssential(false)
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.282Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the contact.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-contactid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-contactid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContactId();

    /**
     * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-rotationids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-rotationids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRotationIds() {
        return null;
    }

    /**
     * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-stages</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStages() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPlanProps> {
        java.lang.String contactId;
        java.util.List<java.lang.String> rotationIds;
        java.lang.Object stages;

        /**
         * Sets the value of {@link CfnPlanProps#getContactId}
         * @param contactId The Amazon Resource Name (ARN) of the contact. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactId(java.lang.String contactId) {
            this.contactId = contactId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getRotationIds}
         * @param rotationIds The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationIds(java.util.List<java.lang.String> rotationIds) {
            this.rotationIds = rotationIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getStages}
         * @param stages A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(software.amazon.awscdk.IResolvable stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getStages}
         * @param stages A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(java.util.List<? extends java.lang.Object> stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPlanProps {
        private final java.lang.String contactId;
        private final java.util.List<java.lang.String> rotationIds;
        private final java.lang.Object stages;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contactId = software.amazon.jsii.Kernel.get(this, "contactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rotationIds = software.amazon.jsii.Kernel.get(this, "rotationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stages = software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contactId = java.util.Objects.requireNonNull(builder.contactId, "contactId is required");
            this.rotationIds = builder.rotationIds;
            this.stages = builder.stages;
        }

        @Override
        public final java.lang.String getContactId() {
            return this.contactId;
        }

        @Override
        public final java.util.List<java.lang.String> getRotationIds() {
            return this.rotationIds;
        }

        @Override
        public final java.lang.Object getStages() {
            return this.stages;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("contactId", om.valueToTree(this.getContactId()));
            if (this.getRotationIds() != null) {
                data.set("rotationIds", om.valueToTree(this.getRotationIds()));
            }
            if (this.getStages() != null) {
                data.set("stages", om.valueToTree(this.getStages()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPlanProps.Jsii$Proxy that = (CfnPlanProps.Jsii$Proxy) o;

            if (!contactId.equals(that.contactId)) return false;
            if (this.rotationIds != null ? !this.rotationIds.equals(that.rotationIds) : that.rotationIds != null) return false;
            return this.stages != null ? this.stages.equals(that.stages) : that.stages == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contactId.hashCode();
            result = 31 * result + (this.rotationIds != null ? this.rotationIds.hashCode() : 0);
            result = 31 * result + (this.stages != null ? this.stages.hashCode() : 0);
            return result;
        }
    }
}
