package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Wait state in the state machine.
 * <p>
 * A Wait state can be used to delay execution of the state machine for a while.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EvaluateExpression convertToSeconds = EvaluateExpression.Builder.create(this, "Convert to seconds")
 *         .expression("$.waitMilliseconds / 1000")
 *         .resultPath("$.waitSeconds")
 *         .build();
 * EvaluateExpression createMessage = EvaluateExpression.Builder.create(this, "Create message")
 *         // Note: this is a string inside a string.
 *         .expression("`Now waiting ${$.waitSeconds} seconds...`")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .resultPath("$.message")
 *         .build();
 * SnsPublish publishMessage = SnsPublish.Builder.create(this, "Publish message")
 *         .topic(new Topic(this, "cool-topic"))
 *         .message(TaskInput.fromJsonPathAt("$.message"))
 *         .resultPath("$.sns")
 *         .build();
 * Wait wait = Wait.Builder.create(this, "Wait")
 *         .time(WaitTime.secondsPath("$.waitSeconds"))
 *         .build();
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definition(convertToSeconds.next(createMessage).next(publishMessage).next(wait))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.497Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Wait")
public class Wait extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {

    protected Wait(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Wait(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Wait(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Define a Wait state using JSONata in the state machine.
     * <p>
     * A Wait state can be used to delay execution of the state machine for a while.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Wait jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitJsonataProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Wait.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Wait.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Define a Wait state using JSONPath in the state machine.
     * <p>
     * A Wait state can be used to delay execution of the state machine for a while.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Wait jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitJsonPathProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Wait.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Wait.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Chain.class), new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     * <p>
     * @param topLevelQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage topLevelQueryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class), new Object[] { topLevelQueryLanguage });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Wait}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Wait> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.WaitProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.WaitProps.Builder();
        }

        /**
         * A comment describing this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment A comment describing this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The name of the query language used by the state.
         * <p>
         * If the state does not contain a <code>queryLanguage</code> field,
         * then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * <p>
         * Default: - JSONPath
         * <p>
         * @return {@code this}
         * @param queryLanguage The name of the query language used by the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.props.queryLanguage(queryLanguage);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Workflow variables to store in this step.
         * <p>
         * Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * <p>
         * Default: - Not assign variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html</a>
         * @param assign Workflow variables to store in this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assign(final java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.props.assign(assign);
            return this;
        }

        /**
         * Wait duration.
         * <p>
         * @return {@code this}
         * @param time Wait duration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder time(final software.amazon.awscdk.services.stepfunctions.WaitTime time) {
            this.props.time(time);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Wait}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Wait build() {
            return new software.amazon.awscdk.services.stepfunctions.Wait(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
