package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for calling an AWS service's API action using JSONata from your state machine across regions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Object assign;
 * Object outputs;
 * Object parameters;
 * PolicyStatement policyStatement;
 * TaskRole taskRole;
 * Timeout timeout;
 * CallAwsServiceCrossRegionJsonataProps callAwsServiceCrossRegionJsonataProps = CallAwsServiceCrossRegionJsonataProps.builder()
 *         .action("action")
 *         .iamResources(List.of("iamResources"))
 *         .region("region")
 *         .service("service")
 *         // the properties below are optional
 *         .additionalIamStatements(List.of(policyStatement))
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .comment("comment")
 *         .credentials(Credentials.builder()
 *                 .role(taskRole)
 *                 .build())
 *         .endpoint("endpoint")
 *         .heartbeat(Duration.minutes(30))
 *         .heartbeatTimeout(timeout)
 *         .iamAction("iamAction")
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .outputs(outputs)
 *         .parameters(Map.of(
 *                 "parametersKey", parameters))
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .retryOnServiceExceptions(false)
 *         .stateName("stateName")
 *         .taskTimeout(timeout)
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.613Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CallAwsServiceCrossRegionJsonataProps")
@software.amazon.jsii.Jsii.Proxy(CallAwsServiceCrossRegionJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CallAwsServiceCrossRegionJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateJsonataBaseProps {

    /**
     * The API action to call.
     * <p>
     * Use camelCase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The resources for the IAM statement that will be added to the Lambda function role's policy to allow the state machine to make the API call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIamResources();

    /**
     * The AWS region to call this AWS API for.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "us-east-1";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * The AWS service to call in AWS SDK for JavaScript v3 format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "s3";
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/">https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * Additional IAM statements that will be added to the state machine role's policy.
     * <p>
     * Use in the case where the call requires more than a single statement to
     * be executed, e.g. <code>rekognition:detectLabels</code> requires also S3 permissions
     * to read the object on which it must act.
     * <p>
     * Default: - no additional statements are added
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getAdditionalIamStatements() {
        return null;
    }

    /**
     * The AWS API endpoint.
     * <p>
     * Default: Do not override API endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
        return null;
    }

    /**
     * The action for the IAM statement that will be added to the Lambda function role's policy to allow the state machine to make the API call.
     * <p>
     * By default the action for this IAM statement will be <code>service:action</code>.
     * <p>
     * Use in the case where the IAM action name does not match with the
     * API service/action name, e.g. <code>s3:ListBuckets</code> requires <code>s3:ListAllMyBuckets</code>.
     * <p>
     * Default: - service:action
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIamAction() {
        return null;
    }

    /**
     * Parameters for the API action call in AWS SDK for JavaScript v3 format.
     * <p>
     * Default: - no parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * Whether to retry on the backend Lambda service exceptions.
     * <p>
     * This handles <code>Lambda.ServiceException</code>, <code>Lambda.AWSLambdaException</code>,
     * <code>Lambda.SdkClientException</code>, and <code>Lambda.ClientExecutionTimeoutException</code>
     * with an interval of 2 seconds, a back-off rate
     * of 2 and 6 maximum attempts.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-lambda-serviceexception.html">https://docs.aws.amazon.com/step-functions/latest/dg/bp-lambda-serviceexception.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetryOnServiceExceptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CallAwsServiceCrossRegionJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CallAwsServiceCrossRegionJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CallAwsServiceCrossRegionJsonataProps> {
        java.lang.String action;
        java.util.List<java.lang.String> iamResources;
        java.lang.String region;
        java.lang.String service;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> additionalIamStatements;
        java.lang.String endpoint;
        java.lang.String iamAction;
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.Boolean retryOnServiceExceptions;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getAction}
         * @param action The API action to call. This parameter is required.
         *               Use camelCase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getIamResources}
         * @param iamResources The resources for the IAM statement that will be added to the Lambda function role's policy to allow the state machine to make the API call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamResources(java.util.List<java.lang.String> iamResources) {
            this.iamResources = iamResources;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getRegion}
         * @param region The AWS region to call this AWS API for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getService}
         * @param service The AWS service to call in AWS SDK for JavaScript v3 format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getAdditionalIamStatements}
         * @param additionalIamStatements Additional IAM statements that will be added to the state machine role's policy.
         *                                Use in the case where the call requires more than a single statement to
         *                                be executed, e.g. <code>rekognition:detectLabels</code> requires also S3 permissions
         *                                to read the object on which it must act.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalIamStatements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> additionalIamStatements) {
            this.additionalIamStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)additionalIamStatements;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getEndpoint}
         * @param endpoint The AWS API endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getIamAction}
         * @param iamAction The action for the IAM statement that will be added to the Lambda function role's policy to allow the state machine to make the API call.
         *                  By default the action for this IAM statement will be <code>service:action</code>.
         *                  <p>
         *                  Use in the case where the IAM action name does not match with the
         *                  API service/action name, e.g. <code>s3:ListBuckets</code> requires <code>s3:ListAllMyBuckets</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAction(java.lang.String iamAction) {
            this.iamAction = iamAction;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getParameters}
         * @param parameters Parameters for the API action call in AWS SDK for JavaScript v3 format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getRetryOnServiceExceptions}
         * @param retryOnServiceExceptions Whether to retry on the backend Lambda service exceptions.
         *                                 This handles <code>Lambda.ServiceException</code>, <code>Lambda.AWSLambdaException</code>,
         *                                 <code>Lambda.SdkClientException</code>, and <code>Lambda.ClientExecutionTimeoutException</code>
         *                                 with an interval of 2 seconds, a back-off rate
         *                                 of 2 and 6 maximum attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryOnServiceExceptions(java.lang.Boolean retryOnServiceExceptions) {
            this.retryOnServiceExceptions = retryOnServiceExceptions;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link CallAwsServiceCrossRegionJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CallAwsServiceCrossRegionJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CallAwsServiceCrossRegionJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CallAwsServiceCrossRegionJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CallAwsServiceCrossRegionJsonataProps {
        private final java.lang.String action;
        private final java.util.List<java.lang.String> iamResources;
        private final java.lang.String region;
        private final java.lang.String service;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> additionalIamStatements;
        private final java.lang.String endpoint;
        private final java.lang.String iamAction;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.Boolean retryOnServiceExceptions;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamResources = software.amazon.jsii.Kernel.get(this, "iamResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalIamStatements = software.amazon.jsii.Kernel.get(this, "additionalIamStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamAction = software.amazon.jsii.Kernel.get(this, "iamAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.retryOnServiceExceptions = software.amazon.jsii.Kernel.get(this, "retryOnServiceExceptions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.iamResources = java.util.Objects.requireNonNull(builder.iamResources, "iamResources is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.additionalIamStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.additionalIamStatements;
            this.endpoint = builder.endpoint;
            this.iamAction = builder.iamAction;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.retryOnServiceExceptions = builder.retryOnServiceExceptions;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.outputs = builder.outputs;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.util.List<java.lang.String> getIamResources() {
            return this.iamResources;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getAdditionalIamStatements() {
            return this.additionalIamStatements;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getIamAction() {
            return this.iamAction;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Boolean getRetryOnServiceExceptions() {
            return this.retryOnServiceExceptions;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("iamResources", om.valueToTree(this.getIamResources()));
            data.set("region", om.valueToTree(this.getRegion()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getAdditionalIamStatements() != null) {
                data.set("additionalIamStatements", om.valueToTree(this.getAdditionalIamStatements()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getIamAction() != null) {
                data.set("iamAction", om.valueToTree(this.getIamAction()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRetryOnServiceExceptions() != null) {
                data.set("retryOnServiceExceptions", om.valueToTree(this.getRetryOnServiceExceptions()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.CallAwsServiceCrossRegionJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CallAwsServiceCrossRegionJsonataProps.Jsii$Proxy that = (CallAwsServiceCrossRegionJsonataProps.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!iamResources.equals(that.iamResources)) return false;
            if (!region.equals(that.region)) return false;
            if (!service.equals(that.service)) return false;
            if (this.additionalIamStatements != null ? !this.additionalIamStatements.equals(that.additionalIamStatements) : that.additionalIamStatements != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.iamAction != null ? !this.iamAction.equals(that.iamAction) : that.iamAction != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.retryOnServiceExceptions != null ? !this.retryOnServiceExceptions.equals(that.retryOnServiceExceptions) : that.retryOnServiceExceptions != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.iamResources.hashCode());
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.additionalIamStatements != null ? this.additionalIamStatements.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.iamAction != null ? this.iamAction.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.retryOnServiceExceptions != null ? this.retryOnServiceExceptions.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
