package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for calling an AWS service's API action using JSONata from your state machine across regions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Object assign;
 * ConfigurationProperty configurationProperty_;
 * Object outputs;
 * Role role;
 * Size size;
 * TaskRole taskRole;
 * Timeout timeout;
 * EmrCreateClusterJsonataProps emrCreateClusterJsonataProps = EmrCreateClusterJsonataProps.builder()
 *         .instances(InstancesConfigProperty.builder()
 *                 .additionalMasterSecurityGroups(List.of("additionalMasterSecurityGroups"))
 *                 .additionalSlaveSecurityGroups(List.of("additionalSlaveSecurityGroups"))
 *                 .ec2KeyName("ec2KeyName")
 *                 .ec2SubnetId("ec2SubnetId")
 *                 .ec2SubnetIds(List.of("ec2SubnetIds"))
 *                 .emrManagedMasterSecurityGroup("emrManagedMasterSecurityGroup")
 *                 .emrManagedSlaveSecurityGroup("emrManagedSlaveSecurityGroup")
 *                 .hadoopVersion("hadoopVersion")
 *                 .instanceCount(123)
 *                 .instanceFleets(List.of(InstanceFleetConfigProperty.builder()
 *                         .instanceFleetType(EmrCreateCluster.getInstanceRoleType().MASTER)
 *                         // the properties below are optional
 *                         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 // the properties below are optional
 *                                 .bidPrice("bidPrice")
 *                                 .bidPriceAsPercentageOfOnDemandPrice(123)
 *                                 .configurations(List.of(ConfigurationProperty.builder()
 *                                         .classification("classification")
 *                                         .configurations(List.of(configurationProperty_))
 *                                         .properties(Map.of(
 *                                                 "propertiesKey", "properties"))
 *                                         .build()))
 *                                 .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                                 .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                         .volumeSize(size)
 *                                                         .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP3)
 *                                                         // the properties below are optional
 *                                                         .iops(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .volumesPerInstance(123)
 *                                                 .build()))
 *                                         .ebsOptimized(false)
 *                                         .build())
 *                                 .weightedCapacity(123)
 *                                 .build()))
 *                         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
 *                                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
 *                                         .allocationStrategy(EmrCreateCluster.getOnDemandAllocationStrategy().LOWEST_PRICE)
 *                                         .build())
 *                                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
 *                                         .timeoutAction(EmrCreateCluster.getSpotTimeoutAction().SWITCH_TO_ON_DEMAND)
 *                                         // the properties below are optional
 *                                         .allocationStrategy(EmrCreateCluster.getSpotAllocationStrategy().CAPACITY_OPTIMIZED)
 *                                         .blockDurationMinutes(123)
 *                                         .timeout(Duration.minutes(30))
 *                                         .timeoutDurationMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .name("name")
 *                         .targetOnDemandCapacity(123)
 *                         .targetSpotCapacity(123)
 *                         .build()))
 *                 .instanceGroups(List.of(InstanceGroupConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceRole(EmrCreateCluster.getInstanceRoleType().MASTER)
 *                         .instanceType("instanceType")
 *                         // the properties below are optional
 *                         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                                 .constraints(ScalingConstraintsProperty.builder()
 *                                         .maxCapacity(123)
 *                                         .minCapacity(123)
 *                                         .build())
 *                                 .rules(List.of(ScalingRuleProperty.builder()
 *                                         .action(ScalingActionProperty.builder()
 *                                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
 *                                                         .scalingAdjustment(123)
 *                                                         // the properties below are optional
 *                                                         .adjustmentType(EmrCreateCluster.getScalingAdjustmentType().CHANGE_IN_CAPACITY)
 *                                                         .coolDown(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
 *                                                 .build())
 *                                         .name("name")
 *                                         .trigger(ScalingTriggerProperty.builder()
 *                                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
 *                                                         .comparisonOperator(EmrCreateCluster.getCloudWatchAlarmComparisonOperator().GREATER_THAN_OR_EQUAL)
 *                                                         .metricName("metricName")
 *                                                         .period(Duration.minutes(30))
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .key("key")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .evaluationPeriods(123)
 *                                                         .namespace("namespace")
 *                                                         .statistic(EmrCreateCluster.getCloudWatchAlarmStatistic().SAMPLE_COUNT)
 *                                                         .threshold(123)
 *                                                         .unit(EmrCreateCluster.getCloudWatchAlarmUnit().NONE)
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .description("description")
 *                                         .build()))
 *                                 .build())
 *                         .bidPrice("bidPrice")
 *                         .configurations(List.of(ConfigurationProperty.builder()
 *                                 .classification("classification")
 *                                 .configurations(List.of(configurationProperty_))
 *                                 .properties(Map.of(
 *                                         "propertiesKey", "properties"))
 *                                 .build()))
 *                         .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                 .volumeSize(size)
 *                                                 .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP3)
 *                                                 // the properties below are optional
 *                                                 .iops(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .volumesPerInstance(123)
 *                                         .build()))
 *                                 .ebsOptimized(false)
 *                                 .build())
 *                         .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
 *                         .name("name")
 *                         .build()))
 *                 .masterInstanceType("masterInstanceType")
 *                 .placement(PlacementTypeProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .availabilityZones(List.of("availabilityZones"))
 *                         .build())
 *                 .serviceAccessSecurityGroup("serviceAccessSecurityGroup")
 *                 .slaveInstanceType("slaveInstanceType")
 *                 .terminationProtected(false)
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .additionalInfo("additionalInfo")
 *         .applications(List.of(ApplicationConfigProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .additionalInfo(Map.of(
 *                         "additionalInfoKey", "additionalInfo"))
 *                 .args(List.of("args"))
 *                 .version("version")
 *                 .build()))
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .autoScalingRole(role)
 *         .autoTerminationPolicyIdleTimeout(Duration.minutes(30))
 *         .bootstrapActions(List.of(BootstrapActionConfigProperty.builder()
 *                 .name("name")
 *                 .scriptBootstrapAction(ScriptBootstrapActionConfigProperty.builder()
 *                         .path("path")
 *                         // the properties below are optional
 *                         .args(List.of("args"))
 *                         .build())
 *                 .build()))
 *         .clusterRole(role)
 *         .comment("comment")
 *         .configurations(List.of(ConfigurationProperty.builder()
 *                 .classification("classification")
 *                 .configurations(List.of(configurationProperty_))
 *                 .properties(Map.of(
 *                         "propertiesKey", "properties"))
 *                 .build()))
 *         .credentials(Credentials.builder()
 *                 .role(taskRole)
 *                 .build())
 *         .customAmiId("customAmiId")
 *         .ebsRootVolumeSize(size)
 *         .heartbeat(Duration.minutes(30))
 *         .heartbeatTimeout(timeout)
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .kerberosAttributes(KerberosAttributesProperty.builder()
 *                 .realm("realm")
 *                 // the properties below are optional
 *                 .adDomainJoinPassword("adDomainJoinPassword")
 *                 .adDomainJoinUser("adDomainJoinUser")
 *                 .crossRealmTrustPrincipalPassword("crossRealmTrustPrincipalPassword")
 *                 .kdcAdminPassword("kdcAdminPassword")
 *                 .build())
 *         .logUri("logUri")
 *         .outputs(outputs)
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .releaseLabel("releaseLabel")
 *         .scaleDownBehavior(EmrCreateCluster.getEmrClusterScaleDownBehavior().TERMINATE_AT_INSTANCE_HOUR)
 *         .securityConfiguration("securityConfiguration")
 *         .serviceRole(role)
 *         .stateName("stateName")
 *         .stepConcurrencyLevel(123)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .taskTimeout(timeout)
 *         .timeout(Duration.minutes(30))
 *         .visibleToAllUsers(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:46.779Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateClusterJsonataProps")
@software.amazon.jsii.Jsii.Proxy(EmrCreateClusterJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmrCreateClusterJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateJsonataBaseProps {

    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty getInstances();

    /**
     * The Name of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A JSON string for selecting additional features.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalInfo() {
        return null;
    }

    /**
     * A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> getApplications() {
        return null;
    }

    /**
     * An IAM role for automatic scaling policies.
     * <p>
     * Default: - A role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
        return null;
    }

    /**
     * The amount of idle time after which the cluster automatically terminates.
     * <p>
     * You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).
     * <p>
     * Default: - No timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutoTerminationPolicyIdleTimeout() {
        return null;
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> getBootstrapActions() {
        return null;
    }

    /**
     * Also called instance profile and EC2 role.
     * <p>
     * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
     * <p>
     * This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
     * <p>
     * Default: - * A Role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getClusterRole() {
        return null;
    }

    /**
     * The list of configurations supplied for the EMR cluster you are creating.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
        return null;
    }

    /**
     * The ID of a custom Amazon EBS-backed Linux AMI.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return null;
    }

    /**
     * The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getEbsRootVolumeSize() {
        return null;
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty getKerberosAttributes() {
        return null;
    }

    /**
     * The location in Amazon S3 to write the log files of the job flow.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
        return null;
    }

    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseLabel() {
        return null;
    }

    /**
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior getScaleDownBehavior() {
        return null;
    }

    /**
     * The name of a security configuration to apply to the cluster.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
     * <p>
     * Default: - A role will be created that Amazon EMR service can assume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return null;
    }

    /**
     * Specifies the step concurrency level to allow multiple steps to run in parallel.
     * <p>
     * Requires EMR release label 5.28.0 or above.
     * Must be in range [1, 256].
     * <p>
     * Default: 1 - no step concurrency allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStepConcurrencyLevel() {
        return null;
    }

    /**
     * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVisibleToAllUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmrCreateClusterJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmrCreateClusterJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmrCreateClusterJsonataProps> {
        software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances;
        java.lang.String name;
        java.lang.String additionalInfo;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications;
        software.amazon.awscdk.services.iam.IRole autoScalingRole;
        software.amazon.awscdk.Duration autoTerminationPolicyIdleTimeout;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions;
        software.amazon.awscdk.services.iam.IRole clusterRole;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
        java.lang.String customAmiId;
        software.amazon.awscdk.Size ebsRootVolumeSize;
        software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes;
        java.lang.String logUri;
        java.lang.String releaseLabel;
        software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior;
        java.lang.String securityConfiguration;
        software.amazon.awscdk.services.iam.IRole serviceRole;
        java.lang.Number stepConcurrencyLevel;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Boolean visibleToAllUsers;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getInstances}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getName}
         * @param name The Name of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getAdditionalInfo}
         * @param additionalInfo A JSON string for selecting additional features.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInfo(java.lang.String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getApplications}
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder applications(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications) {
            this.applications = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty>)applications;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getAutoScalingRole}
         * @param autoScalingRole An IAM role for automatic scaling policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingRole(software.amazon.awscdk.services.iam.IRole autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getAutoTerminationPolicyIdleTimeout}
         * @param autoTerminationPolicyIdleTimeout The amount of idle time after which the cluster automatically terminates.
         *                                         You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoTerminationPolicyIdleTimeout(software.amazon.awscdk.Duration autoTerminationPolicyIdleTimeout) {
            this.autoTerminationPolicyIdleTimeout = autoTerminationPolicyIdleTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getBootstrapActions}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder bootstrapActions(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions) {
            this.bootstrapActions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty>)bootstrapActions;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getClusterRole}
         * @param clusterRole Also called instance profile and EC2 role.
         *                    An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
         *                    <p>
         *                    This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterRole(software.amazon.awscdk.services.iam.IRole clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getConfigurations}
         * @param configurations The list of configurations supplied for the EMR cluster you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
            this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getCustomAmiId}
         * @param customAmiId The ID of a custom Amazon EBS-backed Linux AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAmiId(java.lang.String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getEbsRootVolumeSize}
         * @param ebsRootVolumeSize The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsRootVolumeSize(software.amazon.awscdk.Size ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getKerberosAttributes}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosAttributes(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getLogUri}
         * @param logUri The location in Amazon S3 to write the log files of the job flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logUri(java.lang.String logUri) {
            this.logUri = logUri;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getReleaseLabel}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(java.lang.String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getScaleDownBehavior}
         * @param scaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDownBehavior(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getSecurityConfiguration}
         * @param securityConfiguration The name of a security configuration to apply to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getServiceRole}
         * @param serviceRole The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getStepConcurrencyLevel}
         * @param stepConcurrencyLevel Specifies the step concurrency level to allow multiple steps to run in parallel.
         *                             Requires EMR release label 5.28.0 or above.
         *                             Must be in range [1, 256].
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepConcurrencyLevel(java.lang.Number stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getTags}
         * @param tags A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getVisibleToAllUsers}
         * @param visibleToAllUsers A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibleToAllUsers(java.lang.Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmrCreateClusterJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmrCreateClusterJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmrCreateClusterJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmrCreateClusterJsonataProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances;
        private final java.lang.String name;
        private final java.lang.String additionalInfo;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications;
        private final software.amazon.awscdk.services.iam.IRole autoScalingRole;
        private final software.amazon.awscdk.Duration autoTerminationPolicyIdleTimeout;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions;
        private final software.amazon.awscdk.services.iam.IRole clusterRole;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
        private final java.lang.String customAmiId;
        private final software.amazon.awscdk.Size ebsRootVolumeSize;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes;
        private final java.lang.String logUri;
        private final java.lang.String releaseLabel;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior;
        private final java.lang.String securityConfiguration;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;
        private final java.lang.Number stepConcurrencyLevel;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean visibleToAllUsers;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalInfo = software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applications = software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty.class)));
            this.autoScalingRole = software.amazon.jsii.Kernel.get(this, "autoScalingRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.autoTerminationPolicyIdleTimeout = software.amazon.jsii.Kernel.get(this, "autoTerminationPolicyIdleTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.bootstrapActions = software.amazon.jsii.Kernel.get(this, "bootstrapActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty.class)));
            this.clusterRole = software.amazon.jsii.Kernel.get(this, "clusterRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
            this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsRootVolumeSize = software.amazon.jsii.Kernel.get(this, "ebsRootVolumeSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.kerberosAttributes = software.amazon.jsii.Kernel.get(this, "kerberosAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty.class));
            this.logUri = software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseLabel = software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleDownBehavior = software.amazon.jsii.Kernel.get(this, "scaleDownBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior.class));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.stepConcurrencyLevel = software.amazon.jsii.Kernel.get(this, "stepConcurrencyLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.visibleToAllUsers = software.amazon.jsii.Kernel.get(this, "visibleToAllUsers", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instances = java.util.Objects.requireNonNull(builder.instances, "instances is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.additionalInfo = builder.additionalInfo;
            this.applications = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty>)builder.applications;
            this.autoScalingRole = builder.autoScalingRole;
            this.autoTerminationPolicyIdleTimeout = builder.autoTerminationPolicyIdleTimeout;
            this.bootstrapActions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty>)builder.bootstrapActions;
            this.clusterRole = builder.clusterRole;
            this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)builder.configurations;
            this.customAmiId = builder.customAmiId;
            this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
            this.kerberosAttributes = builder.kerberosAttributes;
            this.logUri = builder.logUri;
            this.releaseLabel = builder.releaseLabel;
            this.scaleDownBehavior = builder.scaleDownBehavior;
            this.securityConfiguration = builder.securityConfiguration;
            this.serviceRole = builder.serviceRole;
            this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
            this.tags = builder.tags;
            this.visibleToAllUsers = builder.visibleToAllUsers;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.outputs = builder.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty getInstances() {
            return this.instances;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> getApplications() {
            return this.applications;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutoTerminationPolicyIdleTimeout() {
            return this.autoTerminationPolicyIdleTimeout;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> getBootstrapActions() {
            return this.bootstrapActions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getClusterRole() {
            return this.clusterRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final java.lang.String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final software.amazon.awscdk.Size getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty getKerberosAttributes() {
            return this.kerberosAttributes;
        }

        @Override
        public final java.lang.String getLogUri() {
            return this.logUri;
        }

        @Override
        public final java.lang.String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final java.lang.Number getStepConcurrencyLevel() {
            return this.stepConcurrencyLevel;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instances", om.valueToTree(this.getInstances()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAdditionalInfo() != null) {
                data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
            }
            if (this.getApplications() != null) {
                data.set("applications", om.valueToTree(this.getApplications()));
            }
            if (this.getAutoScalingRole() != null) {
                data.set("autoScalingRole", om.valueToTree(this.getAutoScalingRole()));
            }
            if (this.getAutoTerminationPolicyIdleTimeout() != null) {
                data.set("autoTerminationPolicyIdleTimeout", om.valueToTree(this.getAutoTerminationPolicyIdleTimeout()));
            }
            if (this.getBootstrapActions() != null) {
                data.set("bootstrapActions", om.valueToTree(this.getBootstrapActions()));
            }
            if (this.getClusterRole() != null) {
                data.set("clusterRole", om.valueToTree(this.getClusterRole()));
            }
            if (this.getConfigurations() != null) {
                data.set("configurations", om.valueToTree(this.getConfigurations()));
            }
            if (this.getCustomAmiId() != null) {
                data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
            }
            if (this.getEbsRootVolumeSize() != null) {
                data.set("ebsRootVolumeSize", om.valueToTree(this.getEbsRootVolumeSize()));
            }
            if (this.getKerberosAttributes() != null) {
                data.set("kerberosAttributes", om.valueToTree(this.getKerberosAttributes()));
            }
            if (this.getLogUri() != null) {
                data.set("logUri", om.valueToTree(this.getLogUri()));
            }
            if (this.getReleaseLabel() != null) {
                data.set("releaseLabel", om.valueToTree(this.getReleaseLabel()));
            }
            if (this.getScaleDownBehavior() != null) {
                data.set("scaleDownBehavior", om.valueToTree(this.getScaleDownBehavior()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            if (this.getStepConcurrencyLevel() != null) {
                data.set("stepConcurrencyLevel", om.valueToTree(this.getStepConcurrencyLevel()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisibleToAllUsers() != null) {
                data.set("visibleToAllUsers", om.valueToTree(this.getVisibleToAllUsers()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateClusterJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmrCreateClusterJsonataProps.Jsii$Proxy that = (EmrCreateClusterJsonataProps.Jsii$Proxy) o;

            if (!instances.equals(that.instances)) return false;
            if (!name.equals(that.name)) return false;
            if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
            if (this.applications != null ? !this.applications.equals(that.applications) : that.applications != null) return false;
            if (this.autoScalingRole != null ? !this.autoScalingRole.equals(that.autoScalingRole) : that.autoScalingRole != null) return false;
            if (this.autoTerminationPolicyIdleTimeout != null ? !this.autoTerminationPolicyIdleTimeout.equals(that.autoTerminationPolicyIdleTimeout) : that.autoTerminationPolicyIdleTimeout != null) return false;
            if (this.bootstrapActions != null ? !this.bootstrapActions.equals(that.bootstrapActions) : that.bootstrapActions != null) return false;
            if (this.clusterRole != null ? !this.clusterRole.equals(that.clusterRole) : that.clusterRole != null) return false;
            if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
            if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
            if (this.ebsRootVolumeSize != null ? !this.ebsRootVolumeSize.equals(that.ebsRootVolumeSize) : that.ebsRootVolumeSize != null) return false;
            if (this.kerberosAttributes != null ? !this.kerberosAttributes.equals(that.kerberosAttributes) : that.kerberosAttributes != null) return false;
            if (this.logUri != null ? !this.logUri.equals(that.logUri) : that.logUri != null) return false;
            if (this.releaseLabel != null ? !this.releaseLabel.equals(that.releaseLabel) : that.releaseLabel != null) return false;
            if (this.scaleDownBehavior != null ? !this.scaleDownBehavior.equals(that.scaleDownBehavior) : that.scaleDownBehavior != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (this.stepConcurrencyLevel != null ? !this.stepConcurrencyLevel.equals(that.stepConcurrencyLevel) : that.stepConcurrencyLevel != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.visibleToAllUsers != null ? !this.visibleToAllUsers.equals(that.visibleToAllUsers) : that.visibleToAllUsers != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instances.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
            result = 31 * result + (this.applications != null ? this.applications.hashCode() : 0);
            result = 31 * result + (this.autoScalingRole != null ? this.autoScalingRole.hashCode() : 0);
            result = 31 * result + (this.autoTerminationPolicyIdleTimeout != null ? this.autoTerminationPolicyIdleTimeout.hashCode() : 0);
            result = 31 * result + (this.bootstrapActions != null ? this.bootstrapActions.hashCode() : 0);
            result = 31 * result + (this.clusterRole != null ? this.clusterRole.hashCode() : 0);
            result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
            result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
            result = 31 * result + (this.ebsRootVolumeSize != null ? this.ebsRootVolumeSize.hashCode() : 0);
            result = 31 * result + (this.kerberosAttributes != null ? this.kerberosAttributes.hashCode() : 0);
            result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
            result = 31 * result + (this.releaseLabel != null ? this.releaseLabel.hashCode() : 0);
            result = 31 * result + (this.scaleDownBehavior != null ? this.scaleDownBehavior.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.stepConcurrencyLevel != null ? this.stepConcurrencyLevel.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visibleToAllUsers != null ? this.visibleToAllUsers.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
