package software.amazon.awscdk.services.timestream;

/**
 * Create a scheduled query that will be run on your behalf at the configured schedule.
 * <p>
 * Timestream assumes the execution role provided as part of the <code>ScheduledQueryExecutionRoleArn</code> parameter to run the query. You can use the <code>NotificationConfiguration</code> parameter to configure notification for your scheduled query operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.timestream.*;
 * CfnScheduledQuery cfnScheduledQuery = CfnScheduledQuery.Builder.create(this, "MyCfnScheduledQuery")
 *         .errorReportConfiguration(ErrorReportConfigurationProperty.builder()
 *                 .s3Configuration(S3ConfigurationProperty.builder()
 *                         .bucketName("bucketName")
 *                         // the properties below are optional
 *                         .encryptionOption("encryptionOption")
 *                         .objectKeyPrefix("objectKeyPrefix")
 *                         .build())
 *                 .build())
 *         .notificationConfiguration(NotificationConfigurationProperty.builder()
 *                 .snsConfiguration(SnsConfigurationProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .build())
 *         .queryString("queryString")
 *         .scheduleConfiguration(ScheduleConfigurationProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .scheduledQueryExecutionRoleArn("scheduledQueryExecutionRoleArn")
 *         // the properties below are optional
 *         .clientToken("clientToken")
 *         .kmsKeyId("kmsKeyId")
 *         .scheduledQueryName("scheduledQueryName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetConfiguration(TargetConfigurationProperty.builder()
 *                 .timestreamConfiguration(TimestreamConfigurationProperty.builder()
 *                         .databaseName("databaseName")
 *                         .dimensionMappings(List.of(DimensionMappingProperty.builder()
 *                                 .dimensionValueType("dimensionValueType")
 *                                 .name("name")
 *                                 .build()))
 *                         .tableName("tableName")
 *                         .timeColumn("timeColumn")
 *                         // the properties below are optional
 *                         .measureNameColumn("measureNameColumn")
 *                         .mixedMeasureMappings(List.of(MixedMeasureMappingProperty.builder()
 *                                 .measureValueType("measureValueType")
 *                                 // the properties below are optional
 *                                 .measureName("measureName")
 *                                 .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
 *                                         .measureValueType("measureValueType")
 *                                         .sourceColumn("sourceColumn")
 *                                         // the properties below are optional
 *                                         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
 *                                         .build()))
 *                                 .sourceColumn("sourceColumn")
 *                                 .targetMeasureName("targetMeasureName")
 *                                 .build()))
 *                         .multiMeasureMappings(MultiMeasureMappingsProperty.builder()
 *                                 .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
 *                                         .measureValueType("measureValueType")
 *                                         .sourceColumn("sourceColumn")
 *                                         // the properties below are optional
 *                                         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .targetMultiMeasureName("targetMultiMeasureName")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:47.055Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery")
public class CfnScheduledQuery extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnScheduledQuery(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScheduledQuery(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.timestream.CfnScheduledQuery.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScheduledQuery(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnScheduledQueryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The <code>ARN</code> of the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduled query error reporting configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqErrorReportConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "attrSqErrorReportConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The KMS key used to encrypt the query resource, if a customer managed KMS key was provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "attrSqKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduled query name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqName() {
        return software.amazon.jsii.Kernel.get(this, "attrSqName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduled query notification configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqNotificationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "attrSqNotificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduled query string..
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqQueryString() {
        return software.amazon.jsii.Kernel.get(this, "attrSqQueryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduled query schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqScheduleConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "attrSqScheduleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that will be used by Timestream to run the query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqScheduledQueryExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSqScheduledQueryExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The configuration for query output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSqTargetConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "attrSqTargetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Configuration for error reporting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getErrorReportConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "errorReportConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for error reporting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrorReportConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "errorReportConfiguration", java.util.Objects.requireNonNull(value, "errorReportConfiguration is required"));
    }

    /**
     * Configuration for error reporting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrorReportConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnScheduledQuery.ErrorReportConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "errorReportConfiguration", java.util.Objects.requireNonNull(value, "errorReportConfiguration is required"));
    }

    /**
     * Notification configuration for the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getNotificationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Notification configuration for the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", java.util.Objects.requireNonNull(value, "notificationConfiguration is required"));
    }

    /**
     * Notification configuration for the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnScheduledQuery.NotificationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", java.util.Objects.requireNonNull(value, "notificationConfiguration is required"));
    }

    /**
     * The query string to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getQueryString() {
        return software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The query string to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryString(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "queryString", java.util.Objects.requireNonNull(value, "queryString is required"));
    }

    /**
     * Schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getScheduleConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "scheduleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scheduleConfiguration", java.util.Objects.requireNonNull(value, "scheduleConfiguration is required"));
    }

    /**
     * Schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnScheduledQuery.ScheduleConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "scheduleConfiguration", java.util.Objects.requireNonNull(value, "scheduleConfiguration is required"));
    }

    /**
     * The ARN for the IAM role that Timestream will assume when running the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduledQueryExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "scheduledQueryExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the IAM role that Timestream will assume when running the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledQueryExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduledQueryExecutionRoleArn", java.util.Objects.requireNonNull(value, "scheduledQueryExecutionRoleArn is required"));
    }

    /**
     * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientToken", value);
    }

    /**
     * The Amazon KMS key used to encrypt the scheduled query resource, at-rest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon KMS key used to encrypt the scheduled query resource, at-rest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * A name for the query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduledQueryName() {
        return software.amazon.jsii.Kernel.get(this, "scheduledQueryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledQueryName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduledQueryName", value);
    }

    /**
     * A list of key-value pairs to label the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs to label the scheduled query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Scheduled query target store configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Scheduled query target store configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetConfiguration", value);
    }

    /**
     * Scheduled query target store configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.timestream.CfnScheduledQuery.TargetConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetConfiguration", value);
    }
    /**
     * This type is used to map column(s) from the query result to a dimension in the destination table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * DimensionMappingProperty dimensionMappingProperty = DimensionMappingProperty.builder()
     *         .dimensionValueType("dimensionValueType")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-dimensionmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-dimensionmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.DimensionMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Type for the dimension: VARCHAR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-dimensionmapping.html#cfn-timestream-scheduledquery-dimensionmapping-dimensionvaluetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-dimensionmapping.html#cfn-timestream-scheduledquery-dimensionmapping-dimensionvaluetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionValueType();

        /**
         * Column name from query result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-dimensionmapping.html#cfn-timestream-scheduledquery-dimensionmapping-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-dimensionmapping.html#cfn-timestream-scheduledquery-dimensionmapping-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link DimensionMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionMappingProperty> {
            java.lang.String dimensionValueType;
            java.lang.String name;

            /**
             * Sets the value of {@link DimensionMappingProperty#getDimensionValueType}
             * @param dimensionValueType Type for the dimension: VARCHAR. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionValueType(java.lang.String dimensionValueType) {
                this.dimensionValueType = dimensionValueType;
                return this;
            }

            /**
             * Sets the value of {@link DimensionMappingProperty#getName}
             * @param name Column name from query result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionMappingProperty {
            private final java.lang.String dimensionValueType;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionValueType = software.amazon.jsii.Kernel.get(this, "dimensionValueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionValueType = java.util.Objects.requireNonNull(builder.dimensionValueType, "dimensionValueType is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getDimensionValueType() {
                return this.dimensionValueType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionValueType", om.valueToTree(this.getDimensionValueType()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.DimensionMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionMappingProperty.Jsii$Proxy that = (DimensionMappingProperty.Jsii$Proxy) o;

                if (!dimensionValueType.equals(that.dimensionValueType)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionValueType.hashCode();
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration required for error reporting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * ErrorReportConfigurationProperty errorReportConfigurationProperty = ErrorReportConfigurationProperty.builder()
     *         .s3Configuration(S3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .encryptionOption("encryptionOption")
     *                 .objectKeyPrefix("objectKeyPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-errorreportconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-errorreportconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.ErrorReportConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ErrorReportConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ErrorReportConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 configuration for the error reports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-errorreportconfiguration.html#cfn-timestream-scheduledquery-errorreportconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-errorreportconfiguration.html#cfn-timestream-scheduledquery-errorreportconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * @return a {@link Builder} of {@link ErrorReportConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ErrorReportConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ErrorReportConfigurationProperty> {
            java.lang.Object s3Configuration;

            /**
             * Sets the value of {@link ErrorReportConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 configuration for the error reports. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ErrorReportConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 configuration for the error reports. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.S3ConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ErrorReportConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ErrorReportConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ErrorReportConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ErrorReportConfigurationProperty {
            private final java.lang.Object s3Configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.ErrorReportConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ErrorReportConfigurationProperty.Jsii$Proxy that = (ErrorReportConfigurationProperty.Jsii$Proxy) o;

                return this.s3Configuration.equals(that.s3Configuration);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Configuration.hashCode();
                return result;
            }
        }
    }
    /**
     * MixedMeasureMappings are mappings that can be used to ingest data into a mixture of narrow and multi measures in the derived table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MixedMeasureMappingProperty mixedMeasureMappingProperty = MixedMeasureMappingProperty.builder()
     *         .measureValueType("measureValueType")
     *         // the properties below are optional
     *         .measureName("measureName")
     *         .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
     *                 .measureValueType("measureValueType")
     *                 .sourceColumn("sourceColumn")
     *                 // the properties below are optional
     *                 .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *                 .build()))
     *         .sourceColumn("sourceColumn")
     *         .targetMeasureName("targetMeasureName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.MixedMeasureMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(MixedMeasureMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MixedMeasureMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Type of the value that is to be read from sourceColumn.
         * <p>
         * If the mapping is for MULTI, use MeasureValueType.MULTI.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-measurevaluetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-measurevaluetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMeasureValueType();

        /**
         * Refers to the value of measure_name in a result row.
         * <p>
         * This field is required if MeasureNameColumn is provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-measurename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-measurename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMeasureName() {
            return null;
        }

        /**
         * Required when measureValueType is MULTI.
         * <p>
         * Attribute mappings for MULTI value measures.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-multimeasureattributemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-multimeasureattributemappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiMeasureAttributeMappings() {
            return null;
        }

        /**
         * This field refers to the source column from which measure-value is to be read for result materialization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-sourcecolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-sourcecolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceColumn() {
            return null;
        }

        /**
         * Target measure name to be used.
         * <p>
         * If not provided, the target measure name by default would be measure-name if provided, or sourceColumn otherwise.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-targetmeasurename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-mixedmeasuremapping.html#cfn-timestream-scheduledquery-mixedmeasuremapping-targetmeasurename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetMeasureName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MixedMeasureMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MixedMeasureMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MixedMeasureMappingProperty> {
            java.lang.String measureValueType;
            java.lang.String measureName;
            java.lang.Object multiMeasureAttributeMappings;
            java.lang.String sourceColumn;
            java.lang.String targetMeasureName;

            /**
             * Sets the value of {@link MixedMeasureMappingProperty#getMeasureValueType}
             * @param measureValueType Type of the value that is to be read from sourceColumn. This parameter is required.
             *                         If the mapping is for MULTI, use MeasureValueType.MULTI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureValueType(java.lang.String measureValueType) {
                this.measureValueType = measureValueType;
                return this;
            }

            /**
             * Sets the value of {@link MixedMeasureMappingProperty#getMeasureName}
             * @param measureName Refers to the value of measure_name in a result row.
             *                    This field is required if MeasureNameColumn is provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureName(java.lang.String measureName) {
                this.measureName = measureName;
                return this;
            }

            /**
             * Sets the value of {@link MixedMeasureMappingProperty#getMultiMeasureAttributeMappings}
             * @param multiMeasureAttributeMappings Required when measureValueType is MULTI.
             *                                      Attribute mappings for MULTI value measures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiMeasureAttributeMappings(software.amazon.awscdk.IResolvable multiMeasureAttributeMappings) {
                this.multiMeasureAttributeMappings = multiMeasureAttributeMappings;
                return this;
            }

            /**
             * Sets the value of {@link MixedMeasureMappingProperty#getMultiMeasureAttributeMappings}
             * @param multiMeasureAttributeMappings Required when measureValueType is MULTI.
             *                                      Attribute mappings for MULTI value measures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiMeasureAttributeMappings(java.util.List<? extends java.lang.Object> multiMeasureAttributeMappings) {
                this.multiMeasureAttributeMappings = multiMeasureAttributeMappings;
                return this;
            }

            /**
             * Sets the value of {@link MixedMeasureMappingProperty#getSourceColumn}
             * @param sourceColumn This field refers to the source column from which measure-value is to be read for result materialization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumn(java.lang.String sourceColumn) {
                this.sourceColumn = sourceColumn;
                return this;
            }

            /**
             * Sets the value of {@link MixedMeasureMappingProperty#getTargetMeasureName}
             * @param targetMeasureName Target measure name to be used.
             *                          If not provided, the target measure name by default would be measure-name if provided, or sourceColumn otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetMeasureName(java.lang.String targetMeasureName) {
                this.targetMeasureName = targetMeasureName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MixedMeasureMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MixedMeasureMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MixedMeasureMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MixedMeasureMappingProperty {
            private final java.lang.String measureValueType;
            private final java.lang.String measureName;
            private final java.lang.Object multiMeasureAttributeMappings;
            private final java.lang.String sourceColumn;
            private final java.lang.String targetMeasureName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.measureValueType = software.amazon.jsii.Kernel.get(this, "measureValueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.measureName = software.amazon.jsii.Kernel.get(this, "measureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.multiMeasureAttributeMappings = software.amazon.jsii.Kernel.get(this, "multiMeasureAttributeMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceColumn = software.amazon.jsii.Kernel.get(this, "sourceColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetMeasureName = software.amazon.jsii.Kernel.get(this, "targetMeasureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.measureValueType = java.util.Objects.requireNonNull(builder.measureValueType, "measureValueType is required");
                this.measureName = builder.measureName;
                this.multiMeasureAttributeMappings = builder.multiMeasureAttributeMappings;
                this.sourceColumn = builder.sourceColumn;
                this.targetMeasureName = builder.targetMeasureName;
            }

            @Override
            public final java.lang.String getMeasureValueType() {
                return this.measureValueType;
            }

            @Override
            public final java.lang.String getMeasureName() {
                return this.measureName;
            }

            @Override
            public final java.lang.Object getMultiMeasureAttributeMappings() {
                return this.multiMeasureAttributeMappings;
            }

            @Override
            public final java.lang.String getSourceColumn() {
                return this.sourceColumn;
            }

            @Override
            public final java.lang.String getTargetMeasureName() {
                return this.targetMeasureName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("measureValueType", om.valueToTree(this.getMeasureValueType()));
                if (this.getMeasureName() != null) {
                    data.set("measureName", om.valueToTree(this.getMeasureName()));
                }
                if (this.getMultiMeasureAttributeMappings() != null) {
                    data.set("multiMeasureAttributeMappings", om.valueToTree(this.getMultiMeasureAttributeMappings()));
                }
                if (this.getSourceColumn() != null) {
                    data.set("sourceColumn", om.valueToTree(this.getSourceColumn()));
                }
                if (this.getTargetMeasureName() != null) {
                    data.set("targetMeasureName", om.valueToTree(this.getTargetMeasureName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.MixedMeasureMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MixedMeasureMappingProperty.Jsii$Proxy that = (MixedMeasureMappingProperty.Jsii$Proxy) o;

                if (!measureValueType.equals(that.measureValueType)) return false;
                if (this.measureName != null ? !this.measureName.equals(that.measureName) : that.measureName != null) return false;
                if (this.multiMeasureAttributeMappings != null ? !this.multiMeasureAttributeMappings.equals(that.multiMeasureAttributeMappings) : that.multiMeasureAttributeMappings != null) return false;
                if (this.sourceColumn != null ? !this.sourceColumn.equals(that.sourceColumn) : that.sourceColumn != null) return false;
                return this.targetMeasureName != null ? this.targetMeasureName.equals(that.targetMeasureName) : that.targetMeasureName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.measureValueType.hashCode();
                result = 31 * result + (this.measureName != null ? this.measureName.hashCode() : 0);
                result = 31 * result + (this.multiMeasureAttributeMappings != null ? this.multiMeasureAttributeMappings.hashCode() : 0);
                result = 31 * result + (this.sourceColumn != null ? this.sourceColumn.hashCode() : 0);
                result = 31 * result + (this.targetMeasureName != null ? this.targetMeasureName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Attribute mapping for MULTI value measures.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MultiMeasureAttributeMappingProperty multiMeasureAttributeMappingProperty = MultiMeasureAttributeMappingProperty.builder()
     *         .measureValueType("measureValueType")
     *         .sourceColumn("sourceColumn")
     *         // the properties below are optional
     *         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.MultiMeasureAttributeMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiMeasureAttributeMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiMeasureAttributeMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Type of the attribute to be read from the source column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html#cfn-timestream-scheduledquery-multimeasureattributemapping-measurevaluetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html#cfn-timestream-scheduledquery-multimeasureattributemapping-measurevaluetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMeasureValueType();

        /**
         * Source column from where the attribute value is to be read.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html#cfn-timestream-scheduledquery-multimeasureattributemapping-sourcecolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html#cfn-timestream-scheduledquery-multimeasureattributemapping-sourcecolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceColumn();

        /**
         * Custom name to be used for attribute name in derived table.
         * <p>
         * If not provided, source column name would be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html#cfn-timestream-scheduledquery-multimeasureattributemapping-targetmultimeasureattributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasureattributemapping.html#cfn-timestream-scheduledquery-multimeasureattributemapping-targetmultimeasureattributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetMultiMeasureAttributeName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiMeasureAttributeMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiMeasureAttributeMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiMeasureAttributeMappingProperty> {
            java.lang.String measureValueType;
            java.lang.String sourceColumn;
            java.lang.String targetMultiMeasureAttributeName;

            /**
             * Sets the value of {@link MultiMeasureAttributeMappingProperty#getMeasureValueType}
             * @param measureValueType Type of the attribute to be read from the source column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureValueType(java.lang.String measureValueType) {
                this.measureValueType = measureValueType;
                return this;
            }

            /**
             * Sets the value of {@link MultiMeasureAttributeMappingProperty#getSourceColumn}
             * @param sourceColumn Source column from where the attribute value is to be read. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumn(java.lang.String sourceColumn) {
                this.sourceColumn = sourceColumn;
                return this;
            }

            /**
             * Sets the value of {@link MultiMeasureAttributeMappingProperty#getTargetMultiMeasureAttributeName}
             * @param targetMultiMeasureAttributeName Custom name to be used for attribute name in derived table.
             *                                        If not provided, source column name would be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetMultiMeasureAttributeName(java.lang.String targetMultiMeasureAttributeName) {
                this.targetMultiMeasureAttributeName = targetMultiMeasureAttributeName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiMeasureAttributeMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiMeasureAttributeMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiMeasureAttributeMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiMeasureAttributeMappingProperty {
            private final java.lang.String measureValueType;
            private final java.lang.String sourceColumn;
            private final java.lang.String targetMultiMeasureAttributeName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.measureValueType = software.amazon.jsii.Kernel.get(this, "measureValueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceColumn = software.amazon.jsii.Kernel.get(this, "sourceColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetMultiMeasureAttributeName = software.amazon.jsii.Kernel.get(this, "targetMultiMeasureAttributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.measureValueType = java.util.Objects.requireNonNull(builder.measureValueType, "measureValueType is required");
                this.sourceColumn = java.util.Objects.requireNonNull(builder.sourceColumn, "sourceColumn is required");
                this.targetMultiMeasureAttributeName = builder.targetMultiMeasureAttributeName;
            }

            @Override
            public final java.lang.String getMeasureValueType() {
                return this.measureValueType;
            }

            @Override
            public final java.lang.String getSourceColumn() {
                return this.sourceColumn;
            }

            @Override
            public final java.lang.String getTargetMultiMeasureAttributeName() {
                return this.targetMultiMeasureAttributeName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("measureValueType", om.valueToTree(this.getMeasureValueType()));
                data.set("sourceColumn", om.valueToTree(this.getSourceColumn()));
                if (this.getTargetMultiMeasureAttributeName() != null) {
                    data.set("targetMultiMeasureAttributeName", om.valueToTree(this.getTargetMultiMeasureAttributeName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.MultiMeasureAttributeMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiMeasureAttributeMappingProperty.Jsii$Proxy that = (MultiMeasureAttributeMappingProperty.Jsii$Proxy) o;

                if (!measureValueType.equals(that.measureValueType)) return false;
                if (!sourceColumn.equals(that.sourceColumn)) return false;
                return this.targetMultiMeasureAttributeName != null ? this.targetMultiMeasureAttributeName.equals(that.targetMultiMeasureAttributeName) : that.targetMultiMeasureAttributeName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.measureValueType.hashCode();
                result = 31 * result + (this.sourceColumn.hashCode());
                result = 31 * result + (this.targetMultiMeasureAttributeName != null ? this.targetMultiMeasureAttributeName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided.
     * <p>
     * MultiMeasureMappings can be used to ingest data as multi measures in the derived table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MultiMeasureMappingsProperty multiMeasureMappingsProperty = MultiMeasureMappingsProperty.builder()
     *         .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
     *                 .measureValueType("measureValueType")
     *                 .sourceColumn("sourceColumn")
     *                 // the properties below are optional
     *                 .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *                 .build()))
     *         // the properties below are optional
     *         .targetMultiMeasureName("targetMultiMeasureName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasuremappings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasuremappings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.MultiMeasureMappingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiMeasureMappingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiMeasureMappingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required.
         * <p>
         * Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasuremappings.html#cfn-timestream-scheduledquery-multimeasuremappings-multimeasureattributemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasuremappings.html#cfn-timestream-scheduledquery-multimeasuremappings-multimeasureattributemappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMultiMeasureAttributeMappings();

        /**
         * The name of the target multi-measure name in the derived table.
         * <p>
         * This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasuremappings.html#cfn-timestream-scheduledquery-multimeasuremappings-targetmultimeasurename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-multimeasuremappings.html#cfn-timestream-scheduledquery-multimeasuremappings-targetmultimeasurename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetMultiMeasureName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiMeasureMappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiMeasureMappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiMeasureMappingsProperty> {
            java.lang.Object multiMeasureAttributeMappings;
            java.lang.String targetMultiMeasureName;

            /**
             * Sets the value of {@link MultiMeasureMappingsProperty#getMultiMeasureAttributeMappings}
             * @param multiMeasureAttributeMappings Required. This parameter is required.
             *                                      Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiMeasureAttributeMappings(software.amazon.awscdk.IResolvable multiMeasureAttributeMappings) {
                this.multiMeasureAttributeMappings = multiMeasureAttributeMappings;
                return this;
            }

            /**
             * Sets the value of {@link MultiMeasureMappingsProperty#getMultiMeasureAttributeMappings}
             * @param multiMeasureAttributeMappings Required. This parameter is required.
             *                                      Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiMeasureAttributeMappings(java.util.List<? extends java.lang.Object> multiMeasureAttributeMappings) {
                this.multiMeasureAttributeMappings = multiMeasureAttributeMappings;
                return this;
            }

            /**
             * Sets the value of {@link MultiMeasureMappingsProperty#getTargetMultiMeasureName}
             * @param targetMultiMeasureName The name of the target multi-measure name in the derived table.
             *                               This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetMultiMeasureName(java.lang.String targetMultiMeasureName) {
                this.targetMultiMeasureName = targetMultiMeasureName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiMeasureMappingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiMeasureMappingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiMeasureMappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiMeasureMappingsProperty {
            private final java.lang.Object multiMeasureAttributeMappings;
            private final java.lang.String targetMultiMeasureName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.multiMeasureAttributeMappings = software.amazon.jsii.Kernel.get(this, "multiMeasureAttributeMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetMultiMeasureName = software.amazon.jsii.Kernel.get(this, "targetMultiMeasureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.multiMeasureAttributeMappings = java.util.Objects.requireNonNull(builder.multiMeasureAttributeMappings, "multiMeasureAttributeMappings is required");
                this.targetMultiMeasureName = builder.targetMultiMeasureName;
            }

            @Override
            public final java.lang.Object getMultiMeasureAttributeMappings() {
                return this.multiMeasureAttributeMappings;
            }

            @Override
            public final java.lang.String getTargetMultiMeasureName() {
                return this.targetMultiMeasureName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("multiMeasureAttributeMappings", om.valueToTree(this.getMultiMeasureAttributeMappings()));
                if (this.getTargetMultiMeasureName() != null) {
                    data.set("targetMultiMeasureName", om.valueToTree(this.getTargetMultiMeasureName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.MultiMeasureMappingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiMeasureMappingsProperty.Jsii$Proxy that = (MultiMeasureMappingsProperty.Jsii$Proxy) o;

                if (!multiMeasureAttributeMappings.equals(that.multiMeasureAttributeMappings)) return false;
                return this.targetMultiMeasureName != null ? this.targetMultiMeasureName.equals(that.targetMultiMeasureName) : that.targetMultiMeasureName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.multiMeasureAttributeMappings.hashCode();
                result = 31 * result + (this.targetMultiMeasureName != null ? this.targetMultiMeasureName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Notification configuration for a scheduled query.
     * <p>
     * A notification is sent by Timestream when a scheduled query is created, its state is updated or when it is deleted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * NotificationConfigurationProperty notificationConfigurationProperty = NotificationConfigurationProperty.builder()
     *         .snsConfiguration(SnsConfigurationProperty.builder()
     *                 .topicArn("topicArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-notificationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-notificationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details on SNS configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-notificationconfiguration.html#cfn-timestream-scheduledquery-notificationconfiguration-snsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-notificationconfiguration.html#cfn-timestream-scheduledquery-notificationconfiguration-snsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSnsConfiguration();

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            java.lang.Object snsConfiguration;

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getSnsConfiguration}
             * @param snsConfiguration Details on SNS configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsConfiguration(software.amazon.awscdk.IResolvable snsConfiguration) {
                this.snsConfiguration = snsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getSnsConfiguration}
             * @param snsConfiguration Details on SNS configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsConfiguration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.SnsConfigurationProperty snsConfiguration) {
                this.snsConfiguration = snsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.Object snsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.snsConfiguration = software.amazon.jsii.Kernel.get(this, "snsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.snsConfiguration = java.util.Objects.requireNonNull(builder.snsConfiguration, "snsConfiguration is required");
            }

            @Override
            public final java.lang.Object getSnsConfiguration() {
                return this.snsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("snsConfiguration", om.valueToTree(this.getSnsConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.NotificationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                return this.snsConfiguration.equals(that.snsConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.snsConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Details on S3 location for error reports that result from running a query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * S3ConfigurationProperty s3ConfigurationProperty = S3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .encryptionOption("encryptionOption")
     *         .objectKeyPrefix("objectKeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.S3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the S3 bucket under which error reports will be created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html#cfn-timestream-scheduledquery-s3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html#cfn-timestream-scheduledquery-s3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * Encryption at rest options for the error reports.
         * <p>
         * If no encryption option is specified, Timestream will choose SSE_S3 as default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html#cfn-timestream-scheduledquery-s3configuration-encryptionoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html#cfn-timestream-scheduledquery-s3configuration-encryptionoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionOption() {
            return null;
        }

        /**
         * Prefix for the error report key.
         * <p>
         * Timestream by default adds the following prefix to the error report path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html#cfn-timestream-scheduledquery-s3configuration-objectkeyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-s3configuration.html#cfn-timestream-scheduledquery-s3configuration-objectkeyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectKeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigurationProperty> {
            java.lang.String bucketName;
            java.lang.String encryptionOption;
            java.lang.String objectKeyPrefix;

            /**
             * Sets the value of {@link S3ConfigurationProperty#getBucketName}
             * @param bucketName Name of the S3 bucket under which error reports will be created. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getEncryptionOption}
             * @param encryptionOption Encryption at rest options for the error reports.
             *                         If no encryption option is specified, Timestream will choose SSE_S3 as default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionOption(java.lang.String encryptionOption) {
                this.encryptionOption = encryptionOption;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getObjectKeyPrefix}
             * @param objectKeyPrefix Prefix for the error report key.
             *                        Timestream by default adds the following prefix to the error report path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKeyPrefix(java.lang.String objectKeyPrefix) {
                this.objectKeyPrefix = objectKeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigurationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String encryptionOption;
            private final java.lang.String objectKeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionOption = software.amazon.jsii.Kernel.get(this, "encryptionOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKeyPrefix = software.amazon.jsii.Kernel.get(this, "objectKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.encryptionOption = builder.encryptionOption;
                this.objectKeyPrefix = builder.objectKeyPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getEncryptionOption() {
                return this.encryptionOption;
            }

            @Override
            public final java.lang.String getObjectKeyPrefix() {
                return this.objectKeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getEncryptionOption() != null) {
                    data.set("encryptionOption", om.valueToTree(this.getEncryptionOption()));
                }
                if (this.getObjectKeyPrefix() != null) {
                    data.set("objectKeyPrefix", om.valueToTree(this.getObjectKeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.S3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigurationProperty.Jsii$Proxy that = (S3ConfigurationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (this.encryptionOption != null ? !this.encryptionOption.equals(that.encryptionOption) : that.encryptionOption != null) return false;
                return this.objectKeyPrefix != null ? this.objectKeyPrefix.equals(that.objectKeyPrefix) : that.objectKeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.encryptionOption != null ? this.encryptionOption.hashCode() : 0);
                result = 31 * result + (this.objectKeyPrefix != null ? this.objectKeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of the schedule of the query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * ScheduleConfigurationProperty scheduleConfigurationProperty = ScheduleConfigurationProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-scheduleconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-scheduleconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.ScheduleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that denotes when to trigger the scheduled query run.
         * <p>
         * This can be a cron expression or a rate expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-scheduleconfiguration.html#cfn-timestream-scheduledquery-scheduleconfiguration-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-scheduleconfiguration.html#cfn-timestream-scheduledquery-scheduleconfiguration-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * @return a {@link Builder} of {@link ScheduleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleConfigurationProperty> {
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link ScheduleConfigurationProperty#getScheduleExpression}
             * @param scheduleExpression An expression that denotes when to trigger the scheduled query run. This parameter is required.
             *                           This can be a cron expression or a rate expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleConfigurationProperty {
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.ScheduleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleConfigurationProperty.Jsii$Proxy that = (ScheduleConfigurationProperty.Jsii$Proxy) o;

                return this.scheduleExpression.equals(that.scheduleExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                return result;
            }
        }
    }
    /**
     * Details on SNS that are required to send the notification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * SnsConfigurationProperty snsConfigurationProperty = SnsConfigurationProperty.builder()
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-snsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-snsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.SnsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * SNS topic ARN that the scheduled query status notifications will be sent to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-snsconfiguration.html#cfn-timestream-scheduledquery-snsconfiguration-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-snsconfiguration.html#cfn-timestream-scheduledquery-snsconfiguration-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

        /**
         * @return a {@link Builder} of {@link SnsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsConfigurationProperty> {
            java.lang.String topicArn;

            /**
             * Sets the value of {@link SnsConfigurationProperty#getTopicArn}
             * @param topicArn SNS topic ARN that the scheduled query status notifications will be sent to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsConfigurationProperty {
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicArn", om.valueToTree(this.getTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.SnsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsConfigurationProperty.Jsii$Proxy that = (SnsConfigurationProperty.Jsii$Proxy) o;

                return this.topicArn.equals(that.topicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.topicArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration used for writing the output of a query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * TargetConfigurationProperty targetConfigurationProperty = TargetConfigurationProperty.builder()
     *         .timestreamConfiguration(TimestreamConfigurationProperty.builder()
     *                 .databaseName("databaseName")
     *                 .dimensionMappings(List.of(DimensionMappingProperty.builder()
     *                         .dimensionValueType("dimensionValueType")
     *                         .name("name")
     *                         .build()))
     *                 .tableName("tableName")
     *                 .timeColumn("timeColumn")
     *                 // the properties below are optional
     *                 .measureNameColumn("measureNameColumn")
     *                 .mixedMeasureMappings(List.of(MixedMeasureMappingProperty.builder()
     *                         .measureValueType("measureValueType")
     *                         // the properties below are optional
     *                         .measureName("measureName")
     *                         .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
     *                                 .measureValueType("measureValueType")
     *                                 .sourceColumn("sourceColumn")
     *                                 // the properties below are optional
     *                                 .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *                                 .build()))
     *                         .sourceColumn("sourceColumn")
     *                         .targetMeasureName("targetMeasureName")
     *                         .build()))
     *                 .multiMeasureMappings(MultiMeasureMappingsProperty.builder()
     *                         .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
     *                                 .measureValueType("measureValueType")
     *                                 .sourceColumn("sourceColumn")
     *                                 // the properties below are optional
     *                                 .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .targetMultiMeasureName("targetMultiMeasureName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-targetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-targetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.TargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration needed to write data into the Timestream database and table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-targetconfiguration.html#cfn-timestream-scheduledquery-targetconfiguration-timestreamconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-targetconfiguration.html#cfn-timestream-scheduledquery-targetconfiguration-timestreamconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTimestreamConfiguration();

        /**
         * @return a {@link Builder} of {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetConfigurationProperty> {
            java.lang.Object timestreamConfiguration;

            /**
             * Sets the value of {@link TargetConfigurationProperty#getTimestreamConfiguration}
             * @param timestreamConfiguration Configuration needed to write data into the Timestream database and table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestreamConfiguration(software.amazon.awscdk.IResolvable timestreamConfiguration) {
                this.timestreamConfiguration = timestreamConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TargetConfigurationProperty#getTimestreamConfiguration}
             * @param timestreamConfiguration Configuration needed to write data into the Timestream database and table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestreamConfiguration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.TimestreamConfigurationProperty timestreamConfiguration) {
                this.timestreamConfiguration = timestreamConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetConfigurationProperty {
            private final java.lang.Object timestreamConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timestreamConfiguration = software.amazon.jsii.Kernel.get(this, "timestreamConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timestreamConfiguration = java.util.Objects.requireNonNull(builder.timestreamConfiguration, "timestreamConfiguration is required");
            }

            @Override
            public final java.lang.Object getTimestreamConfiguration() {
                return this.timestreamConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timestreamConfiguration", om.valueToTree(this.getTimestreamConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.TargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetConfigurationProperty.Jsii$Proxy that = (TargetConfigurationProperty.Jsii$Proxy) o;

                return this.timestreamConfiguration.equals(that.timestreamConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.timestreamConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration to write data into Timestream database and table.
     * <p>
     * This configuration allows the user to map the query result select columns into the destination table columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * TimestreamConfigurationProperty timestreamConfigurationProperty = TimestreamConfigurationProperty.builder()
     *         .databaseName("databaseName")
     *         .dimensionMappings(List.of(DimensionMappingProperty.builder()
     *                 .dimensionValueType("dimensionValueType")
     *                 .name("name")
     *                 .build()))
     *         .tableName("tableName")
     *         .timeColumn("timeColumn")
     *         // the properties below are optional
     *         .measureNameColumn("measureNameColumn")
     *         .mixedMeasureMappings(List.of(MixedMeasureMappingProperty.builder()
     *                 .measureValueType("measureValueType")
     *                 // the properties below are optional
     *                 .measureName("measureName")
     *                 .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
     *                         .measureValueType("measureValueType")
     *                         .sourceColumn("sourceColumn")
     *                         // the properties below are optional
     *                         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *                         .build()))
     *                 .sourceColumn("sourceColumn")
     *                 .targetMeasureName("targetMeasureName")
     *                 .build()))
     *         .multiMeasureMappings(MultiMeasureMappingsProperty.builder()
     *                 .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
     *                         .measureValueType("measureValueType")
     *                         .sourceColumn("sourceColumn")
     *                         // the properties below are optional
     *                         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
     *                         .build()))
     *                 // the properties below are optional
     *                 .targetMultiMeasureName("targetMultiMeasureName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQuery.TimestreamConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestreamConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestreamConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of Timestream database to which the query result will be written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * This is to allow mapping column(s) from the query result to the dimension in the destination table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-dimensionmappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-dimensionmappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDimensionMappings();

        /**
         * Name of Timestream table that the query result will be written to.
         * <p>
         * The table should be within the same database that is provided in Timestream configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * Column from query result that should be used as the time column in destination table.
         * <p>
         * Column type for this should be TIMESTAMP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-timecolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-timecolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeColumn();

        /**
         * Name of the measure column.
         * <p>
         * Also see <code>MultiMeasureMappings</code> and <code>MixedMeasureMappings</code> for how measure name properties on those relate to <code>MeasureNameColumn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-measurenamecolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-measurenamecolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMeasureNameColumn() {
            return null;
        }

        /**
         * Specifies how to map measures to multi-measure records.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-mixedmeasuremappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-mixedmeasuremappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMixedMeasureMappings() {
            return null;
        }

        /**
         * Multi-measure mappings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-multimeasuremappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-scheduledquery-timestreamconfiguration.html#cfn-timestream-scheduledquery-timestreamconfiguration-multimeasuremappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiMeasureMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimestreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestreamConfigurationProperty> {
            java.lang.String databaseName;
            java.lang.Object dimensionMappings;
            java.lang.String tableName;
            java.lang.String timeColumn;
            java.lang.String measureNameColumn;
            java.lang.Object mixedMeasureMappings;
            java.lang.Object multiMeasureMappings;

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getDatabaseName}
             * @param databaseName Name of Timestream database to which the query result will be written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getDimensionMappings}
             * @param dimensionMappings This is to allow mapping column(s) from the query result to the dimension in the destination table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionMappings(software.amazon.awscdk.IResolvable dimensionMappings) {
                this.dimensionMappings = dimensionMappings;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getDimensionMappings}
             * @param dimensionMappings This is to allow mapping column(s) from the query result to the dimension in the destination table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionMappings(java.util.List<? extends java.lang.Object> dimensionMappings) {
                this.dimensionMappings = dimensionMappings;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getTableName}
             * @param tableName Name of Timestream table that the query result will be written to. This parameter is required.
             *                  The table should be within the same database that is provided in Timestream configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getTimeColumn}
             * @param timeColumn Column from query result that should be used as the time column in destination table. This parameter is required.
             *                   Column type for this should be TIMESTAMP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeColumn(java.lang.String timeColumn) {
                this.timeColumn = timeColumn;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getMeasureNameColumn}
             * @param measureNameColumn Name of the measure column.
             *                          Also see <code>MultiMeasureMappings</code> and <code>MixedMeasureMappings</code> for how measure name properties on those relate to <code>MeasureNameColumn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureNameColumn(java.lang.String measureNameColumn) {
                this.measureNameColumn = measureNameColumn;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getMixedMeasureMappings}
             * @param mixedMeasureMappings Specifies how to map measures to multi-measure records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mixedMeasureMappings(software.amazon.awscdk.IResolvable mixedMeasureMappings) {
                this.mixedMeasureMappings = mixedMeasureMappings;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getMixedMeasureMappings}
             * @param mixedMeasureMappings Specifies how to map measures to multi-measure records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mixedMeasureMappings(java.util.List<? extends java.lang.Object> mixedMeasureMappings) {
                this.mixedMeasureMappings = mixedMeasureMappings;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getMultiMeasureMappings}
             * @param multiMeasureMappings Multi-measure mappings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiMeasureMappings(software.amazon.awscdk.IResolvable multiMeasureMappings) {
                this.multiMeasureMappings = multiMeasureMappings;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigurationProperty#getMultiMeasureMappings}
             * @param multiMeasureMappings Multi-measure mappings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiMeasureMappings(software.amazon.awscdk.services.timestream.CfnScheduledQuery.MultiMeasureMappingsProperty multiMeasureMappings) {
                this.multiMeasureMappings = multiMeasureMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestreamConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestreamConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestreamConfigurationProperty {
            private final java.lang.String databaseName;
            private final java.lang.Object dimensionMappings;
            private final java.lang.String tableName;
            private final java.lang.String timeColumn;
            private final java.lang.String measureNameColumn;
            private final java.lang.Object mixedMeasureMappings;
            private final java.lang.Object multiMeasureMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionMappings = software.amazon.jsii.Kernel.get(this, "dimensionMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeColumn = software.amazon.jsii.Kernel.get(this, "timeColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.measureNameColumn = software.amazon.jsii.Kernel.get(this, "measureNameColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mixedMeasureMappings = software.amazon.jsii.Kernel.get(this, "mixedMeasureMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.multiMeasureMappings = software.amazon.jsii.Kernel.get(this, "multiMeasureMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.dimensionMappings = java.util.Objects.requireNonNull(builder.dimensionMappings, "dimensionMappings is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.timeColumn = java.util.Objects.requireNonNull(builder.timeColumn, "timeColumn is required");
                this.measureNameColumn = builder.measureNameColumn;
                this.mixedMeasureMappings = builder.mixedMeasureMappings;
                this.multiMeasureMappings = builder.multiMeasureMappings;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Object getDimensionMappings() {
                return this.dimensionMappings;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getTimeColumn() {
                return this.timeColumn;
            }

            @Override
            public final java.lang.String getMeasureNameColumn() {
                return this.measureNameColumn;
            }

            @Override
            public final java.lang.Object getMixedMeasureMappings() {
                return this.mixedMeasureMappings;
            }

            @Override
            public final java.lang.Object getMultiMeasureMappings() {
                return this.multiMeasureMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("dimensionMappings", om.valueToTree(this.getDimensionMappings()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                data.set("timeColumn", om.valueToTree(this.getTimeColumn()));
                if (this.getMeasureNameColumn() != null) {
                    data.set("measureNameColumn", om.valueToTree(this.getMeasureNameColumn()));
                }
                if (this.getMixedMeasureMappings() != null) {
                    data.set("mixedMeasureMappings", om.valueToTree(this.getMixedMeasureMappings()));
                }
                if (this.getMultiMeasureMappings() != null) {
                    data.set("multiMeasureMappings", om.valueToTree(this.getMultiMeasureMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQuery.TimestreamConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestreamConfigurationProperty.Jsii$Proxy that = (TimestreamConfigurationProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!dimensionMappings.equals(that.dimensionMappings)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (!timeColumn.equals(that.timeColumn)) return false;
                if (this.measureNameColumn != null ? !this.measureNameColumn.equals(that.measureNameColumn) : that.measureNameColumn != null) return false;
                if (this.mixedMeasureMappings != null ? !this.mixedMeasureMappings.equals(that.mixedMeasureMappings) : that.mixedMeasureMappings != null) return false;
                return this.multiMeasureMappings != null ? this.multiMeasureMappings.equals(that.multiMeasureMappings) : that.multiMeasureMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.dimensionMappings.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.timeColumn.hashCode());
                result = 31 * result + (this.measureNameColumn != null ? this.measureNameColumn.hashCode() : 0);
                result = 31 * result + (this.mixedMeasureMappings != null ? this.mixedMeasureMappings.hashCode() : 0);
                result = 31 * result + (this.multiMeasureMappings != null ? this.multiMeasureMappings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.timestream.CfnScheduledQuery}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.timestream.CfnScheduledQuery> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.timestream.CfnScheduledQueryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.timestream.CfnScheduledQueryProps.Builder();
        }

        /**
         * Configuration for error reporting.
         * <p>
         * Error reports will be generated when a problem is encountered when writing the query results.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-errorreportconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-errorreportconfiguration</a>
         * @param errorReportConfiguration Configuration for error reporting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorReportConfiguration(final software.amazon.awscdk.IResolvable errorReportConfiguration) {
            this.props.errorReportConfiguration(errorReportConfiguration);
            return this;
        }
        /**
         * Configuration for error reporting.
         * <p>
         * Error reports will be generated when a problem is encountered when writing the query results.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-errorreportconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-errorreportconfiguration</a>
         * @param errorReportConfiguration Configuration for error reporting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorReportConfiguration(final software.amazon.awscdk.services.timestream.CfnScheduledQuery.ErrorReportConfigurationProperty errorReportConfiguration) {
            this.props.errorReportConfiguration(errorReportConfiguration);
            return this;
        }

        /**
         * Notification configuration for the scheduled query.
         * <p>
         * A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-notificationconfiguration</a>
         * @param notificationConfiguration Notification configuration for the scheduled query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.IResolvable notificationConfiguration) {
            this.props.notificationConfiguration(notificationConfiguration);
            return this;
        }
        /**
         * Notification configuration for the scheduled query.
         * <p>
         * A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-notificationconfiguration</a>
         * @param notificationConfiguration Notification configuration for the scheduled query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.services.timestream.CfnScheduledQuery.NotificationConfigurationProperty notificationConfiguration) {
            this.props.notificationConfiguration(notificationConfiguration);
            return this;
        }

        /**
         * The query string to run.
         * <p>
         * Parameter names can be specified in the query string <code>&#64;</code> character followed by an identifier. The named Parameter <code>&#64;scheduled_runtime</code> is reserved and can be used in the query to get the time at which the query is scheduled to run.
         * <p>
         * The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of <code>&#64;scheduled_runtime</code> paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the <code>&#64;scheduled_runtime</code> parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-querystring</a>
         * @param queryString The query string to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(final java.lang.String queryString) {
            this.props.queryString(queryString);
            return this;
        }

        /**
         * Schedule configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduleconfiguration</a>
         * @param scheduleConfiguration Schedule configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleConfiguration(final software.amazon.awscdk.IResolvable scheduleConfiguration) {
            this.props.scheduleConfiguration(scheduleConfiguration);
            return this;
        }
        /**
         * Schedule configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduleconfiguration</a>
         * @param scheduleConfiguration Schedule configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleConfiguration(final software.amazon.awscdk.services.timestream.CfnScheduledQuery.ScheduleConfigurationProperty scheduleConfiguration) {
            this.props.scheduleConfiguration(scheduleConfiguration);
            return this;
        }

        /**
         * The ARN for the IAM role that Timestream will assume when running the scheduled query.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryexecutionrolearn</a>
         * @param scheduledQueryExecutionRoleArn The ARN for the IAM role that Timestream will assume when running the scheduled query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledQueryExecutionRoleArn(final java.lang.String scheduledQueryExecutionRoleArn) {
            this.props.scheduledQueryExecutionRoleArn(scheduledQueryExecutionRoleArn);
            return this;
        }

        /**
         * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result.
         * <p>
         * Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
         * <p>
         * <ul>
         * <li>If CreateScheduledQuery is called without a <code>ClientToken</code> , the Query SDK generates a <code>ClientToken</code> on your behalf.</li>
         * <li>After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-clienttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-clienttoken</a>
         * @param clientToken Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(final java.lang.String clientToken) {
            this.props.clientToken(clientToken);
            return this;
        }

        /**
         * The Amazon KMS key used to encrypt the scheduled query resource, at-rest.
         * <p>
         * If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with <em>alias/</em>
         * <p>
         * If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-kmskeyid</a>
         * @param kmsKeyId The Amazon KMS key used to encrypt the scheduled query resource, at-rest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * A name for the query.
         * <p>
         * Scheduled query names must be unique within each Region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryname</a>
         * @param scheduledQueryName A name for the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledQueryName(final java.lang.String scheduledQueryName) {
            this.props.scheduledQueryName(scheduledQueryName);
            return this;
        }

        /**
         * A list of key-value pairs to label the scheduled query.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-tags</a>
         * @param tags A list of key-value pairs to label the scheduled query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Scheduled query target store configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-targetconfiguration</a>
         * @param targetConfiguration Scheduled query target store configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(final software.amazon.awscdk.IResolvable targetConfiguration) {
            this.props.targetConfiguration(targetConfiguration);
            return this;
        }
        /**
         * Scheduled query target store configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-targetconfiguration</a>
         * @param targetConfiguration Scheduled query target store configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(final software.amazon.awscdk.services.timestream.CfnScheduledQuery.TargetConfigurationProperty targetConfiguration) {
            this.props.targetConfiguration(targetConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.timestream.CfnScheduledQuery}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.timestream.CfnScheduledQuery build() {
            return new software.amazon.awscdk.services.timestream.CfnScheduledQuery(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
