package software.amazon.awscdk.services.transfer;

/**
 * Creates an agreement.
 * <p>
 * An agreement is a bilateral trading partner agreement, or partnership, between an AWS Transfer Family server and an AS2 process. The agreement defines the file and message transfer relationship between the server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner profile, certificate, and other attributes.
 * <p>
 * The partner is identified with the <code>PartnerProfileId</code> , and the AS2 process is identified with the <code>LocalProfileId</code> .
 * <p>
 * <blockquote>
 * <p>
 * Specify <em>either</em> <code>BaseDirectory</code> or <code>CustomDirectories</code> , but not both. Specifying both causes the command to fail.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnAgreement cfnAgreement = CfnAgreement.Builder.create(this, "MyCfnAgreement")
 *         .accessRole("accessRole")
 *         .localProfileId("localProfileId")
 *         .partnerProfileId("partnerProfileId")
 *         .serverId("serverId")
 *         // the properties below are optional
 *         .baseDirectory("baseDirectory")
 *         .customDirectories(CustomDirectoriesProperty.builder()
 *                 .failedFilesDirectory("failedFilesDirectory")
 *                 .mdnFilesDirectory("mdnFilesDirectory")
 *                 .payloadFilesDirectory("payloadFilesDirectory")
 *                 .statusFilesDirectory("statusFilesDirectory")
 *                 .temporaryFilesDirectory("temporaryFilesDirectory")
 *                 .build())
 *         .description("description")
 *         .enforceMessageSigning("enforceMessageSigning")
 *         .preserveFilename("preserveFilename")
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:47.081Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnAgreement")
public class CfnAgreement extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAgreement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAgreement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnAgreement.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAgreement(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnAgreementProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the AS2 agreement, returned after the API call succeeds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgreementId() {
        return software.amazon.jsii.Kernel.get(this, "attrAgreementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the unique Amazon Resource Name (ARN) for the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Connectors are used to send files using either the AS2 or SFTP protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessRole() {
        return software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Connectors are used to send files using either the AS2 or SFTP protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessRole", java.util.Objects.requireNonNull(value, "accessRole is required"));
    }

    /**
     * A unique identifier for the AS2 local profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLocalProfileId() {
        return software.amazon.jsii.Kernel.get(this, "localProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the AS2 local profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalProfileId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "localProfileId", java.util.Objects.requireNonNull(value, "localProfileId is required"));
    }

    /**
     * A unique identifier for the partner profile used in the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPartnerProfileId() {
        return software.amazon.jsii.Kernel.get(this, "partnerProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the partner profile used in the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartnerProfileId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "partnerProfileId", java.util.Objects.requireNonNull(value, "partnerProfileId is required"));
    }

    /**
     * A system-assigned unique identifier for a server instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServerId() {
        return software.amazon.jsii.Kernel.get(this, "serverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A system-assigned unique identifier for a server instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverId", java.util.Objects.requireNonNull(value, "serverId is required"));
    }

    /**
     * The landing directory (folder) for files that are transferred by using the AS2 protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBaseDirectory() {
        return software.amazon.jsii.Kernel.get(this, "baseDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The landing directory (folder) for files that are transferred by using the AS2 protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaseDirectory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "baseDirectory", value);
    }

    /**
     * A <code>CustomDirectoriesType</code> structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomDirectories() {
        return software.amazon.jsii.Kernel.get(this, "customDirectories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A <code>CustomDirectoriesType</code> structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDirectories(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customDirectories", value);
    }

    /**
     * A <code>CustomDirectoriesType</code> structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDirectories(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnAgreement.CustomDirectoriesProperty value) {
        software.amazon.jsii.Kernel.set(this, "customDirectories", value);
    }

    /**
     * The name or short description that's used to identify the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or short description that's used to identify the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Determines whether or not unsigned messages from your trading partners will be accepted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnforceMessageSigning() {
        return software.amazon.jsii.Kernel.get(this, "enforceMessageSigning", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines whether or not unsigned messages from your trading partners will be accepted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnforceMessageSigning(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "enforceMessageSigning", value);
    }

    /**
     * Determines whether or not Transfer Family appends a unique string of characters to the end of the AS2 message payload filename when saving it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreserveFilename() {
        return software.amazon.jsii.Kernel.get(this, "preserveFilename", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines whether or not Transfer Family appends a unique string of characters to the end of the AS2 message payload filename when saving it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreserveFilename(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preserveFilename", value);
    }

    /**
     * The current status of the agreement, either <code>ACTIVE</code> or <code>INACTIVE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the agreement, either <code>ACTIVE</code> or <code>INACTIVE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }

    /**
     * Key-value pairs that can be used to group and search for agreements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to group and search for agreements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies a separate directory for each type of file to store for an AS2 message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * CustomDirectoriesProperty customDirectoriesProperty = CustomDirectoriesProperty.builder()
     *         .failedFilesDirectory("failedFilesDirectory")
     *         .mdnFilesDirectory("mdnFilesDirectory")
     *         .payloadFilesDirectory("payloadFilesDirectory")
     *         .statusFilesDirectory("statusFilesDirectory")
     *         .temporaryFilesDirectory("temporaryFilesDirectory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnAgreement.CustomDirectoriesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomDirectoriesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomDirectoriesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a location to store the failed files for an AS2 message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-failedfilesdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-failedfilesdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFailedFilesDirectory();

        /**
         * Specifies a location to store the MDN file for an AS2 message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-mdnfilesdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-mdnfilesdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMdnFilesDirectory();

        /**
         * Specifies a location to store the payload file for an AS2 message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-payloadfilesdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-payloadfilesdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPayloadFilesDirectory();

        /**
         * Specifies a location to store the status file for an AS2 message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-statusfilesdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-statusfilesdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusFilesDirectory();

        /**
         * Specifies a location to store the temporary processing file for an AS2 message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-temporaryfilesdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-agreement-customdirectories.html#cfn-transfer-agreement-customdirectories-temporaryfilesdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemporaryFilesDirectory();

        /**
         * @return a {@link Builder} of {@link CustomDirectoriesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomDirectoriesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomDirectoriesProperty> {
            java.lang.String failedFilesDirectory;
            java.lang.String mdnFilesDirectory;
            java.lang.String payloadFilesDirectory;
            java.lang.String statusFilesDirectory;
            java.lang.String temporaryFilesDirectory;

            /**
             * Sets the value of {@link CustomDirectoriesProperty#getFailedFilesDirectory}
             * @param failedFilesDirectory Specifies a location to store the failed files for an AS2 message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failedFilesDirectory(java.lang.String failedFilesDirectory) {
                this.failedFilesDirectory = failedFilesDirectory;
                return this;
            }

            /**
             * Sets the value of {@link CustomDirectoriesProperty#getMdnFilesDirectory}
             * @param mdnFilesDirectory Specifies a location to store the MDN file for an AS2 message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mdnFilesDirectory(java.lang.String mdnFilesDirectory) {
                this.mdnFilesDirectory = mdnFilesDirectory;
                return this;
            }

            /**
             * Sets the value of {@link CustomDirectoriesProperty#getPayloadFilesDirectory}
             * @param payloadFilesDirectory Specifies a location to store the payload file for an AS2 message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadFilesDirectory(java.lang.String payloadFilesDirectory) {
                this.payloadFilesDirectory = payloadFilesDirectory;
                return this;
            }

            /**
             * Sets the value of {@link CustomDirectoriesProperty#getStatusFilesDirectory}
             * @param statusFilesDirectory Specifies a location to store the status file for an AS2 message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusFilesDirectory(java.lang.String statusFilesDirectory) {
                this.statusFilesDirectory = statusFilesDirectory;
                return this;
            }

            /**
             * Sets the value of {@link CustomDirectoriesProperty#getTemporaryFilesDirectory}
             * @param temporaryFilesDirectory Specifies a location to store the temporary processing file for an AS2 message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temporaryFilesDirectory(java.lang.String temporaryFilesDirectory) {
                this.temporaryFilesDirectory = temporaryFilesDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomDirectoriesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomDirectoriesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomDirectoriesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomDirectoriesProperty {
            private final java.lang.String failedFilesDirectory;
            private final java.lang.String mdnFilesDirectory;
            private final java.lang.String payloadFilesDirectory;
            private final java.lang.String statusFilesDirectory;
            private final java.lang.String temporaryFilesDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failedFilesDirectory = software.amazon.jsii.Kernel.get(this, "failedFilesDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mdnFilesDirectory = software.amazon.jsii.Kernel.get(this, "mdnFilesDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payloadFilesDirectory = software.amazon.jsii.Kernel.get(this, "payloadFilesDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusFilesDirectory = software.amazon.jsii.Kernel.get(this, "statusFilesDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.temporaryFilesDirectory = software.amazon.jsii.Kernel.get(this, "temporaryFilesDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failedFilesDirectory = java.util.Objects.requireNonNull(builder.failedFilesDirectory, "failedFilesDirectory is required");
                this.mdnFilesDirectory = java.util.Objects.requireNonNull(builder.mdnFilesDirectory, "mdnFilesDirectory is required");
                this.payloadFilesDirectory = java.util.Objects.requireNonNull(builder.payloadFilesDirectory, "payloadFilesDirectory is required");
                this.statusFilesDirectory = java.util.Objects.requireNonNull(builder.statusFilesDirectory, "statusFilesDirectory is required");
                this.temporaryFilesDirectory = java.util.Objects.requireNonNull(builder.temporaryFilesDirectory, "temporaryFilesDirectory is required");
            }

            @Override
            public final java.lang.String getFailedFilesDirectory() {
                return this.failedFilesDirectory;
            }

            @Override
            public final java.lang.String getMdnFilesDirectory() {
                return this.mdnFilesDirectory;
            }

            @Override
            public final java.lang.String getPayloadFilesDirectory() {
                return this.payloadFilesDirectory;
            }

            @Override
            public final java.lang.String getStatusFilesDirectory() {
                return this.statusFilesDirectory;
            }

            @Override
            public final java.lang.String getTemporaryFilesDirectory() {
                return this.temporaryFilesDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("failedFilesDirectory", om.valueToTree(this.getFailedFilesDirectory()));
                data.set("mdnFilesDirectory", om.valueToTree(this.getMdnFilesDirectory()));
                data.set("payloadFilesDirectory", om.valueToTree(this.getPayloadFilesDirectory()));
                data.set("statusFilesDirectory", om.valueToTree(this.getStatusFilesDirectory()));
                data.set("temporaryFilesDirectory", om.valueToTree(this.getTemporaryFilesDirectory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnAgreement.CustomDirectoriesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomDirectoriesProperty.Jsii$Proxy that = (CustomDirectoriesProperty.Jsii$Proxy) o;

                if (!failedFilesDirectory.equals(that.failedFilesDirectory)) return false;
                if (!mdnFilesDirectory.equals(that.mdnFilesDirectory)) return false;
                if (!payloadFilesDirectory.equals(that.payloadFilesDirectory)) return false;
                if (!statusFilesDirectory.equals(that.statusFilesDirectory)) return false;
                return this.temporaryFilesDirectory.equals(that.temporaryFilesDirectory);
            }

            @Override
            public final int hashCode() {
                int result = this.failedFilesDirectory.hashCode();
                result = 31 * result + (this.mdnFilesDirectory.hashCode());
                result = 31 * result + (this.payloadFilesDirectory.hashCode());
                result = 31 * result + (this.statusFilesDirectory.hashCode());
                result = 31 * result + (this.temporaryFilesDirectory.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnAgreement}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnAgreement> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnAgreementProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnAgreementProps.Builder();
        }

        /**
         * Connectors are used to send files using either the AS2 or SFTP protocol.
         * <p>
         * For the access role, provide the Amazon Resource Name (ARN) of the AWS Identity and Access Management role to use.
         * <p>
         * <em>For AS2 connectors</em>
         * <p>
         * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the request parameter, <code>SendFilePaths</code> . We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
         * <p>
         * If you are using Basic authentication for your AS2 connector, the access role requires the <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a customer-managed key instead of the AWS managed key in Secrets Manager, then the role also needs the <code>kms:Decrypt</code> permission for that key.
         * <p>
         * <em>For SFTP connectors</em>
         * <p>
         * Make sure that the access role provides read and write access to the parent directory of the file location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides <code>secretsmanager:GetSecretValue</code> permission to AWS Secrets Manager .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-accessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-accessrole</a>
         * @param accessRole Connectors are used to send files using either the AS2 or SFTP protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRole(final java.lang.String accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        /**
         * A unique identifier for the AS2 local profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-localprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-localprofileid</a>
         * @param localProfileId A unique identifier for the AS2 local profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localProfileId(final java.lang.String localProfileId) {
            this.props.localProfileId(localProfileId);
            return this;
        }

        /**
         * A unique identifier for the partner profile used in the agreement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-partnerprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-partnerprofileid</a>
         * @param partnerProfileId A unique identifier for the partner profile used in the agreement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerProfileId(final java.lang.String partnerProfileId) {
            this.props.partnerProfileId(partnerProfileId);
            return this;
        }

        /**
         * A system-assigned unique identifier for a server instance.
         * <p>
         * This identifier indicates the specific server that the agreement uses.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-serverid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-serverid</a>
         * @param serverId A system-assigned unique identifier for a server instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverId(final java.lang.String serverId) {
            this.props.serverId(serverId);
            return this;
        }

        /**
         * The landing directory (folder) for files that are transferred by using the AS2 protocol.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-basedirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-basedirectory</a>
         * @param baseDirectory The landing directory (folder) for files that are transferred by using the AS2 protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseDirectory(final java.lang.String baseDirectory) {
            this.props.baseDirectory(baseDirectory);
            return this;
        }

        /**
         * A <code>CustomDirectoriesType</code> structure.
         * <p>
         * This structure specifies custom directories for storing various AS2 message files. You can specify directories for the following types of files.
         * <p>
         * <ul>
         * <li>Failed files</li>
         * <li>MDN files</li>
         * <li>Payload files</li>
         * <li>Status files</li>
         * <li>Temporary files</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-customdirectories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-customdirectories</a>
         * @param customDirectories A <code>CustomDirectoriesType</code> structure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDirectories(final software.amazon.awscdk.IResolvable customDirectories) {
            this.props.customDirectories(customDirectories);
            return this;
        }
        /**
         * A <code>CustomDirectoriesType</code> structure.
         * <p>
         * This structure specifies custom directories for storing various AS2 message files. You can specify directories for the following types of files.
         * <p>
         * <ul>
         * <li>Failed files</li>
         * <li>MDN files</li>
         * <li>Payload files</li>
         * <li>Status files</li>
         * <li>Temporary files</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-customdirectories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-customdirectories</a>
         * @param customDirectories A <code>CustomDirectoriesType</code> structure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDirectories(final software.amazon.awscdk.services.transfer.CfnAgreement.CustomDirectoriesProperty customDirectories) {
            this.props.customDirectories(customDirectories);
            return this;
        }

        /**
         * The name or short description that's used to identify the agreement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-description</a>
         * @param description The name or short description that's used to identify the agreement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Determines whether or not unsigned messages from your trading partners will be accepted.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> : Transfer Family rejects unsigned messages from your trading partner.</li>
         * <li><code>DISABLED</code> (default value): Transfer Family accepts unsigned messages from your trading partner.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-enforcemessagesigning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-enforcemessagesigning</a>
         * @param enforceMessageSigning Determines whether or not unsigned messages from your trading partners will be accepted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceMessageSigning(final java.lang.String enforceMessageSigning) {
            this.props.enforceMessageSigning(enforceMessageSigning);
            return this;
        }

        /**
         * Determines whether or not Transfer Family appends a unique string of characters to the end of the AS2 message payload filename when saving it.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> : the filename provided by your trading parter is preserved when the file is saved.</li>
         * <li><code>DISABLED</code> (default value): when Transfer Family saves the file, the filename is adjusted, as described in <a href="https://docs.aws.amazon.com/transfer/latest/userguide/send-as2-messages.html#file-names-as2">File names and locations</a> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-preservefilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-preservefilename</a>
         * @param preserveFilename Determines whether or not Transfer Family appends a unique string of characters to the end of the AS2 message payload filename when saving it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveFilename(final java.lang.String preserveFilename) {
            this.props.preserveFilename(preserveFilename);
            return this;
        }

        /**
         * The current status of the agreement, either <code>ACTIVE</code> or <code>INACTIVE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-status</a>
         * @param status The current status of the agreement, either <code>ACTIVE</code> or <code>INACTIVE</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for agreements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-agreement.html#cfn-transfer-agreement-tags</a>
         * @param tags Key-value pairs that can be used to group and search for agreements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnAgreement}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnAgreement build() {
            return new software.amazon.awscdk.services.transfer.CfnAgreement(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
